/*
 * Decompiled with CFR 0.152.
 */
package projects.dream2016;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class IntersectDNase {
    public static void main(String[] args) throws IOException {
        HashMap[] peaks = new HashMap[args.length];
        HashSet<String> chroms = new HashSet<String>();
        int i = 0;
        while (i < args.length) {
            peaks[i] = new HashMap();
            BufferedReader read = new BufferedReader(new FileReader(args[i]));
            String str = null;
            while ((str = read.readLine()) != null) {
                String[] parts = str.split("\t");
                String chrom = parts[0];
                Peak p = new Peak(Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), Double.parseDouble(parts[6]), Integer.parseInt(parts[4]));
                if (!peaks[i].containsKey(chrom)) {
                    peaks[i].put(chrom, new ArrayList());
                    chroms.add(chrom);
                }
                ((ArrayList)peaks[i].get(chrom)).add(p);
            }
            ++i;
        }
        for (String chrom : chroms) {
            ArrayList<Peak> peakl = (ArrayList<Peak>)peaks[0].get(chrom);
            int i2 = 1;
            while (i2 < peaks.length) {
                ArrayList myl = (ArrayList)peaks[i2].get(chrom);
                peakl = IntersectDNase.intersect(peakl, myl);
                peakl = IntersectDNase.join(peakl);
                ++i2;
            }
            i2 = 0;
            while (i2 < peakl.size()) {
                Peak p = (Peak)peakl.get(i2);
                System.out.println(String.valueOf(chrom) + "\t" + p.start + "\t" + p.end + "\tpeak_" + chrom + "_" + i2 + "\t" + p.peak + "\t" + p.stat);
                ++i2;
            }
        }
    }

    private static ArrayList<Peak> join(ArrayList<Peak> peakl) {
        ArrayList<Peak> res = new ArrayList<Peak>();
        int i = 0;
        while (i < peakl.size()) {
            int k = i;
            while (k < peakl.size() && peakl.get(i).start == peakl.get(k).start && peakl.get(i).end == peakl.get(k).end) {
                ++k;
            }
            int start = peakl.get(i).start;
            int end = peakl.get(i).end;
            double stat = 0.0;
            double meanPeak = 0.0;
            int j = i;
            while (j < k) {
                stat += peakl.get(j).stat;
                meanPeak += (double)peakl.get(j).peak;
                ++j;
            }
            res.add(new Peak(start, end, stat / (double)(k - i), (int)(meanPeak / (double)(k - i))));
            i = k;
        }
        return res;
    }

    private static ArrayList<Peak> intersect(ArrayList<Peak> peakl, ArrayList<Peak> myl) {
        ArrayList<Peak> inter = new ArrayList<Peak>();
        if (peakl == null || myl == null) {
            return inter;
        }
        int i = 0;
        while (i < peakl.size()) {
            Peak p = peakl.get(i);
            int j = 0;
            while (j < myl.size()) {
                Peak q = myl.get(j);
                if (p.overlaps(q)) {
                    inter.add(Peak.intersect(p, q));
                }
                ++j;
            }
            ++i;
        }
        return inter;
    }

    private static class Peak {
        private int start;
        private int end;
        private double stat;
        private int peak;
        private int n;

        public Peak(int start, int end, double stat, int peak) {
            this.start = start;
            this.end = end;
            this.stat = stat;
            this.peak = peak;
            this.n = 1;
        }

        private boolean overlaps(Peak q) {
            return this.start >= q.start && this.start <= q.end || this.end >= q.end && this.end <= q.end;
        }

        private static Peak intersect(Peak p, Peak q) {
            int start = Math.max(p.start, q.start);
            int end = Math.min(p.end, q.end);
            double stat = p.stat * (double)p.n + q.stat * (double)q.n;
            int meanPeak = (p.start + p.peak + q.start + q.peak) / 2;
            if (meanPeak < start || meanPeak > end) {
                meanPeak = start + (end - start) / 2;
            }
            return new Peak(start, end, stat, meanPeak);
        }
    }
}

