/*
 * Decompiled with CFR 0.152.
 */
package projects.dream2016;

import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifier;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.data.sequences.annotation.StrandedLocatedSequenceAnnotationWithLength;
import de.jstacs.io.FileManager;
import de.jstacs.results.Result;
import de.jstacs.sequenceScores.statisticalModels.differentiable.DifferentiableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.StrandDiffSM;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Pair;
import de.jstacs.utils.ToolBox;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import projects.dimont.AbstractSingleMotifChIPper;

public class GenomicModelScan {
    public static void main(String[] args) throws Exception {
        GenDisMixClassifier cl = new GenDisMixClassifier(FileManager.readFile(args[0]));
        DifferentiableStatisticalModel model = ((AbstractSingleMotifChIPper)cl.getDifferentiableSequenceScore(0)).getFunction(0);
        StrandDiffSM model2 = new StrandDiffSM(model, 1, true, StrandDiffSM.InitMethod.INIT_FORWARD_STRAND, 0.5);
        double t = Double.NEGATIVE_INFINITY;
        Pair<int[][], DataSet> seqs = null;
        StringBuffer lastHeader = new StringBuffer();
        BufferedReader read = new BufferedReader(new FileReader(args[1]));
        DecimalFormat nf = new DecimalFormat("#.####");
        PrintWriter wr = new PrintWriter(String.valueOf(args[0]) + "_scores.txt");
        while ((seqs = GenomicModelScan.readNextSequences(read, lastHeader)) != null) {
            DataSet ds = seqs.getSecondElement();
            int[][] idxs = seqs.getFirstElement();
            int i = 0;
            while (i < ds.getNumberOfElements()) {
                Sequence seq = ds.getElementAt(i);
                String id = seq.getSequenceAnnotationByType("id", 0).getIdentifier();
                if (id.equals("chr10") || id.equals("chr13")) {
                    int j = 0;
                    while (j < seq.getLength() - model2.getLength() + 1) {
                        double score = model2.getLogScoreFor(seq, j);
                        StrandedLocatedSequenceAnnotationWithLength.Strand strand = model2.getStrand(seq, j);
                        if (score > t) {
                            wr.println(String.valueOf(id) + "\t" + (j + idxs[0][i]) + "\t" + score + "\t" + (strand == StrandedLocatedSequenceAnnotationWithLength.Strand.FORWARD ? "+" : "-"));
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        read.close();
        wr.close();
    }

    public static double getConsensusScore(double[][] pwm) {
        double score = 0.0;
        int i = 0;
        while (i < pwm.length) {
            score += ToolBox.max(pwm[i]);
            ++i;
        }
        return score;
    }

    public static Pair<int[][], DataSet> readNextSequences(BufferedReader read, StringBuffer lastHeader) throws Exception {
        String str = null;
        StringBuffer line = new StringBuffer();
        IntList starts = new IntList();
        LinkedList<Sequence> seqs = new LinkedList<Sequence>();
        Pattern acgt = Pattern.compile("[ACGT]+", 2);
        DNAAlphabetContainer con = DNAAlphabetContainer.SINGLETON;
        int size = 0;
        while ((str = read.readLine()) != null || line.length() > 0) {
            if (str != null) {
                str = str.trim();
            }
            if (str == null || str.startsWith(">")) {
                String header = lastHeader.toString();
                if (str != null) {
                    lastHeader.delete(0, lastHeader.length());
                    lastHeader.append(str.substring(1).trim());
                }
                if (line.length() <= 0) continue;
                String seqStr = line.toString();
                line.delete(0, line.length());
                Matcher match = acgt.matcher(seqStr);
                while (match.find()) {
                    int start = match.start();
                    int end = match.end();
                    SequenceAnnotation annotation = new SequenceAnnotation("id", header, (Result[][])new Result[0][]);
                    Sequence seq = Sequence.create(DNAAlphabetContainer.SINGLETON, seqStr.substring(start, end));
                    seq = seq.annotate(false, annotation);
                    seqs.add(seq);
                    size += end - start;
                    starts.add(start);
                }
                if (!((double)size > 1.0E7) && str != null) continue;
                boolean s = false;
                return new Pair<int[][], DataSet>(new int[][]{starts.toArray()}, new DataSet("", seqs));
            }
            line.append(str);
        }
        return null;
    }
}

