/*
 * Decompiled with CFR 0.152.
 */
package projects.dream2016;

import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifier;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.sequences.ByteSequence;
import de.jstacs.data.sequences.WrongSequenceTypeException;
import de.jstacs.io.FileManager;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.MarkovModelDiffSM;
import de.jstacs.utils.ToolBox;
import projects.dimont.AbstractSingleMotifChIPper;

public class EnumerateKMersForPWM {
    public static void main(String[] args) throws Exception {
        GenDisMixClassifier cl = new GenDisMixClassifier(FileManager.readFile(args[0]));
        MarkovModelDiffSM model = (MarkovModelDiffSM)((AbstractSingleMotifChIPper)cl.getDifferentiableSequenceScore(0)).getFunction(0);
        double[][] pwm = model.getPWM();
        int i = 0;
        while (i < pwm.length) {
            int j = 0;
            while (j < pwm[i].length) {
                pwm[i][j] = Math.log(pwm[i][j]);
                ++j;
            }
            ++i;
        }
        double t = EnumerateKMersForPWM.getConsensusScore(pwm) - (double)pwm.length * Math.log(2.0);
        byte[] kmer = new byte[pwm.length];
        EnumerateKMersForPWM.enumerateKmers(pwm, kmer, 0, 0.0, model.getAlphabetContainer(), t);
    }

    public static double getConsensusScore(double[][] pwm) {
        double score = 0.0;
        int i = 0;
        while (i < pwm.length) {
            score += ToolBox.max(pwm[i]);
            ++i;
        }
        return score;
    }

    private static void enumerateKmers(double[][] pwm, byte[] kmer, int i, double score, AlphabetContainer cont, double thresh) throws WrongAlphabetException, WrongSequenceTypeException {
        if (i == pwm.length) {
            if (score > thresh) {
                System.out.println(new ByteSequence(cont, kmer) + "\t" + score);
            }
        } else {
            int j = 0;
            while (j < pwm[i].length) {
                kmer[i] = (byte)j;
                EnumerateKMersForPWM.enumerateKmers(pwm, kmer, i + 1, score + pwm[i][j], cont, thresh);
                ++j;
            }
        }
    }
}

