/*
 * Decompiled with CFR 0.152.
 */
package projects.dream2016;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintWriter;
import projects.dream2016.BigWigAccessor;

public class DNaseWavelet {
    public static void main(String[] args) throws Exception {
        BigWigAccessor acc = new BigWigAccessor(args[0]);
        BufferedReader read = new BufferedReader(new FileReader(args[1]));
        double s = Double.parseDouble(args[2]);
        double[] wave = DNaseWavelet.getWavelet(s);
        PrintWriter wr = new PrintWriter(String.valueOf(args[1]) + "_wv_" + (int)s + ".txt");
        String str = null;
        while ((str = read.readLine()) != null) {
            String[] parts = str.split("\t");
            double[] temp = acc.getProfileInRegion(parts[0], (int)Math.round(Double.parseDouble(parts[1])) - 150 - wave.length / 2, (int)Math.round(Double.parseDouble(parts[2])) + 150 + wave.length / 2);
            temp = DNaseWavelet.apply(temp, wave);
            wr.print(temp[0]);
            int j = 1;
            while (j < temp.length) {
                wr.print("\t" + temp[j]);
                ++j;
            }
            wr.println();
        }
        read.close();
        wr.close();
    }

    private static double[] apply(double[] temp, double[] wave) {
        double[] res = new double[temp.length - wave.length];
        int i = wave.length / 2;
        while (i < temp.length - wave.length / 2) {
            int j = 0;
            while (j < wave.length) {
                int n = i - wave.length / 2;
                res[n] = res[n] + temp[i + j - wave.length / 2] * wave[j];
                ++j;
            }
            ++i;
        }
        return res;
    }

    private static double[] getWavelet(double s) {
        double[] wv = new double[(int)(s * 8.0)];
        double c = s * 4.0;
        int i = 0;
        while (i < wv.length) {
            double x = (double)i - c;
            wv[i] = 2.0 / Math.sqrt(3.0 * s * Math.sqrt(Math.PI)) * (1.0 - x * x / (s * s)) * Math.exp(-x * x / (2.0 * s * s));
            ++i;
        }
        return wv;
    }
}

