/*
 * Decompiled with CFR 0.152.
 */
package projects.dream2016;

import de.jstacs.utils.Time;
import de.jstacs.utils.ToolBox;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.broad.igv.bbfile.BBFileHeader;
import org.broad.igv.bbfile.BBFileReader;
import org.broad.igv.bbfile.BigWigIterator;
import org.broad.igv.bbfile.WigItem;

public class BigWig2Interval2 {
    public static void main(String[] args) throws IOException {
        BigWigAccessor bwa = new BigWigAccessor(args[0]);
        GZIPInputStream stream = new GZIPInputStream(new FileInputStream(args[1]));
        BufferedReader read = new BufferedReader(new InputStreamReader(stream));
        String chr = null;
        int s = -100;
        Time t = Time.getTimeInstance(null);
        String line = read.readLine();
        do {
            System.out.println(line);
            chr = line.substring(1, line.length() - 1);
            int e = 0;
            s = 0;
            FileOutputStream output = new FileOutputStream(String.valueOf(args[0]) + "-" + chr + "-interval2.txt.gz");
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)new GZIPOutputStream(output), "UTF-8"));
            w.append(line);
            w.newLine();
            while ((line = read.readLine()) != null && line.charAt(0) != '[') {
                e += 50;
            }
            double[] profile = bwa.getProfileInRegion(chr, s, e);
            while (s + 50 <= e) {
                w.append(String.valueOf(s) + "\t" + ToolBox.median(s, s + 50, profile));
                w.newLine();
                s += 50;
            }
            System.out.println(t.getElapsedTime());
            w.close();
            output.close();
        } while (line != null);
        read.close();
        stream.close();
    }

    private static class BigWigAccessor {
        private BBFileReader reader;

        public BigWigAccessor(String bigWigFile) throws IOException {
            this.reader = new BBFileReader(bigWigFile);
            BBFileHeader header = this.reader.getBBFileHeader();
            if (!header.isHeaderOK()) {
                throw new RuntimeException("Header not OK");
            }
            if (!header.isBigWig()) {
                throw new RuntimeException("No Bigwig");
            }
        }

        public double[] getProfileInRegion(String chr, int start, int end) {
            double[] res = new double[end - start];
            this.fillProfileInRegion(chr, start, end, res);
            return res;
        }

        public void fillProfileInRegion(String chr, int start, int end, double[] res) {
            BigWigIterator it = this.reader.getBigWigIterator(chr, start, chr, end, false);
            while (it.hasNext()) {
                WigItem item = it.next();
                Arrays.fill(res, Math.max(0, item.getStartBase() - start), Math.min(item.getEndBase(), end) - start, (double)item.getWigValue());
            }
        }
    }
}

