/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.REngine;

import org.rosuda.REngine.REXPDouble;
import org.rosuda.REngine.REXPList;
import org.rosuda.REngine.REXPVector;

public class REXPLogical
extends REXPVector {
    protected byte[] payload;
    static final int NA_internal = Integer.MIN_VALUE;
    public static final byte NA = -128;
    public static final byte TRUE = 1;
    public static final byte FALSE = 0;

    public static boolean isNA(byte value) {
        return value == -128;
    }

    public REXPLogical(boolean load) {
        this.payload = new byte[]{load ? (byte)1 : 0};
    }

    public REXPLogical(byte load) {
        this.payload = new byte[]{load};
    }

    public REXPLogical(byte[] load) {
        this.payload = load == null ? new byte[]{} : load;
    }

    public REXPLogical(boolean[] load) {
        this.payload = new byte[load == null ? 0 : load.length];
        if (load != null) {
            int i = 0;
            while (i < load.length) {
                this.payload[i] = load[i] ? (byte)1 : 0;
                ++i;
            }
        }
    }

    public REXPLogical(byte[] load, REXPList attr) {
        super(attr);
        this.payload = load == null ? new byte[]{} : load;
    }

    public REXPLogical(boolean[] load, REXPList attr) {
        super(attr);
        this.payload = new byte[load == null ? 0 : load.length];
        if (load != null) {
            int i = 0;
            while (i < load.length) {
                this.payload[i] = load[i] ? (byte)1 : 0;
                ++i;
            }
        }
    }

    @Override
    public int length() {
        return this.payload.length;
    }

    @Override
    public boolean isLogical() {
        return true;
    }

    @Override
    public int[] asIntegers() {
        int[] p = new int[this.payload.length];
        int i = 0;
        while (i < this.payload.length) {
            p[i] = this.payload[i] == -128 ? Integer.MIN_VALUE : (this.payload[i] == 0 ? 0 : 1);
            ++i;
        }
        return p;
    }

    @Override
    public byte[] asBytes() {
        return this.payload;
    }

    @Override
    public double[] asDoubles() {
        double[] d = new double[this.payload.length];
        int i = 0;
        while (i < this.payload.length) {
            d[i] = this.payload[i] == -128 ? REXPDouble.NA : (this.payload[i] == 0 ? 0.0 : 1.0);
            ++i;
        }
        return d;
    }

    @Override
    public String[] asStrings() {
        String[] s = new String[this.payload.length];
        int i = 0;
        while (i < this.payload.length) {
            s[i] = this.payload[i] == -128 ? "NA" : (this.payload[i] == 0 ? "FALSE" : "TRUE");
            ++i;
        }
        return s;
    }

    @Override
    public boolean[] isNA() {
        boolean[] a = new boolean[this.payload.length];
        int i = 0;
        while (i < a.length) {
            a[i] = this.payload[i] == -128;
            ++i;
        }
        return a;
    }

    public boolean[] isTRUE() {
        boolean[] a = new boolean[this.payload.length];
        int i = 0;
        while (i < a.length) {
            a[i] = this.payload[i] != -128 && this.payload[i] != 0;
            ++i;
        }
        return a;
    }

    public boolean[] isFALSE() {
        boolean[] a = new boolean[this.payload.length];
        int i = 0;
        while (i < a.length) {
            a[i] = this.payload[i] == 0;
            ++i;
        }
        return a;
    }

    public boolean[] isTrue() {
        return this.isTRUE();
    }

    public boolean[] isFalse() {
        return this.isFALSE();
    }

    @Override
    public String toDebugString() {
        StringBuffer sb = new StringBuffer(String.valueOf(super.toDebugString()) + "{");
        int i = 0;
        while (i < this.payload.length && i < maxDebugItems) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.payload[i] == -128 ? "NA" : (this.payload[i] == 0 ? "FALSE" : "TRUE"));
            ++i;
        }
        if (i < this.payload.length) {
            sb.append(",..");
        }
        return String.valueOf(sb.toString()) + "}";
    }
}

