/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.util.AbstractList;
import java.util.Collections;
import java.util.Iterator;
import org.biojava.bio.BioError;
import org.biojava.bio.symbol.AbstractLocation;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class FuzzyPointLocation
extends AbstractLocation {
    public static final PointResolver RESOLVE_MIN = new MinPointResolver();
    public static final PointResolver RESOLVE_MAX = new MaxPointResolver();
    public static final PointResolver RESOLVE_AVERAGE = new AveragePointResolver();
    private int min;
    private int max;
    private PointResolver resolver;

    public FuzzyPointLocation(int min, int max, PointResolver resolver) {
        this.min = min;
        this.max = max;
        this.resolver = resolver;
    }

    public PointResolver getResolver() {
        return this.resolver;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public boolean hasBoundedMin() {
        return this.min != Integer.MIN_VALUE;
    }

    public boolean hasBoundedMax() {
        return this.max != Integer.MAX_VALUE;
    }

    public boolean overlaps(Location loc) {
        return loc.contains(this);
    }

    public boolean contains(Location loc) {
        return this.hasBoundedMin() && this.hasBoundedMax() && this.resolver.resolve(this) == loc.getMin() && this.resolver.resolve(this) == loc.getMax();
    }

    public boolean contains(int point) {
        return this.hasBoundedMin() && this.hasBoundedMax() && this.resolver.resolve(this) == point;
    }

    public boolean equals(Location loc) {
        return this.contains(loc) && loc.contains(this);
    }

    public int hashCode() {
        return this.getMin();
    }

    public Location intersection(Location loc) {
        return loc.contains(this) ? this : Location.empty;
    }

    public SymbolList symbols(SymbolList slist) {
        final Symbol sym = slist.symbolAt(this.resolver.resolve(this));
        try {
            return new SimpleSymbolList(slist.getAlphabet(), new AbstractList(){

                public Object get(int index) throws IndexOutOfBoundsException {
                    if (index == 0) {
                        return sym;
                    }
                    throw new IndexOutOfBoundsException("Index " + index + " greater than 0");
                }

                public int size() {
                    return 1;
                }
            });
        }
        catch (IllegalSymbolException ise) {
            throw new BioError(ise);
        }
    }

    public boolean isContiguous() {
        return true;
    }

    public Iterator blockIterator() {
        return Collections.singleton(this).iterator();
    }

    public Location translate(int dist) {
        if (dist == 0) {
            return this;
        }
        return new FuzzyPointLocation(this.min + dist, this.max + dist, this.resolver);
    }

    public String toString() {
        if (this.hasBoundedMin() && this.hasBoundedMax()) {
            if (this.getMin() == this.getMax()) {
                return "?" + this.getMin();
            }
            return "[" + Integer.toString(this.getMin()) + "." + Integer.toString(this.getMax());
        }
        if (this.hasBoundedMin()) {
            return "[>" + Integer.toString(this.getMin()) + "]";
        }
        if (this.hasBoundedMax()) {
            return "[<" + Integer.toString(this.getMax()) + "]";
        }
        return "?";
    }

    private static class AveragePointResolver
    implements PointResolver {
        private AveragePointResolver() {
        }

        public int resolve(FuzzyPointLocation loc) {
            if (loc.hasBoundedMin() && loc.hasBoundedMax()) {
                return (loc.getMin() + loc.getMax()) / 2;
            }
            if (!loc.hasBoundedMin() && !loc.hasBoundedMax()) {
                return 0;
            }
            return loc.hasBoundedMin() ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        }
    }

    private static class MaxPointResolver
    implements PointResolver {
        private MaxPointResolver() {
        }

        public int resolve(FuzzyPointLocation loc) {
            if (loc.hasBoundedMax()) {
                return loc.getMax();
            }
            return Integer.MAX_VALUE;
        }
    }

    private static class MinPointResolver
    implements PointResolver {
        private MinPointResolver() {
        }

        public int resolve(FuzzyPointLocation loc) {
            if (loc.hasBoundedMin()) {
                return loc.getMin();
            }
            return Integer.MIN_VALUE;
        }
    }

    public static interface PointResolver {
        public int resolve(FuzzyPointLocation var1);
    }
}

