/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.StaticMemberPlaceHolder;

public interface StrandedFeature
extends Feature {
    public static final ChangeType STRAND = new ChangeType("Strand has altered", StrandedFeature.class, "STRAND");
    public static final Strand POSITIVE = new Strand("POSITIVE", 1, '+');
    public static final Strand NEGATIVE = new Strand("NEGATIVE", -1, '-');
    public static final Strand UNKNOWN = new Strand("UNKNOWN", 0, '.');

    public Strand getStrand();

    public void setStrand(Strand var1) throws ChangeVetoException;

    public SymbolList getSymbols();

    public static final class Strand
    implements Serializable {
        private final String text;
        private final int value;
        private final char token;

        Strand(String text, int value, char token) {
            this.text = text;
            this.value = value;
            this.token = token;
        }

        public String toString() {
            return this.text;
        }

        public int getValue() {
            return this.value;
        }

        public char getToken() {
            return this.token;
        }

        public Strand flip() {
            if (this == POSITIVE) {
                return NEGATIVE;
            }
            if (this == NEGATIVE) {
                return POSITIVE;
            }
            return this;
        }

        private Object writeReplace() throws ObjectStreamException {
            try {
                return new StaticMemberPlaceHolder(StrandedFeature.class.getField(this.text));
            }
            catch (NoSuchFieldException nsfe) {
                throw new NotSerializableException(nsfe.getMessage());
            }
        }
    }

    public static class Template
    extends Feature.Template {
        public Strand strand;
    }
}

