/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.seq.GappedSequence;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.impl.SimpleGappedSequence;
import org.biojava.bio.seq.impl.SimpleSequenceFactory;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.SimpleSymbolPropertyTable;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.bio.symbol.SymbolPropertyTable;
import org.biojava.utils.ClassTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ProteinTools {
    private static final FiniteAlphabet proteinAlpha;
    private static final FiniteAlphabet proteinTAlpha;
    private static final Map tokenToSymbol;
    private static final Map propertyTableMap;

    private ProteinTools() {
    }

    public static final FiniteAlphabet getAlphabet() {
        return proteinAlpha;
    }

    public static final FiniteAlphabet getTAlphabet() {
        return proteinTAlpha;
    }

    public static final SymbolPropertyTable getSymbolPropertyTable(String name) {
        return (SymbolPropertyTable)propertyTableMap.get(name);
    }

    public static SymbolList createProtein(String theProtein) throws IllegalSymbolException {
        SymbolTokenization p = null;
        try {
            p = ProteinTools.getTAlphabet().getTokenization("token");
        }
        catch (BioException e) {
            throw new BioError("Something has gone badly wrong with Protein", e);
        }
        return new SimpleSymbolList(p, theProtein);
    }

    public static GappedSequence createGappedProteinSequence(String theProtein, String name) throws IllegalSymbolException {
        String theProtein1 = theProtein.replaceAll("-", "");
        Sequence protein = ProteinTools.createProteinSequence(theProtein1, name);
        SimpleGappedSequence protein1 = new SimpleGappedSequence(protein);
        int pos = theProtein.indexOf(45, 0);
        while (pos != -1) {
            protein1.addGapInView(pos + 1);
            pos = theProtein.indexOf(45, pos + 1);
        }
        return protein1;
    }

    public static Sequence createProteinSequence(String protein, String name) throws IllegalSymbolException {
        try {
            return new SimpleSequenceFactory().createSequence(ProteinTools.createProtein(protein), "", name, new SimpleAnnotation());
        }
        catch (BioException se) {
            throw new BioError("Something has gone badly wrong with ProteinTAlpha", se);
        }
    }

    public static AtomicSymbol ala() {
        return (AtomicSymbol)tokenToSymbol.get("A");
    }

    public static AtomicSymbol a() {
        return ProteinTools.ala();
    }

    public static AtomicSymbol arg() {
        return (AtomicSymbol)tokenToSymbol.get("R");
    }

    public static AtomicSymbol r() {
        return ProteinTools.arg();
    }

    public static AtomicSymbol asn() {
        return (AtomicSymbol)tokenToSymbol.get("N");
    }

    public static AtomicSymbol n() {
        return ProteinTools.asn();
    }

    public static AtomicSymbol asp() {
        return (AtomicSymbol)tokenToSymbol.get("D");
    }

    public static AtomicSymbol d() {
        return ProteinTools.asp();
    }

    public static AtomicSymbol cys() {
        return (AtomicSymbol)tokenToSymbol.get("C");
    }

    public static AtomicSymbol c() {
        return ProteinTools.cys();
    }

    public static AtomicSymbol gln() {
        return (AtomicSymbol)tokenToSymbol.get("Q");
    }

    public static AtomicSymbol q() {
        return ProteinTools.gln();
    }

    public static AtomicSymbol glu() {
        return (AtomicSymbol)tokenToSymbol.get("E");
    }

    public static AtomicSymbol e() {
        return ProteinTools.glu();
    }

    public static AtomicSymbol gly() {
        return (AtomicSymbol)tokenToSymbol.get("G");
    }

    public static AtomicSymbol g() {
        return ProteinTools.gly();
    }

    public static AtomicSymbol his() {
        return (AtomicSymbol)tokenToSymbol.get("H");
    }

    public static AtomicSymbol h() {
        return ProteinTools.his();
    }

    public static AtomicSymbol ile() {
        return (AtomicSymbol)tokenToSymbol.get("I");
    }

    public static AtomicSymbol i() {
        return ProteinTools.ile();
    }

    public static AtomicSymbol leu() {
        return (AtomicSymbol)tokenToSymbol.get("L");
    }

    public static AtomicSymbol l() {
        return ProteinTools.leu();
    }

    public static AtomicSymbol lys() {
        return (AtomicSymbol)tokenToSymbol.get("K");
    }

    public static AtomicSymbol k() {
        return ProteinTools.lys();
    }

    public static AtomicSymbol met() {
        return (AtomicSymbol)tokenToSymbol.get("M");
    }

    public static AtomicSymbol m() {
        return ProteinTools.met();
    }

    public static AtomicSymbol phe() {
        return (AtomicSymbol)tokenToSymbol.get("F");
    }

    public static AtomicSymbol f() {
        return ProteinTools.phe();
    }

    public static AtomicSymbol pro() {
        return (AtomicSymbol)tokenToSymbol.get("P");
    }

    public static AtomicSymbol p() {
        return ProteinTools.pro();
    }

    public static AtomicSymbol pyl() {
        return (AtomicSymbol)tokenToSymbol.get("O");
    }

    public static AtomicSymbol o() {
        return ProteinTools.pyl();
    }

    public static AtomicSymbol sec() {
        return (AtomicSymbol)tokenToSymbol.get("U");
    }

    public static AtomicSymbol u() {
        return ProteinTools.sec();
    }

    public static AtomicSymbol ser() {
        return (AtomicSymbol)tokenToSymbol.get("S");
    }

    public static AtomicSymbol s() {
        return ProteinTools.ser();
    }

    public static AtomicSymbol thr() {
        return (AtomicSymbol)tokenToSymbol.get("T");
    }

    public static AtomicSymbol t() {
        return ProteinTools.thr();
    }

    public static AtomicSymbol trp() {
        return (AtomicSymbol)tokenToSymbol.get("W");
    }

    public static AtomicSymbol w() {
        return ProteinTools.trp();
    }

    public static AtomicSymbol tyr() {
        return (AtomicSymbol)tokenToSymbol.get("Y");
    }

    public static AtomicSymbol y() {
        return ProteinTools.tyr();
    }

    public static AtomicSymbol val() {
        return (AtomicSymbol)tokenToSymbol.get("V");
    }

    public static AtomicSymbol v() {
        return ProteinTools.val();
    }

    public static AtomicSymbol ter() {
        return (AtomicSymbol)tokenToSymbol.get("*");
    }

    static {
        tokenToSymbol = new HashMap();
        propertyTableMap = new HashMap();
        try {
            proteinAlpha = (FiniteAlphabet)AlphabetManager.alphabetForName("PROTEIN");
            proteinTAlpha = (FiniteAlphabet)AlphabetManager.alphabetForName("PROTEIN-TERM");
            SymbolTokenization st = proteinTAlpha.getTokenization("token");
            Iterator<Symbol> i = proteinTAlpha.iterator();
            while (i.hasNext()) {
                AtomicSymbol s = (AtomicSymbol)i.next();
                tokenToSymbol.put(st.tokenizeSymbol(s), s);
            }
        }
        catch (Exception e) {
            throw new BioError(" Could not initialize ProteinTools", e);
        }
        Document doc = null;
        try {
            InputStream tablesStream = ClassTools.getClassLoader(ProteinTools.class).getResourceAsStream("org/biojava/bio/symbol/ResidueProperties.xml");
            if (tablesStream == null) {
                throw new BioError("Couldn't locate ResidueProperties.xml.");
            }
            InputSource is = new InputSource(tablesStream);
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            doc = parser.parse(is);
        }
        catch (MissingResourceException mre) {
            System.err.println(mre.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            SimpleSymbolPropertyTable monoMassPropertyTable = new SimpleSymbolPropertyTable(ProteinTools.getAlphabet(), "monoMass");
            SimpleSymbolPropertyTable avgMassPropertyTable = new SimpleSymbolPropertyTable(ProteinTools.getAlphabet(), "avgMass");
            SimpleSymbolPropertyTable pK_NtermPropertyTable = new SimpleSymbolPropertyTable(ProteinTools.getAlphabet(), "pK_Nterm");
            SimpleSymbolPropertyTable pKPropertyTable = new SimpleSymbolPropertyTable(ProteinTools.getAlphabet(), "pK");
            SimpleSymbolPropertyTable pK_CtermPropertyTable = new SimpleSymbolPropertyTable(ProteinTools.getAlphabet(), "pK_Cterm");
            SimpleSymbolPropertyTable HydropathicityTable = new SimpleSymbolPropertyTable(ProteinTools.getAlphabet(), "hydropathicity");
            SymbolTokenization tokens = ProteinTools.getAlphabet().getTokenization("token");
            NodeList children = doc.getDocumentElement().getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Element child;
                Node cnode = children.item(i);
                if (!(cnode instanceof Element) || !(child = (Element)cnode).getNodeName().equals("residue")) continue;
                String token = child.getAttribute("token");
                Symbol s = tokens.parseToken(token);
                NodeList properyNodes = child.getChildNodes();
                for (int j = 0; j < properyNodes.getLength(); ++j) {
                    String value;
                    cnode = properyNodes.item(j);
                    if (!(cnode instanceof Element)) continue;
                    Element el = (Element)cnode;
                    String name = el.getAttribute("name");
                    if (name.equals("monoMass")) {
                        value = el.getAttribute("value");
                        monoMassPropertyTable.setDoubleProperty(s, value);
                        continue;
                    }
                    if (name.equals("avgMass")) {
                        value = el.getAttribute("value");
                        avgMassPropertyTable.setDoubleProperty(s, value);
                        continue;
                    }
                    if (name.equals("pK_Nterm")) {
                        value = el.getAttribute("value");
                        pK_NtermPropertyTable.setDoubleProperty(s, value);
                        continue;
                    }
                    if (name.equals("pK")) {
                        value = el.getAttribute("value");
                        pKPropertyTable.setDoubleProperty(s, value);
                        continue;
                    }
                    if (name.equals("pK_Cterm")) {
                        value = el.getAttribute("value");
                        pK_CtermPropertyTable.setDoubleProperty(s, value);
                        continue;
                    }
                    if (!name.equals("hydropathicity")) continue;
                    value = el.getAttribute("value");
                    HydropathicityTable.setDoubleProperty(s, value);
                }
            }
            propertyTableMap.put("monoMass", monoMassPropertyTable);
            propertyTableMap.put("avgMass", avgMassPropertyTable);
            propertyTableMap.put("pK_Nterm", pK_NtermPropertyTable);
            propertyTableMap.put("pK", pKPropertyTable);
            propertyTableMap.put("pK_Cterm", pK_CtermPropertyTable);
            propertyTableMap.put("hydropathicity", HydropathicityTable);
        }
        catch (Exception e) {
            throw new BioError(" Could not initialize ProteinTools", e);
        }
    }
}

