/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.homologene;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.biojava.bio.program.homologene.HomologeneDB;
import org.biojava.bio.program.homologene.OrthoPair;
import org.biojava.bio.program.homologene.OrthoPairCollection;
import org.biojava.bio.program.homologene.OrthoPairSet;
import org.biojava.bio.program.homologene.Orthologue;
import org.biojava.bio.program.homologene.OrthologueSet;
import org.biojava.bio.program.homologene.SimilarityType;
import org.biojava.bio.program.homologene.SimpleOrthoPair;
import org.biojava.bio.program.homologene.SimpleOrthoPairCollection;
import org.biojava.bio.program.homologene.SimpleOrthoPairSet;
import org.biojava.bio.program.homologene.SimpleOrthologue;
import org.biojava.bio.program.homologene.SimpleOrthologueSet;
import org.biojava.bio.program.homologene.Taxon;
import org.biojava.utils.ChangeVetoException;

public class SimpleHomologeneDB
extends SimpleOrthoPairCollection
implements HomologeneDB {
    private OrthologueSet orthologues = new SimpleOrthologueSet();
    private Set orthologySet = new HashSet();
    private Map orthologyByTaxonID = new HashMap();
    private Map orthologyBySimilarityType = new HashMap();

    public Orthologue createOrthologue(Taxon taxon, String locusID, String homologeneID, String accession) throws ChangeVetoException {
        SimpleOrthologue newOrthologue = new SimpleOrthologue(taxon, locusID, homologeneID, accession);
        this.orthologues.addOrthologue(newOrthologue);
        return newOrthologue;
    }

    public Orthologue createOrthologue(int taxonID, String locusID, String homologeneID, String accession) throws IllegalArgumentException, ChangeVetoException {
        SimpleOrthologue newOrthologue = new SimpleOrthologue(taxonID, locusID, homologeneID, accession);
        this.orthologues.addOrthologue(newOrthologue);
        return newOrthologue;
    }

    public Orthologue getOrthologue(String homologeneID) {
        return this.orthologues.getOrthologue(homologeneID);
    }

    public OrthoPair createOrthoPair(Orthologue first, Orthologue second, SimilarityType type, double percentIdentity) {
        SimpleOrthoPair newOrthoPair = new SimpleOrthoPair(first, second, type, percentIdentity);
        this.indexByTaxonID(first.getTaxonID(), newOrthoPair);
        this.indexByTaxonID(second.getTaxonID(), newOrthoPair);
        this.indexBySimilarityType(type, newOrthoPair);
        this.orthologySet.add(newOrthoPair);
        return newOrthoPair;
    }

    public OrthoPair createOrthoPair(Orthologue first, Orthologue second, String ref) {
        SimpleOrthoPair newOrthoPair = new SimpleOrthoPair(first, second, ref);
        this.indexByTaxonID(first.getTaxonID(), newOrthoPair);
        this.indexByTaxonID(second.getTaxonID(), newOrthoPair);
        this.indexBySimilarityType(SimilarityType.CURATED, newOrthoPair);
        this.orthologySet.add(newOrthoPair);
        return newOrthoPair;
    }

    public OrthoPairSet createOrthoPairSet() {
        SimpleOrthoPairSet newGroup = new SimpleOrthoPairSet();
        this.groups.add(newGroup);
        return newGroup;
    }

    public OrthoPairCollection getOrthoPairSets() {
        return new SimpleOrthoPairCollection(Collections.unmodifiableSet(this.groups));
    }

    private void indexByTaxonID(int taxonID, OrthoPair orthology) {
        Integer taxonIDIndex = new Integer(taxonID);
        HashSet<OrthoPair> indexSet = (HashSet<OrthoPair>)this.orthologyByTaxonID.get(taxonIDIndex);
        if (indexSet == null) {
            indexSet = new HashSet<OrthoPair>();
            this.orthologyByTaxonID.put(taxonIDIndex, indexSet);
        }
        indexSet.add(orthology);
    }

    private void indexBySimilarityType(SimilarityType type, OrthoPair orthology) {
        HashSet<OrthoPair> indexSet = (HashSet<OrthoPair>)this.orthologyBySimilarityType.get(type);
        if (indexSet == null) {
            indexSet = new HashSet<OrthoPair>();
            this.orthologyByTaxonID.put(type, indexSet);
        }
        indexSet.add(orthology);
    }
}

