/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.molbio;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.molbio.RestrictionEnzyme;
import org.biojava.bio.molbio.RestrictionEnzymeManager;
import org.biojava.bio.molbio.RestrictionSite;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.io.SymbolListCharSequence;
import org.biojava.bio.symbol.RangeLocation;

class RestrictionSiteFinder
implements Runnable {
    private Sequence target;
    private boolean findAll;
    private RestrictionEnzyme enzyme;

    RestrictionSiteFinder(RestrictionEnzyme enzyme, boolean findAll, Sequence target) {
        this.enzyme = enzyme;
        this.findAll = findAll;
        this.target = target;
    }

    public RestrictionEnzyme getEnzyme() {
        return this.enzyme;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        SymbolListCharSequence charSeq = new SymbolListCharSequence(this.target);
        try {
            Sequence sequence;
            int idx;
            Pattern[] patterns = RestrictionEnzymeManager.getPatterns(this.enzyme);
            int siteLen = this.enzyme.getRecognitionSite().length();
            int seqLen = this.target.length();
            int usOffset = 0;
            int dsOffset = 0;
            int[] dsCut = this.enzyme.getDownstreamCut();
            dsOffset = Math.max(dsCut[0], dsCut[1]);
            if (this.enzyme.getCutType() == 1) {
                int[] usCut = this.enzyme.getUpstreamCut();
                usOffset = Math.min(usCut[0], usCut[1]);
            }
            RestrictionSite.Template t = new RestrictionSite.Template();
            t.type = "misc_binding";
            t.source = "regex";
            t.strand = StrandedFeature.POSITIVE;
            t.annotation = RestrictionEnzymeManager.getAnnotation(this.enzyme);
            t.enzyme = this.enzyme;
            Matcher m = patterns[0].matcher(charSeq);
            while (m.find()) {
                idx = m.start() + 1;
                if (!this.findAll && (idx + usOffset < 0 || idx + dsOffset > seqLen)) continue;
                t.location = new RangeLocation(idx, idx + siteLen - 1);
                sequence = this.target;
                synchronized (sequence) {
                    this.target.createFeature(t);
                }
            }
            if (this.enzyme.isPalindromic()) return;
            t.strand = StrandedFeature.NEGATIVE;
            m = patterns[1].matcher(charSeq);
            while (m.find()) {
                idx = m.start() + 1;
                if (!this.findAll && (idx + usOffset < 0 || idx + dsOffset > seqLen)) continue;
                t.location = new RangeLocation(idx, idx + siteLen - 1);
                sequence = this.target;
                synchronized (sequence) {
                    this.target.createFeature(t);
                }
            }
            return;
        }
        catch (Exception e) {
            throw new BioRuntimeException("Failed to complete search for " + this.enzyme, e);
        }
    }
}

