/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.geometry.meshGeneration.ruppert;

import de.jtem.numericalMethods.geometry.meshGeneration.ruppert.Delaunay;

public class Ruppert
extends Delaunay {
    private static final long serialVersionUID = 1L;
    double[] cosAngle;
    double[] area;
    double cosLeastAngle;
    double largestArea;
    int maximalNumberOfTriangles;
    int numberOfBadTriangles;
    int maxNob;
    int[] badTriangles;
    int numberOfRejectedBadTriangles;
    int[] rejectedBadTriangles;
    boolean refineFlag;
    double sqrLeastDistance;
    private boolean debug;
    double[] weight;

    public Ruppert(double[][] dArray) {
        super(dArray);
        this.cosAngle = new double[3 * this.maximalNumberOfFaces];
        this.area = new double[this.maximalNumberOfFaces];
        this.maximalNumberOfTriangles = 100000;
        this.numberOfBadTriangles = 0;
        this.maxNob = 100000;
        this.badTriangles = new int[this.maxNob];
        this.rejectedBadTriangles = new int[this.maxNob];
        this.refineFlag = false;
        this.sqrLeastDistance = 0.0;
        this.debug = false;
        this.weight = null;
        this.computeAngleAndArea();
        this.refineFlag = true;
        if (this.debug) {
            System.out.println("checking segments");
        }
        this.checkSegments();
        this.cosLeastAngle = this.cosLeastAngle();
        this.largestArea = this.largestArea() * 1.01;
    }

    public void setMaximalNumberOfTriangles(int n) {
        this.maximalNumberOfTriangles = n;
    }

    public int getMaximalNumberOfTriangles() {
        return this.maximalNumberOfTriangles;
    }

    public void setAngleConstraint(double d) {
        this.cosLeastAngle = Math.cos(d * Math.PI / 180.0);
    }

    public double getAngleConstraint() {
        return Math.acos(this.cosLeastAngle) * 180.0 / Math.PI;
    }

    public void setAreaConstraint(double d) {
        this.largestArea = d;
    }

    public double getAreaConstraint() {
        return this.largestArea;
    }

    public void refine(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.refine(nArray[i]);
        }
    }

    public void refine() {
        this.sqrLeastDistance = 0.25 * Math.min(this.leastEdgeSqr(), this.largestArea);
        this.checkForBadTriangles();
        int n = this.numberOfBadTriangles + 1;
        if (this.debug) {
            System.out.println("start refining");
        }
        while (this.numberOfBadTriangles < n) {
            int n2;
            int n3;
            n = this.numberOfBadTriangles;
            for (n3 = 0; n3 <= this.numberOfBadTriangles && this.numberOfFaces <= this.maximalNumberOfTriangles; ++n3) {
                n2 = this.badTriangles[n3];
                if (!this.bad(n2)) continue;
                this.refine(n2);
            }
            this.numberOfBadTriangles = 0;
            for (n3 = 0; n3 < this.numberOfRejectedBadTriangles; ++n3) {
                n2 = this.rejectedBadTriangles[n3];
                if (!this.bad(n2)) continue;
                this.badTriangles[this.numberOfBadTriangles++] = n2;
            }
        }
        if (this.numberOfFaces >= this.maximalNumberOfTriangles && this.debug) {
            System.out.println("reached maximal number of triangles");
        }
        this.result();
    }

    public boolean[] getSegments() {
        boolean[] blArray = new boolean[3 * this.numberOfFaces];
        System.arraycopy(this.segment, 0, blArray, 0, 3 * this.numberOfFaces);
        return blArray;
    }

    public int[] getNeighbors() {
        int[] nArray = new int[3 * this.numberOfFaces];
        System.arraycopy(this.neighbor, 0, nArray, 0, 3 * this.numberOfFaces);
        return nArray;
    }

    boolean edgeIllegal(int n, int n2) {
        if (this.refineFlag) {
            int n3 = 3 * n + n2;
            if (this.segment[n3]) {
                return false;
            }
            int n4 = this.neighbor[n3];
            if (n4 < 0) {
                return false;
            }
            int n5 = 2 * this.face[this.getNeighborPtr(n4, n)];
            return this.pointInCircle(this.point[n5++], this.point[n5], n);
        }
        return super.edgeIllegal(n, n2);
    }

    void checkSegments() {
        for (int i = 0; i < this.numberOfFaces; ++i) {
            this.checkSegments(i);
        }
    }

    void checkSegments(int n) {
        for (int i = 0; i < 3; ++i) {
            this.checkSegment(n, i);
        }
    }

    boolean encroached(int n, int n2, double d, double d2) {
        int n3 = 3 * n;
        int n4 = 2 * this.face[n3 + (n2 + 1) % 3];
        int n5 = 2 * this.face[n3 + (n2 + 2) % 3];
        double d3 = this.point[n4++];
        double d4 = this.point[n4];
        double d5 = this.point[n5++];
        double d6 = this.point[n5];
        this.circleX = (d3 + d5) * 0.5;
        this.circleY = (d4 + d6) * 0.5;
        double d7 = d - this.circleX;
        double d8 = d2 - this.circleY;
        double d9 = (d5 - d3) * 0.5;
        double d10 = (d6 - d4) * 0.5;
        return d7 * d7 + d8 * d8 + 1.0E-4 < d9 * d9 + d10 * d10;
    }

    int encroached(int n, double d, double d2) {
        int n2 = 3 * n;
        int n3 = 0;
        while (n3 < 3) {
            if (this.segment[n2] && this.encroached(n, n3, d, d2)) {
                return n3;
            }
            ++n3;
            ++n2;
        }
        return -1;
    }

    boolean encroached(int n, int n2) {
        int n3 = 3 * n + n2;
        if (this.segment[n3]) {
            int n4 = 2 * this.face[n3];
            return this.encroached(n, n2, this.point[n4++], this.point[n4]);
        }
        return false;
    }

    void checkSegment(int n, int n2) {
        if (this.encroached(n, n2)) {
            int n3 = this.numberOfFaces;
            this.addPoint(this.circleX, this.circleY, n, n2);
            this.checkSegment(n, n2);
            this.checkSegment(n3, 0);
        }
    }

    void legalizeNewFaces() {
        if (this.refineFlag) {
            int n = this.newFace[0];
            int n2 = this.newFace[1];
            int n3 = this.newFace[2];
            int n4 = this.newFace[3];
            super.legalizeNewFaces();
            this.checkSegments(n);
            this.checkSegments(n2);
            if (n3 >= 0) {
                this.checkSegments(n3);
            }
            if (n4 >= 0) {
                this.checkSegments(n4);
            }
        } else {
            super.legalizeNewFaces();
        }
    }

    int flipEdge(int n, int n2) {
        if (this.refineFlag) {
            int n3 = 3 * n;
            int n4 = this.neighbor[n3 + n2];
            int n5 = n3 + (n2 + 2) % 3;
            int n6 = 3 * n4;
            int n7 = this.getNeighbor(n4, n);
            int n8 = n6 + (n7 + 2) % 3;
            boolean bl = this.segment[n5];
            boolean bl2 = this.segment[n8];
            int n9 = super.flipEdge(n, n2);
            this.segment[n3 + n2] = bl2;
            this.segment[n5] = false;
            this.segment[n6 + n7] = bl;
            this.segment[n8] = false;
            this.computeAngleAndArea(n);
            this.computeAngleAndArea(n4);
            return n9;
        }
        return super.flipEdge(n, n2);
    }

    void splitTriangle(int n) {
        if (this.refineFlag) {
            int n2 = 3 * n;
            int n3 = this.numberOfFaces;
            int n4 = 3 * this.numberOfFaces;
            boolean bl = this.segment[n2];
            boolean bl2 = this.segment[n2 + 2];
            super.splitTriangle(n);
            this.segment[n2++] = false;
            this.segment[++n2] = false;
            this.segment[n4++] = false;
            this.segment[n4++] = false;
            this.segment[n4++] = bl2;
            this.segment[n4++] = false;
            this.segment[n4++] = false;
            this.segment[n4] = bl;
            this.computeAngleAndArea(n);
            this.computeAngleAndArea(n3++);
            this.computeAngleAndArea(n3);
        } else {
            super.splitTriangle(n);
        }
    }

    void splitEdge(int n, int n2) {
        if (this.refineFlag) {
            int n3 = 3 * n;
            int n4 = n3 + (n2 + 2) % 3;
            int n5 = this.neighbor[n3 + n2];
            int n6 = 3 * n5;
            int n7 = this.numberOfFaces;
            int n8 = 3 * this.numberOfFaces;
            int n9 = 0;
            int n10 = 0;
            boolean bl = this.segment[n3 + n2];
            boolean bl2 = this.segment[n4];
            boolean bl3 = false;
            if (n5 >= 0) {
                n9 = this.getNeighbor(n5, n);
                n10 = n6 + (n9 + 1) % 3;
                bl3 = this.segment[n10];
            }
            super.splitEdge(n, n2);
            this.segment[n4] = false;
            this.segment[n8++] = bl;
            this.segment[n8++] = false;
            this.segment[n8] = bl2;
            this.computeAngleAndArea(n);
            this.computeAngleAndArea(n7);
            if (n5 >= 0) {
                this.segment[n10] = false;
                this.segment[++n8] = false;
                this.segment[++n8] = bl;
                this.segment[++n8] = bl3;
                this.computeAngleAndArea(n5);
                this.computeAngleAndArea(n7 + 1);
            }
        } else {
            super.splitEdge(n, n2);
        }
    }

    void refine(int n) {
        this.computeCircumCircle(n);
        int n2 = this.findTriangle(this.circleX, this.circleY);
        if (n2 >= 0) {
            double d = this.circleX;
            double d2 = this.circleY;
            int n3 = this.encroached(n2, d, d2);
            if (n3 < 0) {
                if (!this.pointIsToClose(d, d2, n2)) {
                    if (this.pointOnEdge < 0) {
                        this.addPoint(d, d2, n2);
                    } else {
                        this.checkNeighborForSplit(n, n2, d, d2);
                    }
                } else {
                    this.rejectBadTriangle(n);
                }
            } else if (!this.pointIsToClose(this.circleX, this.circleY, n2)) {
                this.addPoint(this.circleX, this.circleY, n2, n3);
            } else {
                this.rejectBadTriangle(n);
            }
        } else {
            int n4 = this.largestEdge(n);
            if (this.segment[3 * n + n4]) {
                this.computeMean(n, n4);
                if (!this.pointIsToClose(this.circleX, this.circleY, n)) {
                    this.addPoint(this.circleX, this.circleY, n, n4);
                } else {
                    this.rejectBadTriangle(n);
                }
            } else {
                this.rejectBadTriangle(n);
            }
        }
    }

    void checkNeighborForSplit(int n, int n2, double d, double d2) {
        int n3 = this.neighbor[3 * n2 + this.pointOnEdge];
        if (n3 >= 0) {
            if (!this.pointIsTooClose(d, d2, n3, this.getNeighbor(n3, n2))) {
                int n4 = this.encroached(n3, d, d2);
                if (n4 < 0) {
                    this.addPoint(d, d2, n2, this.pointOnEdge);
                } else if (this.pointIsToClose(this.circleX, this.circleY, n3)) {
                    this.addPoint(this.circleX, this.circleY, n3, n4);
                } else {
                    this.rejectBadTriangle(n);
                }
            } else {
                this.rejectBadTriangle(n);
            }
        } else {
            this.addPoint(d, d2, n2, this.pointOnEdge);
        }
    }

    boolean pointIsToClose(double d, double d2, int n) {
        for (int i = 0; i < 3; ++i) {
            if (!this.pointIsTooClose(d, d2, n, i)) continue;
            return true;
        }
        return false;
    }

    boolean pointIsTooClose(double d, double d2, int n, int n2) {
        return this.distanceSqr(d, d2, n, n2) < this.sqrLeastDistance;
    }

    void computeMean(int n, int n2) {
        int n3 = 3 * n;
        int n4 = 2 * this.face[n3 + (n2 + 1) % 3];
        int n5 = 2 * this.face[n3 + (n2 + 2) % 3];
        this.circleX = 0.5 * (this.point[n4++] + this.point[n5++]);
        this.circleY = 0.5 * (this.point[n4] + this.point[n5]);
    }

    int largestEdge(int n) {
        int n2 = 3 * n;
        if (this.cosAngle[n2] < this.cosAngle[n2 + 1]) {
            if (this.cosAngle[n2] < this.cosAngle[n2 + 2]) {
                return 0;
            }
            return 2;
        }
        if (this.cosAngle[n2 + 1] < this.cosAngle[n2 + 2]) {
            return 1;
        }
        return 2;
    }

    void computeAngleAndArea(int n) {
        int n2 = 3 * n;
        int n3 = 2 * this.face[n2++];
        int n4 = 2 * this.face[n2++];
        int n5 = 2 * this.face[n2];
        double d = this.point[n3++];
        double d2 = this.point[n3];
        double d3 = this.point[n4++];
        double d4 = this.point[n4];
        double d5 = this.point[n5++];
        double d6 = this.point[n5];
        double d7 = d3 - d;
        double d8 = d4 - d2;
        double d9 = d5 - d3;
        double d10 = d6 - d4;
        double d11 = d - d5;
        double d12 = d2 - d6;
        double d13 = Math.sqrt(d7 * d7 + d8 * d8);
        double d14 = Math.sqrt(d9 * d9 + d10 * d10);
        double d15 = Math.sqrt(d11 * d11 + d12 * d12);
        n2 = 3 * n;
        this.cosAngle[n2++] = -(d7 * d11 + d8 * d12) / (d13 * d15);
        this.cosAngle[n2++] = -(d7 * d9 + d8 * d10) / (d13 * d14);
        this.cosAngle[n2] = -(d9 * d11 + d10 * d12) / (d14 * d15);
        this.area[n] = this.area(n);
        this.checkForBadTriangles(n);
    }

    void computeAngleAndArea() {
        for (int i = 0; i < this.numberOfFaces; ++i) {
            this.computeAngleAndArea(i);
        }
    }

    public boolean bad(int n) {
        return this.bad(n, this.cosLeastAngle, this.largestArea);
    }

    public boolean bad(int n, double d, double d2) {
        int n2 = 3 * n;
        int n3 = n2++;
        if (this.cosAngle[n3] > d) {
            return true;
        }
        int n4 = n2++;
        if (this.cosAngle[n4] > d) {
            return true;
        }
        if (this.cosAngle[n2] > d) {
            return true;
        }
        return this.area[n] > d2;
    }

    void checkForBadTriangles() {
        this.numberOfBadTriangles = 0;
        for (int i = 0; i < this.numberOfFaces; ++i) {
            this.checkForBadTriangles(i);
        }
    }

    void checkForBadTriangles(int n) {
        if (this.bad(n)) {
            this.addToBadTriangles(n);
        }
    }

    void addToBadTriangles(int n) {
        if (this.numberOfBadTriangles == this.maxNob) {
            this.badTriangles = this.doubleSize(this.badTriangles);
            this.rejectedBadTriangles = this.doubleSize(this.rejectedBadTriangles);
            this.maxNob *= 2;
        }
        this.badTriangles[this.numberOfBadTriangles++] = n;
    }

    void rejectBadTriangle(int n) {
        if (this.numberOfRejectedBadTriangles == this.maxNob) {
            this.badTriangles = this.doubleSize(this.badTriangles);
            this.rejectedBadTriangles = this.doubleSize(this.rejectedBadTriangles);
            this.maxNob *= 2;
        }
        this.rejectedBadTriangles[this.numberOfRejectedBadTriangles++] = n;
    }

    void checkFaceArray() {
        super.checkFaceArray();
        if (this.area == null) {
            this.area = new double[this.maximalNumberOfFaces];
        }
        if (this.cosAngle == null) {
            this.cosAngle = new double[3 * this.maximalNumberOfFaces];
        }
        if (this.maximalNumberOfFaces > this.area.length) {
            this.area = this.doubleSize(this.area);
            this.cosAngle = this.doubleSize(this.cosAngle);
        }
    }

    double leastEdgeSqr() {
        double d = 4.0 * this.xyBound * this.xyBound;
        int n = 0;
        int n2 = 0;
        while (n < this.numberOfFaces) {
            for (int i = 0; i < 3; ++i) {
                int n3;
                int n4;
                double d2;
                if (this.neighbor[n2 + i] >= n || !(d > (d2 = this.distanceSqr(n4 = this.face[n2 + (i + 1) % 3], n3 = this.face[n2 + (i + 2) % 3])))) continue;
                d = d2;
            }
            ++n;
            n2 += 3;
        }
        return d;
    }

    double cosLeastAngle() {
        double d = 0.0;
        int n = 3 * this.numberOfFaces;
        for (int i = 0; i < n; ++i) {
            if (!(this.cosAngle[i] > d)) continue;
            d = this.cosAngle[i];
        }
        return d;
    }

    double largestArea() {
        double d = 0.0;
        for (int i = 0; i < this.numberOfFaces; ++i) {
            if (!(this.area[i] > d)) continue;
            d = this.area[i];
        }
        return d;
    }

    void result() {
        if (this.debug) {
            System.out.println("least angle = " + 180.0 * Math.acos(this.cosLeastAngle()) / Math.PI + "  largest area = " + this.largestArea() + "  number of faces = " + this.numberOfFaces);
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public double[] getWeight() {
        if (this.weight == null) {
            return null;
        }
        double[] dArray = new double[this.numberOfPoints];
        System.arraycopy(this.weight, 0, dArray, 0, this.numberOfPoints);
        return dArray;
    }

    public void setWeight(double[] dArray) {
        if (dArray == null) {
            this.weight = null;
            return;
        }
        if (dArray.length != this.numberOfPoints) {
            throw new IllegalArgumentException("number of weights != number of points");
        }
        this.weight = new double[this.maximalNumberOfPoints];
        System.arraycopy(dArray, 0, this.weight, 0, this.numberOfPoints);
    }

    void addPoint(double d, double d2, int n) {
        if (this.weight != null) {
            this.addWeight(d, d2, n, this.numberOfPoints);
        }
        super.addPoint(d, d2, n);
    }

    void addPoint(double d, double d2, int n, int n2) {
        if (this.weight != null) {
            this.addWeight(d, d2, n, this.numberOfPoints);
        }
        super.addPoint(d, d2, n, n2);
    }

    void checkPointArray() {
        int n = this.maximalNumberOfPoints;
        super.checkPointArray();
        if (this.weight != null && n != this.maximalNumberOfPoints) {
            this.weight = this.doubleSize(this.weight);
        }
    }

    void addWeight(double d, double d2, int n, int n2) {
        if (this.weight != null) {
            this.weight[n2] = this.interpolatedWeight(d, d2, n);
        }
    }

    double interpolatedWeight(double d, double d2, int n) {
        int n2 = this.face[3 * n];
        int n3 = this.face[3 * n + 1];
        int n4 = this.face[3 * n + 2];
        double d3 = this.point[2 * n2];
        double d4 = this.point[2 * n2 + 1];
        double d5 = this.point[2 * n3];
        double d6 = this.point[2 * n3 + 1];
        double d7 = this.point[2 * n4];
        double d8 = this.point[2 * n4 + 1];
        double d9 = Ruppert.det(d3, d4, d5, d6, d7, d8);
        return (this.weight[n2] * Ruppert.det(d, d2, d5, d6, d7, d8) + this.weight[n3] * Ruppert.det(d3, d4, d, d2, d7, d8) + this.weight[n4] * Ruppert.det(d3, d4, d5, d6, d, d2)) / d9;
    }

    double distanceSqr(int n, int n2) {
        double d = this.point[2 * n];
        double d2 = this.point[2 * n + 1];
        double d3 = this.point[2 * n2];
        double d4 = this.point[2 * n2 + 1];
        double d5 = (d - d3) * (d - d3) + (d2 - d4) * (d2 - d4);
        if (this.weight != null) {
            d5 *= 0.5 * (this.weight[n] + this.weight[n2]);
        }
        return d5;
    }

    double distanceSqr(double d, double d2, int n, int n2) {
        int n3 = this.face[3 * n + n2];
        double d3 = this.point[2 * n3];
        double d4 = this.point[2 * n3 + 1];
        double d5 = (d3 - d) * (d3 - d) + (d4 - d2) * (d4 - d2);
        if (this.weight != null) {
            d5 *= 0.5 * (this.weight[n3] + this.interpolatedWeight(d, d2, n));
        }
        return d5;
    }

    protected double area(int n) {
        int n2 = this.face[3 * n];
        int n3 = this.face[3 * n + 1];
        int n4 = this.face[3 * n + 2];
        double d = this.point[2 * n2];
        double d2 = this.point[2 * n2 + 1];
        double d3 = this.point[2 * n3];
        double d4 = this.point[2 * n3 + 1];
        double d5 = this.point[2 * n4];
        double d6 = this.point[2 * n4 + 1];
        double d7 = Ruppert.det(d, d2, d3, d4, d5, d6) / 2.0;
        if (this.weight != null) {
            d7 *= (this.weight[n2] * this.weight[n2] + this.weight[n3] * this.weight[n3] + this.weight[n4] * this.weight[n4]) / 3.0;
        }
        return d7;
    }

    static double det(double d, double d2, double d3, double d4, double d5, double d6) {
        return (d4 - d2) * (d - d5) - (d3 - d) * (d2 - d6);
    }
}

