/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.specialFunctions;

public class Gamma {
    private static final double a = Math.sqrt(Math.PI * 2) * 1.000000000190015;
    private static final double b = Math.sqrt(Math.PI * 2) * 76.18009172947146;
    private static final double c = Math.sqrt(Math.PI * 2) * -86.50532032941678;
    private static final double d = Math.sqrt(Math.PI * 2) * 24.01409824083091;
    private static final double e = Math.sqrt(Math.PI * 2) * -1.231739572450155;
    private static final double f = Math.sqrt(Math.PI * 2) * 0.001208650973866179;
    private static final double g = Math.sqrt(Math.PI * 2) * -5.395239384953E-6;
    static int MAX_NUMBER_OF_ITERATIONS = 200;
    static double EPS = 1.0E-16;
    static double MIN_DP = 1.0E-30;

    private Gamma() {
    }

    static double gamma_(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("argument must be positive");
        }
        double d2 = Math.exp(Math.log(d + 5.5) * (d + 0.5) - (d + 5.5));
        return d2 * (a + b / (d + 1.0) + c / (d + 2.0) + Gamma.d / (d + 3.0) + e / (d + 4.0) + f / (d + 5.0) + g / (d + 6.0)) / d;
    }

    public static double gamma(double d) {
        return d <= 0.5 ? Math.PI / Gamma.gamma_(1.0 - d) / Math.sin(Math.PI * d) : Gamma.gamma_(d);
    }

    static double logOfGamma_(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("argument must be positive");
        }
        double d2 = Math.log(d + 5.5) * (d + 0.5) - (d + 5.5);
        return d2 + Math.log((a + b / (d + 1.0) + c / (d + 2.0) + Gamma.d / (d + 3.0) + e / (d + 4.0) + f / (d + 5.0) + g / (d + 6.0)) / d);
    }

    public static double logOfGamma(double d) {
        return d <= 0.5 ? Math.log(Math.PI / Math.sin(Math.PI * d)) - Gamma.logOfGamma_(1.0 - d) : Gamma.logOfGamma_(d);
    }

    private static double gamma(double d, double d2, double d3, boolean bl) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("a is not positive");
        }
        if (d2 < 0.0) {
            throw new IllegalArgumentException("x is negative");
        }
        if (d2 < d + 1.0) {
            if (bl) {
                d3 = Gamma.gamma(d);
            }
            return Gamma.computeViaSeries(d, d2, d3);
        }
        return Gamma.computeViaContinuedFraction(d, d2);
    }

    public static double gamma(double d, double d2, double d3) {
        return Gamma.gamma(d, d2, d3, false);
    }

    public static double gamma(double d, double d2) {
        return Gamma.gamma(d, d2, 123.0, true);
    }

    static double computeViaSeries(double d, double d2, double d3) {
        double d4;
        double d5 = d;
        double d6 = d4 = 1.0 / d;
        int n = 0;
        while (Math.abs(d4) > Math.abs(d6) * EPS) {
            d6 += (d4 *= d2 / (d5 += 1.0));
            if (n <= MAX_NUMBER_OF_ITERATIONS) continue;
            throw new RuntimeException("exeeded max number of iterations=" + MAX_NUMBER_OF_ITERATIONS);
        }
        return d3 - d6 * Math.exp(d * Math.log(d2) - d2);
    }

    static double computeViaContinuedFraction(double d, double d2) {
        double d3;
        double d4 = d2 + 1.0 - d;
        double d5 = 1.0 / MIN_DP;
        double d6 = d3 = 1.0 / d4;
        for (int i = 1; i < MAX_NUMBER_OF_ITERATIONS; ++i) {
            double d7 = (double)(-i) * ((double)i - d);
            d3 = d7 * d3 + (d4 += 2.0);
            if (Math.abs(d5 = d7 / d5 + d4) < MIN_DP) {
                d5 = MIN_DP;
            }
            if (Math.abs(d3) < MIN_DP) {
                d3 = MIN_DP;
            }
            d3 = 1.0 / d3;
            double d8 = d5 * d3;
            d6 *= d8;
            if (!(Math.abs(d8 - 1.0) < EPS)) continue;
            return d6 * Math.exp(d * Math.log(d2) - d2);
        }
        throw new RuntimeException("exeeded max number of iterations=" + MAX_NUMBER_OF_ITERATIONS);
    }
}

