/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.odeSolving;

import de.jtem.numericalMethods.calculus.odeSolving.ODE;
import de.jtem.numericalMethods.calculus.odeSolving.ODEIntermediateResultListener;
import de.jtem.numericalMethods.calculus.odeSolving.OdeSolver;
import java.io.Serializable;

public final class Extrap
implements OdeSolver,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private int KM;
    private int numOfEquations;
    private double absTol = 1.0E-7;
    private double relTol = 1.0E-7;
    private double[] WORK;
    private int[] IWORK;
    private double[] DY;
    private double[] YH1;
    private double[] YH2;
    private double[] DZ;
    private double[] SCAL;
    private double[] HH;
    private double[] W;
    private double[] A;
    private double[] ERRFAC;
    private double[][] T;
    private int[] NJ;
    private int[] IPOINT;
    private double SAFE1;
    private double SAFE2;
    private double SAFE3;
    private double FAC1;
    private double FAC2;
    private double FAC3;
    private double FAC4;
    private double UROUND;
    private double HMAX;
    private double ERR;
    private double FAC;
    private double ERROLD;
    private int NFCN;
    private int NSTEP;
    private int NACCPT;
    private int NREJCT;
    private int NMAX;
    private int MUDIF;
    private int NSEQU;
    private int MSTAB;
    private int JSTAB;
    private int IDERR;
    private boolean ATOV;
    private boolean REJECT;
    private double[] H = new double[]{0.1};
    private final double[] rTol = new double[1];
    private final double[] aTol = new double[1];

    public Extrap(int n, int n2) {
        this.WORK = new double[21];
        this.IWORK = new int[22];
        this.setNumOfEquations(n);
        this.setMaxTableSize(n2);
    }

    public Extrap(int n) {
        this(n, 9);
    }

    public Extrap() {
        this(1, 9);
    }

    public int getNumOfEquations() {
        return this.numOfEquations;
    }

    public void setNumOfEquations(int n) {
        if (this.numOfEquations == n) {
            return;
        }
        this.numOfEquations = n;
        this.DY = new double[n];
        this.YH1 = new double[n];
        this.YH2 = new double[n];
        this.DZ = new double[n];
        this.SCAL = new double[n];
        this.T = new double[this.KM][n];
    }

    public int getMaxTableSize() {
        return this.KM;
    }

    public void setMaxTableSize(int n) {
        if (this.KM == n) {
            return;
        }
        if (n < 3) {
            throw new IllegalArgumentException("KM must be bigger then 2");
        }
        this.KM = n;
        this.HH = new double[n + 1];
        this.W = new double[n + 1];
        this.A = new double[n + 1];
        this.ERRFAC = new double[2 * n + 1];
        this.T = new double[n][this.numOfEquations + 1];
        this.NJ = new int[n + 1];
        this.IPOINT = new int[n + 2];
    }

    public double getAbsTol() {
        return this.absTol;
    }

    public void setAbsTol(double d) {
        if (this.absTol == d) {
            return;
        }
        this.absTol = d;
    }

    public double getRelTol() {
        return this.relTol;
    }

    public void setRelTol(double d) {
        if (this.relTol == d) {
            return;
        }
        this.relTol = d;
    }

    public void printStatistics() {
        System.out.println(" fcn= " + this.NFCN + " step= " + this.NSTEP + " accpt= " + this.NACCPT + " rejct= " + this.NREJCT);
    }

    public void setIntParameter(int n, int n2) {
        this.IWORK[n] = n2;
    }

    public void setDoubleParameter(int n, double d) {
        this.WORK[n] = d;
    }

    public double getCurrentStepSize() {
        return this.H[0];
    }

    public void setCurrentStepSize(double d) {
        this.H[0] = d;
    }

    public void odex(ODE oDE, double[] dArray, double d, double d2) {
        this.odex(oDE, dArray, d, d2, this.H, this.relTol, this.absTol, null);
    }

    public void odex(ODE oDE, double[] dArray, double d, double d2, double d3) {
        this.odex(oDE, dArray, d2, d3, this.H, d, d, null);
    }

    public void odex(ODE oDE, double[] dArray, double d, double d2, ODEIntermediateResultListener oDEIntermediateResultListener) {
        this.odex(oDE, dArray, d, d2, this.H, this.relTol, this.absTol, oDEIntermediateResultListener);
    }

    public void odex(ODE oDE, double[] dArray, double d, double d2, double d3, ODEIntermediateResultListener oDEIntermediateResultListener) {
        this.odex(oDE, dArray, d, d2, this.H, d3, d3, oDEIntermediateResultListener);
    }

    public static void solve(ODE oDE, double[] dArray, double d, double d2, double d3) {
        int n = oDE.getNumberOfEquations();
        new Extrap(n).odex(oDE, dArray, d, d2, d3, null);
    }

    public static void solve(ODE oDE, double[] dArray, double d, double d2, double d3, ODEIntermediateResultListener oDEIntermediateResultListener) {
        int n = oDE.getNumberOfEquations();
        new Extrap(n).odex(oDE, dArray, d, d2, d3, oDEIntermediateResultListener);
    }

    public void odex(ODE oDE, double[] dArray, double d) {
        this.odex(oDE, dArray, d, new double[]{0.1}, this.rTol[0], this.aTol[0], null);
    }

    public void odex(ODE oDE, double[] dArray, double d, double[] dArray2, double d2, double d3, ODEIntermediateResultListener oDEIntermediateResultListener) {
        int n = oDE.getNumberOfEquations();
        double[] dArray3 = new double[n];
        System.arraycopy(dArray, 1, dArray3, 0, n);
        new Extrap(n).odex(oDE, dArray3, dArray[0], d, dArray2, d2, d3, oDEIntermediateResultListener);
        System.arraycopy(dArray3, 0, dArray, 1, n);
    }

    public void odex(ODE oDE, double[] dArray, double d, double d2, double[] dArray2, double d3, double d4) {
        this.odex(oDE, dArray, d, d2, dArray2, d3, d4, null);
    }

    public void odex(ODE oDE, double[] dArray, double d, double d2, double[] dArray2, double d3, double d4, ODEIntermediateResultListener oDEIntermediateResultListener) {
        this.rTol[0] = d3;
        this.aTol[0] = d4;
        this.odex(oDE, dArray, d, d2, dArray2, this.rTol, this.aTol, 0, oDEIntermediateResultListener);
    }

    public void odex(ODE oDE, double[] dArray, double d, double d2, double[] dArray2, double[] dArray3, double[] dArray4, int n, ODEIntermediateResultListener oDEIntermediateResultListener) {
        this.NFCN = 0;
        this.NSTEP = 0;
        this.NACCPT = 0;
        this.NREJCT = 0;
        if (this.IWORK[1] == 0) {
            this.NMAX = 10000;
        } else {
            this.NMAX = this.IWORK[1];
            if (this.NMAX < 0) {
                throw new IllegalArgumentException(" WRONG INPUT IWORK[ 1 ]= " + this.IWORK[1]);
            }
        }
        this.NSEQU = this.IWORK[3];
        if (this.NSEQU == 0) {
            this.NSEQU = 1;
        }
        if (this.NSEQU < 0 || this.NSEQU >= 6) {
            throw new IllegalArgumentException(" CURIOUS INPUT IWORK[ 3 ]= " + this.IWORK[3]);
        }
        this.MSTAB = this.IWORK[4] == 0 ? 1 : this.IWORK[4];
        this.JSTAB = this.IWORK[5] == 0 ? 2 : this.IWORK[5];
        if (this.IWORK[7] == 0) {
            this.MUDIF = 4;
        } else {
            this.MUDIF = this.IWORK[7];
            if (this.MUDIF <= 0 || this.MUDIF >= 7) {
                throw new IllegalArgumentException(" WRONG INPUT IWORK[ 7 ]  " + this.IWORK[7]);
            }
        }
        if (this.WORK[1] == 0.0) {
            this.UROUND = 2.3E-16;
        } else {
            this.UROUND = this.WORK[1];
            if (this.UROUND <= 1.0E-35 || this.UROUND >= 1.0) {
                throw new IllegalArgumentException(" WHICH MACHINE DO YOU HAVE? YOUR UROUND WAS:  " + this.WORK[1]);
            }
        }
        this.HMAX = this.WORK[2] == 0.0 ? d2 - d : Math.abs(this.WORK[2]);
        if (this.WORK[3] == 0.0) {
            this.SAFE3 = 0.5;
        } else {
            this.SAFE3 = this.WORK[3];
            if (this.SAFE3 <= this.UROUND || this.SAFE3 >= 1.0) {
                throw new IllegalArgumentException(" CURIOUS INPUT WORK[ 3 ]= " + this.WORK[3]);
            }
        }
        this.FAC1 = this.WORK[4] == 0.0 ? 0.02 : this.WORK[4];
        this.FAC2 = this.WORK[5] == 0.0 ? 4.0 : this.WORK[5];
        this.FAC3 = this.WORK[6] == 0.0 ? 0.8 : this.WORK[6];
        this.FAC4 = this.WORK[7] == 0.0 ? 0.9 : this.WORK[7];
        this.SAFE1 = this.WORK[8] == 0.0 ? 0.65 : this.WORK[8];
        this.SAFE2 = this.WORK[9] == 0.0 ? 0.94 : this.WORK[9];
        this.odxcore(oDE, dArray, d, d2, dArray2, dArray3, dArray4, n, oDEIntermediateResultListener);
        this.IWORK[17] = this.NFCN;
        this.IWORK[18] = this.NSTEP;
        this.IWORK[19] = this.NACCPT;
        this.IWORK[20] = this.NREJCT;
    }

    private void odxcore(ODE oDE, double[] dArray, double d, double d2, double[] dArray2, double[] dArray3, double[] dArray4, int n, ODEIntermediateResultListener oDEIntermediateResultListener) {
        int n2;
        switch (this.NSEQU) {
            case 1: {
                int n3;
                for (n3 = 1; n3 <= this.KM; ++n3) {
                    this.NJ[n3] = 2 * n3;
                }
                break;
            }
            case 2: {
                int n3;
                this.NJ[1] = 2;
                for (n3 = 2; n3 <= this.KM; ++n3) {
                    this.NJ[n3] = 4 * n3 - 4;
                }
                break;
            }
            case 3: {
                int n3;
                this.NJ[1] = 2;
                this.NJ[2] = 4;
                this.NJ[3] = 6;
                for (n3 = 4; n3 <= this.KM; ++n3) {
                    this.NJ[n3] = 2 * this.NJ[n3 - 2];
                }
                break;
            }
            case 4: {
                int n3;
                for (n3 = 1; n3 <= this.KM; ++n3) {
                    this.NJ[n3] = 4 * n3 - 2;
                }
                break;
            }
            case 5: {
                int n3;
                for (n3 = 1; n3 <= this.KM; ++n3) {
                    this.NJ[n3] = 4 * n3;
                }
                break;
            }
        }
        double d3 = d;
        this.A[1] = 1.0 + (double)this.NJ[1];
        for (n2 = 2; n2 <= this.KM; ++n2) {
            this.A[n2] = this.A[n2 - 1] + (double)this.NJ[n2];
        }
        for (n2 = 0; n2 < this.numOfEquations; ++n2) {
            this.SCAL[n2] = n == 0 ? dArray4[0] + dArray3[0] * Math.abs(dArray[n2]) : dArray4[n2] + dArray3[n2] * Math.abs(dArray[n2]);
        }
        double d4 = d2 - d >= 0.0 ? 1.0 : -1.0;
        int n4 = Math.max(2, Math.min(this.KM - 1, (int)(-Math.log(dArray3[0]) / Math.log(10.0) * 0.6 + 1.5)));
        this.HMAX = Math.abs(this.HMAX);
        dArray2[0] = Math.max(Math.abs(dArray2[0]), 1.0E-4);
        dArray2[0] = d4 * Math.min(dArray2[0], Math.min(this.HMAX, Math.abs(d2 - d) / 2.0));
        if (oDEIntermediateResultListener != null) {
            oDEIntermediateResultListener.intermediateResult(d, dArray, 0);
        }
        this.ERR = 0.0;
        this.ERROLD = 1.0E10;
        double d5 = d4 * this.HMAX;
        this.W[1] = 0.0;
        this.REJECT = false;
        boolean bl = false;
        int n5 = 0;
        block14: while (true) {
            int n6;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            this.ATOV = false;
            if (0.1 * Math.abs(d2 - d) <= Math.abs(d) * this.UROUND) {
                return;
            }
            dArray2[0] = d4 * Math.min(Math.min(Math.abs(dArray2[0]), Math.abs(d2 - d)), Math.min(this.HMAX, Math.abs(d5)));
            if ((d + 1.01 * dArray2[0] - d2) * d4 > 0.0) {
                dArray2[0] = d2 - d;
                bl = true;
            }
            oDE.eval(d, dArray, this.DZ);
            ++this.NFCN;
            if (this.NSTEP == 0 || bl) {
                ++this.NSTEP;
                for (n6 = 1; n6 <= n4; ++n6) {
                    n5 = n6;
                    this.midex(oDE, n6, d, dArray, dArray2, dArray3, dArray4, n);
                    if (this.ATOV) continue block14;
                    if (n6 <= 1 || !(this.ERR <= 1.0)) continue;
                    bl3 = true;
                    break;
                }
                bl2 = true;
            }
            while (true) {
                if (!(bl2 || bl3 || bl4)) {
                    bl2 = false;
                    ++this.NSTEP;
                    if (this.NSTEP >= this.NMAX) {
                        throw new IllegalArgumentException(" EXIT OF ODEX AT X= " + d + " H = " + dArray2[0] + " NUMBER OF STEPS > " + this.NSTEP);
                    }
                    n5 = n4 - 1;
                    for (n6 = 1; n6 <= n5; ++n6) {
                        this.midex(oDE, n6, d, dArray, dArray2, dArray3, dArray4, n);
                        if (this.ATOV) continue block14;
                    }
                    if (n4 == 2 || this.REJECT) {
                        bl3 = false;
                        bl4 = false;
                    } else if (this.ERR <= 1.0) {
                        bl3 = true;
                        bl4 = false;
                    } else if (this.ERR > (double)(this.NJ[n4 + 1] * this.NJ[n4]) / 4.0 * ((double)(this.NJ[n4 + 1] * this.NJ[n4]) / 4.0)) {
                        bl3 = false;
                        bl4 = true;
                    } else {
                        bl3 = false;
                        bl4 = false;
                    }
                    if (!bl3 && !bl4) {
                        this.midex(oDE, n4, d, dArray, dArray2, dArray3, dArray4, n);
                        if (this.ATOV) continue block14;
                        n5 = n4;
                        if (this.ERR <= 1.0) {
                            bl3 = true;
                            bl4 = false;
                        }
                    }
                } else {
                    bl2 = false;
                }
                if (!bl3 && !bl4) {
                    bl3 = false;
                    if (this.ERR > (double)this.NJ[n4 + 1] / 2.0 * ((double)this.NJ[n4 + 1] / 2.0)) {
                        bl4 = true;
                    } else {
                        n5 = n4 + 1;
                        this.midex(oDE, n5, d, dArray, dArray2, dArray3, dArray4, n);
                        if (this.ATOV) continue block14;
                        if (this.ERR > 1.0) {
                            bl4 = true;
                        }
                    }
                } else {
                    bl3 = false;
                }
                if (!bl4) {
                    d += dArray2[0];
                    for (int i = 0; i < this.numOfEquations; ++i) {
                        dArray[i] = this.T[0][i];
                    }
                    ++this.NACCPT;
                    if (oDEIntermediateResultListener != null) {
                        oDEIntermediateResultListener.intermediateResult(d, dArray, 0);
                    }
                    if (n5 == 2) {
                        n6 = Math.min(3, this.KM - 1);
                        if (this.REJECT) {
                            n6 = 2;
                        }
                    } else if (n5 <= n4) {
                        n6 = n5;
                        if (this.W[n5 - 1] < this.W[n5] * this.FAC3) {
                            n6 = n5 - 1;
                        }
                        if (this.W[n5] < this.W[n5 - 1] * this.FAC4) {
                            n6 = Math.min(n5 + 1, this.KM - 1);
                        }
                    } else {
                        n6 = n5 - 1;
                        if (n5 > 3 && this.W[n5 - 2] < this.W[n5 - 1] * this.FAC3) {
                            n6 = n5 - 2;
                        }
                        if (this.W[n5] < this.W[n6] * this.FAC4) {
                            n6 = Math.min(n5, this.KM - 1);
                        }
                    }
                    if (this.REJECT) {
                        n4 = Math.min(n6, n5);
                        dArray2[0] = d4 * Math.min(Math.abs(dArray2[0]), Math.abs(this.HH[n4]));
                        this.REJECT = false;
                        continue block14;
                    }
                    dArray2[0] = n6 <= n5 ? this.HH[n6] : (n5 < n4 && this.W[n5] < this.W[n5 - 1] * this.FAC4 ? this.HH[n5] * this.A[n6 + 1] / this.A[n5] : this.HH[n5] * this.A[n6] / this.A[n5]);
                    n4 = n6;
                    dArray2[0] = d4 * Math.abs(dArray2[0]);
                    continue block14;
                }
                bl4 = false;
                if ((n4 = Math.min(n4, Math.min(n5, this.KM - 1))) > 2 && this.W[n4 - 1] < this.W[n4] * this.FAC3) {
                    --n4;
                }
                ++this.NREJCT;
                dArray2[0] = d4 * this.HH[n4];
                this.REJECT = true;
            }
            break;
        }
    }

    private void midex(ODE oDE, int n, double d, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, int n2) {
        int n3;
        int n4;
        int n5;
        double d2 = dArray2[0] / (double)this.NJ[n];
        for (n5 = 0; n5 < this.numOfEquations; ++n5) {
            this.YH1[n5] = dArray[n5];
            this.YH2[n5] = dArray[n5] + d2 * this.DZ[n5];
        }
        n5 = this.NJ[n] - 1;
        for (n4 = 1; n4 <= n5; ++n4) {
            oDE.eval(d + d2 * (double)n4, this.YH2, this.DY);
            for (int i = 0; i < this.numOfEquations; ++i) {
                double d3 = this.YH1[i];
                this.YH1[i] = this.YH2[i];
                this.YH2[i] = d3 + 2.0 * d2 * this.DY[i];
            }
            if (n4 > this.MSTAB || n > this.JSTAB) continue;
            double d4 = 0.0;
            for (int i = 0; i < this.numOfEquations; ++i) {
                d4 += this.DZ[i] / this.SCAL[i] * (this.DZ[i] / this.SCAL[i]);
            }
            double d5 = 0.0;
            for (int i = 0; i < this.numOfEquations; ++i) {
                d5 += (this.DY[i] - this.DZ[i]) / this.SCAL[i] * ((this.DY[i] - this.DZ[i]) / this.SCAL[i]);
            }
            double d6 = d5 / Math.max(this.UROUND, d4);
            if (!(d6 > 4.0)) continue;
            ++this.NFCN;
            this.ATOV = true;
            dArray2[0] = dArray2[0] * this.SAFE3;
            this.REJECT = true;
            return;
        }
        oDE.eval(d + dArray2[0], this.YH2, this.DY);
        for (n4 = 0; n4 < this.numOfEquations; ++n4) {
            this.T[n - 1][n4] = (this.YH1[n4] + this.YH2[n4] + d2 * this.DY[n4]) / 2.0;
        }
        this.NFCN += this.NJ[n];
        if (n == 1) {
            return;
        }
        double d7 = this.NJ[n];
        for (n3 = n; n3 >= 2; --n3) {
            this.FAC = d7 / (double)this.NJ[n3 - 1] * (d7 / (double)this.NJ[n3 - 1]) - 1.0;
            for (int i = 0; i < this.numOfEquations; ++i) {
                this.T[n3 - 2][i] = this.T[n3 - 1][i] + (this.T[n3 - 1][i] - this.T[n3 - 2][i]) / this.FAC;
            }
        }
        this.ERR = 0.0;
        for (n3 = 0; n3 < this.numOfEquations; ++n3) {
            double d8 = Math.max(Math.abs(dArray[n3]), Math.abs(this.T[0][n3]));
            this.SCAL[n3] = n2 == 0 ? dArray4[0] + dArray3[0] * d8 : dArray4[n3] + dArray3[n3] * d8;
            this.ERR += (this.T[0][n3] - this.T[1][n3]) / this.SCAL[n3] * ((this.T[0][n3] - this.T[1][n3]) / this.SCAL[n3]);
        }
        this.ERR = Math.sqrt(this.ERR / (double)this.numOfEquations);
        if (this.ERR * this.UROUND >= 1.0) {
            this.ATOV = true;
            dArray2[0] = dArray2[0] * this.SAFE3;
            this.REJECT = true;
            return;
        }
        if (n > 2 && this.ERR >= this.ERROLD) {
            this.ATOV = true;
            dArray2[0] = dArray2[0] * this.SAFE3;
            this.REJECT = true;
            return;
        }
        this.ERROLD = Math.max(4.0 * this.ERR, 1.0);
        double d9 = 1.0 / (double)(2 * n - 1);
        double d10 = Math.pow(this.FAC1, d9);
        this.FAC = Math.min(this.FAC2 / d10, Math.max(d10, Math.pow(this.ERR / this.SAFE1, d9) / this.SAFE2));
        this.FAC = 1.0 / this.FAC;
        this.HH[n] = Math.min(Math.abs(dArray2[0]) * this.FAC, this.HMAX);
        this.W[n] = this.A[n] / this.HH[n];
    }
}

