/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.utils.graphics;

import de.jstacs.utils.graphics.SVGAdaptor;
import java.awt.Graphics2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.fop.svg.PDFTranscoder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PDFAdaptor
extends SVGAdaptor {
    private int width;
    private int height;

    @Override
    public Graphics2D getGraphics(int width, int height) {
        this.width = width;
        this.height = height;
        return super.getGraphics(width, height);
    }

    @Override
    public void generateOutput(File file) throws IOException {
        Document doc = this.graphics.getDOMFactory();
        Element rootE = doc.getDocumentElement();
        this.graphics.getRoot(rootE);
        TranscoderInput input = new TranscoderInput(doc);
        PDFTranscoder trans = new PDFTranscoder();
        trans.addTranscodingHint(PDFTranscoder.KEY_WIDTH, Float.valueOf(this.width));
        trans.addTranscodingHint(PDFTranscoder.KEY_HEIGHT, Float.valueOf(this.height));
        trans.addTranscodingHint(PDFTranscoder.KEY_STROKE_TEXT, false);
        FileOutputStream stream = new FileOutputStream(file);
        TranscoderOutput output = new TranscoderOutput(stream);
        try {
            trans.transcode(input, output);
        }
        catch (TranscoderException e) {
            throw new IOException(e);
        }
        stream.flush();
        stream.close();
    }

    @Override
    public String getGraphicsExtension() {
        return "pdf";
    }
}

