/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.DifferentiableEmission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.Emission;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.ToolBox;
import de.jstacs.utils.random.DirichletMRG;
import de.jstacs.utils.random.DirichletMRGParams;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.LinkedList;
import javax.naming.OperationNotSupportedException;

public class CodonEmission
implements DifferentiableEmission {
    private static String[] codes = new String[]{"F", "L", "I", "M", "V", "S", "P", "T", "A", "Y", "*", "H", "Q", "N", "K", "D", "E", "C", "W", "R", "G"};
    private double[] asParameters;
    private double[] asProbs;
    private double[] statistic;
    private final int[][][] codonMap;
    private double ess;
    private double logNorm;
    private int offset;
    private int priorCodon;
    private double pCodon;

    public CodonEmission clone() throws CloneNotSupportedException {
        CodonEmission clone = (CodonEmission)super.clone();
        clone.asParameters = (double[])this.asParameters.clone();
        clone.asProbs = (double[])this.asProbs.clone();
        clone.statistic = (double[])this.statistic.clone();
        return clone;
    }

    public CodonEmission(boolean mapCodonsToAs, double ess, Sequence priorCodon, double pCodon) {
        this.pCodon = pCodon;
        this.ess = ess;
        this.codonMap = new int[4][4][4];
        if (mapCodonsToAs) {
            this.codonMap[3][3][1] = 0;
            this.codonMap[3][3][3] = 0;
            this.codonMap[3][3][2] = 1;
            this.codonMap[3][3][0] = 1;
            Arrays.fill(this.codonMap[1][3], 1);
            Arrays.fill(this.codonMap[0][3], 2);
            this.codonMap[0][3][2] = 3;
            Arrays.fill(this.codonMap[2][3], 4);
            Arrays.fill(this.codonMap[3][1], 5);
            Arrays.fill(this.codonMap[1][1], 6);
            Arrays.fill(this.codonMap[0][1], 7);
            Arrays.fill(this.codonMap[2][1], 8);
            this.codonMap[3][0][1] = 9;
            this.codonMap[3][0][3] = 9;
            this.codonMap[3][2][0] = 10;
            this.codonMap[3][0][2] = 10;
            this.codonMap[3][0][0] = 10;
            this.codonMap[1][0][1] = 11;
            this.codonMap[1][0][3] = 11;
            this.codonMap[1][0][2] = 12;
            this.codonMap[1][0][0] = 12;
            this.codonMap[0][0][1] = 13;
            this.codonMap[0][0][3] = 13;
            this.codonMap[0][0][2] = 14;
            this.codonMap[0][0][0] = 14;
            this.codonMap[2][0][1] = 15;
            this.codonMap[2][0][3] = 15;
            this.codonMap[2][0][2] = 16;
            this.codonMap[2][0][0] = 16;
            this.codonMap[3][2][1] = 17;
            this.codonMap[3][2][3] = 17;
            this.codonMap[3][2][2] = 18;
            Arrays.fill(this.codonMap[1][2], 19);
            this.codonMap[0][2][1] = 5;
            this.codonMap[0][2][3] = 5;
            this.codonMap[0][2][2] = 19;
            this.codonMap[0][2][0] = 19;
            Arrays.fill(this.codonMap[2][2], 20);
            this.asParameters = new double[21];
            this.asProbs = new double[21];
            this.statistic = new double[21];
        } else {
            int l = 0;
            int i = 0;
            while (i < this.codonMap.length) {
                int j = 0;
                while (j < this.codonMap[i].length) {
                    int k = 0;
                    while (k < this.codonMap[i][j].length) {
                        this.codonMap[i][j][k] = l++;
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            this.asParameters = new double[l];
            this.asProbs = new double[l];
            this.statistic = new double[l];
        }
        this.priorCodon = priorCodon == null ? -1 : this.codonMap[priorCodon.discreteVal(0)][priorCodon.discreteVal(1)][priorCodon.discreteVal(2)];
    }

    public CodonEmission(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, this.getClass().getSimpleName());
        this.asParameters = (double[])XMLParser.extractObjectForTags(xml, "asParameters");
        this.asProbs = (double[])XMLParser.extractObjectForTags(xml, "asProbs");
        this.codonMap = (int[][][])XMLParser.extractObjectForTags(xml, "codonMap");
        this.ess = (Double)XMLParser.extractObjectForTags(xml, "ess");
        this.logNorm = (Double)XMLParser.extractObjectForTags(xml, "logNorm");
        this.offset = (Integer)XMLParser.extractObjectForTags(xml, "offset");
        this.pCodon = (Double)XMLParser.extractObjectForTags(xml, "pCodon");
        this.priorCodon = (Integer)XMLParser.extractObjectForTags(xml, "priorCodon");
        this.statistic = (double[])XMLParser.extractObjectForTags(xml, "statistic");
    }

    @Override
    public AlphabetContainer getAlphabetContainer() {
        return DNAAlphabetContainer.SINGLETON;
    }

    @Override
    public void initializeFunctionRandomly() {
        double[] alphas = new double[this.asParameters.length];
        if (this.priorCodon > -1) {
            Arrays.fill(alphas, this.ess * (1.0 - this.pCodon) / (double)(this.asParameters.length - 1));
            alphas[this.priorCodon] = this.ess * this.pCodon;
        } else {
            Arrays.fill(alphas, this.ess / (double)this.asParameters.length);
        }
        DirichletMRG.DEFAULT_INSTANCE.generateLog(this.asParameters, 0, this.asParameters.length, new DirichletMRGParams(alphas));
        this.precompute();
    }

    @Override
    public double getLogProbFor(boolean forward, int startPos, int endPos, Sequence seq) throws OperationNotSupportedException {
        if (startPos < 2) {
            return Double.NEGATIVE_INFINITY;
        }
        if (startPos != endPos || !forward) {
            throw new OperationNotSupportedException();
        }
        return this.asParameters[this.codonMap[seq.discreteVal(startPos - 2)][seq.discreteVal(startPos - 1)][seq.discreteVal(startPos)]] - this.logNorm;
    }

    @Override
    public double getLogPriorTerm() {
        double res = 0.0;
        int i = 0;
        while (i < this.asParameters.length) {
            res += this.ess / (double)this.asParameters.length * this.asParameters[i];
            ++i;
        }
        return res -= this.ess * this.logNorm;
    }

    @Override
    public void resetStatistic() {
        Arrays.fill(this.statistic, 0.0);
    }

    @Override
    public void addToStatistic(boolean forward, int startPos, int endPos, double weight, Sequence seq) throws OperationNotSupportedException {
        if (startPos < 2) {
            return;
        }
        if (startPos != endPos || !forward) {
            throw new OperationNotSupportedException();
        }
        int n = this.codonMap[seq.discreteVal(startPos - 2)][seq.discreteVal(startPos - 1)][seq.discreteVal(startPos)];
        this.statistic[n] = this.statistic[n] + weight;
    }

    @Override
    public void joinStatistics(Emission ... emissions) {
        int i = 0;
        while (i < emissions.length) {
            if (emissions[i] != this) {
                int j = 0;
                while (j < this.statistic.length) {
                    int n = j;
                    this.statistic[n] = this.statistic[n] + ((CodonEmission)emissions[i]).statistic[j];
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < emissions.length) {
            if (emissions[i] != this) {
                System.arraycopy(this.statistic, 0, ((CodonEmission)emissions[i]).statistic, 0, this.statistic.length);
            }
            ++i;
        }
    }

    @Override
    public void estimateFromStatistic() {
        double sum = 0.0;
        int i = 0;
        while (i < this.statistic.length) {
            int n = i;
            this.statistic[n] = this.statistic[n] + this.ess / (double)this.statistic.length;
            sum += this.statistic[i];
            ++i;
        }
        if (sum == 0.0) {
            Arrays.fill(this.statistic, 1.0);
            sum = this.statistic.length;
        }
        double logSum = Math.log(sum);
        int i2 = 0;
        while (i2 < this.statistic.length) {
            this.asParameters[i2] = Math.log(this.statistic[i2]) - logSum;
            ++i2;
        }
        this.precompute();
    }

    @Override
    public String getNodeShape(boolean forward) {
        return "\"box\"";
    }

    @Override
    public String getNodeLabel(double weight, String name, NumberFormat nf) {
        int mi = ToolBox.getMaxIndex(this.asProbs);
        if (this.asProbs.length == codes.length) {
            return "\"" + name + ": " + codes[mi] + " (" + nf.format(this.asProbs[mi]) + ")\"";
        }
        return "\"" + name + ": " + mi + " (" + nf.format(this.asProbs[mi]) + ")\"";
    }

    @Override
    public void setParameters(Emission t) throws IllegalArgumentException {
        if (!t.getClass().equals(this.getClass()) || ((CodonEmission)t).asParameters.length != this.asParameters.length) {
            throw new IllegalArgumentException("The transitions are not comparable.");
        }
        CodonEmission tt = (CodonEmission)t;
        System.arraycopy(tt.asParameters, 0, this.asParameters, 0, tt.asParameters.length);
        this.precompute();
    }

    private void precompute() {
        this.logNorm = Normalisation.getLogSum(this.asParameters);
        int i = 0;
        while (i < this.asParameters.length) {
            this.asProbs[i] = Math.exp(this.asParameters[i] - this.logNorm);
            ++i;
        }
    }

    @Override
    public String toString(NumberFormat nf) {
        return "";
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.asParameters, "asParameters");
        XMLParser.appendObjectWithTags(xml, this.asProbs, "asProbs");
        XMLParser.appendObjectWithTags(xml, this.codonMap, "codonMap");
        XMLParser.appendObjectWithTags(xml, this.ess, "ess");
        XMLParser.appendObjectWithTags(xml, this.logNorm, "logNorm");
        XMLParser.appendObjectWithTags(xml, this.offset, "offset");
        XMLParser.appendObjectWithTags(xml, this.pCodon, "pCodon");
        XMLParser.appendObjectWithTags(xml, this.priorCodon, "priorCodon");
        XMLParser.appendObjectWithTags(xml, this.statistic, "statistic");
        XMLParser.addTags(xml, this.getClass().getSimpleName());
        return xml;
    }

    @Override
    public void fillCurrentParameter(double[] params) {
        int myOffset = this.offset;
        int i = 0;
        while (i < this.asParameters.length) {
            params[myOffset] = this.asParameters[i];
            ++i;
            ++myOffset;
        }
    }

    @Override
    public void setParameter(double[] params, int offset) {
        int i = 0;
        while (i < this.asParameters.length) {
            this.asParameters[i] = params[this.offset + offset + i];
            ++i;
        }
    }

    @Override
    public int setParameterOffset(int offset) {
        this.offset = offset;
        return offset + this.asParameters.length;
    }

    @Override
    public double getLogProbAndPartialDerivationFor(boolean forward, int startPos, int endPos, IntList indices, DoubleList partDer, Sequence seq) throws OperationNotSupportedException {
        if (startPos < 2) {
            return Double.NEGATIVE_INFINITY;
        }
        if (startPos != endPos || !forward) {
            throw new OperationNotSupportedException();
        }
        int param = this.codonMap[seq.discreteVal(startPos - 2)][seq.discreteVal(startPos - 1)][seq.discreteVal(startPos)];
        double v = this.asParameters[param] - this.logNorm;
        int i = 0;
        while (i < this.asParameters.length) {
            indices.add(this.offset + i);
            if (i == param) {
                partDer.add(1.0 - this.asProbs[i]);
            } else {
                partDer.add(-this.asProbs[i]);
            }
            ++i;
        }
        return v;
    }

    @Override
    public void addGradientOfLogPriorTerm(double[] grad, int offset) {
        int i = 0;
        while (i < this.asParameters.length) {
            int n = this.offset + offset + i;
            grad[n] = grad[n] + (this.ess / (double)this.asParameters.length - this.ess * this.asProbs[i]);
            ++i;
        }
    }

    @Override
    public void fillSamplingGroups(int parameterOffset, LinkedList<int[]> list) {
        int[] idx = new int[this.asParameters.length];
        int i = 0;
        while (i < idx.length) {
            idx[i] = this.offset + parameterOffset + i;
            ++i;
        }
        list.add(idx);
    }

    @Override
    public int getNumberOfParameters() {
        return this.asParameters.length;
    }

    @Override
    public int getSizeOfEventSpace() {
        return this.asParameters.length;
    }
}

