/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms.optimization.termination;

import de.jstacs.DataType;
import de.jstacs.algorithms.optimization.termination.AbstractTerminationCondition;
import de.jstacs.io.NonParsableException;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.utils.Time;

public class TimeCondition
extends AbstractTerminationCondition {
    private double seconds;

    public TimeCondition(double s) throws Exception {
        this(new TimeConditionParameterSet(s));
    }

    public TimeCondition(TimeConditionParameterSet parameter) throws CloneNotSupportedException {
        super(parameter);
    }

    @Override
    protected void set() {
        this.seconds = (Double)this.parameter.getParameterAt(0).getValue();
    }

    @Override
    protected String getXmlTag() {
        return "TimeCondition";
    }

    public TimeCondition(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public boolean doNextIteration(int iteration, double f_last, double f_current, double[] gradient, double[] direction, double alpha, Time t) {
        return t.getElapsedTime() < this.seconds;
    }

    @Override
    public boolean isSimple() {
        return true;
    }

    public static class TimeConditionParameterSet
    extends AbstractTerminationCondition.AbstractTerminationConditionParameterSet {
        public TimeConditionParameterSet() {
            super((Class<? extends AbstractTerminationCondition>)TimeCondition.class);
            try {
                this.parameters.add(new Parameter[]{new SimpleParameter(DataType.DOUBLE, "seconds", "the number of seconds until stopping the algorithm", true, new NumberValidator<Double>(new Double(0.0), new Double(Double.MAX_VALUE)))});
            }
            catch (Exception e) {
                RuntimeException re = new RuntimeException(e.getMessage());
                re.setStackTrace(e.getStackTrace());
                throw re;
            }
        }

        public TimeConditionParameterSet(StringBuffer xml) throws NonParsableException {
            super(xml);
        }

        public TimeConditionParameterSet(double seconds) throws IllegalArgumentException, SimpleParameter.IllegalValueException {
            this();
            this.getParameterAt(0).setValue(seconds);
        }

        @Override
        public String getInstanceComment() {
            return "a set of parameters for the TimeCondition";
        }

        @Override
        public String getInstanceName() {
            return "TimeConditionParameterSet";
        }
    }
}

