/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.util.Num;
import umontreal.iro.lecuyer.util.RootFinder;

public class KolmogorovSmirnovDist
extends ContinuousDistribution {
    protected int n;
    protected static final int NLIM = 160;

    public KolmogorovSmirnovDist(int n) {
        this.setN(n);
    }

    public double density(double x) {
        return KolmogorovSmirnovDist.density(this.n, x);
    }

    public double cdf(double x) {
        return KolmogorovSmirnovDist.cdf(this.n, x);
    }

    public double barF(double x) {
        return KolmogorovSmirnovDist.barF(this.n, x);
    }

    public double inverseF(double u) {
        return KolmogorovSmirnovDist.inverseF(this.n, u);
    }

    private static double dclem(int n, double x, double EPS) {
        return (KolmogorovSmirnovDist.cdf(n, x + EPS) - KolmogorovSmirnovDist.cdf(n, x - EPS)) / (2.0 * EPS);
    }

    protected static double densConnue(int n, double x) {
        if (x >= 1.0 || x <= 0.5 / (double)n) {
            return 0.0;
        }
        if (n == 1) {
            return 2.0;
        }
        if (x <= 1.0 / (double)n) {
            double Res;
            double T = 2.0 * x - 1.0 / (double)n;
            if (n <= 160) {
                Res = Num.factorial(n) * 2.0 * (double)n;
                if ((Res *= Math.pow(T, n - 1)) > 0.0) {
                    return Res;
                }
            }
            Res = Num.lnFactorial(n) + 2.0 + (double)n + (double)(n - 1) * Math.log(T);
            return Math.exp(Res);
        }
        if (x >= 1.0 - 1.0 / (double)n) {
            return 2.0 * (double)n * Math.pow(1.0 - x, n - 1);
        }
        return -1.0;
    }

    public static double density(int n, double x) {
        double D2;
        double Res = KolmogorovSmirnovDist.densConnue(n, x);
        if (Res != -1.0) {
            return Res;
        }
        double EPS = 0.005;
        double D1 = KolmogorovSmirnovDist.dclem(n, x, EPS);
        Res = D1 + (D1 - (D2 = KolmogorovSmirnovDist.dclem(n, x, 2.0 * EPS))) / 3.0;
        if (Res <= 0.0) {
            return 0.0;
        }
        return Res;
    }

    private static void mMultiply(double[] A, double[] B, double[] C, int m) {
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < m; ++j) {
                double s = 0.0;
                for (int k = 0; k < m; ++k) {
                    s += A[i * m + k] * B[k * m + j];
                }
                C[i * m + j] = s;
            }
        }
    }

    private static int[] mPower(double[] A, int eA, double[] V, int m, long n) {
        int i;
        int[] eV = new int[1];
        if (n == 1L) {
            for (int i2 = 0; i2 < m * m; ++i2) {
                V[i2] = A[i2];
            }
            eV[0] = eA;
            return eV;
        }
        eV = KolmogorovSmirnovDist.mPower(A, eA, V, m, n / 2L);
        double[] B = new double[m * m];
        KolmogorovSmirnovDist.mMultiply(V, V, B, m);
        int eB = 2 * eV[0];
        if (n % 2L == 0L) {
            for (i = 0; i < m * m; ++i) {
                V[i] = B[i];
            }
            eV[0] = eB;
        } else {
            KolmogorovSmirnovDist.mMultiply(A, B, V, m);
            eV[0] = eA + eB;
        }
        if (V[m / 2 * m + m / 2] > 1.0E140) {
            for (i = 0; i < m * m; ++i) {
                V[i] = V[i] * 1.0E-140;
            }
            eV[0] = eV[0] + 140;
        }
        return eV;
    }

    protected static double cdfConnu(int n, double x) {
        if (x >= 1.0) {
            return 1.0;
        }
        if (x <= 0.5 / (double)n) {
            return 0.0;
        }
        if (n == 1) {
            return 2.0 * x - 1.0;
        }
        if (x <= 1.0 / (double)n) {
            double E2;
            double Res;
            double T = 2.0 * x - 1.0 / (double)n;
            if (n <= 160 && (Res = (E2 = Num.factorial(n)) * Math.pow(T, n)) > 0.0) {
                return Res;
            }
            E2 = Num.lnFactorial(n) + (double)n * Math.log(T);
            return Math.exp(E2);
        }
        if (x >= 1.0 - 1.0 / (double)n) {
            double E2 = 2.0 * Math.pow(1.0 - x, n);
            return 1.0 - E2;
        }
        return -1.0;
    }

    public static double cdf(int n, double x) {
        int j;
        int i;
        double Res = KolmogorovSmirnovDist.cdfConnu(n, x);
        if (Res != -1.0) {
            return Res;
        }
        boolean LESS7 = true;
        double s = x * x * (double)n;
        if (s > 7.24 || s > 3.76 && n > 99) {
            return 1.0 - 2.0 * Math.exp(-(2.000071 + 0.331 / Math.sqrt(n) + 1.409 / (double)n) * s);
        }
        int k = (int)((double)n * x) + 1;
        int m = 2 * k - 1;
        double h = (double)k - (double)n * x;
        double[] H = new double[m * m];
        double[] Q = new double[m * m];
        for (i = 0; i < m; ++i) {
            for (j = 0; j < m; ++j) {
                H[i * m + j] = i - j + 1 < 0 ? 0.0 : 1.0;
            }
        }
        for (i = 0; i < m; ++i) {
            int n2 = i * m;
            H[n2] = H[n2] - Math.pow(h, i + 1);
            int n3 = (m - 1) * m + i;
            H[n3] = H[n3] - Math.pow(h, m - i);
        }
        int n4 = (m - 1) * m;
        H[n4] = H[n4] + (2.0 * h - 1.0 > 0.0 ? Math.pow(2.0 * h - 1.0, m) : 0.0);
        for (i = 0; i < m; ++i) {
            for (j = 0; j < m; ++j) {
                if (i - j + 1 <= 0) continue;
                for (int g = 1; g <= i - j + 1; ++g) {
                    int n5 = i * m + j;
                    H[n5] = H[n5] / (double)g;
                }
            }
        }
        int eH = 0;
        int eQ = KolmogorovSmirnovDist.mPower(H, eH, Q, m, n)[0];
        s = Q[(k - 1) * m + k - 1];
        for (i = 1; i <= n; ++i) {
            if (!((s = s * (double)i / (double)n) < 1.0E-140)) continue;
            s *= 1.0E140;
            eQ -= 140;
        }
        return s *= Math.pow(10.0, eQ);
    }

    protected static double barFConnu(int n, double x) {
        if (x >= 1.0) {
            return 0.0;
        }
        if (x <= 0.5 / (double)n) {
            return 1.0;
        }
        if (n == 1) {
            return 2.0 - 2.0 * x;
        }
        if (x <= 1.0 / (double)n) {
            double E2;
            double Res;
            double T = 2.0 * x - 1.0 / (double)n;
            if (n <= 160 && (Res = (E2 = Num.factorial(n)) * Math.pow(T, n)) > 0.0) {
                return 1.0 - Res;
            }
            E2 = Num.lnFactorial(n) + (double)n * Math.log(T);
            return 1.0 - Math.exp(E2);
        }
        if (x >= 1.0 - 1.0 / (double)n) {
            double E2 = 2.0 * Math.pow(1.0 - x, n);
            return E2;
        }
        return -1.0;
    }

    public static double barF(int n, double x) {
        double h = KolmogorovSmirnovDist.barFConnu(n, x);
        if (h >= 0.0) {
            return h;
        }
        double s = x * x * (double)n;
        if (s > 7.24 || s > 3.76 && n > 99) {
            return 2.0 * Math.exp(-(2.000071 + 0.331 / Math.sqrt(n) + 1.409 / (double)n) * s);
        }
        h = 1.0 - KolmogorovSmirnovDist.cdf(n, x);
        if (h >= 0.0) {
            return h;
        }
        return 0.0;
    }

    protected static double inverseConnue(int n, double u) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u must be in [0,1]");
        }
        if (u == 1.0) {
            return 1.0;
        }
        if (u == 0.0) {
            return 0.5 / (double)n;
        }
        if (n == 1) {
            return (u + 1.0) / 2.0;
        }
        double NLNN = (double)n * Math.log(n);
        double LNU = Math.log(u) - Num.lnFactorial(n);
        if (LNU <= -NLNN) {
            double T = 1.0 / (double)n * LNU;
            return 0.5 * (Math.exp(T) + 1.0 / (double)n);
        }
        if (u >= 1.0 - 2.0 / Math.exp(NLNN)) {
            return 1.0 - Math.pow((1.0 - u) / 2.0, 1.0 / (double)n);
        }
        return -1.0;
    }

    public static double inverseF(int n, double u) {
        double Res = KolmogorovSmirnovDist.inverseConnue(n, u);
        if (Res != -1.0) {
            return Res;
        }
        Function f = new Function(n, u);
        return RootFinder.brentDekker(0.5 / (double)n, 1.0, f, 1.0E-10);
    }

    public int getN() {
        return this.n;
    }

    public void setN(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        this.n = n;
        this.supportA = 0.5 / (double)n;
        this.supportB = 1.0;
    }

    public double[] getParams() {
        double[] retour = new double[]{this.n};
        return retour;
    }

    public String toString() {
        return this.getClass().getName() + " : n = " + this.n;
    }

    private static class Function
    implements MathFunction {
        protected int n;
        protected double u;

        public Function(int n, double u) {
            this.n = n;
            this.u = u;
        }

        public double evaluate(double x) {
            return this.u - KolmogorovSmirnovDist.cdf(this.n, x);
        }
    }
}

