/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.ContinuousDistribution;

public class ExponentialDist
extends ContinuousDistribution {
    private double lambda;

    public ExponentialDist() {
        this.setLambda(1.0);
    }

    public ExponentialDist(double lambda) {
        this.setLambda(lambda);
    }

    public double density(double x) {
        return ExponentialDist.density(this.lambda, x);
    }

    public double cdf(double x) {
        return ExponentialDist.cdf(this.lambda, x);
    }

    public double barF(double x) {
        return ExponentialDist.barF(this.lambda, x);
    }

    public double inverseF(double u) {
        return ExponentialDist.inverseF(this.lambda, u);
    }

    public double getMean() {
        return ExponentialDist.getMean(this.lambda);
    }

    public double getVariance() {
        return ExponentialDist.getVariance(this.lambda);
    }

    public double getStandardDeviation() {
        return ExponentialDist.getStandardDeviation(this.lambda);
    }

    public static double density(double lambda, double x) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return x < 0.0 ? 0.0 : lambda * Math.exp(-lambda * x);
    }

    public static double cdf(double lambda, double x) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (x <= 0.0) {
            return 0.0;
        }
        double y = lambda * x;
        if (y >= 100.0) {
            return 1.0;
        }
        return -Math.expm1(-y);
    }

    public static double barF(double lambda, double x) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (x <= 0.0) {
            return 1.0;
        }
        if (lambda * x >= 1000.0) {
            return 0.0;
        }
        return Math.exp(-lambda * x);
    }

    public static double inverseF(double lambda, double u) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (u >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (u <= 0.0) {
            return 0.0;
        }
        return -Math.log1p(-u) / lambda;
    }

    public static double[] getMLE(double[] x, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double sum = 0.0;
        double[] parameters = new double[1];
        for (int i = 0; i < n; ++i) {
            sum += x[i];
        }
        parameters[0] = (double)n / sum;
        return parameters;
    }

    @Deprecated
    public static double[] getMaximumLikelihoodEstimate(double[] x, int n) {
        return ExponentialDist.getMLE(x, n);
    }

    public static ExponentialDist getInstanceFromMLE(double[] x, int n) {
        double[] parameters = ExponentialDist.getMaximumLikelihoodEstimate(x, n);
        return new ExponentialDist(parameters[0]);
    }

    public static double getMean(double lambda) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return 1.0 / lambda;
    }

    public static double getVariance(double lambda) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return 1.0 / (lambda * lambda);
    }

    public static double getStandardDeviation(double lambda) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return 1.0 / lambda;
    }

    public double getLambda() {
        return this.lambda;
    }

    public void setLambda(double lambda) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        this.lambda = lambda;
        this.supportA = 0.0;
    }

    public double[] getParams() {
        double[] retour = new double[]{this.lambda};
        return retour;
    }

    public String toString() {
        return this.getClass().getName() + " : lambda = " + this.lambda;
    }
}

