/*
 * Decompiled with CFR 0.152.
 */
package projects.dream2016.mix;

import de.jstacs.algorithms.optimization.DimensionException;
import de.jstacs.algorithms.optimization.EvaluationException;
import de.jstacs.classifiers.differentiableSequenceScoreBased.AbstractMultiThreadedOptimizableFunction;
import de.jstacs.classifiers.differentiableSequenceScoreBased.OptimizableFunction;
import de.jstacs.data.DataSet;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import java.util.Arrays;
import projects.dream2016.mix.OptimizableClassifier;

public class MSPClassifierObjective
extends AbstractMultiThreadedOptimizableFunction {
    private OptimizableClassifier[] optClassifiers;
    private double[][] grad;
    private double[] value;
    private IntList[] indices;
    private DoubleList[] partDer;

    public MSPClassifierObjective(int threads, OptimizableClassifier optCl, DataSet[] data, double[][] weights, boolean norm) throws IllegalArgumentException {
        super(threads, data, weights, norm, false);
        this.optClassifiers = new OptimizableClassifier[threads];
        this.optClassifiers[0] = optCl;
        this.value = new double[threads];
        this.grad = new double[threads][];
        this.indices = new IntList[threads];
        this.partDer = new DoubleList[threads];
        int t = 0;
        while (t < this.indices.length) {
            this.indices[t] = new IntList();
            this.partDer[t] = new DoubleList();
            ++t;
        }
    }

    @Override
    protected void evaluateFunction(int index, int startClass, int startSeq, int endClass, int endSeq) throws EvaluationException {
        int dataSet = startClass;
        this.value[index] = 0.0;
        while (dataSet <= endClass) {
            int start = dataSet == startClass ? startSeq : 0;
            int end = dataSet == endClass ? endSeq : this.data[dataSet].getNumberOfElements();
            int seqIndex = start;
            while (seqIndex < end) {
                double v = this.weights[dataSet][seqIndex] * this.optClassifiers[index].getLogProb(dataSet, this.data[dataSet].getElementAt(seqIndex));
                if (Double.isNaN(v)) {
                    System.out.println("PROBLEM: NaN");
                    System.out.println("Classifier:");
                    System.out.println(this.optClassifiers[index]);
                    System.out.println("Sequence:");
                    System.out.println(this.data[dataSet].getElementAt(seqIndex));
                    try {
                        System.out.println("Parameter:");
                        System.out.println(Arrays.toString(this.optClassifiers[0].getCurrentParameterValues(OptimizableFunction.KindOfParameter.LAST)));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new IllegalArgumentException("NaN");
                }
                int n = index;
                this.value[n] = this.value[n] + v;
                ++seqIndex;
            }
            ++dataSet;
        }
    }

    @Override
    protected double joinFunction() throws EvaluationException, DimensionException {
        double res = 0.0;
        int t = 0;
        while (t < this.value.length) {
            res += this.value[t];
            ++t;
        }
        if (Double.isNaN(res += this.optClassifiers[0].getLogPriorTerm())) {
            throw new EvaluationException("Error in evaluation: " + res);
        }
        if (this.norm) {
            res /= this.sum[this.cl];
        }
        return res;
    }

    @Override
    protected void evaluateGradientOfFunction(int index, int startClass, int startSeq, int endClass, int endSeq) {
        int dataSet = startClass;
        Arrays.fill(this.grad[index], 0.0);
        while (dataSet <= endClass) {
            int start = dataSet == startClass ? startSeq : 0;
            int end = dataSet == endClass ? endSeq : this.data[dataSet].getNumberOfElements();
            int seqIndex = start;
            while (seqIndex < end) {
                this.indices[index].clear();
                this.partDer[index].clear();
                this.optClassifiers[index].getLogProbAndPartialDerivations(dataSet, this.data[dataSet].getElementAt(seqIndex), this.indices[index], this.partDer[index]);
                int h = 0;
                while (h < this.indices[index].length()) {
                    double[] dArray = this.grad[index];
                    int n = this.indices[index].get(h);
                    dArray[n] = dArray[n] + this.weights[dataSet][seqIndex] * this.partDer[index].get(h);
                    ++h;
                }
                ++seqIndex;
            }
            ++dataSet;
        }
    }

    @Override
    protected double[] joinGradients() throws EvaluationException {
        double[] res = new double[this.grad[0].length];
        int i = 0;
        while (i < res.length) {
            int t = 0;
            while (t < this.grad.length) {
                int n = i;
                res[n] = res[n] + this.grad[t][i];
                ++t;
            }
            ++i;
        }
        this.optClassifiers[0].addGradient(res, 0);
        if (this.norm) {
            i = 0;
            while (i < res.length) {
                int n = i++;
                res[n] = res[n] / this.sum[this.cl];
            }
        }
        return res;
    }

    @Override
    public void getParameters(OptimizableFunction.KindOfParameter kind, double[] erg) throws Exception {
        double[] params = this.optClassifiers[0].getCurrentParameterValues(kind);
        System.arraycopy(params, 0, erg, 0, params.length);
    }

    @Override
    public void reset() throws Exception {
        this.optClassifiers[0].reset();
        int j = 1;
        while (j < this.optClassifiers.length) {
            this.optClassifiers[j] = this.optClassifiers[0].clone();
            this.optClassifiers[j].reset();
            ++j;
        }
        int t = 0;
        while (t < this.grad.length) {
            this.grad[t] = new double[this.getDimensionOfScope()];
            ++t;
        }
    }

    @Override
    protected void setThreadIndependentParameters() throws DimensionException {
    }

    @Override
    protected void setParams(int index) throws DimensionException {
        try {
            this.optClassifiers[index].setParameters(this.params, 0);
        }
        catch (Exception e) {
            DimensionException d = new DimensionException();
            d.setStackTrace(e.getStackTrace());
            throw d;
        }
    }

    @Override
    public int getDimensionOfScope() {
        return this.optClassifiers[0].getNumberOfParameters();
    }
}

