/*
 * Decompiled with CFR 0.152.
 */
package projects.dream2016;

import de.jstacs.classifiers.AbstractScoreBasedClassifier;
import de.jstacs.classifiers.differentiableSequenceScoreBased.OptimizableFunction;
import de.jstacs.classifiers.differentiableSequenceScoreBased.ScoreClassifier;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifier;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifierParameterSet;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.LearningPrinciple;
import de.jstacs.classifiers.differentiableSequenceScoreBased.logPrior.DoesNothingLogPrior;
import de.jstacs.classifiers.differentiableSequenceScoreBased.logPrior.LogPrior;
import de.jstacs.classifiers.performanceMeasures.AucPR;
import de.jstacs.classifiers.performanceMeasures.AucROC;
import de.jstacs.classifiers.performanceMeasures.PRCurve;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.alphabets.DoubleSymbolException;
import de.jstacs.data.sequences.ArbitrarySequence;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.AbstractStringExtractor;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.FileManager;
import de.jstacs.io.StringExtractor;
import de.jstacs.io.XMLParser;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.results.ResultSet;
import de.jstacs.sequenceScores.differentiable.AbstractDifferentiableSequenceScore;
import de.jstacs.sequenceScores.statisticalModels.differentiable.DifferentiableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.differentiable.IndependentProductDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.UniformDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.continuous.ConstantDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.continuous.GaussianNetwork;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.BayesianNetworkDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.structureLearning.measures.FixedStructure;
import de.jstacs.sequenceScores.statisticalModels.differentiable.homogeneous.HomogeneousMMDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.MixtureDiffSM;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.SafeOutputStream;
import de.jstacs.utils.Time;
import de.jstacs.utils.ToolBox;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import projects.dream2016.Aggregation_multi2;
import projects.dream2016.DataParser;
import projects.dream2016.mix.NewMixtureClassifier;
import projects.dream2016.mix.SubDiffSM;

public class IterativeTraining_Round2_LO {
    private static Time time;
    private static AlphabetContainer con;
    private static SafeOutputStream sos;
    static int newNeg;
    private static DataSet[] data;
    private static double[][] weights;
    private static long[][] hist;
    static String type;
    static Aggregation_multi2.Aggregate a;

    static {
        sos = SafeOutputStream.getSafeOutputStream(System.out);
        newNeg = -1;
        data = new DataSet[2];
        hist = new long[2][101];
        type = "EACH";
        a = Aggregation_multi2.Aggregate.MeanProd;
    }

    private static void fill(String fName, int lab, HashMap<String, ArrayList<Region>> region) throws IOException {
        File f = new File(fName);
        if (f.exists()) {
            String line;
            BufferedReader r = new BufferedReader(new FileReader(fName));
            while ((line = r.readLine()) != null) {
                Region reg = new Region(line, lab);
                ArrayList<Region> c = region.get(reg.chr);
                if (c == null) {
                    c = new ArrayList();
                    region.put(reg.chr, c);
                }
                c.add(reg);
            }
            r.close();
        }
    }

    private static int sort(HashMap<String, ArrayList<Region>> region) throws IOException {
        int windows = -1;
        for (String chr : region.keySet()) {
            ArrayList<Region> list = region.get(chr);
            if (list.size() <= 0) continue;
            if (windows < 0) {
                Region r = list.get(0);
                windows = (int)Math.round((Double.parseDouble(r.split[2]) - Double.parseDouble(r.split[1])) / 50.0);
            }
            Collections.sort(list);
            sos.writeln(String.valueOf(chr) + "\t" + list.size() + "\t" + list.get((int)0).pos + "\t" + list.get((int)(list.size() - 1)).pos);
        }
        return windows;
    }

    private static DataParser getDataParser(int offset, String[] args, String confOut) throws IllegalArgumentException, IOException, DoubleSymbolException {
        int col = 0;
        LinkedList<String> conf = new LinkedList<String>();
        int f = offset;
        while (f < args.length) {
            int a;
            int anz;
            if (args[f].endsWith("hg19.fa_other.txt.gz")) {
                conf.add("Percent\t" + col + "," + (col + 1) + "\tEach\tMeanCenter3");
                conf.add("Entropy\t" + ((col += 2) + 2) + "\tEach\tMaxCenter3");
                col += 3;
            } else if (args[f].endsWith("hg19.fa_tracts.txt.gz")) {
                conf.add("Length\t" + col + "," + (col + 1) + "," + (col + 2) + "," + (col + 3) + "\tEach\tMaxCenter3");
                col += 4;
            } else if (args[f].endsWith("gencode.v19.types.txt.gz")) {
                conf.add("Region\t" + col + "\tEach\tMin");
                ++col;
            } else if (args[f].endsWith(".bigwig-interval.txt.gz")) {
                conf.add("Coverage\t" + col + "\tEach\tMinCenter3");
                conf.add("Coverage\t" + (col + 2) + "," + (col + 3) + "\tEach\tMin");
                conf.add("Coverage\t" + (col + 1) + "\tEach\tEach");
                col += 4;
            } else if (args[f].endsWith(".xml_winscores2.txt.gz")) {
                conf.add("Score\t" + col + "\tEach\tMaxCenter3");
                conf.add("Score\t" + (col + 1) + "\tEach\tCenter");
                conf.add("Score\t" + col + "\tEach\tLogSum");
                col += 2;
                col += 2;
                ++col;
            } else if (args[f].endsWith("_winscores2.txt.gz")) {
                conf.add("Score\t" + col + "\tEach\tMax");
                col += 2;
                col += 2;
                ++col;
            } else if (args[f].endsWith("hg19.genome.fa.seqs.gz")) {
                conf.add("Seq\t" + col + "\tEach\tCenter3");
                ++col;
            } else if (args[f].endsWith("expression-interval.txt.gz")) {
                conf.add("Coverage\t" + col + "\tEach\tCenter");
                conf.add("Coverage\t" + (col + 1) + "\tEach\tCenter");
                conf.add("Coverage\t" + (col + 2) + "\tEach\tCenter");
                col += 3;
            } else if (args[f].endsWith("specific.txt.gz")) {
                anz = args[f].substring(args[f].lastIndexOf("/") + 1).startsWith("qN-") ? 2 : 1;
                a = 0;
                while (a < anz) {
                    conf.add("Coverage\t" + col + "\tEach\tCenter");
                    ++col;
                    ++a;
                }
            } else if (args[f].endsWith("conserved.txt.gz")) {
                anz = args[f].substring(args[f].lastIndexOf("/") + 1).startsWith("dnase") ? 2 : 1;
                a = 0;
                while (a < anz) {
                    conf.add("Coverage\t" + col + "\tEach\tCenter");
                    conf.add("Coverage\t" + (col + 1) + "\tEach\tCenter");
                    col += 2;
                    ++a;
                }
            } else if (args[f].endsWith("_bw.gz")) {
                conf.add("Coverage\t" + col + "\tEach\tCenter");
                conf.add("Coverage\t" + (col + 1) + "\tEach\tCenter");
                conf.add("Coverage\t" + (col + 2) + "\tEach\tCenter");
                conf.add("Coverage\t" + (col + 3) + "\tEach\tCenter");
                conf.add("Coverage\t" + (col + 4) + "\tEach\tCenter");
                conf.add("Coverage\t" + (col + 5) + "\tEach\tCenter");
                col += 6;
            } else if (args[f].endsWith("DNase-peak2interval.txt.gz")) {
                conf.add("Coverage\t" + col + "\tEach\tCenter");
                conf.add("Coverage\t" + (col + 1) + "\tEach\tCenter");
                col += 2;
            } else if (args[f].endsWith("fc.signal.bigwig-interval-orange.txt.gz")) {
                conf.add("Coverage\t" + col + "\tEach\tCenter");
                conf.add("Coverage\t" + (col + 1) + "\tEach\tCenter");
                conf.add("Coverage\t" + (col + 2) + "\tEach\tCenter");
                conf.add("Coverage\t" + (col + 3) + "\tEach\tCenter");
                conf.add("Coverage\t" + (col + 4) + "\tEach\tCenter");
                col += 5;
            } else if (args[f].endsWith("DNase-peakStat2interval.txt.gz")) {
                conf.add("Coverage\t" + col + "\tEach\tCenter");
                conf.add("Coverage\t" + (col + 1) + "\tEach\tMaxCenter5");
                conf.add("Coverage\t" + (col + 2) + "\tEach\tCenter");
                conf.add("Coverage\t" + (col + 3) + "\tEach\tMaxCenter5");
                col += 4;
            } else if (args[f].endsWith(".nearest_tss.txt.gz")) {
                conf.add("Distance\t" + col + "," + (col + 2) + "," + (col + 4) + "," + (col + 6) + "\tMin\tCenter");
                col += 8;
            } else if (args[f].endsWith("unicov.gz")) {
                conf.add("Coverage\t" + col + "\tEach\tMinCenter3");
                conf.add("Coverage\t" + (col + 2) + "\tEach\tMaxCenter3");
                col += 4;
            } else {
                throw new RuntimeException("Unknown file type: " + args[f]);
            }
            ++f;
        }
        conf.addFirst("5\t" + col);
        if (confOut != null) {
            PrintWriter confw = new PrintWriter(String.valueOf(confOut) + ".conf");
            confw.println("0\t" + col);
            int c = 1;
            while (c < conf.size()) {
                confw.println((String)conf.get(c));
                ++c;
            }
            confw.close();
        }
        return new DataParser(conf.toArray(new String[0]));
    }

    public static void main(String[] args) throws Exception {
        String line;
        time = Time.getTimeInstance(null);
        HashMap<String, ArrayList<Region>> region = new HashMap<String, ArrayList<Region>>();
        IterativeTraining_Round2_LO.fill(args[0], 0, region);
        IterativeTraining_Round2_LO.fill(args[1], 1, region);
        int epigram = Integer.parseInt(args[7]);
        int threads = Integer.parseInt(args[8]);
        String uses = args[9];
        boolean useDnase = uses.contains("d");
        boolean useRegion = uses.contains("r");
        boolean useGlobal = uses.contains("g");
        boolean useSequence = uses.contains("s");
        int off = 10;
        DataParser pars = IterativeTraining_Round2_LO.getDataParser(off, args, args[3]);
        ArrayList<String> chrs = new ArrayList<String>();
        HashMap<String, ArrayList<int[]>> hash = new HashMap<String, ArrayList<int[]>>();
        BufferedReader r = new BufferedReader(new FileReader(args[4]));
        while ((line = r.readLine()) != null) {
            String[] split = line.split("\t");
            ArrayList<int[]> current = (ArrayList<int[]>)hash.get(split[0]);
            if (current == null) {
                current = new ArrayList<int[]>();
                hash.put(split[0], current);
                chrs.add(split[0]);
            }
            current.add(new int[]{Integer.parseInt(split[1]), Integer.parseInt(split[2])});
        }
        r.close();
        System.out.println("Iterative training using: " + chrs);
        System.out.println();
        AbstractScoreBasedClassifier cl = null;
        ArrayList<AbstractScoreBasedClassifier> list = new ArrayList<AbstractScoreBasedClassifier>();
        int stop = 5;
        int col = Integer.parseInt(args[6]);
        int idx = 0;
        while (idx < stop) {
            System.out.println("ITERATION: " + idx);
            int windows = IterativeTraining_Round2_LO.sort(region);
            IterativeTraining_Round2_LO.extract(off, idx, pars, args, region, windows, null, idx == 0 ? null : chrs);
            cl = cl == null ? IterativeTraining_Round2_LO.create("ipsf", false, epigram, threads, useDnase, useRegion, useGlobal, useSequence) : cl.clone();
            list.add(cl);
            IterativeTraining_Round2_LO.train(String.valueOf(args[3]) + "_positives" + idx + ".txt", String.valueOf(args[3]) + "_negatives" + idx + ".txt", idx, list);
            IterativeTraining_Round2_LO.extract(off, idx, pars, args, null, windows, cl, chrs);
            Iterator<String> it = region.keySet().iterator();
            while (it.hasNext()) {
                region.get(it.next()).clear();
            }
            int add = IterativeTraining_Round2_LO.evaluate(idx, hash, chrs, String.valueOf(args[3]) + ".gws.gz", args[5], col, 3, region, windows, false);
            if (add == 0) break;
            ++idx;
        }
    }

    private static void extract(int offset, int idx, DataParser pars, String[] args, HashMap<String, ArrayList<Region>> region, int windows, AbstractScoreBasedClassifier cl, ArrayList<String> chrs) throws Exception {
        int f;
        BufferedWriter[] w;
        time.reset();
        String outpath = args[3];
        int l = args.length - offset;
        BufferedReader[] reader = new BufferedReader[l];
        int f2 = 0;
        while (f2 < l) {
            GZIPInputStream stream = new GZIPInputStream(new FileInputStream(args[f2 + offset]));
            reader[f2] = new BufferedReader(new InputStreamReader(stream));
            ++f2;
        }
        int c = 0;
        int start = 0;
        int last = -1;
        int a = -1;
        int p = -1000;
        String chr = null;
        Object[] line = new String[l];
        String[] li = new String[l];
        int[] remove = null;
        Object[] split = null;
        double[] scores = new double[2];
        double ls = 0.0;
        boolean[] read = new boolean[l];
        Arrays.fill(read, true);
        int x = 0;
        if (cl == null) {
            w = new BufferedWriter[4 + (idx == 0 ? 2 : 0)];
            x = w.length / 2;
            w[0] = new BufferedWriter(new FileWriter(String.valueOf(outpath) + "_positives" + idx + ".txt"));
            w[1] = new BufferedWriter(new FileWriter(String.valueOf(outpath) + "_negatives" + idx + ".txt"));
            w[x] = new BufferedWriter(new FileWriter(String.valueOf(outpath) + "_positives" + idx + ".txt.weights"));
            w[x + 1] = new BufferedWriter(new FileWriter(String.valueOf(outpath) + "_negatives" + idx + ".txt.weights"));
        } else {
            w = null;
        }
        BufferedWriter gws = cl != null ? new BufferedWriter(new OutputStreamWriter((OutputStream)new GZIPOutputStream(new FileOutputStream(String.valueOf(outpath) + ".gws.gz" + idx)), "UTF-8")) : null;
        ArrayList<Region> reg = null;
        int r = 0;
        boolean use = false;
        int anz = chrs != null ? chrs.size() : Integer.MAX_VALUE;
        int skip = 0;
        int end = Integer.MAX_VALUE;
        block5: while (true) {
            int f3;
            boolean any = false;
            f = 0;
            while (f < l) {
                if (read[f]) {
                    try {
                        line[f] = reader[f].readLine();
                    }
                    catch (OutOfMemoryError err) {
                        System.out.println(String.valueOf(f) + " " + idx);
                        System.out.println(args[f + offset]);
                        System.out.println(outpath);
                        System.out.flush();
                        throw err;
                    }
                    read[f] = line[f] != null && ((String)line[f]).charAt(0) != '[';
                }
                any |= read[f];
                ++f;
            }
            if (!any) {
                if (use) {
                    System.out.println("last window\t" + chr + "\t" + p + "\t" + (p + 50) + "\t" + skip + "\t" + time.getElapsedTime() + "\t" + anz);
                }
                if (anz == 0) break;
                System.out.println(Arrays.toString(line));
                boolean changed = false;
                f3 = 0;
                while (f3 < l) {
                    int n = 0;
                    while (line[f3] != null && (((String)line[f3]).charAt(0) != '[' || ((String)line[f3]).indexOf(95) >= 0)) {
                        line[f3] = reader[f3].readLine();
                        ++n;
                    }
                    changed |= n > 0;
                    if (line[f3] == null) break block5;
                    if (!((String)line[f3]).equals(line[0])) {
                        throw new Exception("Mismatch:\nFile 0: " + args[offset] + "\nLine: " + (String)line[0] + "\nFile " + f3 + ": " + args[f3 + offset] + "\nLine: " + (String)line[f3]);
                    }
                    read[f3] = true;
                    ++f3;
                }
                if (changed) {
                    System.out.println("=> " + Arrays.toString(line));
                }
                chr = ((String)line[0]).substring(1, ((String)line[0]).length() - 1);
                reg = region == null ? null : region.get(chr);
                r = 0;
                end = reg != null && r < reg.size() ? reg.get((int)r).pos : Integer.MAX_VALUE;
                boolean bl = use = chrs == null || chrs.contains(chr);
                if (!use) {
                    System.out.println("skip " + chr);
                } else {
                    --anz;
                }
                c = 0;
                start = 0;
                p = -100000;
                continue;
            }
            if (!use) continue;
            f = 0;
            while (f < l) {
                if (!read[f]) {
                    int an;
                    int anzahl;
                    if (args[f + offset].endsWith("hg19.fa_other.txt.gz")) {
                        li[f] = "0.5\t0.125\t0.0\t0.0\t0.0";
                    } else if (args[f + offset].endsWith("hg19.fa_tracts.txt.gz")) {
                        li[f] = "0\t0\t0\t0";
                    } else if (args[f + offset].endsWith("gencode.v19.types.txt.gz")) {
                        li[f] = String.valueOf(chr) + "\t" + start + "\t----------";
                    } else if (args[f + offset].endsWith(".bigwig-interval.txt.gz")) {
                        li[f] = "0\t0\t0\t0";
                    } else if (args[f + offset].endsWith(".xml_winscores2.txt.gz")) {
                        li[f] = "Inf\tInf\t0\t0\t..0";
                    } else if (args[f + offset].endsWith("_winscores2.txt.gz")) {
                        li[f] = "Inf\tInf\t0\t0\t..0";
                    } else if (args[f + offset].endsWith("hg19.genome.fa.seqs.gz")) {
                        li[f] = "CTTAGCGGAAATAGGAGAAACTGTACTAGACGTCCTTGATCGTTATTCGG";
                    } else if (args[f + offset].endsWith("expression-interval.txt.gz")) {
                        li[f] = "0.0\t0.0\t0.0";
                    } else if (args[f + offset].endsWith("specific.txt.gz")) {
                        li[f] = "";
                        anzahl = args[f + offset].substring(args[f + offset].lastIndexOf("/") + 1).startsWith("qN-") ? 2 : 1;
                        an = 0;
                        while (an < anzahl) {
                            int n = f;
                            li[n] = String.valueOf(li[n]) + (an == 0 ? "" : "\t") + "0.0";
                            ++an;
                        }
                    } else if (args[f + offset].endsWith("conserved.txt.gz")) {
                        li[f] = "";
                        anzahl = args[f + offset].substring(args[f + offset].lastIndexOf("/") + 1).startsWith("dnase") ? 2 : 1;
                        an = 0;
                        while (an < anzahl) {
                            int n = f;
                            li[n] = String.valueOf(li[n]) + (an == 0 ? "" : "\t") + "0.0\t0.0";
                            ++an;
                        }
                    } else if (args[f + offset].endsWith("_bw.gz")) {
                        li[f] = "0.0\t0.0\t0.0\t0.0\t0.0\t0.0";
                    } else if (args[f + offset].endsWith("DNase-peak2interval.txt.gz")) {
                        li[f] = "0.0\t0.0";
                    } else if (args[f + offset].endsWith("fc.signal.bigwig-interval-orange.txt.gz")) {
                        li[f] = "0.0\t0.0\t0.0\t0.0\t0.0";
                    } else if (args[f + offset].endsWith("DNase-peakStat2interval.txt.gz")) {
                        li[f] = "0.0\t0.0\t0.0\t0.0";
                    } else if (args[f + offset].endsWith(".nearest_tss.txt.gz")) {
                        li[f] = String.valueOf(chr) + "\t" + start + "\t1E6\t-1\t1E6\t-1\t1E6\t-1\t1E6\t-1";
                    } else if (args[f + offset].endsWith("unicov.gz")) {
                        li[f] = "0\t0\t0\t0";
                    } else {
                        System.out.println("WARNING: no default values for " + args[f + offset]);
                    }
                } else {
                    li[f] = line[f];
                }
                ++f;
            }
            int st = start;
            ++c;
            p = (start += 50) - (windows + 1) / 2 * 50;
            if (cl != null || start + windows * 50 >= end) {
                int f4;
                if (remove == null) {
                    remove = new int[l];
                    f3 = 0;
                    while (f3 < l) {
                        remove[f3] = 0;
                        if (li[f3].startsWith(String.valueOf(chr) + "\t")) {
                            int pos = li[f3].indexOf(9) + 1;
                            li[f3] = li[f3].substring(pos);
                            int n = f3;
                            remove[n] = remove[n] + 1;
                            if (li[f3].startsWith(String.valueOf(st) + "\t")) {
                                pos = li[f3].indexOf(9) + 1;
                                li[f3] = li[f3].substring(pos);
                                int n2 = f3;
                                remove[n2] = remove[n2] + 1;
                            }
                        }
                        ++f3;
                    }
                } else {
                    f3 = 0;
                    while (f3 < l) {
                        int re = 0;
                        while (re < remove[f3]) {
                            int pos = li[f3].indexOf(9) + 1;
                            li[f3] = li[f3].substring(pos);
                            ++re;
                        }
                        ++f3;
                    }
                }
                boolean out = false;
                Region current = null;
                if (reg != null && r < reg.size() && start == reg.get((int)r).pos) {
                    current = reg.get(r);
                    out = true;
                }
                if (split == null) {
                    a = 0;
                    f4 = 0;
                    while (f4 < li.length) {
                        a += li[f4].split("\t").length;
                        ++f4;
                    }
                    split = new String[5 + windows * a];
                    last = 5 + a * (windows - 1);
                } else {
                    System.arraycopy(split, 5 + a, split, 5, last - 5);
                }
                f4 = 0;
                int b = last;
                while (f4 < l) {
                    String[] help = li[f4].split("\t");
                    System.arraycopy(help, 0, split, b, help.length);
                    b += help.length;
                    ++f4;
                }
                if (!out && cl == null || c < windows) continue;
                if (current != null) {
                    System.arraycopy(current.split, 0, split, 0, 5);
                }
                ArbitrarySequence s = null;
                try {
                    s = pars.parse(con, (String[])split);
                }
                catch (WrongAlphabetException exc) {
                    System.out.println(Arrays.toString(split));
                    System.out.println(con);
                    System.out.println(pars.getAlphabets(split.length));
                    throw exc;
                }
                if (con == null) {
                    con = s.getAlphabetContainer();
                    FileManager.writeFile(String.valueOf(outpath) + "_positives.txt.alpha", (CharSequence)con.toXML());
                }
                Arrays.fill(split, 0, 5, null);
                if (cl == null) {
                    do {
                        current = reg.get(r);
                        w[current.lab].append(s.toString("\t", 0, s.getLength()));
                        w[current.lab].newLine();
                        w[current.lab + x].append(current.split[4]);
                        w[current.lab + x].newLine();
                    } while (++r < reg.size() && reg.get((int)r).pos == current.pos);
                    if (reg != null && r < reg.size()) {
                        end = reg.get((int)r).pos;
                        continue;
                    }
                    end = Integer.MAX_VALUE;
                    continue;
                }
                gws.append(String.valueOf(chr) + "\t" + p);
                scores[0] = cl.getScore(s, 0);
                scores[1] = cl.getScore(s, 1);
                ls = Normalisation.getLogSum(scores);
                gws.append("\t" + Math.exp(scores[0] - ls));
                gws.newLine();
                continue;
            }
            ++skip;
        }
        System.out.println(String.valueOf(cl == null ? "extract" : "gws") + " - elapsed time: " + time.getElapsedTime() + " " + skip);
        System.out.println();
        if (w != null) {
            int i = 0;
            while (i < w.length) {
                if (w[i] != null) {
                    w[i].close();
                }
                ++i;
            }
        }
        if (gws != null) {
            gws.close();
        }
        f = 0;
        while (f < l) {
            reader[f].close();
            ++f;
        }
    }

    private static AbstractScoreBasedClassifier create(String type, boolean useDeps, int epigram, int threads, boolean useDnase, boolean useRegion, boolean useGlobal, boolean useSequence) throws Exception {
        AbstractScoreBasedClassifier cl;
        int anz;
        double[] beta = LearningPrinciple.getBeta(LearningPrinciple.MCL);
        double ess = 1.0;
        ArrayList<AbstractDifferentiableSequenceScore> fun = new ArrayList<AbstractDifferentiableSequenceScore>();
        IntList lens = new IntList();
        int d = 0;
        while (d < con.getPossibleLength() && !con.isDiscreteAt(d)) {
            ++d;
        }
        Object structure = new int[d][];
        if (useDeps) {
            structure[1] = new int[0];
            structure[2] = new int[]{1};
            structure[0] = new int[]{2};
            int c = 3 + (d - 3) / 2;
            structure[c] = new int[1];
            int h = 0;
            while (c + h + 1 < d) {
                structure[c + h + 1] = new int[]{c + h};
                structure[c - h - 1] = new int[]{c - h};
                ++h;
            }
        } else {
            structure = new int[d][0];
        }
        if (useDnase) {
            fun.add(new GaussianNetwork(con.getSubContainer(0, d), (int[][])structure));
        } else {
            fun.add(new ConstantDiffSM(con.getSubContainer(0, d), d));
        }
        lens.add(d);
        structure = new int[10][];
        if (useDeps) {
            structure[4] = new int[0];
            structure[9] = new int[]{4};
            structure[3] = new int[]{4};
            structure[8] = new int[]{9};
            structure[2] = new int[]{3};
            structure[7] = new int[]{8};
            structure[1] = new int[]{3};
            structure[6] = new int[]{8};
            structure[0] = new int[]{2};
            structure[5] = new int[]{7};
        } else {
            structure = new int[10][0];
        }
        if (useRegion) {
            fun.add(new BayesianNetworkDiffSM(con.getSubContainer(d, 10), 10, 256.0, true, new FixedStructure((int[][])structure)));
        } else {
            fun.add(new UniformDiffSM(con.getSubContainer(d, 10), 10, 256.0));
        }
        lens.add(10);
        structure = new int[7][];
        if (useDeps) {
            structure[0] = new int[0];
            structure[1] = new int[1];
            structure[2] = new int[0];
            structure[5] = new int[1];
            structure[3] = new int[]{5};
            structure[6] = new int[1];
            structure[4] = new int[]{6};
        } else {
            structure = new int[7][0];
        }
        if (useGlobal) {
            fun.add(new GaussianNetwork(con.getSubContainer(lens.get(0) + lens.get(1), 7), (int[][])structure));
        } else {
            fun.add(new ConstantDiffSM(con.getSubContainer(lens.get(0) + lens.get(1), 7), 7));
        }
        lens.add(7);
        if (epigram > 0) {
            structure = new int[epigram][0];
            fun.add(new GaussianNetwork((int[][])structure));
            lens.add(epigram);
        }
        int le = 0;
        int i = 0;
        while (i < lens.length()) {
            le += lens.get(i);
            ++i;
        }
        structure = new int[3][];
        if (useDeps) {
            structure[2] = new int[0];
            structure[1] = new int[]{2};
            structure[0] = new int[]{1};
        } else {
            structure = new int[3][0];
        }
        int l = con.getPossibleLength();
        while (le < l && !con.isDiscreteAt(le)) {
            fun.add(new GaussianNetwork(con.getSubContainer(le, 3), (int[][])structure));
            lens.add(3);
            le += 3;
        }
        if (le < l) {
            if (useSequence) {
                fun.add(new HomogeneousMMDiffSM(con.getSubContainer(le, 150), 3, 256.0, HomogeneousMMDiffSM.getSumOfHyperParameters(3, 150, 256.0), true, true, 1));
            } else {
                fun.add(new UniformDiffSM(con.getSubContainer(le, 150), 150, 256.0));
            }
            lens.add(150);
            le += 150;
        }
        if ((anz = l - le) > 0) {
            fun.add(new GaussianNetwork(con.getSubContainer(le, anz), new int[anz][0]));
            lens.add(anz);
            le += anz;
        }
        GenDisMixClassifierParameterSet ps = new GenDisMixClassifierParameterSet(con, l, 20, 1.0E-6, 1.0E-6, 1.0, false, OptimizableFunction.KindOfParameter.ZEROS, true, threads);
        DoesNothingLogPrior prior = DoesNothingLogPrior.defaultInstance;
        int start = 0;
        type = type.toLowerCase();
        IndependentProductDiffSM ipsf = new IndependentProductDiffSM(ess, true, fun.toArray(new DifferentiableStatisticalModel[0]), lens.toArray());
        switch (type) {
            case "ipsf": {
                GenDisMixClassifier gdsm;
                cl = gdsm = new GenDisMixClassifier(ps, (LogPrior)prior, beta, ipsf, ipsf);
                break;
            }
            case "bgmix": {
                GenDisMixClassifier gdsm;
                MixtureDiffSM bgMix = new MixtureDiffSM(3, true, ipsf, ipsf);
                cl = gdsm = new GenDisMixClassifier(ps, (LogPrior)prior, beta, ipsf, bgMix);
                break;
            }
            case "mix_each": {
                AbstractScoreBasedClassifier[] comp = new NewMixtureClassifier.OptimizableMSPClassifier[fun.size()];
                DifferentiableStatisticalModel[] mix = new DifferentiableStatisticalModel[comp.length];
                start = 0;
                int i2 = 0;
                while (i2 < comp.length) {
                    SubDiffSM s = new SubDiffSM(con, l, (DifferentiableStatisticalModel)fun.get(i2), start);
                    comp[i2] = new NewMixtureClassifier.OptimizableMSPClassifier(ps, (LogPrior)prior, s, s);
                    ((ScoreClassifier)comp[i2]).setOutputStream(null);
                    mix[i2] = new ConstantDiffSM(con, l);
                    start += lens.get(i2);
                    ++i2;
                }
                cl = new NewMixtureClassifier(threads, NewMixtureClassifier.Training.COMBINED, 3, mix, comp, NewMixtureClassifier.Vote.VOC, prior);
                break;
            }
            case "mix_dnase_single": 
            case "mix_dnase_block": {
                DifferentiableStatisticalModel[] mix = (DifferentiableStatisticalModel[])ArrayHandler.createArrayOf((Cloneable)(type.endsWith("single") ? new SubDiffSM(con, l, new GaussianNetwork(new int[1][0]), 0) : new SubDiffSM(con, l, (DifferentiableStatisticalModel)fun.get(0), 0)), (int)2);
                NewMixtureClassifier.OptimizableMSPClassifier o = new NewMixtureClassifier.OptimizableMSPClassifier(ps, (LogPrior)prior, ipsf, ipsf);
                AbstractScoreBasedClassifier[] cla = (NewMixtureClassifier.OptimizableMSPClassifier[])ArrayHandler.createArrayOf((Cloneable)o, (int)mix.length);
                cl = new NewMixtureClassifier(threads, NewMixtureClassifier.Training.COMBINED, 3, mix, cla, NewMixtureClassifier.Vote.VOC, ((LogPrior)prior).getNewInstance());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unkown type: " + type);
            }
        }
        return cl;
    }

    private static void train(String pFile, String nFile, int idx, ArrayList<AbstractScoreBasedClassifier> list) throws Exception {
        time.reset();
        if (idx == 0) {
            data = new DataSet[]{new DataSet(con, (AbstractStringExtractor)new StringExtractor(new File(pFile), 1000, '#'), "\t"), new DataSet(con, (AbstractStringExtractor)new StringExtractor(new File(nFile), 1000, '#'), "\t")};
            weights = new double[][]{DataParser.getWeights(String.valueOf(pFile) + ".weights", DataParser.Weighting.ONE), DataParser.getWeights(String.valueOf(nFile) + ".weights", DataParser.Weighting.DIRECT)};
            newNeg = (int)Math.round(ToolBox.sum(weights[1]) * 0.15);
        } else {
            DataSet part = new DataSet(con, (AbstractStringExtractor)new StringExtractor(new File(nFile), 1000, '#'), "\t");
            double[] pWeights = DataParser.getWeights(String.valueOf(nFile) + ".weights", DataParser.Weighting.DIRECT);
            IterativeTraining_Round2_LO.data[1] = DataSet.union(part, data[1]);
            int i = 1;
            double[] help = new double[pWeights.length + weights[i].length];
            System.arraycopy(pWeights, 0, help, 0, pWeights.length);
            System.arraycopy(weights[i], 0, help, pWeights.length, weights[i].length);
            IterativeTraining_Round2_LO.weights[i] = help;
            double[] scores = new double[2];
            int c = 0;
            while (c < 1) {
                Arrays.fill(hist[0], 0L);
                i = 0;
                while (i < weights[c].length) {
                    Sequence s = data[c].getElementAt(i);
                    double w = 0.0;
                    if (a == Aggregation_multi2.Aggregate.MeanProd) {
                        int e = 0;
                        while (e < list.size() - 1) {
                            AbstractScoreBasedClassifier cl = list.get(e);
                            scores[c] = cl.getScore(s, 0);
                            scores[1] = cl.getScore(s, 1);
                            double ls = Normalisation.getLogSum(scores);
                            w += Math.exp(scores[0] - ls);
                            ++e;
                        }
                    } else {
                        throw new RuntimeException("" + (Object)((Object)a));
                    }
                    long[] lArray = hist[0];
                    int n = (int)Math.round((w /= (double)(list.size() - 1)) * 100.0);
                    lArray[n] = lArray[n] + 1L;
                    IterativeTraining_Round2_LO.weights[c][i] = w;
                    ++i;
                }
                System.out.println(Arrays.toString(hist[0]));
                ++c;
            }
        }
        int i = 0;
        while (i < data.length) {
            System.out.println(String.valueOf(i) + ": #=" + data[i].getNumberOfElements() + ", length=" + data[i].getElementLength() + ", " + data[i].getAnnotation());
            ++i;
        }
        AbstractScoreBasedClassifier cl = list.get(list.size() - 1);
        cl.train(data, weights);
        System.out.println("train - elapsed time: " + time.getElapsedTime());
        System.out.println();
        if (idx >= 0) {
            StringBuffer xml = new StringBuffer();
            XMLParser.appendObjectWithTags(xml, cl, "classifier");
            FileManager.writeFile(String.valueOf(pFile) + "-classifier.xml", (CharSequence)xml);
        }
    }

    private static int evaluate(int idx, HashMap<String, ArrayList<int[]>> hash, ArrayList<String> chrs, String gwsFileName, String truth, int col, int wi, HashMap<String, ArrayList<Region>> region, int windows, boolean curve) throws IOException {
        double th = IterativeTraining_Round2_LO.agg(idx, hash, chrs, gwsFileName, truth, col, wi, Double.NaN, newNeg, null, 0, curve);
        System.out.println("threshold: " + th);
        return (int)IterativeTraining_Round2_LO.agg(idx, hash, chrs, gwsFileName, truth, col, wi, th, 0, region, windows, curve);
    }

    private static double agg(int index, HashMap<String, ArrayList<int[]>> hash, ArrayList<String> chrs, String gwsFileName, String truth, int col, int wi, double th, int anz2, HashMap<String, ArrayList<Region>> region, int bins, boolean curve) throws NumberFormatException, IOException {
        BufferedReader[] reader = new BufferedReader[index + 1];
        int i = 0;
        while (i <= index) {
            reader[i] = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(String.valueOf(gwsFileName) + i))));
            ++i;
        }
        String[] line = new String[reader.length];
        int windows = 2 * wi;
        int offset = (wi - 2) * 50;
        String chr = null;
        ArrayList<int[]> intervals = null;
        int[] inter = null;
        HashMap<String, ArrayList> predictions = new HashMap<String, ArrayList>();
        ArrayList currentPred = null;
        double[][] p = null;
        double[] values = new double[reader.length];
        int idx = -1;
        int h = -1;
        int anz = type.equals("EACH") ? reader.length : 1;
        while ((line[0] = reader[0].readLine()) != null) {
            block67: {
                int start;
                int i2 = 1;
                while (i2 <= index) {
                    line[i2] = reader[i2].readLine();
                    ++i2;
                }
                if (line[0].charAt(0) == '#') continue;
                String[] split = line[0].split("\t");
                if (chr == null || !chr.equals(split[0])) {
                    chr = split[0];
                    intervals = hash.get(chr);
                    if (intervals != null) {
                        currentPred = new ArrayList();
                        predictions.put(chr, currentPred);
                        idx = 0;
                        inter = intervals.get(idx);
                        if (anz > 0) {
                            p = new double[anz][(inter[1] - inter[0]) / 50 + 1 + 2 * (wi - 2)];
                            currentPred.add(p);
                        }
                        h = 0;
                    } else {
                        inter = null;
                        idx = -1;
                        p = null;
                    }
                }
                if (intervals == null || (start = Integer.parseInt(split[1])) < inter[0] - offset) continue;
                if (start > inter[1] + offset) break block67;
                int i3 = 0;
                while (i3 < values.length) {
                    values[i3] = Double.parseDouble(line[i3].split("\t")[2]);
                    ++i3;
                }
                switch (type) {
                    case "MEAN": {
                        p[0][h] = ToolBox.mean(0, values.length, values);
                        break;
                    }
                    case "MAX": {
                        p[0][h] = ToolBox.max(0, values.length, values);
                        break;
                    }
                    case "MIN": {
                        p[0][h] = ToolBox.min(0, values.length, values);
                        break;
                    }
                    case "PROD": {
                        p[0][h] = 1.0;
                        int k = 0;
                        while (k < values.length) {
                            double[] dArray = p[0];
                            int n = h;
                            dArray[n] = dArray[n] * (1.0 - values[k]);
                            ++k;
                        }
                        p[0][h] = 1.0 - p[0][h];
                        break;
                    }
                    case "EACH": {
                        int k = 0;
                        while (k < values.length) {
                            p[k][h] = values[k];
                            ++k;
                        }
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown:" + type);
                    }
                }
                ++h;
                continue;
            }
            if (idx + 1 >= intervals.size()) continue;
            if (++idx < intervals.size()) {
                inter = intervals.get(idx);
                p = new double[anz][(inter[1] - inter[0]) / 50 + 1 + 2 * (wi - 2)];
                currentPred.add(p);
                h = 0;
                continue;
            }
            h = -1;
        }
        int i4 = 0;
        while (i4 <= index) {
            reader[i4].close();
            ++i4;
        }
        DoubleList pos = new DoubleList();
        DoubleList neg = new DoubleList();
        GZIPInputStream stream = new GZIPInputStream(new FileInputStream(truth));
        BufferedReader r = new BufferedReader(new InputStreamReader(stream));
        String first = r.readLine();
        if (Double.isNaN(th)) {
            System.out.println("Compute performance for cell type: " + first.split("\t")[col]);
        }
        int x = 50 * (bins - 1) / 2;
        int[] num = new int[2];
        ArrayList<Region> list = null;
        if (region == null) {
            Arrays.fill(hist[0], 0L);
            Arrays.fill(hist[1], 0L);
        }
        double[] weight = new double[p.length];
        Arrays.fill(weight, 1.0 / (double)p.length);
        int c = 0;
        while (c < chrs.size()) {
            chr = chrs.get(c);
            currentPred = (ArrayList)predictions.get(chr);
            if (region != null) {
                list = region.get(chr);
            }
            if (currentPred != null) {
                intervals = hash.get(chr);
                int i5 = 0;
                while (i5 < currentPred.size()) {
                    inter = intervals.get(i5);
                    p = (double[][])currentPred.get(i5);
                    int start = inter[0];
                    int j = 0;
                    while (j < p[0].length - windows) {
                        double ag = -1.0;
                        switch (a) {
                            case Max: {
                                ag = ToolBox.max(j, j + windows, p[0]);
                                break;
                            }
                            case Mean: {
                                ag = ToolBox.mean(j, j + windows, p[0]);
                                break;
                            }
                            case Prod: {
                                ag = 1.0;
                                int k = j;
                                while (k < j + windows) {
                                    ag *= 1.0 - p[0][k];
                                    ++k;
                                }
                                ag = 1.0 - ag;
                                break;
                            }
                            case Median: {
                                ag = ToolBox.median(j, j + windows, p[0]);
                                break;
                            }
                            case MeanProd: {
                                ag = 0.0;
                                int e = 0;
                                while (e < p.length) {
                                    double ag2 = 1.0;
                                    int k = j;
                                    while (k < j + windows) {
                                        ag2 *= 1.0 - p[e][k];
                                        ++k;
                                    }
                                    ag += weight[e] * (1.0 - ag2);
                                    ++e;
                                }
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("not implemented: " + (Object)((Object)a));
                            }
                        }
                        if (r != null) {
                            String s = r.readLine();
                            String[] split = s.split("\t");
                            if (!(j != 0 || chr.equals(split[0]) && split[1].equals("" + start))) {
                                System.out.println();
                                System.out.println(s);
                                System.out.println(Arrays.toString(inter));
                                System.out.println(String.valueOf(chr) + "\t" + start + "\t" + (start + 200));
                                System.exit(1);
                            }
                            if (region == null) {
                                switch (split[col].charAt(0)) {
                                    case 'B': 
                                    case 'b': {
                                        pos.add(ag);
                                        long[] lArray = hist[0];
                                        int n = (int)Math.round(100.0 * ag);
                                        lArray[n] = lArray[n] + 1L;
                                        break;
                                    }
                                    case 'U': 
                                    case 'u': {
                                        neg.add(ag);
                                        long[] lArray = hist[1];
                                        int n = (int)Math.round(100.0 * ag);
                                        lArray[n] = lArray[n] + 1L;
                                    }
                                }
                            } else if (ag >= th && (split[col].charAt(0) == 'U' || split[col].charAt(0) == 'u')) {
                                list.add(new Region(String.valueOf(chr) + "\t" + (start - x) + "\t" + (start + x + 50) + "\tn\t1", 1));
                                num[1] = num[1] + 1;
                            }
                        }
                        start += 50;
                        ++j;
                    }
                    ++i5;
                }
            } else {
                System.out.println("WARNING: Did not find predictions for " + chr);
            }
            ++c;
        }
        r.close();
        if (region == null) {
            System.out.println("pos=c" + Arrays.toString(hist[0]).replace('[', '(').replace(']', ')'));
            System.out.println("neg=c" + Arrays.toString(hist[1]).replace('[', '(').replace(']', ')'));
        }
        if (Double.isNaN(th)) {
            double[] po = pos.toArray();
            double[] ne = neg.toArray();
            Arrays.sort(po);
            Arrays.sort(ne);
            NumericalResultSet aucpr = new AucPR().compute(po, ne);
            System.out.println("#positives: " + po.length + "\t" + po[0] + " .. " + po[po.length - 1]);
            System.out.println("#negatives: " + ne.length + "\t" + ne[0] + " .. " + ne[ne.length - 1]);
            System.out.println("random: " + (double)po.length / (double)(po.length + ne.length));
            System.out.println();
            System.out.println(String.valueOf(windows) + "\t" + (Object)((Object)a) + "\t" + Arrays.toString(weight));
            System.out.println(new AucROC().compute(po, ne));
            System.out.println(aucpr);
            ResultSet rs = new PRCurve().compute(po, ne);
            AbstractScoreBasedClassifier.DoubleTableResult dtr = (AbstractScoreBasedClassifier.DoubleTableResult)rs.getResultAt(rs.getNumberOfResults() - 1);
            double[][] c2 = dtr.getValue();
            double[] t = new double[]{0.95, 0.9, 0.75, 0.5};
            double[] max = new double[t.length];
            Arrays.fill(max, 0.0);
            BufferedWriter w = null;
            if (curve) {
                w = new BufferedWriter(new FileWriter(String.valueOf(gwsFileName) + index + ".prcurve"));
            }
            int i6 = 0;
            while (i6 < c2.length) {
                int j = 0;
                while (j < t.length) {
                    if (c2[i6][1] >= t[j] && c2[i6][0] > max[j]) {
                        max[j] = c2[i6][0];
                    }
                    ++j;
                }
                if (w != null) {
                    w.append(String.valueOf(c2[i6][0]) + "\t" + c2[i6][1]);
                    w.newLine();
                }
                ++i6;
            }
            if (w != null) {
                w.close();
            }
            int j = 0;
            while (j < t.length) {
                System.out.println("Recall at " + Math.round(100.0 * (1.0 - t[j])) + "% FDR: " + max[j]);
                ++j;
            }
            return Math.max(ne[Math.max(ne.length - anz2, 0)], po[(int)Math.floor((double)po.length * 0.01)]);
        }
        System.out.println("add " + Arrays.toString(num));
        System.out.println(list.size());
        return num[0] + num[1];
    }

    static class Region
    implements Comparable<Region> {
        int pos;
        String chr;
        String line;
        int lab;
        String[] split;

        Region(String line, int lab) {
            this.line = line;
            this.split = line.split("\t");
            this.chr = this.split[0];
            this.pos = (int)Math.round(Double.parseDouble(this.split[2]));
            this.lab = lab;
        }

        @Override
        public int compareTo(Region o) {
            return Integer.compare(this.pos, o.pos);
        }
    }
}

