/*
 * Decompiled with CFR 0.152.
 */
package projects.dream2016;

import de.jstacs.utils.Time;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.zip.GZIPInputStream;

public class ExtractFeatures {
    public static void main(String[] args) throws Exception {
        HashMap selList = new HashMap();
        BufferedReader sel = new BufferedReader(new FileReader(args[0]));
        String str = null;
        int a = 0;
        while ((str = sel.readLine()) != null) {
            Entry en = new Entry(str, args.length - 2);
            if (!selList.containsKey(en.chrom)) {
                selList.put(en.chrom, new LinkedList());
            }
            ((LinkedList)selList.get(en.chrom)).add(en);
            ++a;
        }
        sel.close();
        System.out.println("selected: " + a + " regions in " + selList.size() + " chromsomes");
        Time t = Time.getTimeInstance(null);
        Iterator it = null;
        Entry curr = null;
        StringBuffer conf = new StringBuffer();
        int col = 0;
        int f = 0;
        while (f < args.length - 2) {
            if (args[2 + f].endsWith("hg19.fa_other.txt.gz")) {
                conf.append("Percent\t" + col + "," + (col + 1) + "\tEach\tEach\n");
                conf.append("Entropy\t" + (col += 2) + "," + (col + 1) + "," + (col + 2) + "\tEach\tEach\n");
                col += 3;
            } else if (args[2 + f].endsWith("hg19.fa_tracts.txt.gz")) {
                conf.append("Length\t" + col + "," + (col + 1) + "," + (col + 2) + "," + (col + 3) + "\tEach\tEach\n");
                col += 4;
            } else if (args[2 + f].endsWith("gencode.v19.types.txt.gz")) {
                conf.append("Region\t" + col + "\tEach\tEach\n");
                ++col;
            } else if (args[2 + f].endsWith(".bigwig-interval.txt.gz")) {
                conf.append("Coverage\t" + col + "," + (col + 1) + "," + (col + 2) + "\tEach\tEach\n");
                col += 3;
            } else if (args[2 + f].endsWith(".xml_winscores2.txt.gz")) {
                conf.append("Score\t" + col + "," + (col + 1) + "\tEach\tEach\n");
                conf.append("Distance\t" + (col += 2) + "," + (col + 1) + "\tEach\tEach\n");
                conf.append("StrandStrandPos\t" + (col += 2) + "\tEach\tEach\n");
                ++col;
            } else {
                conf.append("???\tsubsequent columns might be wrong\n");
            }
            t.reset();
            GZIPInputStream stream = new GZIPInputStream(new FileInputStream(args[f + 2]));
            BufferedReader read = new BufferedReader(new InputStreamReader(stream));
            int idx = 0;
            LinkedList<String> buffer = new LinkedList<String>();
            while ((str = read.readLine()) != null) {
                if (str.startsWith("[")) {
                    String chr = str.substring(1, str.length() - 1);
                    if (selList.containsKey(chr)) {
                        it = ((LinkedList)selList.get(chr)).iterator();
                        curr = (Entry)it.next();
                    } else {
                        it = null;
                        curr = null;
                    }
                    idx = 0;
                    continue;
                }
                buffer.addLast(str);
                if (curr != null) {
                    int startIdx = curr.start / 50;
                    int endIdx = curr.end / 50;
                    if (idx >= startIdx && idx < endIdx) {
                        curr.append(str, f);
                    }
                    if (idx == endIdx - 1) {
                        while (it.hasNext()) {
                            curr = (Entry)it.next();
                            int tempStart = curr.start / 50;
                            int tempEnd = curr.end / 50;
                            if (tempStart <= idx) {
                                int diff;
                                int j = diff = idx - tempStart;
                                while (j >= 0) {
                                    curr.append((String)buffer.get(buffer.size() - 1 - j), f);
                                    --j;
                                }
                            }
                            if (idx != tempEnd - 1) break;
                        }
                    }
                }
                if (buffer.size() > 1000) {
                    buffer.removeFirst();
                }
                ++idx;
            }
            read.close();
            System.out.println("Finished " + args[f + 2] + ": " + t.getElapsedTime());
            ++f;
        }
        System.out.println();
        System.out.println("5\t" + col);
        System.out.println(conf);
        String out = args[1];
        PrintWriter wr = new PrintWriter(out);
        for (String chrom : selList.keySet()) {
            LinkedList li = (LinkedList)selList.get(chrom);
            for (Entry en : li) {
                wr.println(en);
            }
        }
        wr.close();
    }

    private static class Entry {
        private String chrom;
        private int start;
        private int end;
        private String pos;
        private String value;
        private ArrayList[] list;
        private int[] rem;

        public Entry(String line, int nfiles) {
            String[] parts = line.split("\t");
            this.chrom = parts[0];
            this.start = (int)Math.round(Double.parseDouble(parts[1]));
            this.end = (int)Math.round(Double.parseDouble(parts[2]));
            this.pos = parts[3];
            this.value = parts[4];
            this.list = new ArrayList[nfiles];
            this.rem = new int[nfiles];
            int i = 0;
            while (i < this.list.length) {
                this.list[i] = new ArrayList();
                this.rem[i] = -1;
                ++i;
            }
        }

        public void append(String s, int idx) {
            if (this.rem[idx] == -1) {
                this.rem[idx] = 0;
                if (s.startsWith(String.valueOf(this.chrom) + "\t")) {
                    int pos = s.indexOf(9) + 1;
                    s = s.substring(pos);
                    int n = idx;
                    this.rem[n] = this.rem[n] + 1;
                    if (s.startsWith(String.valueOf(this.start) + "\t")) {
                        pos = s.indexOf(9) + 1;
                        s = s.substring(pos);
                        int n2 = idx;
                        this.rem[n2] = this.rem[n2] + 1;
                    }
                }
            } else if (this.rem[idx] > 0) {
                int pos = 0;
                int j = 0;
                while (j < this.rem[idx]) {
                    pos = s.indexOf(9, pos) + 1;
                    ++j;
                }
                s = s.substring(pos);
            }
            this.list[idx].add(s);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(String.valueOf(this.chrom) + "\t" + this.start + "\t" + this.end + "\t" + this.pos + "\t" + this.value);
            int j = 0;
            while (j < this.list[0].size()) {
                int i = 0;
                while (i < this.list.length) {
                    sb.append("\t" + this.list[i].get(j));
                    ++i;
                }
                ++j;
            }
            return sb.toString();
        }
    }
}

