/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.stats.svm;

import org.biojava.stats.svm.SVMRegressionModel;

public class SMORegressionTrainer {
    private double C = 1000.0;
    private double epsilon = 1.0E-6;
    private SVMRegressionModel model;
    private double[] target;
    private double[] E;

    public void setC(double C) {
        this.C = C;
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    private boolean takeStep(int i1, int i2) {
        if (i1 == i2) {
            return false;
        }
        double y1 = this.target[i1];
        double y2 = this.target[i2];
        double alpha1 = this.model.getAlpha(i1);
        double alpha2 = this.model.getAlpha(i2);
        double alpha1star = this.model.getAlphaStar(i1);
        double alpha2star = this.model.getAlphaStar(i2);
        double phi1 = this.getError(i1);
        double phi2 = this.getError(i2);
        System.out.println("y1=" + y1 + "\ty2=" + y2);
        System.out.println("alpha1=" + alpha1 + "\talpha2=" + alpha2);
        System.out.println("alpha1star=" + alpha1star + "\talpha2star=" + alpha2star);
        System.out.println("phi1=" + phi1 + "\tphi2=" + phi2);
        double k11 = this.model.getKernelValue(i1, i1);
        double k12 = this.model.getKernelValue(i1, i2);
        double k22 = this.model.getKernelValue(i2, i2);
        double eta = k11 + k22 - 2.0 * k12;
        System.out.println("k11=" + k11 + "\tk12=" + k12 + "\tk22=" + k22);
        System.out.println("eta=" + eta);
        double deltaphi = phi2 - phi1;
        boolean changed = false;
        boolean finnished = false;
        boolean case4 = false;
        boolean case3 = false;
        boolean case2 = false;
        boolean case1 = false;
        System.out.println("deltaphi=" + deltaphi);
        double a1 = 0.0;
        double a2 = 0.0;
        double gamma = alpha1 - alpha1star + alpha2 - alpha2star;
        System.out.println("gamma=" + gamma);
        System.out.println("epsilon=" + this.epsilon);
        if (eta <= 0.0) {
            System.out.println("Negative eta");
            return false;
        }
        while (!finnished) {
            double H;
            double L;
            if (!case1 && (alpha1 > 0.0 || alpha1star == 0.0 && deltaphi > 0.0) && (alpha2 > 0.0 || alpha2star == 0.0 && deltaphi < 0.0)) {
                L = Math.max(0.0, gamma - this.C);
                H = Math.min(this.C, gamma);
                System.out.println("L=" + L + "\tH=" + H);
                if (L < H) {
                    a2 = alpha2 - deltaphi / eta;
                    System.out.println("Ideal a2 = " + a2);
                    a2 = Math.min(a2, H);
                    a2 = Math.max(L, a2);
                    a1 = alpha1 - (a2 - alpha2);
                    System.out.println("a1=" + a1 + ", a2=" + a2);
                    if (Math.abs(a2 - alpha2) > this.epsilon * (a2 + alpha2 + 1.0 + this.epsilon)) {
                        this.model.setAlpha(i1, a1);
                        this.model.setAlpha(i2, a2);
                        alpha1 = a1;
                        alpha2 = a2;
                        System.out.println("case1 worked");
                        changed = true;
                    } else {
                        System.out.println("case1: change too small: " + (a2 - alpha2));
                    }
                } else {
                    System.out.println("case1: L > H");
                    finnished = true;
                }
                case1 = true;
            } else if (!case2 && (alpha1 > 0.0 || alpha1star == 0.0 && deltaphi > 2.0 * this.epsilon) && (alpha2star > 0.0 || alpha2 == 0.0 && deltaphi > 2.0 * this.epsilon)) {
                L = Math.max(0.0, gamma);
                H = Math.min(this.C, this.C + gamma);
                System.out.println("L=" + L + "\tH=" + H);
                if (L < H) {
                    a2 = alpha2star + (deltaphi - 2.0 * this.epsilon) / eta;
                    System.out.println("Ideal a2 = " + a2);
                    a2 = Math.min(a2, H);
                    a2 = Math.max(L, a2);
                    a1 = alpha1 + (a2 - alpha2star);
                    System.out.println("a1=" + a1 + ", a2=" + a2);
                    if (Math.abs(a2 - alpha2star) > this.epsilon * (a2 + alpha2star + 1.0 + this.epsilon)) {
                        this.model.setAlpha(i1, a1);
                        this.model.setAlphaStar(i2, a2);
                        alpha1 = a1;
                        alpha2star = a2;
                        System.out.println("case2 worked");
                        changed = true;
                    } else {
                        System.out.println("case2: change too small: " + (a2 - alpha2star));
                    }
                } else {
                    System.out.println("case2: L > H");
                    finnished = true;
                }
                case2 = true;
            } else if (!case3 && (alpha1star > 0.0 || alpha1 == 0.0 && deltaphi < 2.0 * this.epsilon) && (alpha2 > 0.0 || alpha2star == 0.0 && deltaphi < 2.0 * this.epsilon)) {
                L = Math.max(0.0, -gamma);
                H = Math.min(this.C, -gamma + this.C);
                System.out.println("L=" + L + "\tH=" + H);
                if (L < H) {
                    a2 = alpha2 - (deltaphi + 2.0 * this.epsilon) / eta;
                    System.out.println("Ideal a2 = " + a2);
                    a2 = Math.min(a2, H);
                    a2 = Math.max(L, a2);
                    a1 = alpha1star + (a2 - alpha2);
                    System.out.println("a1=" + a1 + ", a2=" + a2);
                    if (Math.abs(a2 - alpha2) > this.epsilon * (a2 + alpha2 + 1.0 + this.epsilon)) {
                        this.model.setAlphaStar(i1, a1);
                        this.model.setAlpha(i2, a2);
                        alpha1star = a1;
                        alpha2 = a2;
                        System.out.println("case3 worked");
                        changed = true;
                    } else {
                        System.out.println("case3: change too small: " + (a2 - alpha2));
                    }
                } else {
                    System.out.println("case3: L > H");
                    finnished = true;
                }
                case3 = true;
            } else if (!case4 && (alpha1star > 0.0 || alpha1 == 0.0 && deltaphi < 0.0) && (alpha2star > 0.0 || alpha2 == 0.0 && deltaphi > 0.0)) {
                L = Math.max(0.0, -gamma - this.C);
                H = Math.min(this.C, -gamma);
                System.out.println("L=" + L + "\tH=" + H);
                if (L < H) {
                    a2 = alpha2star + deltaphi / eta;
                    System.out.println("Ideal a2 = " + a2);
                    a2 = Math.min(a2, H);
                    a2 = Math.max(L, a2);
                    a1 = alpha1star - (a2 - alpha2star);
                    System.out.println("a1=" + a1 + ", a2=" + a2);
                    if (Math.abs(a2 - alpha2star) > this.epsilon * (a2 + alpha2star + 1.0 + this.epsilon)) {
                        this.model.setAlphaStar(i1, a1);
                        this.model.setAlphaStar(i2, a2);
                        alpha1star = a1;
                        alpha2star = a2;
                        System.out.println("case4 worked");
                        changed = true;
                    } else {
                        System.out.println("case4: change too small: " + (a2 - alpha2star));
                    }
                } else {
                    System.out.println("case4: L > H");
                    finnished = true;
                }
                case4 = true;
            } else {
                finnished = true;
            }
            System.out.println("!!!Errors: " + this.getError(i1) + "    " + this.getError(i2));
            deltaphi = this.getError(i2) - this.getError(i1);
            System.out.println("deltaphi=" + deltaphi);
        }
        double bOld = this.model.getThreshold();
        System.out.println("b was " + bOld);
        double b = !this.isBound(alpha1) ? y1 - this.model.internalClassify(i1) + bOld - this.epsilon : (!this.isBound(alpha1star) ? y1 - this.model.internalClassify(i1) + bOld - this.epsilon : y1 - this.model.internalClassify(i1) + bOld);
        this.model.setThreshold(b);
        if (changed) {
            System.out.println("Successfuly changed things");
            return true;
        }
        System.out.println("Nothing changed");
        return false;
    }

    private int examineExample(int i2) {
        double alpha2 = this.model.getAlpha(i2);
        double alpha2star = this.model.getAlphaStar(i2);
        double phi2 = this.getError(i2);
        if (phi2 < this.epsilon && alpha2star < this.C || phi2 < this.epsilon && alpha2star > 0.0 || -phi2 > this.epsilon && alpha2 < this.C || -phi2 > this.epsilon && alpha2 > 0.0) {
            int randomStart = (int)Math.floor(Math.random() * (double)this.model.size());
            for (int l = 0; l < this.model.size(); ++l) {
                int i1 = (l + randomStart) % this.model.size();
                System.out.println("Using bound huristic for " + i1 + ", " + i2);
                if (!this.takeStep(i1, i2)) continue;
                return 1;
            }
        }
        return 0;
    }

    private boolean isBound(double alpha) {
        return alpha <= 0.0 || alpha >= this.C;
    }

    private double getError(int i) {
        this.E[i] = this.model.internalClassify(i) - this.target[i];
        System.out.println("Calculated error: " + this.E[i]);
        return this.E[i];
    }

    public synchronized void trainModel(SVMRegressionModel m, double[] t) {
        this.model = m;
        this.target = t;
        this.E = new double[this.model.size()];
        for (int i = 0; i < t.length; ++i) {
            this.E[i] = Double.NEGATIVE_INFINITY;
        }
        int numChanged = 0;
        boolean examineAll = true;
        while (numChanged > 0 || examineAll) {
            int i;
            System.out.print(".");
            numChanged = 0;
            if (examineAll) {
                System.out.println("Running full iteration");
                for (i = 0; i < this.model.size(); ++i) {
                    numChanged += this.examineExample(i);
                }
            } else {
                System.out.println("Running non-bounds iteration");
                for (i = 0; i < this.model.size(); ++i) {
                    double alpha = this.model.getAlpha(i);
                    if (this.isBound(alpha)) continue;
                    numChanged += this.examineExample(i);
                }
            }
            if (examineAll) {
                examineAll = false;
                continue;
            }
            examineAll = numChanged == 0;
        }
        this.E = null;
    }
}

