/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg12;

import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.util.XBLConstants;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public abstract class XBLOMElement
extends SVGOMElement
implements XBLConstants {
    protected String prefix;

    protected XBLOMElement() {
    }

    protected XBLOMElement(String prefix, AbstractDocument owner) {
        this.ownerDocument = owner;
        this.setPrefix(prefix);
    }

    public String getNodeName() {
        if (this.prefix == null || this.prefix.equals("")) {
            return this.getLocalName();
        }
        return this.prefix + ':' + this.getLocalName();
    }

    public String getNamespaceURI() {
        return "http://www.w3.org/2004/xbl";
    }

    public void setPrefix(String prefix) throws DOMException {
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
        }
        if (prefix != null && !prefix.equals("") && !DOMUtilities.isValidName(prefix)) {
            throw this.createDOMException((short)5, "prefix", new Object[]{new Integer(this.getNodeType()), this.getNodeName(), prefix});
        }
        this.prefix = prefix;
    }

    protected Node export(Node n, AbstractDocument d) {
        super.export(n, d);
        XBLOMElement e = (XBLOMElement)n;
        e.prefix = this.prefix;
        return n;
    }

    protected Node deepExport(Node n, AbstractDocument d) {
        super.deepExport(n, d);
        XBLOMElement e = (XBLOMElement)n;
        e.prefix = this.prefix;
        return n;
    }

    protected Node copyInto(Node n) {
        super.copyInto(n);
        XBLOMElement e = (XBLOMElement)n;
        e.prefix = this.prefix;
        return n;
    }

    protected Node deepCopyInto(Node n) {
        super.deepCopyInto(n);
        XBLOMElement e = (XBLOMElement)n;
        e.prefix = this.prefix;
        return n;
    }
}

