/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.utils;

import de.jstacs.InstantiableFromParameterSet;
import de.jstacs.Singleton;
import de.jstacs.io.RegExFilenameFilter;
import de.jstacs.parameters.InstanceParameterSet;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.SelectionParameter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class SubclassFinder {
    public static String includePath = null;

    public static <T> LinkedList<Class<? extends T>> findInstantiableSubclasses(Class<T> clazz, String startPackage) throws ClassNotFoundException, IOException {
        LinkedList<Class<T>> list = SubclassFinder.findSubclasses(clazz, startPackage);
        LinkedList<Class<T>> list2 = new LinkedList<Class<T>>();
        for (Class clazz2 : list) {
            if (clazz2.isInterface() || Modifier.isAbstract(clazz2.getModifiers())) continue;
            list2.add(clazz2);
        }
        return list2;
    }

    public static <S, T> LinkedList<Class<? extends S>> filterBySuperclass(Class<S> superclass, LinkedList<Class<? extends T>> listToFilter) {
        LinkedList<Class<S>> list2 = new LinkedList<Class<S>>();
        for (Class clazz : listToFilter) {
            if (!superclass.isAssignableFrom(clazz)) continue;
            list2.add(clazz);
        }
        return list2;
    }

    public static LinkedList<Class<? extends InstanceParameterSet>> getParameterSetFor(Class<? extends InstantiableFromParameterSet> clazz) {
        Constructor<?>[] cons = clazz.getConstructors();
        Class<?>[] types = null;
        LinkedList<Class<? extends InstanceParameterSet>> list = new LinkedList<Class<? extends InstanceParameterSet>>();
        boolean add = false;
        int i = 0;
        while (i < cons.length) {
            types = cons[i].getParameterTypes();
            if (types.length == 1 && InstanceParameterSet.class.isAssignableFrom(types[0])) {
                list.add(types[0]);
                add = true;
            }
            ++i;
        }
        if (!add && Singleton.class.isAssignableFrom(clazz)) {
            try {
                InstantiableFromParameterSet ifps = (InstantiableFromParameterSet)((Object)Singleton.SingletonHandler.getSingelton(clazz));
                list.add(ifps.getCurrentParameterSet().getClass());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return list;
    }

    public static <T> LinkedList<Class<? extends T>> findSubclasses(Class<T> clazz, String startPackage) throws ClassNotFoundException, IOException {
        HashSet<Class<? extends T>> hash = new HashSet<Class<? extends T>>();
        SubclassFinder.find(clazz, startPackage, hash);
        SubclassFinder.find(clazz, includePath, hash);
        return new LinkedList<Class<? extends T>>(hash);
    }

    private static <T> void find(Class<T> clazz, String startPackage, HashSet<Class<? extends T>> hash) throws ClassNotFoundException, IOException {
        URL[] urls;
        if (startPackage == null) {
            return;
        }
        String name = startPackage;
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        name = name.replace(".", "/");
        URL[] uRLArray = urls = SubclassFinder.getResources(name);
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            URL url = uRLArray[n2];
            if (url != null) {
                File dir;
                String s = url.toString();
                if (s.startsWith("file:")) {
                    s = s.substring(5);
                }
                if ((dir = new File(s)).exists()) {
                    File[] files = dir.listFiles();
                    int i = 0;
                    while (i < files.length) {
                        if (files[i].isDirectory()) {
                            SubclassFinder.find(clazz, String.valueOf(startPackage) + "." + files[i].getName(), hash);
                        } else if (files[i].isFile() && files[i].getName().endsWith(".class")) {
                            SubclassFinder.add(clazz, hash, String.valueOf(startPackage) + "." + files[i].getName().substring(0, files[i].getName().lastIndexOf(".")));
                        }
                        ++i;
                    }
                } else {
                    JarURLConnection con = (JarURLConnection)url.openConnection();
                    JarFile jar = con.getJarFile();
                    String starts = con.getEntryName();
                    Enumeration<JarEntry> en = jar.entries();
                    while (en.hasMoreElements()) {
                        JarEntry entry = en.nextElement();
                        String entryname = entry.getName();
                        if (starts != null && !entryname.startsWith(starts) || !entryname.endsWith(".class")) continue;
                        String classname = entryname.substring(0, entryname.length() - 6);
                        if (classname.startsWith("/")) {
                            classname = classname.substring(1);
                        }
                        SubclassFinder.add(clazz, hash, classname.replace("/", "."));
                    }
                }
            }
            ++n2;
        }
    }

    private static <T> void add(Class<T> clazz, HashSet<Class<? extends T>> list, String className) {
        try {
            Class<?> c = Class.forName(className);
            if (clazz.isAssignableFrom(c)) {
                list.add(c);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static URL[] getResources(String startPackage) throws MalformedURLException {
        JarURLConnection con;
        URL url;
        String cp = System.getProperty("java.class.path");
        String ext = System.getProperty("java.ext.dirs");
        String sun = System.getProperty("sun.boot.class.path");
        LinkedList<URL> list = new LinkedList<URL>();
        String startStart = startPackage;
        if (startStart.startsWith("/")) {
            startStart = startStart.substring(1);
        }
        if (sun != null) {
            cp = String.valueOf(cp) + System.getProperty("path.separator") + sun;
        }
        if (ext != null) {
            String[] extDirs;
            String[] stringArray = extDirs = ext.split(System.getProperty("path.separator"));
            int n = extDirs.length;
            int n2 = 0;
            while (n2 < n) {
                String dir = stringArray[n2];
                File temp = new File(dir);
                if (temp.isDirectory()) {
                    File[] jars;
                    File[] fileArray = jars = temp.listFiles(new RegExFilenameFilter("", RegExFilenameFilter.Directory.FORBIDDEN, true, ".*(\\.jar|\\.zip)"));
                    int n3 = jars.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File jar = fileArray[n4];
                        url = new URL("jar:file:" + jar.getAbsolutePath() + "!" + startPackage);
                        try {
                            con = (JarURLConnection)url.openConnection();
                            con.getJarFile();
                            list.add(url);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        String[] cps = cp.split(System.getProperty("path.separator"));
        int i = 0;
        while (i < cps.length) {
            cps[i] = cps[i].trim();
            File curr = new File(cps[i]);
            if (curr.exists() && curr.isDirectory() && new File(String.valueOf(cps[i]) + System.getProperty("file.separator") + startPackage).exists()) {
                list.add(new URL("file:" + cps[i] + startPackage));
            } else if (cps[i].endsWith(".jar") || cps[i].endsWith(".zip")) {
                url = new URL("jar:file:" + cps[i] + "!" + startPackage);
                try {
                    con = (JarURLConnection)url.openConnection();
                    con.getJarFile();
                    list.add(url);
                }
                catch (IOException e) {
                    try {
                        url = new URL("jar:file:" + cps[i] + "!/");
                        con = (JarURLConnection)url.openConnection();
                        JarFile fj = con.getJarFile();
                        Enumeration<JarEntry> en = fj.entries();
                        while (en.hasMoreElements()) {
                            if (!en.nextElement().getName().startsWith(startStart)) continue;
                            list.add(url);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            ++i;
        }
        return list.toArray(new URL[0]);
    }

    public static <T> SelectionParameter getSelectionParameter(Class<? extends ParameterSet> clazz, String startPackage, String name, String comment, boolean required) throws Exception {
        LinkedList<Class<? extends ParameterSet>> list = SubclassFinder.findInstantiableSubclasses(clazz, startPackage);
        Class[] classes = new Class[list.size()];
        Iterator it = list.iterator();
        int i = 0;
        while (i < classes.length) {
            classes[i] = (Class)it.next();
            ++i;
        }
        Arrays.sort(classes, ClassNameComparator.DEFAULT);
        return new SelectionParameter(name, comment, required, classes);
    }

    public static <T> LinkedList<InstanceParameterSet<? extends T>> getInstanceParameterSets(Class<T> clazz, String startPackage) throws ClassNotFoundException, IOException, InstantiationException, IllegalAccessException {
        LinkedList<Class<? extends T>> classes = SubclassFinder.findInstantiableSubclasses(clazz, startPackage);
        LinkedList<Class<InstantiableFromParameterSet>> filteredClasses = SubclassFinder.filterBySuperclass(InstantiableFromParameterSet.class, classes);
        LinkedList<InstanceParameterSet<T>> sets = new LinkedList<InstanceParameterSet<T>>();
        Iterator it = filteredClasses.iterator();
        while (it.hasNext()) {
            for (Class clazz2 : SubclassFinder.getParameterSetFor((Class)it.next())) {
                if (Singleton.class.isAssignableFrom(clazz2)) {
                    try {
                        sets.add((InstanceParameterSet)((Object)Singleton.SingletonHandler.getSingelton(clazz2)));
                        continue;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                sets.add((InstanceParameterSet)clazz2.newInstance());
            }
        }
        return sets;
    }

    private static class ClassNameComparator
    implements Comparator<Class> {
        private static ClassNameComparator DEFAULT = new ClassNameComparator();

        private ClassNameComparator() {
        }

        @Override
        public int compare(Class o1, Class o2) {
            return o1.getSimpleName().compareTo(o2.getSimpleName());
        }
    }
}

