/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.discrete;

import cern.colt.Arrays;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.ReferenceSequenceAnnotation;
import de.jstacs.io.ArrayHandler;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.DifferentiableEmission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.Emission;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import java.text.NumberFormat;
import java.util.LinkedList;
import javax.naming.OperationNotSupportedException;

public class CRISPREmission
implements DifferentiableEmission {
    private double[][] mixPars;
    private double[][][] condPars;
    private int index;
    private CRISPREmission ref;
    private int offset;
    private CRISPREmission tempClone;

    private static final Sequence getReferenceSequence(Sequence seq) {
        return ((ReferenceSequenceAnnotation)seq.getSequenceAnnotationByType("reference", 0)).getReferenceSequence();
    }

    public CRISPREmission(CRISPREmission ref, int index) {
        this.ref = ref;
        this.offset = -1;
        this.mixPars = new double[20][2];
        this.condPars = new double[2][4][4];
        this.index = index;
    }

    public CRISPREmission clone() throws CloneNotSupportedException {
        CRISPREmission clone = (CRISPREmission)super.clone();
        clone.mixPars = (double[][])ArrayHandler.clone((Cloneable[])this.mixPars);
        clone.condPars = (double[][][])ArrayHandler.clone((Cloneable[])this.condPars);
        if (this.index == 0) {
            this.tempClone = clone;
            return clone;
        }
        clone.ref = this.ref.tempClone;
        return clone;
    }

    @Override
    public AlphabetContainer getAlphabetContainer() {
        return DNAAlphabetContainer.SINGLETON;
    }

    @Override
    public void initializeFunctionRandomly() {
        if (this.index == 0) {
            int j;
            int i = 0;
            while (i < this.mixPars.length) {
                j = 0;
                while (j < this.mixPars[i].length) {
                    this.mixPars[i][j] = Math.random() + 5.0 * (double)(j == 0 ? i : -i) / (double)this.mixPars.length;
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < this.condPars.length) {
                j = 0;
                while (j < this.condPars[i].length) {
                    int k = 0;
                    while (k < this.condPars[i][j].length) {
                        this.condPars[i][j][k] = Math.random() + (i == 0 ? (double)(j == k ? 4 : -4) : -0.5);
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            this.copyFromRef(this.ref);
        }
    }

    @Override
    public double getLogProbFor(boolean forward, int startPos, int endPos, Sequence seq) throws OperationNotSupportedException {
        Sequence ref = CRISPREmission.getReferenceSequence(seq);
        double score = 0.0;
        int s = startPos;
        while (s <= endPos) {
            double p1 = this.condPars[0][ref.discreteVal(this.index)][seq.discreteVal(s)] + this.mixPars[this.index][0];
            double p2 = this.condPars[1][ref.discreteVal(this.index)][seq.discreteVal(s)] + this.mixPars[this.index][1];
            score += Normalisation.getLogSum(p1, p2);
            ++s;
        }
        return score;
    }

    @Override
    public double getLogPriorTerm() {
        return 0.0;
    }

    @Override
    public void resetStatistic() {
        throw new RuntimeException();
    }

    @Override
    public void addToStatistic(boolean forward, int startPos, int endPos, double weight, Sequence seq) throws OperationNotSupportedException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void joinStatistics(Emission ... emissions) {
        throw new RuntimeException();
    }

    @Override
    public void estimateFromStatistic() {
        throw new RuntimeException();
    }

    @Override
    public String getNodeShape(boolean forward) {
        return null;
    }

    @Override
    public String getNodeLabel(double weight, String name, NumberFormat nf) {
        return name;
    }

    @Override
    public void setParameters(Emission t) throws IllegalArgumentException {
        if (this.index == 0) {
            this.copyFromRef((CRISPREmission)t);
        } else {
            this.copyFromRef(this.ref);
        }
    }

    private void copyFromRef(CRISPREmission t) {
        int j;
        int i = 0;
        while (i < this.mixPars.length) {
            j = 0;
            while (j < this.mixPars[i].length) {
                this.mixPars[i][j] = t.mixPars[i][j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.condPars.length) {
            j = 0;
            while (j < this.condPars[i].length) {
                int k = 0;
                while (k < this.condPars[i][j].length) {
                    this.condPars[i][j][k] = t.condPars[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    public String toString(NumberFormat nf) {
        if (this.index == 0) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.mixPars.length) {
                sb.append(String.valueOf(i) + " " + Arrays.toString(this.mixPars[i]) + "\n");
                ++i;
            }
            sb.append("\n");
            i = 0;
            while (i < this.condPars.length) {
                int j = 0;
                while (j < this.condPars[i].length) {
                    sb.append(String.valueOf(i) + " " + j + " " + Arrays.toString(this.condPars[i][j]) + "\n");
                    ++j;
                }
                ++i;
            }
            return sb.toString();
        }
        return "";
    }

    @Override
    public StringBuffer toXML() {
        return null;
    }

    @Override
    public void fillCurrentParameter(double[] params) {
        if (this.index == 0) {
            int j;
            int myOffset = this.offset;
            int i = 0;
            while (i < this.mixPars.length) {
                j = 0;
                while (j < this.mixPars[i].length) {
                    params[myOffset] = this.mixPars[i][j];
                    ++j;
                    ++myOffset;
                }
                ++i;
            }
            i = 0;
            while (i < this.condPars.length) {
                j = 0;
                while (j < this.condPars[i].length) {
                    int k = 0;
                    while (k < this.condPars[i][j].length) {
                        params[myOffset] = this.condPars[i][j][k];
                        ++k;
                        ++myOffset;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    @Override
    public void setParameter(double[] params, int offset) {
        if (this.index == 0) {
            int j;
            int myOffset = offset;
            int i = 0;
            while (i < this.mixPars.length) {
                j = 0;
                while (j < this.mixPars[i].length) {
                    this.mixPars[i][j] = params[myOffset];
                    ++j;
                    ++myOffset;
                }
                ++i;
            }
            i = 0;
            while (i < this.condPars.length) {
                j = 0;
                while (j < this.condPars[i].length) {
                    int k = 0;
                    while (k < this.condPars[i][j].length) {
                        this.condPars[i][j][k] = params[myOffset];
                        ++k;
                        ++myOffset;
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            this.copyFromRef(this.ref);
        }
    }

    @Override
    public int setParameterOffset(int offset) {
        if (this.index == 0) {
            this.offset = offset;
            System.out.println("offset" + this.offset);
            return offset + this.getNumberOfParameters();
        }
        this.offset = this.ref.offset;
        return offset;
    }

    @Override
    public double getLogProbAndPartialDerivationFor(boolean forward, int startPos, int endPos, IntList indices, DoubleList partDer, Sequence seq) throws OperationNotSupportedException {
        Sequence ref = CRISPREmission.getReferenceSequence(seq);
        double score = 0.0;
        int s = startPos;
        while (s <= endPos) {
            int idx1 = ref.discreteVal(this.index);
            int idx2 = seq.discreteVal(s);
            double p1 = this.condPars[0][idx1][idx2] + this.mixPars[this.index][0];
            double p2 = this.condPars[1][idx1][idx2] + this.mixPars[this.index][1];
            double temp = Normalisation.getLogSum(p1, p2);
            indices.add(this.offset + 2 * this.index);
            partDer.add(Math.exp(p1) / Math.exp(temp));
            indices.add(this.offset + 2 * this.index + 1);
            partDer.add(Math.exp(p2) / Math.exp(temp));
            indices.add(this.offset + this.mixPars.length * 2 + idx1 * this.condPars[0][0].length + idx2);
            partDer.add(Math.exp(p1) / Math.exp(temp));
            indices.add(this.offset + this.mixPars.length * 2 + this.condPars[0].length * this.condPars[0][0].length + idx1 * this.condPars[1][0].length + idx2);
            partDer.add(Math.exp(p2) / Math.exp(temp));
            score += temp;
            ++s;
        }
        return score;
    }

    @Override
    public void addGradientOfLogPriorTerm(double[] grad, int offset) {
    }

    @Override
    public void fillSamplingGroups(int parameterOffset, LinkedList<int[]> list) {
        throw new RuntimeException();
    }

    @Override
    public int getNumberOfParameters() {
        if (this.index == 0) {
            int num = this.mixPars.length * 2;
            int i = 0;
            while (i < this.condPars[0].length) {
                num += this.condPars[0][i].length + this.condPars[1][i].length;
                ++i;
            }
            System.out.println("num: " + num);
            return num;
        }
        return 0;
    }

    @Override
    public int getSizeOfEventSpace() {
        return 0;
    }
}

