/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous;

import de.jstacs.NotTrainedException;
import de.jstacs.algorithms.optimization.termination.SmallDifferenceOfFunctionEvaluationsCondition;
import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.Constraint;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.ConstraintManager;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.InhomogeneousDGTrainSM;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.MEM;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.MEMConstraint;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.SequenceIterator;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.parameters.MEManagerParameterSet;
import de.jstacs.utils.DiscreteInhomogenousDataSetEmitter;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.naming.OperationNotSupportedException;

public abstract class MEManager
extends InhomogeneousDGTrainSM {
    protected MEM[] factors;

    public MEManager(MEManagerParameterSet params) throws CloneNotSupportedException, IllegalArgumentException, NonParsableException {
        super(params);
    }

    public MEManager(StringBuffer stringBuff) throws NonParsableException {
        super(stringBuff);
    }

    @Override
    public MEManager clone() throws CloneNotSupportedException {
        MEManager clone = (MEManager)super.clone();
        if (this.factors != null) {
            clone.factors = new MEM[this.factors.length];
            int i = 0;
            while (i < this.factors.length) {
                clone.factors[i] = this.factors[i].clone();
                ++i;
            }
        }
        return clone;
    }

    @Override
    public DataSet emitDataSet(int n, int ... lengths) throws NotTrainedException, Exception {
        if (lengths != null && lengths.length != 0) {
            throw new Exception("This is an inhomogeneous model. Please check parameter lengths.");
        }
        return DiscreteInhomogenousDataSetEmitter.emitDataSet(this, n);
    }

    @Override
    public double getLogPriorTerm() throws Exception {
        if (this.trained) {
            double ess = this.getESS();
            if (ess == 0.0) {
                return 0.0;
            }
            if ((ConstraintManager.Decomposition)((Object)this.params.getParameterAt(2).getValue()) != ConstraintManager.Decomposition.DECOMPOSE_LESS_CONNECTED) {
                double res = 0.0;
                int i = 0;
                while (i < this.factors.length) {
                    res += this.factors[i].getLogPriorPart(ess);
                    ++i;
                }
                return res;
            }
            throw new OperationNotSupportedException("The prior can not be computed if the MEM is decomposed uding DECOMPOSE_LESS_CONNECTED.");
        }
        throw new NotTrainedException();
    }

    @Override
    public double getLogProbFor(Sequence sequence, int startpos, int endpos) throws NotTrainedException, Exception {
        this.check(sequence, startpos, endpos);
        double res = this.factors[0].getLogScoreFor(sequence, startpos);
        int i = 1;
        while (i < this.factors.length) {
            res += this.factors[i].getLogScoreFor(sequence, startpos);
            ++i;
        }
        return res;
    }

    @Override
    public NumericalResultSet getNumericalCharacteristics() {
        return null;
    }

    @Override
    public String getStructure() throws NotTrainedException {
        if (this.factors == null) {
            throw new NotTrainedException();
        }
        int counter1 = 0;
        String erg = "";
        while (counter1 < this.factors.length) {
            erg = String.valueOf(erg) + "factor " + counter1 + ": " + this.factors[counter1].toString() + "\n";
            int counter2 = 0;
            while (counter2 < this.factors[counter1].constraints.length) {
                erg = String.valueOf(erg) + this.factors[counter1].constraints[counter2] + "\n";
                ++counter2;
            }
            ++counter1;
        }
        return erg;
    }

    @Override
    public String toString(NumberFormat nf) {
        String erg = super.toString(nf);
        if (this.factors != null && this.factors.length > 1) {
            erg = String.valueOf(erg) + "\n\n";
            int i = 0;
            while (i < this.factors.length) {
                erg = String.valueOf(erg) + "MEM " + i + ": " + this.factors[i].toString(nf) + "\n";
                ++i;
            }
        }
        return erg;
    }

    protected MEM[] getFactors(String constraints, boolean reduce, ConstraintManager.Decomposition decomposition) {
        return this.getFactors(ConstraintManager.extract(this.length, constraints), reduce, decomposition);
    }

    protected MEM[] getFactors(ArrayList<int[]> list, boolean reduce, ConstraintManager.Decomposition decomposition) {
        if (reduce) {
            ConstraintManager.reduce(list);
        }
        return ConstraintManager.disconnect(list, this.alphabetLength, decomposition);
    }

    @Override
    protected StringBuffer getFurtherModelInfos() {
        StringBuffer b = new StringBuffer(10000);
        XMLParser.appendObjectWithTags(b, this.sostream.doesNothing(), "outStream_does_nothing");
        if (this.trained) {
            XMLParser.appendObjectWithTags(b, this.factors, "mem");
        }
        return b;
    }

    protected void trainFactors(DataSet data, double[] weights) throws Exception {
        int i = 0;
        int offset = 0;
        while (i < this.factors.length) {
            offset += this.factors[i++].constraints.length;
        }
        Constraint[] c = new MEMConstraint[offset];
        offset = 0;
        i = 0;
        while (i < this.factors.length) {
            int l = this.factors[i].constraints.length;
            System.arraycopy(this.factors[i].constraints, 0, c, offset, l);
            offset += l;
            ++i;
        }
        ConstraintManager.countInhomogeneous(this.alphabets, this.length, data, weights, true, c);
        ConstraintManager.computeFreqs(this.getESS(), c);
        SequenceIterator s = new SequenceIterator(this.length);
        byte algo = (Byte)this.params.getParameterAt(4).getValue();
        SmallDifferenceOfFunctionEvaluationsCondition eps = new SmallDifferenceOfFunctionEvaluationsCondition((Double)this.params.getParameterAt(5).getValue());
        i = 0;
        while (i < this.factors.length) {
            this.factors[i].train(s, algo, eps, this.sostream);
            ++i;
        }
        System.gc();
    }

    @Override
    protected void setFurtherModelInfos(StringBuffer xml) throws NonParsableException {
        if (XMLParser.extractObjectForTags(xml, "outStream_does_nothing", Boolean.TYPE).booleanValue()) {
            this.setOutputStream(null);
        } else {
            this.setOutputStream(DEFAULT_STREAM);
        }
        if (this.trained) {
            this.factors = XMLParser.extractObjectForTags(xml, "mem", MEM[].class);
        }
    }
}

