/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.InhConstraint;
import de.jstacs.utils.random.DirichletMRG;
import de.jstacs.utils.random.DirichletMRGParams;
import javax.naming.OperationNotSupportedException;

public class InhCondProb
extends InhConstraint {
    private boolean conditional;
    private double[] lnFreq;
    private static final String XML_TAG = "InhCondProb";

    public InhCondProb(int pos, int ... alphabetLength) {
        this(new int[]{pos}, alphabetLength, false);
    }

    public InhCondProb(int[] pos, int[] alphabetLength, boolean cond) {
        super(pos, alphabetLength);
        this.conditional = pos.length > 1 && cond;
    }

    public InhCondProb(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public InhCondProb clone() throws CloneNotSupportedException {
        InhCondProb clone = (InhCondProb)super.clone();
        if (this.lnFreq != null) {
            clone.lnFreq = null;
            clone.lnFreq(0, this.freq.length);
        }
        return clone;
    }

    public void drawParameters(double ess) {
        double pc = ess / (double)this.getNumberOfSpecificConstraints();
        if (!this.conditional || this.usedPositions.length == 1) {
            this.drawUnConditional(0, this.freq.length, pc);
        } else {
            int l = this.offset[this.offset.length - 2];
            int counter1 = 0;
            while (counter1 < this.freq.length) {
                this.drawUnConditional(counter1, counter1 + l, pc);
                counter1 += l;
            }
        }
        this.lnFreq(0, this.freq.length);
    }

    @Override
    public void estimate(double ess) {
        double pc = ess / (double)this.getNumberOfSpecificConstraints();
        if (!this.conditional || this.usedPositions.length == 1) {
            this.estimateUnConditional(0, this.freq.length, pc, false);
        } else {
            int l = this.offset[this.offset.length - 2];
            int counter1 = 0;
            while (counter1 < this.freq.length) {
                this.estimateUnConditional(counter1, counter1 + l, pc, false);
                counter1 += l;
            }
        }
    }

    public void estimateUnConditional(double ess, double all) {
        this.conditional = false;
        all = ess + all;
        double pc = ess / (double)this.getNumberOfSpecificConstraints();
        int i = 0;
        while (i < this.freq.length) {
            this.freq[i] = (this.counts[i] + pc) / all;
            ++i;
        }
        this.lnFreq(0, this.freq.length);
    }

    public double getLnFreq(int index) {
        return this.lnFreq[index];
    }

    public double getLnFreq(Sequence s, int start) {
        return this.lnFreq[this.satisfiesSpecificConstraint(s, start)];
    }

    public void getOutput(byte[] content, double p) throws OperationNotSupportedException {
        int off = 0;
        int i = 0;
        if (this.conditional) {
            while (i < this.usedPositions.length - 1) {
                off += content[this.usedPositions[i]] * this.offset[i];
                i = (byte)(i + 1);
            }
        } else if (this.usedPositions.length > 1) {
            throw new OperationNotSupportedException();
        }
        i = 0;
        while (p > this.freq[off]) {
            p -= this.freq[off++];
            i = (byte)(i + 1);
        }
        content[this.usedPositions[this.usedPositions.length - 1]] = i;
    }

    @Override
    public String toString() {
        String erg = "";
        int i = 1;
        int l = this.usedPositions.length - 1;
        if (l > 0) {
            erg = String.valueOf(erg) + this.usedPositions[0];
            while (i < l) {
                erg = String.valueOf(erg) + ", " + this.usedPositions[i++];
            }
            if (this.conditional) {
                erg = String.valueOf(erg) + " -> ";
            }
        }
        return String.valueOf(erg) + this.usedPositions[l];
    }

    protected void drawUnConditional(int start, int end, double pc) {
        double[] alpha = new double[end - start];
        int index = 0;
        while (index < alpha.length) {
            alpha[index] = this.counts[start + index] + pc;
            ++index;
        }
        DirichletMRG.DEFAULT_INSTANCE.generate(this.freq, start, alpha.length, new DirichletMRGParams(alpha));
    }

    @Override
    protected void estimateUnConditional(int start, int end, double pc, boolean exceptionWhenNoData) {
        super.estimateUnConditional(start, end, pc, exceptionWhenNoData);
        this.lnFreq(start, end);
    }

    @Override
    protected void appendAdditionalInfo(StringBuffer xml) {
        super.appendAdditionalInfo(xml);
        XMLParser.appendObjectWithTags(xml, this.conditional, "conditional");
    }

    @Override
    protected String getXMLTag() {
        return XML_TAG;
    }

    @Override
    protected void extractAdditionalInfo(StringBuffer xml) throws NonParsableException {
        super.extractAdditionalInfo(xml);
        this.conditional = XMLParser.extractObjectForTags(xml, "conditional", Boolean.TYPE);
        this.lnFreq(0, this.freq.length);
    }

    private void lnFreq(int start, int end) {
        if (this.lnFreq == null) {
            this.lnFreq = new double[this.freq.length];
        }
        int i = start;
        while (i < end) {
            this.lnFreq[i] = Math.log(this.freq[i]);
            ++i;
        }
    }

    public void setFreqs(String[] array, int start) throws IllegalArgumentException {
        int l = !this.conditional || this.usedPositions.length == 1 ? this.freq.length : this.offset[this.offset.length - 2];
        double p = 0.0;
        int k = 0;
        int i = 0;
        while (i < this.freq.length) {
            this.freq[i] = Double.parseDouble(array[start++]);
            if (this.freq[i] < 0.0) {
                throw new IllegalArgumentException("this is no proper frequency");
            }
            p += this.freq[i];
            if (++k == l) {
                if (Math.abs(1.0 - p) > 1.0E-7) {
                    throw new IllegalArgumentException("The frequencies does not sum to 1.");
                }
                k = 0;
                p = 0.0;
            }
            ++i;
        }
        this.lnFreq(0, this.freq.length);
    }

    @Override
    public String getDescription(AlphabetContainer con, int i) {
        String res = super.getDescription(con, i);
        if (this.conditional) {
            res = res.replaceFirst(", ", " | ");
        }
        return res;
    }
}

