/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.performanceMeasures;

import de.jstacs.classifiers.performanceMeasures.AbstractPerformanceMeasure;
import de.jstacs.io.NonParsableException;
import de.jstacs.results.ListResult;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.results.ResultSet;
import de.jstacs.utils.ToolBox;

public class ConfusionMatrix
extends AbstractPerformanceMeasure {
    public ConfusionMatrix() {
    }

    public ConfusionMatrix(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public ResultSet compute(double[] sortedScoresClass0, double[] weightClass0, double[] sortedScoresClass1, double[] weightClass1) {
        double tp = 0.0;
        double fn = 0.0;
        double fp = 0.0;
        double tn = 0.0;
        double w = 1.0;
        int i = 0;
        while (i < sortedScoresClass0.length) {
            if (weightClass0 != null) {
                w = weightClass0[i];
            }
            if (sortedScoresClass0[i] >= 0.0) {
                tp += w;
            } else {
                fn += w;
            }
            ++i;
        }
        w = 1.0;
        i = 0;
        while (i < sortedScoresClass1.length) {
            if (weightClass1 != null) {
                w = weightClass1[i];
            }
            if (sortedScoresClass0[i] >= 0.0) {
                fp += w;
            } else {
                tn += w;
            }
            ++i;
        }
        return new ResultSet(new ListResult(this.getName(), String.valueOf(this.getName()) + " for two classes.", null, new NumericalResultSet(new NumericalResult[][]{{new NumericalResult("TP", "true positives", tp), new NumericalResult("FN", "false negatives", fn)}}), new NumericalResultSet(new NumericalResult[][]{{new NumericalResult("FP", "false positives", fp), new NumericalResult("TN", "true negatives", tn)}})));
    }

    @Override
    public ResultSet compute(double[][][] classSpecificScores, double[][] weights) {
        double[][] res = new double[classSpecificScores.length][classSpecificScores.length];
        int i = 0;
        while (i < classSpecificScores.length) {
            double w = 1.0;
            int j = 0;
            while (j < classSpecificScores[i].length) {
                if (weights != null && weights[i] != null) {
                    w = weights[i][j];
                }
                int predicted = ToolBox.getMaxIndex(classSpecificScores[i][j]);
                double[] dArray = res[i];
                int n = predicted;
                dArray[n] = dArray[n] + w;
                ++j;
            }
            ++i;
        }
        ResultSet[] sets = new NumericalResultSet[classSpecificScores.length];
        int i2 = 0;
        while (i2 < res.length) {
            NumericalResult[] temp = new NumericalResult[res[i2].length];
            int j = 0;
            while (j < res[i2].length) {
                temp[j] = new NumericalResult(String.valueOf(i2) + "/" + j, "correct class: " + i2 + ", predicted class: " + j, res[i2][j]);
                ++j;
            }
            sets[i2] = new NumericalResultSet(new NumericalResult[][]{temp});
            ++i2;
        }
        return new ResultSet(new ListResult(this.getName(), String.valueOf(this.getName()) + " for " + classSpecificScores.length + " classes", null, sets));
    }

    @Override
    public int getAllowedNumberOfClasses() {
        return 0;
    }

    @Override
    public String getName() {
        return "Confusion matrix";
    }
}

