/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.writer;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.mapsforge.map.writer.model.TDNode;
import org.mapsforge.map.writer.model.TDWay;
import org.mapsforge.map.writer.util.JTSUtils;

class WayPolygonizer {
    private static final int MIN_NODES_POLYGON = 4;
    private List<TDWay> dangling;
    private final GeometryFactory geometryFactory = new GeometryFactory();
    private List<TDWay> illegal;
    private Map<Integer, List<Integer>> outerToInner;
    private List<Deque<TDWay>> polygons;

    WayPolygonizer() {
    }

    private static boolean isClosedPolygon(Deque<TDWay> currentPolygonSegments) {
        TDWay c1Start = currentPolygonSegments.getFirst();
        TDWay c1End = currentPolygonSegments.getLast();
        long startFirst = c1Start.isReversedInRelation() ? c1Start.getWayNodes()[c1Start.getWayNodes().length - 1].getId() : c1Start.getWayNodes()[0].getId();
        long endLast = c1End.isReversedInRelation() ? c1End.getWayNodes()[0].getId() : c1End.getWayNodes()[c1End.getWayNodes().length - 1].getId();
        return startFirst == endLast;
    }

    private static boolean isClosedPolygon(TDWay way) {
        TDNode[] waynodes = way.getWayNodes();
        return waynodes[0].getId() == waynodes[waynodes.length - 1].getId();
    }

    private static Coordinate[] toCoordinates(Collection<TDWay> linestrings) {
        Coordinate[][] temp = new Coordinate[linestrings.size()][];
        int i = 0;
        int n = 0;
        for (TDWay tdWay : linestrings) {
            temp[i] = JTSUtils.toCoordinates(tdWay);
            n += temp[i].length;
            ++i;
        }
        Coordinate[] res = new Coordinate[n];
        int pos = 0;
        for (i = 0; i < temp.length; ++i) {
            System.arraycopy(temp[i], 0, res, pos, temp[i].length);
            pos += temp[i].length;
        }
        return res;
    }

    List<TDWay> getDangling() {
        return this.dangling;
    }

    List<TDWay> getIllegal() {
        return this.illegal;
    }

    Map<Integer, List<Integer>> getOuterToInner() {
        return this.outerToInner;
    }

    List<Deque<TDWay>> getPolygons() {
        return this.polygons;
    }

    void mergePolygons(TDWay[] ways) {
        this.polygons = new ArrayList<Deque<TDWay>>();
        this.dangling = new ArrayList<TDWay>();
        this.illegal = new ArrayList<TDWay>();
        ArrayDeque<TDWay> ungroupedWays = new ArrayDeque<TDWay>();
        for (TDWay tdWay : ways) {
            tdWay.setReversedInRelation(false);
            if (WayPolygonizer.isClosedPolygon(tdWay)) {
                if (tdWay.getWayNodes().length < 4) {
                    this.illegal.add(tdWay);
                    continue;
                }
                ArrayDeque<TDWay> cluster = new ArrayDeque<TDWay>();
                cluster.add(tdWay);
                this.polygons.add(cluster);
                continue;
            }
            ungroupedWays.add(tdWay);
        }
        if (ungroupedWays.isEmpty()) {
            return;
        }
        if (ungroupedWays.size() == 1) {
            this.dangling.add((TDWay)ungroupedWays.getFirst());
            return;
        }
        boolean startNewPolygon = true;
        while (true) {
            boolean merge = false;
            if (startNewPolygon) {
                ArrayDeque cluster = new ArrayDeque();
                cluster.add(ungroupedWays.removeFirst());
                this.polygons.add(cluster);
                startNewPolygon = false;
            }
            Iterator it = ungroupedWays.iterator();
            while (it.hasNext()) {
                TDWay current = (TDWay)it.next();
                Deque<TDWay> currentPolygonSegments = this.polygons.get(this.polygons.size() - 1);
                TDWay c1Start = currentPolygonSegments.getFirst();
                TDWay c1End = currentPolygonSegments.getLast();
                long startFirst = c1Start.isReversedInRelation() ? c1Start.getWayNodes()[c1Start.getWayNodes().length - 1].getId() : c1Start.getWayNodes()[0].getId();
                long endLast = c1End.isReversedInRelation() ? c1End.getWayNodes()[0].getId() : c1End.getWayNodes()[c1End.getWayNodes().length - 1].getId();
                long currentFirst = current.getWayNodes()[0].getId();
                long currentLast = current.getWayNodes()[current.getWayNodes().length - 1].getId();
                if (startFirst == currentLast) {
                    merge = true;
                    it.remove();
                    currentPolygonSegments.offerFirst(current);
                    continue;
                }
                if (startFirst == currentFirst) {
                    current.setReversedInRelation(true);
                    merge = true;
                    it.remove();
                    currentPolygonSegments.offerFirst(current);
                    continue;
                }
                if (endLast == currentFirst) {
                    merge = true;
                    it.remove();
                    currentPolygonSegments.offerLast(current);
                    continue;
                }
                if (endLast != currentLast) continue;
                current.setReversedInRelation(true);
                merge = true;
                it.remove();
                currentPolygonSegments.offerLast(current);
            }
            Deque<TDWay> currentCluster = this.polygons.get(this.polygons.size() - 1);
            boolean closed = WayPolygonizer.isClosedPolygon(currentCluster);
            if (!closed) {
                if (!ungroupedWays.isEmpty() && merge) continue;
                this.dangling.addAll((Collection<TDWay>)this.polygons.get(this.polygons.size() - 1));
                this.dangling.addAll(ungroupedWays);
                this.polygons.remove(this.polygons.size() - 1);
                return;
            }
            if (ungroupedWays.isEmpty()) {
                return;
            }
            startNewPolygon = true;
        }
    }

    void polygonizeAndRelate(TDWay[] ways) {
        this.mergePolygons(ways);
        this.relatePolygons();
    }

    void relatePolygons() {
        this.outerToInner = new HashMap<Integer, List<Integer>>();
        if (this.polygons.isEmpty()) {
            return;
        }
        Polygon[] polygonGeometries = new Polygon[this.polygons.size()];
        int i = 0;
        for (Deque<TDWay> polygon : this.polygons) {
            polygonGeometries[i++] = this.geometryFactory.createPolygon(this.geometryFactory.createLinearRing(WayPolygonizer.toCoordinates(polygon)), null);
        }
        this.outerToInner = new HashMap<Integer, List<Integer>>();
        HashSet<Integer> inner = new HashSet<Integer>();
        for (int k = 0; k < polygonGeometries.length; ++k) {
            if (inner.contains(k)) continue;
            for (int l = k + 1; l < polygonGeometries.length; ++l) {
                List<Integer> inners;
                if (inner.contains(l)) continue;
                if (polygonGeometries[k].covers(polygonGeometries[l])) {
                    inners = this.outerToInner.get(k);
                    if (inners == null) {
                        inners = new ArrayList<Integer>();
                        this.outerToInner.put(k, inners);
                    }
                    inners.add(l);
                    inner.add(l);
                    continue;
                }
                if (this.outerToInner.containsKey(k) || !polygonGeometries[l].covers(polygonGeometries[k])) continue;
                inners = this.outerToInner.get(l);
                if (inners == null) {
                    inners = new ArrayList<Integer>();
                    this.outerToInner.put(l, inners);
                }
                inners.add(k);
                inner.add(k);
            }
            if (this.outerToInner.containsKey(k) || inner.contains(k)) continue;
            this.outerToInner.put(k, null);
        }
    }

    class PolygonMergeException
    extends Exception {
        private static final long serialVersionUID = 1L;

        PolygonMergeException() {
        }
    }
}

