/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.util;

import java.io.File;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;

public class AtomicFileCreator {
    private File file;
    private File tmpFile;

    public AtomicFileCreator(File file) {
        this.file = file;
        this.tmpFile = new File(file.getPath() + ".tmp");
    }

    public boolean exists() {
        return this.file.exists() || this.tmpFile.exists();
    }

    public void renameTmpFileToCurrent() {
        if (!this.tmpFile.exists()) {
            throw new OsmosisRuntimeException("Can't rename non-existent file " + this.tmpFile + ".");
        }
        if (this.file.exists() && !this.file.delete()) {
            throw new OsmosisRuntimeException("Unable to delete file " + this.file + ".");
        }
        if (!this.tmpFile.renameTo(this.file)) {
            throw new OsmosisRuntimeException("Unable to rename file " + this.tmpFile + " to " + this.file + ".");
        }
    }

    public File getTmpFile() {
        return this.tmpFile;
    }

    public File getFile() {
        return this.file;
    }
}

