/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.tagfilter.v0_6;

import java.io.File;
import org.openstreetmap.osmosis.core.pipeline.common.TaskConfiguration;
import org.openstreetmap.osmosis.core.pipeline.common.TaskManager;
import org.openstreetmap.osmosis.core.pipeline.common.TaskManagerFactory;
import org.openstreetmap.osmosis.core.pipeline.v0_6.SinkSourceManager;
import org.openstreetmap.osmosis.core.task.v0_6.SinkSource;
import org.openstreetmap.osmosis.tagfilter.v0_6.WayKeyValueFilter;

public class WayKeyValueFilterFactory
extends TaskManagerFactory {
    private static final String ARG_KEY_VALUE_LIST = "keyValueList";
    private static final String ARG_KEY_VALUE_LIST_FILE = "keyValueListFile";

    protected TaskManager createTaskManagerImpl(TaskConfiguration taskConfig) {
        WayKeyValueFilter wayKeyValueFilter;
        if (this.doesArgumentExist(taskConfig, ARG_KEY_VALUE_LIST)) {
            String keyValueList = this.getStringArgument(taskConfig, ARG_KEY_VALUE_LIST);
            wayKeyValueFilter = new WayKeyValueFilter(keyValueList);
        } else if (this.doesArgumentExist(taskConfig, ARG_KEY_VALUE_LIST_FILE)) {
            String keyValueListFile = this.getStringArgument(taskConfig, ARG_KEY_VALUE_LIST_FILE);
            wayKeyValueFilter = new WayKeyValueFilter(new File(keyValueListFile));
        } else {
            String keyValueList = this.getDefaultStringArgument(taskConfig, "highway.motorway,highway.motorway_link,highway.trunk,highway.trunk_link");
            wayKeyValueFilter = new WayKeyValueFilter(keyValueList);
        }
        return new SinkSourceManager(taskConfig.getId(), (SinkSource)wayKeyValueFilter, taskConfig.getPipeArgs());
    }
}

