/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.apidb.v0_6;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.openstreetmap.osmosis.apidb.common.DatabaseContext;
import org.openstreetmap.osmosis.apidb.v0_6.ApidbVersionConstants;
import org.openstreetmap.osmosis.apidb.v0_6.impl.ChangesetManager;
import org.openstreetmap.osmosis.apidb.v0_6.impl.MemberTypeRenderer;
import org.openstreetmap.osmosis.apidb.v0_6.impl.SchemaVersionValidator;
import org.openstreetmap.osmosis.apidb.v0_6.impl.UserManager;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.container.v0_6.BoundContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityProcessor;
import org.openstreetmap.osmosis.core.container.v0_6.NodeContainer;
import org.openstreetmap.osmosis.core.container.v0_6.RelationContainer;
import org.openstreetmap.osmosis.core.container.v0_6.WayContainer;
import org.openstreetmap.osmosis.core.database.DatabaseLoginCredentials;
import org.openstreetmap.osmosis.core.database.DatabasePreferences;
import org.openstreetmap.osmosis.core.database.DbFeature;
import org.openstreetmap.osmosis.core.database.DbFeatureHistory;
import org.openstreetmap.osmosis.core.database.DbOrderedFeature;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;
import org.openstreetmap.osmosis.core.domain.v0_6.Relation;
import org.openstreetmap.osmosis.core.domain.v0_6.RelationMember;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;
import org.openstreetmap.osmosis.core.domain.v0_6.Way;
import org.openstreetmap.osmosis.core.domain.v0_6.WayNode;
import org.openstreetmap.osmosis.core.store.Storeable;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.core.util.FixedPrecisionCoordinateConvertor;
import org.openstreetmap.osmosis.core.util.TileCalculator;

public class ApidbWriter
implements Sink,
EntityProcessor {
    private static final String INSERT_SQL_NODE_COLUMNS = "INSERT INTO nodes(node_id, timestamp, version, visible, changeset_id, latitude, longitude, tile)";
    private static final String INSERT_SQL_NODE_PARAMS = ApidbWriter.createParamPlaceholders(8);
    private static final int INSERT_PRM_COUNT_NODE = 8;
    private static final String INSERT_SQL_NODE_TAG_COLUMNS = "INSERT INTO node_tags (node_id, k, v, version)";
    private static final String INSERT_SQL_NODE_TAG_PARAMS = ApidbWriter.createParamPlaceholders(4);
    private static final int INSERT_PRM_COUNT_NODE_TAG = 4;
    private static final String INSERT_SQL_WAY_COLUMNS = "INSERT INTO ways (way_id, timestamp, version, visible, changeset_id)";
    private static final String INSERT_SQL_WAY_PARAMS = ApidbWriter.createParamPlaceholders(5);
    private static final int INSERT_PRM_COUNT_WAY = 5;
    private static final String INSERT_SQL_WAY_TAG_COLUMNS = "INSERT INTO way_tags (way_id, k, v, version)";
    private static final String INSERT_SQL_WAY_TAG_PARAMS = ApidbWriter.createParamPlaceholders(4);
    private static final int INSERT_PRM_COUNT_WAY_TAG = 4;
    private static final String INSERT_SQL_WAY_NODE_COLUMNS = "INSERT INTO way_nodes (way_id, node_id, sequence_id, version)";
    private static final String INSERT_SQL_WAY_NODE_PARAMS = ApidbWriter.createParamPlaceholders(4);
    private static final int INSERT_PRM_COUNT_WAY_NODE = 4;
    private static final String INSERT_SQL_RELATION_COLUMNS = "INSERT INTO relations (relation_id, timestamp, version, visible, changeset_id)";
    private static final String INSERT_SQL_RELATION_PARAMS = "?, ?, ?, ?, ?";
    private static final int INSERT_PRM_COUNT_RELATION = 5;
    private static final String INSERT_SQL_RELATION_TAG_COLUMNS = "INSERT INTO relation_tags (relation_id, k, v, version)";
    private static final String INSERT_SQL_RELATION_TAG_PARAMS = ApidbWriter.createParamPlaceholders(4);
    private static final int INSERT_PRM_COUNT_RELATION_TAG = 4;
    private static final String INSERT_SQL_RELATION_MEMBER_COLUMNS = "INSERT INTO relation_members (relation_id, member_type, member_id, sequence_id, member_role, version)";
    private static final String INSERT_SQL_RELATION_MEMBER_PARAMS_MYSQL = "?, ?, ?, ?, ?, ?";
    private static final String INSERT_SQL_RELATION_MEMBER_PARAMS_PGSQL = "?, ?::nwr_enum, ?, ?, ?, ?";
    private static final int INSERT_PRM_COUNT_RELATION_MEMBER = 6;
    private static final List<String> DISABLE_KEY_TABLES = Arrays.asList("nodes", "node_tags", "ways", "way_tags", "way_nodes", "relations", "relation_tags", "relation_members");
    private static final int LOAD_CURRENT_NODE_ROW_COUNT = 1000000;
    private static final int LOAD_CURRENT_WAY_ROW_COUNT = 100000;
    private static final int LOAD_CURRENT_RELATION_ROW_COUNT = 100000;
    private static final String LOAD_CURRENT_NODES = "INSERT INTO current_nodes SELECT node_id, latitude, longitude, changeset_id, visible, timestamp, tile, version FROM nodes WHERE node_id >= ? AND node_id < ?";
    private static final String LOAD_CURRENT_NODE_TAGS = "INSERT INTO current_node_tags SELECT node_id, k, v FROM node_tags WHERE node_id >= ? AND node_id < ?";
    private static final String WHERE_WAY_ID_IN_RANGE = " WHERE way_id >= ? AND way_id < ?";
    private static final String LOAD_CURRENT_WAYS = "INSERT INTO current_ways SELECT way_id, changeset_id, timestamp, visible, version FROM ways WHERE way_id >= ? AND way_id < ?";
    private static final String LOAD_CURRENT_WAY_TAGS = "INSERT INTO current_way_tags SELECT way_id, k, v FROM way_tags WHERE way_id >= ? AND way_id < ?";
    private static final String LOAD_CURRENT_WAY_NODES = "INSERT INTO current_way_nodes SELECT way_id, node_id, sequence_id FROM way_nodes WHERE way_id >= ? AND way_id < ?";
    private static final String LOAD_CURRENT_RELATIONS = "INSERT INTO current_relations SELECT relation_id, changeset_id, timestamp, visible, version FROM relations WHERE relation_id >= ? AND relation_id < ?";
    private static final String LOAD_CURRENT_RELATION_TAGS = "INSERT INTO current_relation_tags SELECT relation_id, k, v FROM relation_tags WHERE relation_id >= ? AND relation_id < ?";
    private static final String LOAD_CURRENT_RELATION_MEMBERS = "INSERT INTO current_relation_members (relation_id, member_id, member_role, member_type, sequence_id) SELECT relation_id, member_id, member_role, member_type, sequence_id FROM relation_members WHERE relation_id >= ? AND relation_id < ?";
    private static final List<String> LOCK_TABLES = Arrays.asList("nodes", "node_tags", "ways", "way_tags", "way_nodes", "relations", "relation_tags", "relation_members", "current_nodes", "current_node_tags", "current_ways", "current_way_tags", "current_way_nodes", "current_relations", "current_relation_tags", "current_relation_members", "users", "changesets", "changeset_tags");
    private static final int INSERT_BULK_ROW_COUNT_NODE = 100;
    private static final int INSERT_BULK_ROW_COUNT_NODE_TAG = 100;
    private static final int INSERT_BULK_ROW_COUNT_WAY = 100;
    private static final int INSERT_BULK_ROW_COUNT_WAY_TAG = 100;
    private static final int INSERT_BULK_ROW_COUNT_WAY_NODE = 100;
    private static final int INSERT_BULK_ROW_COUNT_RELATION = 100;
    private static final int INSERT_BULK_ROW_COUNT_RELATION_TAG = 100;
    private static final int INSERT_BULK_ROW_COUNT_RELATION_MEMBER = 100;
    private static final int TRANSACTION_SIZE = 100000;
    private String insertSqlSingleNode;
    private String insertSqlBulkNode;
    private String insertSqlSingleNodeTag;
    private String insertSqlBulkNodeTag;
    private String insertSqlSingleWay;
    private String insertSqlBulkWay;
    private String insertSqlSingleWayTag;
    private String insertSqlBulkWayTag;
    private String insertSqlSingleWayNode;
    private String insertSqlBulkWayNode;
    private String insertSqlSingleRelation;
    private String insertSqlBulkRelation;
    private String insertSqlSingleRelationTag;
    private String insertSqlBulkRelationTag;
    private String insertSqlSingleRelationMember;
    private String insertSqlBulkRelationMember;
    private final DatabaseContext dbCtx;
    private final UserManager userManager;
    private final ChangesetManager changesetManager;
    private final SchemaVersionValidator schemaVersionValidator;
    private final boolean lockTables;
    private final boolean populateCurrentTables;
    private final List<Node> nodeBuffer;
    private final List<DbFeatureHistory<DbFeature<Tag>>> nodeTagBuffer;
    private final List<Way> wayBuffer;
    private final List<DbFeatureHistory<DbFeature<Tag>>> wayTagBuffer;
    private final List<DbFeatureHistory<DbOrderedFeature<WayNode>>> wayNodeBuffer;
    private final List<Relation> relationBuffer;
    private final List<DbFeatureHistory<DbFeature<Tag>>> relationTagBuffer;
    private final List<DbFeatureHistory<DbOrderedFeature<RelationMember>>> relationMemberBuffer;
    private long maxNodeId;
    private long minNodeId;
    private long maxWayId;
    private long minWayId;
    private long maxRelationId;
    private long minRelationId;
    private long transactionSizeCount;
    private final TileCalculator tileCalculator;
    private final MemberTypeRenderer memberTypeRenderer;
    private boolean initialized;
    private PreparedStatement singleNodeStatement;
    private PreparedStatement bulkNodeStatement;
    private PreparedStatement singleNodeTagStatement;
    private PreparedStatement bulkNodeTagStatement;
    private PreparedStatement singleWayStatement;
    private PreparedStatement bulkWayStatement;
    private PreparedStatement singleWayTagStatement;
    private PreparedStatement bulkWayTagStatement;
    private PreparedStatement singleWayNodeStatement;
    private PreparedStatement bulkWayNodeStatement;
    private PreparedStatement singleRelationStatement;
    private PreparedStatement bulkRelationStatement;
    private PreparedStatement singleRelationTagStatement;
    private PreparedStatement bulkRelationTagStatement;
    private PreparedStatement singleRelationMemberStatement;
    private PreparedStatement bulkRelationMemberStatement;
    private PreparedStatement loadCurrentNodesStatement;
    private PreparedStatement loadCurrentNodeTagsStatement;
    private PreparedStatement loadCurrentWaysStatement;
    private PreparedStatement loadCurrentWayTagsStatement;
    private PreparedStatement loadCurrentWayNodesStatement;
    private PreparedStatement loadCurrentRelationsStatement;
    private PreparedStatement loadCurrentRelationTagsStatement;
    private PreparedStatement loadCurrentRelationMembersStatement;

    public ApidbWriter(DatabaseLoginCredentials loginCredentials, DatabasePreferences preferences, boolean lockTables, boolean populateCurrentTables) {
        this.dbCtx = new DatabaseContext(loginCredentials);
        this.userManager = new UserManager(this.dbCtx);
        this.changesetManager = new ChangesetManager(this.dbCtx);
        this.schemaVersionValidator = new SchemaVersionValidator(loginCredentials, preferences);
        this.lockTables = lockTables;
        this.populateCurrentTables = populateCurrentTables;
        this.nodeBuffer = new ArrayList<Node>();
        this.nodeTagBuffer = new ArrayList<DbFeatureHistory<DbFeature<Tag>>>();
        this.wayBuffer = new ArrayList<Way>();
        this.wayTagBuffer = new ArrayList<DbFeatureHistory<DbFeature<Tag>>>();
        this.wayNodeBuffer = new ArrayList<DbFeatureHistory<DbOrderedFeature<WayNode>>>();
        this.relationBuffer = new ArrayList<Relation>();
        this.relationTagBuffer = new ArrayList<DbFeatureHistory<DbFeature<Tag>>>();
        this.relationMemberBuffer = new ArrayList<DbFeatureHistory<DbOrderedFeature<RelationMember>>>();
        this.maxNodeId = Long.MIN_VALUE;
        this.minNodeId = Long.MAX_VALUE;
        this.maxWayId = Long.MIN_VALUE;
        this.minWayId = Long.MAX_VALUE;
        this.maxRelationId = Long.MIN_VALUE;
        this.minRelationId = Long.MAX_VALUE;
        this.transactionSizeCount = 0L;
        this.tileCalculator = new TileCalculator();
        this.memberTypeRenderer = new MemberTypeRenderer();
        this.initialized = false;
    }

    private static String buildSqlInsertStatement(String columnSql, String parametersSql, int rowCount) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(columnSql).append(" VALUES ");
        for (int i = 0; i < rowCount; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append("(");
            buffer.append(parametersSql);
            buffer.append(")");
        }
        return buffer.toString();
    }

    private void buildSqlStatements() {
        this.insertSqlSingleNode = ApidbWriter.buildSqlInsertStatement(INSERT_SQL_NODE_COLUMNS, INSERT_SQL_NODE_PARAMS, 1);
        this.insertSqlBulkNode = ApidbWriter.buildSqlInsertStatement(INSERT_SQL_NODE_COLUMNS, INSERT_SQL_NODE_PARAMS, 100);
        this.insertSqlSingleNodeTag = ApidbWriter.buildSqlInsertStatement(INSERT_SQL_NODE_TAG_COLUMNS, INSERT_SQL_NODE_TAG_PARAMS, 1);
        this.insertSqlBulkNodeTag = ApidbWriter.buildSqlInsertStatement(INSERT_SQL_NODE_TAG_COLUMNS, INSERT_SQL_NODE_TAG_PARAMS, 100);
        this.insertSqlSingleWay = ApidbWriter.buildSqlInsertStatement(INSERT_SQL_WAY_COLUMNS, INSERT_SQL_WAY_PARAMS, 1);
        this.insertSqlBulkWay = ApidbWriter.buildSqlInsertStatement(INSERT_SQL_WAY_COLUMNS, INSERT_SQL_WAY_PARAMS, 100);
        this.insertSqlSingleWayTag = ApidbWriter.buildSqlInsertStatement(INSERT_SQL_WAY_TAG_COLUMNS, INSERT_SQL_WAY_TAG_PARAMS, 1);
        this.insertSqlBulkWayTag = ApidbWriter.buildSqlInsertStatement(INSERT_SQL_WAY_TAG_COLUMNS, INSERT_SQL_WAY_TAG_PARAMS, 100);
        this.insertSqlSingleWayNode = ApidbWriter.buildSqlInsertStatement(INSERT_SQL_WAY_NODE_COLUMNS, INSERT_SQL_WAY_NODE_PARAMS, 1);
        this.insertSqlBulkWayNode = ApidbWriter.buildSqlInsertStatement(INSERT_SQL_WAY_NODE_COLUMNS, INSERT_SQL_WAY_NODE_PARAMS, 100);
        this.insertSqlSingleRelation = ApidbWriter.buildSqlInsertStatement(INSERT_SQL_RELATION_COLUMNS, INSERT_SQL_RELATION_PARAMS, 1);
        this.insertSqlBulkRelation = ApidbWriter.buildSqlInsertStatement(INSERT_SQL_RELATION_COLUMNS, INSERT_SQL_RELATION_PARAMS, 100);
        this.insertSqlSingleRelationTag = ApidbWriter.buildSqlInsertStatement(INSERT_SQL_RELATION_TAG_COLUMNS, INSERT_SQL_RELATION_TAG_PARAMS, 1);
        this.insertSqlBulkRelationTag = ApidbWriter.buildSqlInsertStatement(INSERT_SQL_RELATION_TAG_COLUMNS, INSERT_SQL_RELATION_TAG_PARAMS, 100);
    }

    private OsmosisRuntimeException createUnknownDbTypeException() {
        return new OsmosisRuntimeException("Unknown database type " + this.dbCtx.getDatabaseType() + ".");
    }

    private void initialize() {
        if (!this.initialized) {
            this.schemaVersionValidator.validateVersion(ApidbVersionConstants.SCHEMA_MIGRATIONS);
            this.buildSqlStatements();
            switch (this.dbCtx.getDatabaseType()) {
                case POSTGRESQL: {
                    this.insertSqlSingleRelationMember = ApidbWriter.buildSqlInsertStatement(INSERT_SQL_RELATION_MEMBER_COLUMNS, INSERT_SQL_RELATION_MEMBER_PARAMS_PGSQL, 1);
                    this.insertSqlBulkRelationMember = ApidbWriter.buildSqlInsertStatement(INSERT_SQL_RELATION_MEMBER_COLUMNS, INSERT_SQL_RELATION_MEMBER_PARAMS_PGSQL, 100);
                    break;
                }
                case MYSQL: {
                    this.insertSqlSingleRelationMember = ApidbWriter.buildSqlInsertStatement(INSERT_SQL_RELATION_MEMBER_COLUMNS, INSERT_SQL_RELATION_MEMBER_PARAMS_MYSQL, 1);
                    this.insertSqlBulkRelationMember = ApidbWriter.buildSqlInsertStatement(INSERT_SQL_RELATION_MEMBER_COLUMNS, INSERT_SQL_RELATION_MEMBER_PARAMS_MYSQL, 100);
                    break;
                }
                default: {
                    throw this.createUnknownDbTypeException();
                }
            }
            this.bulkNodeStatement = this.dbCtx.prepareStatement(this.insertSqlBulkNode);
            this.singleNodeStatement = this.dbCtx.prepareStatement(this.insertSqlSingleNode);
            this.bulkNodeTagStatement = this.dbCtx.prepareStatement(this.insertSqlBulkNodeTag);
            this.singleNodeTagStatement = this.dbCtx.prepareStatement(this.insertSqlSingleNodeTag);
            this.bulkWayStatement = this.dbCtx.prepareStatement(this.insertSqlBulkWay);
            this.singleWayStatement = this.dbCtx.prepareStatement(this.insertSqlSingleWay);
            this.bulkWayTagStatement = this.dbCtx.prepareStatement(this.insertSqlBulkWayTag);
            this.singleWayTagStatement = this.dbCtx.prepareStatement(this.insertSqlSingleWayTag);
            this.bulkWayNodeStatement = this.dbCtx.prepareStatement(this.insertSqlBulkWayNode);
            this.singleWayNodeStatement = this.dbCtx.prepareStatement(this.insertSqlSingleWayNode);
            this.bulkRelationStatement = this.dbCtx.prepareStatement(this.insertSqlBulkRelation);
            this.singleRelationStatement = this.dbCtx.prepareStatement(this.insertSqlSingleRelation);
            this.bulkRelationTagStatement = this.dbCtx.prepareStatement(this.insertSqlBulkRelationTag);
            this.singleRelationTagStatement = this.dbCtx.prepareStatement(this.insertSqlSingleRelationTag);
            this.bulkRelationMemberStatement = this.dbCtx.prepareStatement(this.insertSqlBulkRelationMember);
            this.singleRelationMemberStatement = this.dbCtx.prepareStatement(this.insertSqlSingleRelationMember);
            this.loadCurrentNodesStatement = this.dbCtx.prepareStatement(LOAD_CURRENT_NODES);
            this.loadCurrentNodeTagsStatement = this.dbCtx.prepareStatement(LOAD_CURRENT_NODE_TAGS);
            this.loadCurrentWaysStatement = this.dbCtx.prepareStatement(LOAD_CURRENT_WAYS);
            this.loadCurrentWayTagsStatement = this.dbCtx.prepareStatement(LOAD_CURRENT_WAY_TAGS);
            this.loadCurrentWayNodesStatement = this.dbCtx.prepareStatement(LOAD_CURRENT_WAY_NODES);
            this.loadCurrentRelationsStatement = this.dbCtx.prepareStatement(LOAD_CURRENT_RELATIONS);
            this.loadCurrentRelationTagsStatement = this.dbCtx.prepareStatement(LOAD_CURRENT_RELATION_TAGS);
            this.loadCurrentRelationMembersStatement = this.dbCtx.prepareStatement(LOAD_CURRENT_RELATION_MEMBERS);
            this.dbCtx.disableIndexes(DISABLE_KEY_TABLES);
            if (this.lockTables) {
                this.dbCtx.lockTables(LOCK_TABLES);
            }
            this.initialized = true;
        }
    }

    private void assertEntityHasTimestamp(Entity entity) {
        if (entity.getTimestamp() == null) {
            throw new OsmosisRuntimeException(entity.getType().toString() + " " + entity.getId() + " does not have a timestamp set.");
        }
    }

    private void populateNodeParameters(PreparedStatement statement, int initialIndex, Node node) {
        int prmIndex = initialIndex;
        this.assertEntityHasTimestamp((Entity)node);
        try {
            statement.setLong(prmIndex++, node.getId());
            statement.setTimestamp(prmIndex++, new Timestamp(node.getTimestamp().getTime()));
            statement.setInt(prmIndex++, node.getVersion());
            statement.setBoolean(prmIndex++, true);
            statement.setLong(prmIndex++, node.getChangesetId());
            statement.setInt(prmIndex++, FixedPrecisionCoordinateConvertor.convertToFixed((double)node.getLatitude()));
            statement.setInt(prmIndex++, FixedPrecisionCoordinateConvertor.convertToFixed((double)node.getLongitude()));
            statement.setLong(prmIndex++, this.tileCalculator.calculateTile(node.getLatitude(), node.getLongitude()));
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to set a prepared statement parameter for a node.", (Throwable)e);
        }
    }

    private static String createParamPlaceholders(int amount) {
        StringBuilder questionMarks = new StringBuilder();
        for (int i = 0; i < amount; ++i) {
            questionMarks.append("?");
            if (i == amount - 1) continue;
            questionMarks.append(", ");
        }
        return questionMarks.toString();
    }

    private void populateWayParameters(PreparedStatement statement, int initialIndex, Way way) {
        int prmIndex = initialIndex;
        this.assertEntityHasTimestamp((Entity)way);
        try {
            statement.setLong(prmIndex++, way.getId());
            statement.setTimestamp(prmIndex++, new Timestamp(way.getTimestamp().getTime()));
            statement.setInt(prmIndex++, way.getVersion());
            statement.setBoolean(prmIndex++, true);
            statement.setLong(prmIndex++, way.getChangesetId());
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to set a prepared statement parameter for a way.", (Throwable)e);
        }
    }

    private void populateEntityTagParameters(PreparedStatement statement, int initialIndex, DbFeatureHistory<DbFeature<Tag>> dbEntityTag) {
        int prmIndex = initialIndex;
        Tag tag = (Tag)((DbFeature)dbEntityTag.getFeature()).getFeature();
        try {
            statement.setLong(prmIndex++, ((DbFeature)dbEntityTag.getFeature()).getEntityId());
            statement.setString(prmIndex++, tag.getKey());
            statement.setString(prmIndex++, tag.getValue());
            statement.setInt(prmIndex++, dbEntityTag.getVersion());
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to set a prepared statement parameter for an entity tag.", (Throwable)e);
        }
    }

    private void populateWayNodeParameters(PreparedStatement statement, int initialIndex, DbFeatureHistory<DbOrderedFeature<WayNode>> dbWayNode) {
        int prmIndex = initialIndex;
        try {
            statement.setLong(prmIndex++, ((DbOrderedFeature)dbWayNode.getFeature()).getEntityId());
            statement.setLong(prmIndex++, ((WayNode)((DbOrderedFeature)dbWayNode.getFeature()).getFeature()).getNodeId());
            statement.setInt(prmIndex++, ((DbOrderedFeature)dbWayNode.getFeature()).getSequenceId());
            statement.setInt(prmIndex++, dbWayNode.getVersion());
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to set a prepared statement parameter for a way node.", (Throwable)e);
        }
    }

    private void populateRelationParameters(PreparedStatement statement, int initialIndex, Relation relation) {
        int prmIndex = initialIndex;
        this.assertEntityHasTimestamp((Entity)relation);
        try {
            statement.setLong(prmIndex++, relation.getId());
            statement.setTimestamp(prmIndex++, new Timestamp(relation.getTimestamp().getTime()));
            statement.setInt(prmIndex++, relation.getVersion());
            statement.setBoolean(prmIndex++, true);
            statement.setLong(prmIndex++, relation.getChangesetId());
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to set a prepared statement parameter for a relation.", (Throwable)e);
        }
    }

    private void populateRelationMemberParameters(PreparedStatement statement, int initialIndex, DbFeatureHistory<DbOrderedFeature<RelationMember>> dbRelationMember) {
        int prmIndex = initialIndex;
        RelationMember relationMember = (RelationMember)((DbOrderedFeature)dbRelationMember.getFeature()).getFeature();
        try {
            statement.setLong(prmIndex++, ((DbOrderedFeature)dbRelationMember.getFeature()).getEntityId());
            statement.setString(prmIndex++, this.memberTypeRenderer.render(relationMember.getMemberType()));
            statement.setLong(prmIndex++, relationMember.getMemberId());
            statement.setInt(prmIndex++, ((DbOrderedFeature)dbRelationMember.getFeature()).getSequenceId());
            statement.setString(prmIndex++, relationMember.getMemberRole());
            statement.setInt(prmIndex++, dbRelationMember.getVersion());
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to set a prepared statement parameter for a relation member.", (Throwable)e);
        }
    }

    private void flushNodes(boolean complete) {
        while (this.nodeBuffer.size() >= 100) {
            ArrayList<Node> processedNodes = new ArrayList<Node>(100);
            int prmIndex = 1;
            for (int i = 0; i < 100; ++i) {
                Node node = this.nodeBuffer.remove(0);
                processedNodes.add(node);
                this.populateNodeParameters(this.bulkNodeStatement, prmIndex, node);
                prmIndex += 8;
                ++this.transactionSizeCount;
            }
            try {
                this.bulkNodeStatement.executeUpdate();
                if (this.transactionSizeCount % 100000L == 0L) {
                    this.dbCtx.commit();
                }
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to bulk insert nodes into the database.", (Throwable)e);
            }
            for (Node node : processedNodes) {
                this.addNodeTags(node);
            }
        }
        if (complete) {
            while (this.nodeBuffer.size() > 0) {
                Node node = this.nodeBuffer.remove(0);
                this.populateNodeParameters(this.singleNodeStatement, 1, node);
                try {
                    this.singleNodeStatement.executeUpdate();
                }
                catch (SQLException e) {
                    throw new OsmosisRuntimeException("Unable to insert a node into the database.", (Throwable)e);
                }
                this.addNodeTags(node);
            }
        }
        this.dbCtx.commit();
    }

    private void flushNodeTags(boolean complete) {
        while (this.nodeTagBuffer.size() >= 100) {
            int prmIndex = 1;
            for (int i = 0; i < 100; ++i) {
                this.populateEntityTagParameters(this.bulkNodeTagStatement, prmIndex, this.nodeTagBuffer.remove(0));
                prmIndex += 4;
                ++this.transactionSizeCount;
            }
            try {
                this.bulkNodeTagStatement.executeUpdate();
                if (this.transactionSizeCount % 100000L != 0L) continue;
                this.dbCtx.commit();
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to bulk insert node tags into the database.", (Throwable)e);
            }
        }
        if (complete) {
            while (this.nodeTagBuffer.size() > 0) {
                this.populateEntityTagParameters(this.singleNodeTagStatement, 1, this.nodeTagBuffer.remove(0));
                try {
                    this.singleNodeTagStatement.executeUpdate();
                }
                catch (SQLException e) {
                    throw new OsmosisRuntimeException("Unable to insert a node tag into the database.", (Throwable)e);
                }
            }
        }
        this.dbCtx.commit();
    }

    private void flushWays(boolean complete) {
        while (this.wayBuffer.size() >= 100) {
            ArrayList<Way> processedWays = new ArrayList<Way>(100);
            int prmIndex = 1;
            for (int i = 0; i < 100; ++i) {
                Way way = this.wayBuffer.remove(0);
                processedWays.add(way);
                this.populateWayParameters(this.bulkWayStatement, prmIndex, way);
                prmIndex += 5;
                ++this.transactionSizeCount;
            }
            try {
                this.bulkWayStatement.executeUpdate();
                if (this.transactionSizeCount % 100000L == 0L) {
                    this.dbCtx.commit();
                }
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to bulk insert ways into the database.", (Throwable)e);
            }
            for (Way way : processedWays) {
                this.addWayTags(way);
                this.addWayNodes(way);
            }
        }
        if (complete) {
            while (this.wayBuffer.size() > 0) {
                Way way = this.wayBuffer.remove(0);
                this.populateWayParameters(this.singleWayStatement, 1, way);
                try {
                    this.singleWayStatement.executeUpdate();
                }
                catch (SQLException e) {
                    throw new OsmosisRuntimeException("Unable to insert a way into the database.", (Throwable)e);
                }
                this.addWayTags(way);
                this.addWayNodes(way);
            }
        }
        this.dbCtx.commit();
    }

    private void flushWayTags(boolean complete) {
        while (this.wayTagBuffer.size() >= 100) {
            int prmIndex = 1;
            for (int i = 0; i < 100; ++i) {
                this.populateEntityTagParameters(this.bulkWayTagStatement, prmIndex, this.wayTagBuffer.remove(0));
                prmIndex += 4;
                ++this.transactionSizeCount;
            }
            try {
                this.bulkWayTagStatement.executeUpdate();
                if (this.transactionSizeCount % 100000L != 0L) continue;
                this.dbCtx.commit();
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to bulk insert way tags into the database.", (Throwable)e);
            }
        }
        if (complete) {
            while (this.wayTagBuffer.size() > 0) {
                this.populateEntityTagParameters(this.singleWayTagStatement, 1, this.wayTagBuffer.remove(0));
                try {
                    this.singleWayTagStatement.executeUpdate();
                }
                catch (SQLException e) {
                    throw new OsmosisRuntimeException("Unable to insert a way tag into the database.", (Throwable)e);
                }
            }
        }
        this.dbCtx.commit();
    }

    private void flushWayNodes(boolean complete) {
        while (this.wayNodeBuffer.size() >= 100) {
            int prmIndex = 1;
            for (int i = 0; i < 100; ++i) {
                this.populateWayNodeParameters(this.bulkWayNodeStatement, prmIndex, this.wayNodeBuffer.remove(0));
                prmIndex += 4;
                ++this.transactionSizeCount;
            }
            try {
                this.bulkWayNodeStatement.executeUpdate();
                if (this.transactionSizeCount % 100000L != 0L) continue;
                this.dbCtx.commit();
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to bulk insert way nodes into the database.", (Throwable)e);
            }
        }
        if (complete) {
            while (this.wayNodeBuffer.size() > 0) {
                this.populateWayNodeParameters(this.singleWayNodeStatement, 1, this.wayNodeBuffer.remove(0));
                try {
                    this.singleWayNodeStatement.executeUpdate();
                }
                catch (SQLException e) {
                    throw new OsmosisRuntimeException("Unable to insert a way node into the database.", (Throwable)e);
                }
            }
        }
        this.dbCtx.commit();
    }

    private void flushRelations(boolean complete) {
        while (this.relationBuffer.size() >= 100) {
            ArrayList<Relation> processedRelations = new ArrayList<Relation>(100);
            int prmIndex = 1;
            for (int i = 0; i < 100; ++i) {
                Relation relation = this.relationBuffer.remove(0);
                processedRelations.add(relation);
                this.populateRelationParameters(this.bulkRelationStatement, prmIndex, relation);
                prmIndex += 5;
                ++this.transactionSizeCount;
            }
            try {
                this.bulkRelationStatement.executeUpdate();
                if (this.transactionSizeCount % 100000L == 0L) {
                    this.dbCtx.commit();
                }
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to bulk insert relations into the database.", (Throwable)e);
            }
            for (Relation relation : processedRelations) {
                this.addRelationTags(relation);
                this.addRelationMembers(relation);
            }
        }
        if (complete) {
            while (this.relationBuffer.size() > 0) {
                Relation relation = this.relationBuffer.remove(0);
                this.populateRelationParameters(this.singleRelationStatement, 1, relation);
                try {
                    this.singleRelationStatement.executeUpdate();
                }
                catch (SQLException e) {
                    throw new OsmosisRuntimeException("Unable to insert a relation into the database.", (Throwable)e);
                }
                this.addRelationTags(relation);
                this.addRelationMembers(relation);
            }
        }
        this.dbCtx.commit();
    }

    private void flushRelationTags(boolean complete) {
        while (this.relationTagBuffer.size() >= 100) {
            int prmIndex = 1;
            for (int i = 0; i < 100; ++i) {
                this.populateEntityTagParameters(this.bulkRelationTagStatement, prmIndex, this.relationTagBuffer.remove(0));
                prmIndex += 4;
                ++this.transactionSizeCount;
            }
            try {
                this.bulkRelationTagStatement.executeUpdate();
                if (this.transactionSizeCount % 100000L != 0L) continue;
                this.dbCtx.commit();
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to bulk insert relation tags into the database.", (Throwable)e);
            }
        }
        if (complete) {
            while (this.relationTagBuffer.size() > 0) {
                this.populateEntityTagParameters(this.singleRelationTagStatement, 1, this.relationTagBuffer.remove(0));
                try {
                    this.singleRelationTagStatement.executeUpdate();
                }
                catch (SQLException e) {
                    throw new OsmosisRuntimeException("Unable to insert a relation tag into the database.", (Throwable)e);
                }
            }
        }
        this.dbCtx.commit();
    }

    private void flushRelationMembers(boolean complete) {
        while (this.relationMemberBuffer.size() >= 100) {
            int prmIndex = 1;
            for (int i = 0; i < 100; ++i) {
                this.populateRelationMemberParameters(this.bulkRelationMemberStatement, prmIndex, this.relationMemberBuffer.remove(0));
                prmIndex += 6;
                ++this.transactionSizeCount;
            }
            try {
                this.bulkRelationMemberStatement.executeUpdate();
                if (this.transactionSizeCount % 100000L != 0L) continue;
                this.dbCtx.commit();
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to bulk insert relation members into the database.", (Throwable)e);
            }
        }
        if (complete) {
            while (this.relationMemberBuffer.size() > 0) {
                this.populateRelationMemberParameters(this.singleRelationMemberStatement, 1, this.relationMemberBuffer.remove(0));
                try {
                    this.singleRelationMemberStatement.executeUpdate();
                }
                catch (SQLException e) {
                    throw new OsmosisRuntimeException("Unable to insert a relation member into the database.", (Throwable)e);
                }
            }
        }
        this.dbCtx.commit();
    }

    private void populateCurrentNodes() {
        for (long i = this.minNodeId; i < this.maxNodeId; i += 1000000L) {
            try {
                this.loadCurrentNodesStatement.setLong(1, i);
                this.loadCurrentNodesStatement.setLong(2, i + 1000000L);
                this.loadCurrentNodesStatement.execute();
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to load current nodes.", (Throwable)e);
            }
            try {
                this.loadCurrentNodeTagsStatement.setLong(1, i);
                this.loadCurrentNodeTagsStatement.setLong(2, i + 1000000L);
                this.loadCurrentNodeTagsStatement.execute();
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to load current node tags.", (Throwable)e);
            }
            this.dbCtx.commit();
        }
    }

    private void populateCurrentWays() {
        for (long i = this.minWayId; i < this.maxWayId; i += 100000L) {
            try {
                this.loadCurrentWaysStatement.setLong(1, i);
                this.loadCurrentWaysStatement.setLong(2, i + 100000L);
                this.loadCurrentWaysStatement.execute();
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to load current ways.", (Throwable)e);
            }
            try {
                this.loadCurrentWayTagsStatement.setLong(1, i);
                this.loadCurrentWayTagsStatement.setLong(2, i + 100000L);
                this.loadCurrentWayTagsStatement.execute();
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to load current way tags.", (Throwable)e);
            }
            try {
                this.loadCurrentWayNodesStatement.setLong(1, i);
                this.loadCurrentWayNodesStatement.setLong(2, i + 100000L);
                this.loadCurrentWayNodesStatement.execute();
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to load current way nodes.", (Throwable)e);
            }
            this.dbCtx.commit();
        }
    }

    private void populateCurrentRelations() {
        for (long i = this.minRelationId; i < this.maxRelationId; i += 100000L) {
            try {
                this.loadCurrentRelationsStatement.setLong(1, i);
                this.loadCurrentRelationsStatement.setLong(2, i + 100000L);
                this.loadCurrentRelationsStatement.execute();
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to load current relations.", (Throwable)e);
            }
            try {
                this.loadCurrentRelationTagsStatement.setLong(1, i);
                this.loadCurrentRelationTagsStatement.setLong(2, i + 100000L);
                this.loadCurrentRelationTagsStatement.execute();
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to load current relation tags.", (Throwable)e);
            }
            try {
                this.loadCurrentRelationMembersStatement.setLong(1, i);
                this.loadCurrentRelationMembersStatement.setLong(2, i + 100000L);
                this.loadCurrentRelationMembersStatement.execute();
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to load current relation members.", (Throwable)e);
            }
            this.dbCtx.commit();
        }
    }

    private void populateCurrentTables() {
        if (this.populateCurrentTables) {
            this.populateCurrentNodes();
            this.populateCurrentWays();
            this.populateCurrentRelations();
        }
    }

    public void initialize(Map<String, Object> metaData) {
    }

    public void complete() {
        this.initialize();
        this.flushNodes(true);
        this.flushNodeTags(true);
        this.flushWays(true);
        this.flushWayTags(true);
        this.flushWayNodes(true);
        this.flushRelations(true);
        this.flushRelationTags(true);
        this.flushRelationMembers(true);
        this.dbCtx.enableIndexes(DISABLE_KEY_TABLES);
        this.populateCurrentTables();
        if (this.lockTables) {
            this.dbCtx.unlockTables(LOCK_TABLES);
        }
        this.dbCtx.commit();
    }

    public void close() {
        this.userManager.close();
        this.dbCtx.close();
    }

    public void process(EntityContainer entityContainer) {
        this.initialize();
        Entity entity = entityContainer.getEntity();
        this.userManager.addOrUpdateUser(entityContainer.getEntity().getUser());
        this.changesetManager.addChangesetIfRequired(entity.getChangesetId(), entity.getUser());
        entityContainer.process((EntityProcessor)this);
    }

    public void process(BoundContainer boundContainer) {
    }

    public void process(NodeContainer nodeContainer) {
        Node node = nodeContainer.getEntity();
        long nodeId = node.getId();
        if (nodeId >= this.maxNodeId) {
            this.maxNodeId = nodeId + 1L;
        }
        if (nodeId < this.minNodeId) {
            this.minNodeId = nodeId;
        }
        this.nodeBuffer.add(node);
        this.flushNodes(false);
    }

    private void addNodeTags(Node node) {
        for (Tag tag : node.getTags()) {
            this.nodeTagBuffer.add((DbFeatureHistory<DbFeature<Tag>>)new DbFeatureHistory((Storeable)new DbFeature(node.getId(), (Storeable)tag), node.getVersion()));
        }
        this.flushNodeTags(false);
    }

    public void process(WayContainer wayContainer) {
        this.flushNodes(true);
        Way way = wayContainer.getEntity();
        long wayId = way.getId();
        if (wayId >= this.maxWayId) {
            this.maxWayId = wayId + 1L;
        }
        if (wayId < this.minWayId) {
            this.minWayId = wayId;
        }
        this.wayBuffer.add(way);
        this.flushWays(false);
    }

    private void addWayTags(Way way) {
        for (Tag tag : way.getTags()) {
            this.wayTagBuffer.add((DbFeatureHistory<DbFeature<Tag>>)new DbFeatureHistory((Storeable)new DbFeature(way.getId(), (Storeable)tag), way.getVersion()));
        }
        this.flushWayTags(false);
    }

    private void addWayNodes(Way way) {
        List nodeReferenceList = way.getWayNodes();
        for (int i = 0; i < nodeReferenceList.size(); ++i) {
            this.wayNodeBuffer.add((DbFeatureHistory<DbOrderedFeature<WayNode>>)new DbFeatureHistory((Storeable)new DbOrderedFeature(way.getId(), (Storeable)((WayNode)nodeReferenceList.get(i)), i + 1), way.getVersion()));
        }
        this.flushWayNodes(false);
    }

    public void process(RelationContainer relationContainer) {
        this.flushWays(true);
        Relation relation = relationContainer.getEntity();
        long relationId = relation.getId();
        if (relationId >= this.maxRelationId) {
            this.maxRelationId = relationId + 1L;
        }
        if (relationId < this.minRelationId) {
            this.minRelationId = relationId;
        }
        this.relationBuffer.add(relation);
        this.flushRelations(false);
    }

    private void addRelationTags(Relation relation) {
        for (Tag tag : relation.getTags()) {
            this.relationTagBuffer.add((DbFeatureHistory<DbFeature<Tag>>)new DbFeatureHistory((Storeable)new DbFeature(relation.getId(), (Storeable)tag), relation.getVersion()));
        }
        this.flushRelationTags(false);
    }

    private void addRelationMembers(Relation relation) {
        List memberReferenceList = relation.getMembers();
        for (int i = 0; i < memberReferenceList.size(); ++i) {
            this.relationMemberBuffer.add((DbFeatureHistory<DbOrderedFeature<RelationMember>>)new DbFeatureHistory((Storeable)new DbOrderedFeature(relation.getId(), (Storeable)((RelationMember)memberReferenceList.get(i)), i + 1), relation.getVersion()));
        }
        this.flushRelationMembers(false);
    }
}

