# Generated by Django 3.2 on 2021-04-15 17:00

import ckeditor.fields
import datetime
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import filer.fields.image
import imagekit.models.fields
import mptt.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.FILER_IMAGE_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Award',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('order', models.IntegerField(default=0)),
                ('name', models.CharField(max_length=200)),
                ('url', models.URLField(blank=True)),
            ],
            options={
                'verbose_name_plural': 'Awards',
            },
        ),
        migrations.CreateModel(
            name='Contact',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('name', models.CharField(max_length=200)),
                ('email', models.EmailField(max_length=254)),
                ('subject', models.CharField(blank=True, max_length=200, null=True)),
                ('telephone', models.CharField(blank=True, max_length=200, null=True)),
                ('comments', models.TextField()),
                ('referral', models.TextField(blank=True, default='example.com', null=True)),
                ('ipaddress', models.CharField(blank=True, max_length=20, null=True)),
                ('user_agent', models.CharField(blank=True, max_length=200, null=True)),
            ],
            options={
                'verbose_name': 'Contact',
                'verbose_name_plural': 'Contacts',
            },
        ),
        migrations.CreateModel(
            name='Content',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('order', models.IntegerField(default=0)),
                ('title', models.CharField(default='', max_length=200)),
                ('small_title', models.CharField(blank=True, default='', max_length=200, null=True)),
                ('description', ckeditor.fields.RichTextField(blank=True, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='GoogleJs',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('tag_manager', models.CharField(default='', max_length=20)),
            ],
            options={
                'verbose_name_plural': 'Google Tags',
            },
        ),
        migrations.CreateModel(
            name='Image',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200)),
                ('order', models.IntegerField()),
                ('uploaded_at', models.DateTimeField(auto_now_add=True)),
                ('content', models.ManyToManyField(blank=True, to='rapidbounce_cms.Content')),
                ('image', filer.fields.image.FilerImageField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.FILER_IMAGE_MODEL)),
            ],
            options={
                'ordering': ['order'],
            },
        ),
        migrations.CreateModel(
            name='Language',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('order', models.IntegerField(default=0)),
                ('name', models.CharField(max_length=200)),
                ('lang_code', models.CharField(max_length=2)),
                ('display_lang', models.CharField(max_length=2)),
                ('is_default', models.BooleanField(default=False)),
                ('active', models.BooleanField(db_index=True, default=False)),
            ],
            options={
                'ordering': ['order'],
            },
        ),
        migrations.CreateModel(
            name='Offers',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('name', models.CharField(max_length=200)),
                ('image', imagekit.models.fields.ProcessedImageField(upload_to='photos/special_offers/')),
                ('offer_start', models.DateTimeField()),
                ('offer_end', models.DateTimeField()),
                ('url', models.CharField(max_length=200)),
                ('active', models.BooleanField(db_index=True, default=True)),
            ],
            options={
                'verbose_name': 'Special Offer',
                'verbose_name_plural': 'Special Offers',
            },
        ),
        migrations.CreateModel(
            name='Page',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('order', models.IntegerField(default=0)),
                ('name', models.CharField(db_index=True, max_length=200)),
                ('menu', models.CharField(default='', max_length=200)),
                ('extra_menu', models.CharField(blank=True, default='', max_length=200, null=True)),
                ('friendlyurl', models.SlugField(blank=True, default='', max_length=300, null=True)),
                ('external_url', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('page_class', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('show', models.BooleanField(db_index=True, default=True)),
                ('lft', models.PositiveIntegerField(editable=False)),
                ('rght', models.PositiveIntegerField(editable=False)),
                ('tree_id', models.PositiveIntegerField(db_index=True, editable=False)),
                ('level', models.PositiveIntegerField(editable=False)),
                ('parent', mptt.fields.TreeForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='children', to='rapidbounce_cms.page')),
            ],
            options={
                'ordering': ['tree_id', 'level', 'order'],
            },
        ),
        migrations.CreateModel(
            name='Review',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('name', models.CharField(default='Anonymous', max_length=200)),
                ('email', models.EmailField(blank=True, max_length=254)),
                ('location', models.CharField(blank=True, max_length=200)),
                ('title', models.CharField(max_length=200)),
                ('review', models.TextField()),
                ('publish', models.BooleanField(default=False)),
                ('source', models.CharField(default='example.com', max_length=200)),
                ('date', models.DateField(default=datetime.date.today)),
                ('visited', models.DateField(blank=True, null=True)),
                ('stars', models.IntegerField(default=5)),
                ('order', models.IntegerField(blank=True, default=0, null=True)),
                ('referral', models.TextField(blank=True, null=True)),
                ('ipaddress', models.CharField(blank=True, max_length=20, null=True)),
                ('user_agent', models.CharField(blank=True, max_length=200, null=True)),
                ('copy_email', models.BooleanField(default=False)),
            ],
            options={
                'verbose_name': 'Review',
                'verbose_name_plural': 'Reviews',
            },
        ),
        migrations.CreateModel(
            name='Subscribe',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('email', models.EmailField(error_messages={'unique': 'This email has already been registered.'}, max_length=254, unique=True)),
                ('referral', models.TextField(blank=True, default='example.com', null=True)),
                ('ipaddress', models.CharField(blank=True, max_length=20, null=True)),
                ('user_agent', models.CharField(blank=True, max_length=200, null=True)),
            ],
            options={
                'verbose_name_plural': 'Subscriptions',
            },
        ),
        migrations.CreateModel(
            name='SocialTags',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('title', models.CharField(default='', max_length=95)),
                ('description', models.TextField(default='')),
                ('image', filer.fields.image.FilerImageField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.FILER_IMAGE_MODEL)),
                ('page', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='rapidbounce_cms.page')),
            ],
            options={
                'verbose_name': 'Social Tag',
                'verbose_name_plural': 'Social Tags',
            },
        ),
        migrations.CreateModel(
            name='Social',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('order', models.IntegerField(default=0)),
                ('name', models.CharField(max_length=200)),
                ('icon', models.CharField(max_length=200)),
                ('url', models.CharField(max_length=255)),
                ('active', models.BooleanField(db_index=True, default=True)),
                ('image', filer.fields.image.FilerImageField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.FILER_IMAGE_MODEL)),
            ],
            options={
                'verbose_name': 'Social',
                'verbose_name_plural': 'Socials',
                'ordering': ['order'],
            },
        ),
        migrations.CreateModel(
            name='Seo',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('title', models.CharField(default='', max_length=200)),
                ('description', models.TextField(default='')),
                ('page', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='rapidbounce_cms.page')),
            ],
            options={
                'verbose_name_plural': 'SEO',
            },
        ),
        migrations.CreateModel(
            name='ImageDetails',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('title', models.CharField(default='', max_length=200)),
                ('alt', models.CharField(default='', max_length=200)),
                ('caption_big', models.CharField(blank=True, default='', max_length=200, null=True)),
                ('caption_small', models.CharField(blank=True, default='', max_length=200, null=True)),
                ('image', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='rapidbounce_cms.image')),
            ],
            options={
                'verbose_name_plural': 'Images Meta Data',
            },
        ),
        migrations.AddField(
            model_name='content',
            name='page',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='rapidbounce_cms.page'),
        ),
        migrations.CreateModel(
            name='CompanyDetails',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('bkeng_url', models.CharField(blank=True, max_length=200, null=True)),
                ('echeckin_url', models.CharField(blank=True, max_length=200, null=True)),
                ('telephone_code', models.CharField(blank=True, max_length=200, null=True)),
                ('telephone1', models.CharField(blank=True, max_length=200, null=True)),
                ('telephone2', models.CharField(blank=True, max_length=200, null=True)),
                ('telephone3', models.CharField(blank=True, max_length=200, null=True)),
                ('telephone4', models.CharField(blank=True, max_length=200, null=True)),
                ('telephone5', models.CharField(blank=True, max_length=200, null=True)),
                ('mobile', models.CharField(blank=True, max_length=200, null=True)),
                ('fax', models.CharField(blank=True, max_length=200, null=True)),
                ('email', models.CharField(blank=True, max_length=200, null=True)),
                ('email2', models.CharField(blank=True, max_length=200, null=True)),
                ('address', models.CharField(default='', max_length=200)),
                ('location', models.CharField(default='', max_length=200)),
                ('country', models.CharField(blank=True, default='', max_length=200, null=True)),
                ('gmaps_latitude', models.CharField(blank=True, max_length=200, null=True)),
                ('gmaps_longitude', models.CharField(blank=True, max_length=200, null=True)),
                ('gps_latitude', models.CharField(blank=True, max_length=200, null=True)),
                ('gps_longitude', models.CharField(blank=True, max_length=200, null=True)),
                ('tbrn', models.CharField(blank=True, max_length=200, null=True)),
                ('logo_main', filer.fields.image.FilerImageField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.FILER_IMAGE_MODEL)),
                ('logo_secondary', filer.fields.image.FilerImageField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='logo_secondary', to=settings.FILER_IMAGE_MODEL)),
            ],
            options={
                'verbose_name_plural': 'Company Details',
            },
        ),
        migrations.CreateModel(
            name='AwardImage',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('order', models.IntegerField(default=0)),
                ('award', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='images', to='rapidbounce_cms.award')),
                ('image', filer.fields.image.FilerImageField(on_delete=django.db.models.deletion.CASCADE, to=settings.FILER_IMAGE_MODEL)),
            ],
            options={
                'verbose_name_plural': 'Award Images',
            },
        ),
    ]
