import os
import shutil


async def get_osarch(hub):
    # Build the osarch grain. This grain will be used for platform-specific
    # considerations such as package management. Fall back to the CPU architecture.
    if shutil.which("uname"):
        ret = await hub.exec.cmd.run(["uname", "-m"])
        hub.corn.CORN.osarch = ret["stdout"].strip()
    elif shutil.which("rpm") and os.environ.get("_host_cpu"):
        ret = await hub.exec.cmd.run(
            ["rpm", "--eval", os.environ["_host_cpu"]], shell=True
        )
        hub.corn.CORN.osarch = ret["stdout"].strip() or "unknown"
    elif shutil.which("opkg"):
        archinfo = {}
        for line in (
            (await hub.exec.cmd.run(["opkg", "print-architecture"]))["stdout"]
        ).splitlines():
            if line.startswith("arch"):
                _, arch, priority = line.split()
                archinfo[arch.strip()] = int(priority.strip())
        # Return osarch in priority order (higher to lower)
        hub.corn.CORN.osarch = sorted(archinfo, key=archinfo.get, reverse=True)[0]
    elif shutil.which("dpkg"):
        hub.corn.CORN.osarch = (await hub.exec.cmd.run("dpkg --print-architecture"))[
            "stdout"
        ].strip()
    else:
        # WOW64 processes mask the native architecture
        if "PROCESSOR_ARCHITEW6432" in os.environ:
            hub.corn.CORN.osarch = os.environ.get("PROCESSOR_ARCHITEW6432", "")
        else:
            hub.corn.CORN.osarch = os.environ.get("PROCESSOR_ARCHITECTURE", "")
