# mypy-boto3-sso-admin<a id="mypy-boto3-sso-admin"></a>

[![PyPI - mypy-boto3-sso-admin](https://img.shields.io/pypi/v/mypy-boto3-sso-admin.svg?color=blue)](https://pypi.org/project/mypy-boto3-sso-admin)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-sso-admin.svg?color=blue)](https://pypi.org/project/mypy-boto3-sso-admin)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-sso-admin?color=blue)](https://pypistats.org/packages/mypy-boto3-sso-admin)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.SSOAdmin 1.17.82](https://boto3.amazonaws.com/v1/documentation/api/1.17.82/reference/services/sso-admin.html#SSOAdmin)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.14.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-sso-admin docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_sso_admin/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-sso-admin](#mypy-boto3-sso-admin)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

## How to install<a id="how-to-install"></a>

Install `boto3-stubs` for `SSOAdmin` service.

```bash
python -m pip install boto3-stubs[sso-admin]
```

## Usage<a id="usage"></a>

### VSCode<a id="vscode"></a>

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[sso-admin]` in your environment:
  `python -m pip install 'boto3-stubs[sso-admin]'`

Both type checking and auto-complete should work for `SSOAdmin` service. No
explicit type annotations required, write your `boto3` code as usual.

### PyCharm<a id="pycharm"></a>

- Install `boto-stubs[sso-admin]` in your environment:
  `python -m pip install 'boto3-stubs[sso-admin]'`

Both type checking and auto-complete should work for `SSOAdmin` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

### Other IDEs<a id="other-ides"></a>

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

### mypy<a id="mypy"></a>

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[sso-admin]` in your environment:
  `python -m pip install 'boto3-stubs[sso-admin]'`
- Run `mypy` as usual

Type checking should work for `SSOAdmin` service. No explicit type annotations
required, write your `boto3` code as usual.

### pyright<a id="pyright"></a>

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[sso-admin]` in your environment:
  `python -m pip install 'boto3-stubs[sso-admin]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `SSOAdmin` service. No explicit type annotations
required, write your `boto3` code as usual.

## Explicit type annotations<a id="explicit-type-annotations"></a>

### Client annotations<a id="client-annotations"></a>

`SSOAdminClient` provides annotations for `boto3.client("sso-admin")`.

```python
import boto3

from mypy_boto3_sso_admin import SSOAdminClient

client: SSOAdminClient = boto3.client("sso-admin")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: SSOAdminClient = session.client("sso-admin")
```

### Paginators annotations<a id="paginators-annotations"></a>

`mypy_boto3_sso_admin.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_sso_admin import SSOAdminClient
from mypy_boto3_sso_admin.paginator import (
    ListAccountAssignmentCreationStatusPaginator,
    ListAccountAssignmentDeletionStatusPaginator,
    ListAccountAssignmentsPaginator,
    ListAccountsForProvisionedPermissionSetPaginator,
    ListInstancesPaginator,
    ListManagedPoliciesInPermissionSetPaginator,
    ListPermissionSetProvisioningStatusPaginator,
    ListPermissionSetsPaginator,
    ListPermissionSetsProvisionedToAccountPaginator,
    ListTagsForResourcePaginator,
)

client: SSOAdminClient = boto3.client("sso-admin")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_account_assignment_creation_status_paginator: ListAccountAssignmentCreationStatusPaginator = client.get_paginator("list_account_assignment_creation_status")
list_account_assignment_deletion_status_paginator: ListAccountAssignmentDeletionStatusPaginator = client.get_paginator("list_account_assignment_deletion_status")
list_account_assignments_paginator: ListAccountAssignmentsPaginator = client.get_paginator("list_account_assignments")
list_accounts_for_provisioned_permission_set_paginator: ListAccountsForProvisionedPermissionSetPaginator = client.get_paginator("list_accounts_for_provisioned_permission_set")
list_instances_paginator: ListInstancesPaginator = client.get_paginator("list_instances")
list_managed_policies_in_permission_set_paginator: ListManagedPoliciesInPermissionSetPaginator = client.get_paginator("list_managed_policies_in_permission_set")
list_permission_set_provisioning_status_paginator: ListPermissionSetProvisioningStatusPaginator = client.get_paginator("list_permission_set_provisioning_status")
list_permission_sets_paginator: ListPermissionSetsPaginator = client.get_paginator("list_permission_sets")
list_permission_sets_provisioned_to_account_paginator: ListPermissionSetsProvisionedToAccountPaginator = client.get_paginator("list_permission_sets_provisioned_to_account")
list_tags_for_resource_paginator: ListTagsForResourcePaginator = client.get_paginator("list_tags_for_resource")
```

### Literals<a id="literals"></a>

`mypy_boto3_sso_admin.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_sso_admin.literals import (
    InstanceAccessControlAttributeConfigurationStatusType,
    ListAccountAssignmentCreationStatusPaginatorName,
    ListAccountAssignmentDeletionStatusPaginatorName,
    ListAccountAssignmentsPaginatorName,
    ListAccountsForProvisionedPermissionSetPaginatorName,
    ListInstancesPaginatorName,
    ListManagedPoliciesInPermissionSetPaginatorName,
    ListPermissionSetProvisioningStatusPaginatorName,
    ListPermissionSetsPaginatorName,
    ListPermissionSetsProvisionedToAccountPaginatorName,
    ListTagsForResourcePaginatorName,
    PrincipalTypeType,
    ProvisionTargetTypeType,
    ProvisioningStatusType,
    StatusValuesType,
    TargetTypeType,
)

def check_value(value: InstanceAccessControlAttributeConfigurationStatusType) -> bool:
    ...
```

### Typed dictionaries<a id="typed-dictionaries"></a>

`mypy_boto3_sso_admin.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_sso_admin.type_defs import (
    AccessControlAttributeTypeDef,
    AccessControlAttributeValueTypeDef,
    AccountAssignmentOperationStatusMetadataTypeDef,
    AccountAssignmentOperationStatusTypeDef,
    AccountAssignmentTypeDef,
    AttachedManagedPolicyTypeDef,
    CreateAccountAssignmentResponseTypeDef,
    CreatePermissionSetResponseTypeDef,
    DeleteAccountAssignmentResponseTypeDef,
    DescribeAccountAssignmentCreationStatusResponseTypeDef,
    DescribeAccountAssignmentDeletionStatusResponseTypeDef,
    DescribeInstanceAccessControlAttributeConfigurationResponseTypeDef,
    DescribePermissionSetProvisioningStatusResponseTypeDef,
    DescribePermissionSetResponseTypeDef,
    GetInlinePolicyForPermissionSetResponseTypeDef,
    InstanceAccessControlAttributeConfigurationTypeDef,
    InstanceMetadataTypeDef,
    ListAccountAssignmentCreationStatusResponseTypeDef,
    ListAccountAssignmentDeletionStatusResponseTypeDef,
    ListAccountAssignmentsResponseTypeDef,
    ListAccountsForProvisionedPermissionSetResponseTypeDef,
    ListInstancesResponseTypeDef,
    ListManagedPoliciesInPermissionSetResponseTypeDef,
    ListPermissionSetProvisioningStatusResponseTypeDef,
    ListPermissionSetsProvisionedToAccountResponseTypeDef,
    ListPermissionSetsResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    OperationStatusFilterTypeDef,
    PaginatorConfigTypeDef,
    PermissionSetProvisioningStatusMetadataTypeDef,
    PermissionSetProvisioningStatusTypeDef,
    PermissionSetTypeDef,
    ProvisionPermissionSetResponseTypeDef,
    TagTypeDef,
)

def get_structure() -> AccessControlAttributeTypeDef:
    return {
      ...
    }
```

## Versioning<a id="versioning"></a>

`mypy-boto3-sso-admin` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

## Documentation<a id="documentation"></a>

All type annotations can be found in
[mypy-boto3-sso-admin docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_sso_admin/)

## Support and contributing<a id="support-and-contributing"></a>

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
