"""Tests for mail utilities."""
from util_rpa.mail.models import EmailMessage
from util_rpa.mail.smtp import SMTPClient


def test_smtp_init_env(monkeypatch):
    """Test SMTPClient initialization with environment variables."""
    monkeypatch.setenv("SMTP_HOST", "127.0.0.1")
    monkeypatch.setenv("SMTP_PORT", "25")

    client = SMTPClient()
    assert client.host == "127.0.0.1"
    assert client.port == 25


def test_email_message():
    """Test EmailMessage creation."""
    msg = EmailMessage(
        sender="a@a.com",
        to=["b@b.com"],
        subject="test",
        body_html="<b>x</b>"
    )
    assert msg.sender == "a@a.com"
    assert msg.to[0] == "b@b.com"
