"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SourceActionBuilder = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codecommit = require("@aws-cdk/aws-codecommit");
const codepipeline = require("@aws-cdk/aws-codepipeline");
const codepipeline_actions = require("@aws-cdk/aws-codepipeline-actions");
const s3 = require("@aws-cdk/aws-s3");
const cdk = require("@aws-cdk/core");
const source_action_1 = require("./source_action");
/**
 * @stability stable
 */
class SourceActionBuilder {
    /**
     * @stability stable
     */
    constructor(scope, sources, idPrefix) {
        this.sources = sources;
        this.idPrefix = idPrefix;
        this.scope = scope;
    }
    /**
     * @stability stable
     */
    createPipelineSources() {
        if (this.sources) {
            return this.sources.map((s) => createSource(this.scope, s, this.idPrefix));
        }
        return [];
    }
}
exports.SourceActionBuilder = SourceActionBuilder;
_a = JSII_RTTI_SYMBOL_1;
SourceActionBuilder[_a] = { fqn: "halloumi-ami-pipelines.SourceActionBuilder", version: "0.0.18" };
function createSource(scope, source, idPrefix) {
    let action = null;
    let sourceOutput = new codepipeline.Artifact();
    switch (source.type) {
        case 's3':
            action = new codepipeline_actions.S3SourceAction({
                actionName: source.name,
                bucket: s3.Bucket.fromBucketName(scope, `${idPrefix}${source.name}`, source.bucket),
                bucketKey: source.object,
                output: sourceOutput,
            });
            break;
        case 'codecommit':
            action = new codepipeline_actions.CodeCommitSourceAction({
                actionName: source.name,
                repository: codecommit.Repository.fromRepositoryName(scope, `${idPrefix}${source.name}`, source.repo_name),
                branch: source.branch,
                output: sourceOutput,
            });
            break;
        case 'github':
            action = new codepipeline_actions.GitHubSourceAction({
                actionName: source.name,
                output: sourceOutput,
                owner: source.owner,
                repo: source.repo_name,
                oauthToken: cdk.SecretValue.plainText(source.github_token),
                trigger: codepipeline_actions.GitHubTrigger.WEBHOOK,
            });
            break;
        default:
            action = new codepipeline_actions.S3SourceAction({
                actionName: source.name,
                bucket: s3.Bucket.fromBucketName(scope, `${idPrefix}${source.name}`, source.bucket),
                bucketKey: source.object,
                output: sourceOutput,
            });
    }
    return new source_action_1.SourceAction(sourceOutput, action);
}
//# sourceMappingURL=data:application/json;base64,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