import * as codepipeline from '@aws-cdk/aws-codepipeline';
import * as ec2 from '@aws-cdk/aws-ec2';
import * as imagebuilder from '@aws-cdk/aws-imagebuilder';
import * as sns from '@aws-cdk/aws-sns';
import * as cdk from '@aws-cdk/core';
import { ComponentBuilder } from './component_builder';
import { SlackConfiguration } from './slack_notification';
import { SourceActionBuilder } from './source_action_builder';
/**
 * Construct for creating a Codepipeline, EC2 Image builder pipeline from 1 pipeline configuration.
 *
 * @stability stable
 */
export declare class AmiPipelineLib extends cdk.Construct {
    /**
     * @stability stable
     */
    pipelineConfig: any;
    /**
     * @stability stable
     */
    componentDepsConfig: any[];
    /**
     * @stability stable
     */
    id: string;
    /**
     * @stability stable
     */
    sourceActionBuilder: SourceActionBuilder;
    /**
     * @stability stable
     */
    componentBuilder: ComponentBuilder;
    /**
     * @stability stable
     */
    imagePipeline: imagebuilder.CfnImagePipeline | undefined;
    /**
     * @stability stable
     */
    topic: sns.Topic | undefined;
    /**
     * @stability stable
     */
    codepipeline: codepipeline.Pipeline | undefined;
    /**
     * @stability stable
     */
    slackConfig: SlackConfiguration;
    /**
     * @stability stable
     */
    recipe: imagebuilder.CfnImageRecipe | undefined;
    /**
     * @stability stable
     */
    infrastructure: imagebuilder.CfnInfrastructureConfiguration | undefined;
    /**
     * @stability stable
     */
    distributionConfig: imagebuilder.CfnDistributionConfiguration | undefined;
    /**
     * @stability stable
     */
    diskSize: number | undefined;
    /**
     * Constructor.
     *
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, pipelineConfig: any, componentDepsConfig: any[], slackConfig: SlackConfiguration);
    /**
     * @stability stable
     */
    createScheduledTask(): void;
    /**
     * @stability stable
     */
    createImagebuilderPipeline(): void;
    private getInlinePolicies;
    private createBlockDeviceMapping;
    /**
     * @stability stable
     */
    getNextRecipeVersion(recipeName: string): string;
    /**
     * @stability stable
     */
    createCodepipelineProject(): void;
    /**
     * @stability stable
     */
    getLookupCriteria(parentImage: any): ec2.LookupMachineImageProps;
}
