# `detect_order_edges` -- COMPLETED 

The purpose of the [`detect_order_edges`](../_api/soxspipe.commonutils.detect_order_edges.html) utility is to detect the edges of each order on the detector.

The utility takes as input a fully illuminated slit image, that is, a calibrated flat-field frame or a stacked flat-field frame (preferable as cosmic ray hits will be removed from the stack frame). The second input is the order table generated by the [`soxs_order_centres`](../recipes/soxs_order_centres.md) recipe which provides an estimation of a. the order locations, and b. the order shapes.

For each order an array of central pixel positions is generated. At each pixel position a N-pixel long, M-pixel wide image slice in the cross-dispersion direction (N and M are recipe parameters) is cut from the flat-frame. The slice is collapsed to a 1D array by taking the median value across its width (ignoring masked pixels). Further median smoothing is applied along the length of the slice to compensate of any rogue pixel values. Below you can see an example of a slice with the grey dot representing the collapsed 1D slice pixel values and the red crosses showing the median smoothed values. 

[![](https://live.staticflickr.com/65535/50372050666_b7a6470afb_z.png)](https://live.staticflickr.com/65535/50372050666_b7a6470afb_o.png)

From the central 1D slice in each order the minimum and maximum fluxes are calculated to give a flux range. The absolute minimum and maximum flux thresholds are determined from the percentage thresholds given as recipe parameters. If the minimum threshold was set at 25% then the absolute flux would be:

$$
threshold = minvalue + (maxvalue - minvalue) * 0.25
$$

For each slice along each order the pixel-locations xmin and xmax along the order edge where the flux reaches this minimum flux threshold are detected and recorded (see red circles in the figure above). If the minimum flux is not recorded at any point along the order edge, the threshold is slowly incremented up to a maximum flux until the threshold is registered. Slices where both edges are not detected before the maximum flux threshold is reached are rejected.

Finally for each order the arrays of xmin and xmax pixel-positions are iteratively fitted with low order polynomials of Y as a function of X. The new [order table](../files/order_table.md) is written to file and now includes the upper and lower-edge locations alongside the central location for each order.

[![{@width=900px}](https://live.staticflickr.com/65535/50393406747_750a1f2c31_k.png)](https://live.staticflickr.com/65535/50393406747_750a1f2c31_o.png)

