## `detect_continuum`

The purpose of the [`detect_continuum`](../_api/soxspipe.commonutils.detect_continuum.html) utility is to find and fit the order centres with low-level polynomials.

![](detect_continuum.png)

The utility takes as input a calibrated single pinhole flat-frame which displays the traces of the order centre locations:

[![](https://live.staticflickr.com/65535/50318769388_03e2329c2f_z.png)](https://live.staticflickr.com/65535/50318769388_03e2329c2f_o.png)

From a [spectral format table](../files/spectral_format_table.md) (specific to the arm in question) we know the minimum and maximum wavelength values for each order. Then using the [first guess dispersion map](../files/dispersion_map.md) generated by [`soxs_disp_solution`](../recipes/soxs_disp_solution.md) we generate an array of approximate pixel locations on each order centre between these wavelength limits.

[![](https://live.staticflickr.com/65535/50341874392_aa0f4f02da_z.png)](https://live.staticflickr.com/65535/50341874392_aa0f4f02da_o.png)

Centred on each pixel position we take a single-pixel wide image slice in the cross-dispersion direction N-pixels long (N is a recipe parameter). A 1D gaussian is fitted against the pixel slice and the peak pixel-position is stored.

[![](https://live.staticflickr.com/65535/50320359807_b4ae69c556_z.png)](https://live.staticflickr.com/65535/50320359807_b4ae69c556_o.png)

Finally, for each order, the set of gaussian peak pixel-positions is fitted with a low-order polynomial (X as a function of Y).

$$
X = \sum_{i=0}^n c_{i} \times Y^i 
$$

Where $n$ is the degree of the polynomials. Polynomials are iteratively fitted while sigma-clipping pixel-positions with outlying residuals. Results are stored in an [order table](../files/order_table.md).

[![](https://live.staticflickr.com/65535/50341080558_27e22d1666_z.png)](https://live.staticflickr.com/65535/50341080558_27e22d1666_o.png)

[![](https://live.staticflickr.com/65535/50344277283_7fb1f19946_z.png)](https://live.staticflickr.com/65535/50344277283_7fb1f19946_o.png)



