# `soxs_disp_solution`

The purpose of the [`soxs_disp_solution`](../_api/soxspipe.recipes.soxs_disp_solution.html) is to use a single-pinhole arc-lamp frame (example image above) to generate a first guess dispersion solution.

### Input

As input this recipes accepts the [Pinhole Map](../files/pinhole_map.md) file.

[![](https://live.staticflickr.com/65535/50292838383_b824f69a86_z.png)](https://live.staticflickr.com/65535/50292838383_b824f69a86_o.png)

[![](https://live.staticflickr.com/65535/50636320023_33a47c36d0_z.png)](https://live.staticflickr.com/65535/50636320023_33a47c36d0_o.png)


| Data Type | Content | Related OB |
|:----|:----|:---|
| FITS Image | Arc Lamp through single pinhole mask | `SOXS_slt_cal_VISArcsPinhole`, `SOXS_slt_cal_NIRArcsPinhole`|
| FITS Image | Master Dark Frame (VIS only) | - |
| FITS Image | Master Bias Frame (VIS only) | - |
| FITS Image | Dark frame (Lamp-Off) of equal exposure length as single pinhole frame (Lamp-On) (NIR only) | `SOXS_slt_cal_NIRArcsPinhole` |
| CSV File | [Pinhole Map](../files/pinhole_map.md) |

### Parameters

| Parameter                | Description                                   | Type  | Entry Point   | Related Util                                   |
| ------------------------ | --------------------------------------------- | ----- | ------------- | ---------------------------------------------- |
| pixel-window-size  | the side-length (in pixels) of the square window used to search for arc-line detection  |  int | settings file |  [`create_dispersion_map`](../utils/create_dispersion_map.md) |
| order-deg  |  the order of polynomial used to fit spectral-orders of detected arc-lines   | int | settings file  |  [`create_dispersion_map`](../utils/create_dispersion_map.md) |
| wavelength-deg  |  the order of polynomial used to fit wavelengths of detected arc-lines  | int | settings file  |  [`create_dispersion_map`](../utils/create_dispersion_map.md) |
| poly-fitting-residual-clipping-sigma  | sigma distance limit, where distance is the difference between the detected and polynomial fitted positions of an arc-line, outside of which to remove lines from the fit   | float   | settings file |  [`create_dispersion_map`](../utils/create_dispersion_map.md) | 
| clipping-iteration-limit  |  number of times to perform sigma-clipping (if number of clipped lines remains above zero) |  int   | settings file | [`create_dispersion_map`](../utils/create_dispersion_map.md) |

### Method

After preparing and calibrating the single-pinhole arc-lamp frame (using the [`subtract_calibrations`](../utils/subtract_calibrations.md)), the [`create_dispersion_map`](../utils/create_dispersion_map.md)) util is employed to detect and measure the positions of the arc lines on the frame. Below you can see the bright arc-lines outshining the traces of the order-centres and the detection of one of these lines during the [`create_dispersion_map`](../utils/create_dispersion_map.md)) util.

[![{@height=300px}](https://live.staticflickr.com/65535/50293674417_80470ed5f0_z.png)](https://live.staticflickr.com/65535/50293674417_80470ed5f0_o.png) [![{@height=300px}](https://live.staticflickr.com/65535/50294361037_a5a5ddd7f0_m.png)](https://live.staticflickr.com/65535/50294361037_a5a5ddd7f0_o.png)

Once the line positions have been measured, a dispersion solution is generated by iteratively fitting a global polynomial against the observed line-positions (see [`create_dispersion_map`](../utils/create_dispersion_map.md)) for details). The final product is a [Dispersion Map](../files/dispersion_map.md) file.

![](soxs_disp_solution.png)

### Output
 
| Data Type | Content |
|:----|:----|
| CSV file (subject to change)  |  First guess [Dispersion Map](../files/dispersion_map.md) | 

### QC Metrics

The typical solution for the `soxs_disp_solution` recipe has sub-pixel residuals.

[![](https://live.staticflickr.com/65535/50330665336_accab9eed4_z.png)](https://live.staticflickr.com/65535/50330665336_accab9eed4_o.png)


| Metric  | Description |
| :------------ | :----------- |
| TBC     | ...  |

### Recipe API

```eval_rst
.. autoclass:: soxspipe.recipes.soxs_disp_solution
    :members:
```
