<p align="center">
  <a href="https://github.com/piterator-org"><img src="https://static.piterator.com/logo.min.svg" alt="Piterator" width="20%"></a>
</p>

# dockerjudge
[![Maintainability](https://api.codeclimate.com/v1/badges/28a2fdc5f6d8afd9c2d4/maintainability)](https://codeclimate.com/github/piterator-org/dockerjudge/maintainability)
[![Python package](https://github.com/piterator-org/dockerjudge/workflows/Python%20package/badge.svg)](https://github.com/piterator-org/dockerjudge/actions?query=workflow%3A%22Python+package%22)
[![Upload Python Package](https://github.com/piterator-org/dockerjudge/workflows/Upload%20Python%20Package/badge.svg)](https://github.com/piterator-org/dockerjudge/actions?query=workflow%3A%22Upload+Python+Package%22)
[![Build Status](https://travis-ci.com/piterator-org/dockerjudge.svg)](https://travis-ci.com/piterator-org/dockerjudge)
[![CodeCov](https://codecov.io/gh/piterator-org/dockerjudge/graph/badge.svg)](https://codecov.io/gh/piterator-org/dockerjudge)
[![Python Version](https://img.shields.io/pypi/pyversions/dockerjudge.svg)](https://www.python.org/downloads/)
[![GitHub pre-release](https://img.shields.io/github/release-pre/piterator-org/dockerjudge.svg)](https://github.com/piterator-org/dockerjudge/releases)
[![PyPI](https://img.shields.io/pypi/v/dockerjudge.svg)](https://pypi.org/project/dockerjudge/#history)
[![Wheel](https://img.shields.io/pypi/wheel/dockerjudge.svg)](https://pypi.org/project/dockerjudge/#files)
[![License](https://img.shields.io/github/license/piterator-org/dockerjudge.svg)](LICENSE)

🎌 **🇺🇸 English** | [🇨🇳 大陆简体](README.zh-Hans-CN.md)

**A Docker based online judge engine**, which supports 5+ programming language processors:
- [C](https://en.wikipedia.org/wiki/C_(programming_language))/[C++](https://en.wikipedia.org/wiki/C%2B%2B)
  - [GCC (The GNU Compiler Collection)](https://gcc.gnu.org/)
- [Python](https://www.python.org/)
  - [CPython](https://www.python.org/downloads/)
- [Node.js](https://nodejs.org/en/)
  - [`node`](https://nodejs.org/en/download/)
- [Go](https://golang.org/)
  - [`go`](https://golang.org/dl/)
- [Java](https://www.oracle.com/java/)
  - [OpenJDK](https://openjdk.java.net/)

## Installation
### From the [Python Package Index (PyPI)](https://pypi.org/)
[dockerjudge · PyPI](https://pypi.org/project/dockerjudge/)
- [PyPI](https://pypi.org/simple/dockerjudge/)
- [阿里巴巴开源镜像站 (Alibaba Open Source Mirror)](https://mirrors.aliyun.com/pypi/simple/dockerjudge/)
- [清华大学开源软件镜像站 | Tsinghua Open Source Mirror](https://pypi.tuna.tsinghua.edu.cn/simple/dockerjudge/)

#### Via [pip](https://pip.pypa.io/)
```sh
pip install dockerjudge
```

#### Via [Esay install](https://setuptools.readthedocs.io/en/latest/easy_install.html) (deprecated)
```sh
easy_install dockerjudge
```

### From [GitHub](https://github.com/)
[piterator-org/dockerjudge: A Docker Based Online Judge Engine](https://github.com/piterator-org/dockerjudge)
- HTTPS: `https://github.com/piterator-org/dockerjudge.git`
- SSH: `git@github.com:piterator-org/dockerjudge.git`
```sh
git clone https://github.com/piterator-org/dockerjudge.git
cd dockerjudge
python3 setup.py install
```

## [License](LICENSE)
Licensed under [the **Apache License, Version 2.0**](https://www.apache.org/licenses/LICENSE-2.0)
<a href="https://www.apache.org/foundation/press/kit/#wide"><img src="https://www.apache.org/foundation/press/kit/asf_logo_wide.svg" alt="Wide Apache Software Foundation Logo with Feather.svg" height="32" align="right"></a>
