/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.vcf;

import htsjdk.tribble.TribbleException;
import htsjdk.variant.vcf.VCFLineParser;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class VCF4Parser
implements VCFLineParser {
    VCF4Parser() {
    }

    @Override
    public Map<String, String> parseLine(String valueLine, List<String> expectedTagOrder) {
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        StringBuilder builder = new StringBuilder();
        String key = "";
        int index = 0;
        boolean inQuote = false;
        for (char c : valueLine.toCharArray()) {
            if (c == '\"') {
                inQuote = !inQuote;
            } else if (inQuote) {
                builder.append(c);
            } else {
                switch (c) {
                    case '<': {
                        if (index == 0) break;
                    }
                    case '>': {
                        if (index != valueLine.length() - 1) break;
                        ret.put(key, builder.toString().trim());
                        break;
                    }
                    case '=': {
                        key = builder.toString().trim();
                        builder = new StringBuilder();
                        break;
                    }
                    case ',': {
                        ret.put(key, builder.toString().trim());
                        builder = new StringBuilder();
                        break;
                    }
                    default: {
                        builder.append(c);
                    }
                }
            }
            ++index;
        }
        index = 0;
        if (expectedTagOrder != null) {
            if (ret.size() > expectedTagOrder.size()) {
                throw new TribbleException.InvalidHeader("unexpected tag count " + ret.size() + " in line " + valueLine);
            }
            for (String str : ret.keySet()) {
                if (!expectedTagOrder.get(index).equals(str)) {
                    throw new TribbleException.InvalidHeader("Unexpected tag " + str + " in line " + valueLine);
                }
                ++index;
            }
        }
        return ret;
    }
}

