/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.compbio.ChromHMM;

import edu.mit.compbio.ChromHMM.ChromHMM;
import edu.mit.compbio.ChromHMM.Util;
import java.awt.Color;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.tc33.jheatchart.HeatChart;

public class StateAnalysis {
    static double EPSILONOVERLAP = 1.0E-8;

    static void makeEnrichmentHeatMap(double[][] dArray, String[] stringArray, String[] stringArray2, String string, Color color, String string2, String string3, String string4) throws IOException {
        HeatChart heatChart = new HeatChart(dArray);
        heatChart.setTitle(string2);
        heatChart.setXAxisLabel(string3);
        heatChart.setYAxisLabel(string4);
        heatChart.setChartMargin(100);
        heatChart.setXValues(stringArray);
        heatChart.setYValues(stringArray2);
        heatChart.setHighValueColour(color);
        heatChart.setAxisValuesFont(new Font("SansSerif", 0, 20));
        heatChart.setAxisLabelsFont(new Font("SansSerif", 0, 22));
        heatChart.setTitleFont(new Font("SansSerif", 0, 24));
        heatChart.saveToFile(new File(string + ".png"));
        Util.printImageToSVG(heatChart, string + ".svg");
        System.out.println("Writing to file " + string + ".png");
        System.out.println("Writing to file " + string + ".svg");
    }

    public static void enrichmentPosterior(String string, String string2, String string3, String string4, int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3, String string5, boolean bl4, String string6, boolean bl5, Color color, String string7, String string8, boolean bl6) throws IOException {
        Object object;
        int n4;
        String string9;
        Object[] objectArray;
        int n5;
        Object object2;
        Object object3;
        File file;
        char c = '0';
        if (bl3) {
            bl2 = false;
        }
        if (!(file = new File(string)).exists()) {
            throw new IllegalArgumentException(string + " was not found!");
        }
        String[] stringArray = file.list();
        int n6 = 0;
        int n7 = 0;
        boolean bl7 = true;
        if (string4 == null) {
            object3 = new File(string3);
            if (((File)object3).isDirectory()) {
                int n8;
                object2 = ((File)object3).list();
                n5 = 0;
                for (n8 = 0; n8 < ((String[])object2).length; ++n8) {
                    if (new File(object2[n8]).isHidden()) continue;
                    ++n5;
                }
                n8 = 0;
                objectArray = new String[n5];
                if (n5 == 0) {
                    throw new IllegalArgumentException("No files found in " + string3);
                }
                for (int i = 0; i < ((Object)object2).length; ++i) {
                    if (new File((String)object2[i]).isHidden()) continue;
                    objectArray[n8] = object2[i];
                    ++n8;
                }
                Arrays.sort(objectArray);
                string3 = string3 + "/";
            } else {
                objectArray = new String[]{string3};
                string3 = "";
            }
        } else {
            string3 = string3 + "/";
            object3 = Util.getBufferedReader(string4);
            object2 = new ArrayList();
            while ((string9 = ((BufferedReader)object3).readLine()) != null) {
                ((ArrayList)object2).add(string9);
            }
            ((BufferedReader)object3).close();
            objectArray = new String[((ArrayList)object2).size()];
            for (n5 = 0; n5 < objectArray.length; ++n5) {
                objectArray[n5] = (String)((ArrayList)object2).get(n5);
            }
        }
        double d = 0.0;
        double[] dArray = null;
        double[][] dArray2 = null;
        double[] dArray3 = new double[objectArray.length];
        boolean bl8 = false;
        for (n4 = 0; n4 < stringArray.length; ++n4) {
            object = stringArray[n4];
            if (!((String)object).contains("_posterior") || new File((String)object).isHidden()) continue;
            BufferedReader bufferedReader = Util.getBufferedReader(string + "/" + (String)object);
            String string10 = bufferedReader.readLine();
            if (string10 == null) {
                throw new IllegalArgumentException(string + "/" + (String)object + " is empty!");
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string10, "\t");
            String string11 = stringTokenizer.nextToken().trim();
            if (!string11.equals(string2) && !string2.equals("")) {
                bufferedReader.close();
                continue;
            }
            bl8 = true;
            String string12 = stringTokenizer.nextToken().trim();
            int n9 = 0;
            string9 = bufferedReader.readLine();
            if (string9 == null) {
                throw new IllegalArgumentException(string + "/" + (String)object + " is missing lines!");
            }
            stringTokenizer = new StringTokenizer(string9, "\t");
            int n10 = stringTokenizer.countTokens();
            if (bl7) {
                c = stringTokenizer.nextToken().trim().charAt(0);
                bl7 = false;
                n7 = n4;
                n6 = n10;
                dArray = new double[n6];
                dArray2 = new double[objectArray.length][n6];
            } else if (n6 != n10) {
                throw new IllegalArgumentException("Number of states " + n10 + " in " + (String)object + " does not match number of states " + n6 + " in " + stringArray[n7]);
            }
            while ((string9 = bufferedReader.readLine()) != null) {
                ++n9;
            }
            bufferedReader.close();
            float[][] fArray = new float[n9][n6];
            bufferedReader = Util.getBufferedReader(string + "/" + (String)object);
            bufferedReader.readLine();
            bufferedReader.readLine();
            int n11 = 0;
            while ((string9 = bufferedReader.readLine()) != null) {
                stringTokenizer = new StringTokenizer(string9, "\t");
                float[] fArray2 = fArray[n11];
                int n12 = 0;
                while (n12 < n6) {
                    float f;
                    fArray2[n12] = f = Float.parseFloat(stringTokenizer.nextToken().trim());
                    int n13 = n12++;
                    dArray[n13] = dArray[n13] + (double)f;
                }
                ++n11;
            }
            bufferedReader.close();
            for (int i = 0; i < objectArray.length; ++i) {
                float[] fArray3;
                int n14;
                int n15;
                int n16;
                int n17;
                Object object4;
                String[] stringArray2;
                Object object5;
                double[] dArray4 = dArray2[i];
                int n18 = 0;
                int n19 = 1;
                int n20 = 2;
                int n21 = 3;
                if (string5 != null) {
                    object5 = new StringTokenizer(string5, ",");
                    n18 = Integer.parseInt(((StringTokenizer)object5).nextToken().trim());
                    n19 = Integer.parseInt(((StringTokenizer)object5).nextToken().trim());
                    n20 = Integer.parseInt(((StringTokenizer)object5).nextToken().trim());
                    if (bl3) {
                        n21 = Integer.parseInt(((StringTokenizer)object5).nextToken().trim());
                    }
                }
                object5 = Util.getBufferedReader(string3 + (String)objectArray[i]);
                if (bl2) {
                    stringArray2 = new ArrayList();
                    while ((string9 = ((BufferedReader)object5).readLine()) != null) {
                        Object object6;
                        if (string9.trim().equals("") || !((String)(object6 = (object4 = string9.split("\\s+"))[n18])).equals(string12)) continue;
                        Object object7 = object4[n18];
                        n17 = Integer.parseInt((String)object4[n19]) - n;
                        n16 = Integer.parseInt((String)object4[n20]) - n2;
                        if (bl) {
                            n16 = n17 = (n17 + n16) / 2;
                        }
                        stringArray2.add(new Interval(n17, n16));
                    }
                    object4 = stringArray2.toArray();
                    Arrays.sort(object4, new IntervalCompare());
                    n15 = 1;
                    n14 = -1;
                    n17 = -1;
                    n16 = 0;
                    for (int j = 0; j <= ((Object)object4).length && ((Object)object4).length > 0; ++j) {
                        int n22;
                        float[] fArray4;
                        int n23 = -1;
                        int n24 = -1;
                        if (j == ((Object)object4).length) {
                            n16 = 1;
                        } else {
                            n23 = ((Interval)object4[j]).nstart;
                            n24 = ((Interval)object4[j]).nend;
                            if (j == 0) {
                                n14 = n23;
                                n17 = n24;
                            } else if (n23 <= n17) {
                                if (n24 > n17) {
                                    n17 = n24;
                                }
                            } else {
                                n16 = 1;
                            }
                        }
                        if (n16 == 0) continue;
                        int n25 = n14 / n3;
                        int n26 = n17 / n3;
                        if (n25 < 0) {
                            n25 = 0;
                        }
                        if (n26 >= fArray.length) {
                            n26 = fArray.length - 1;
                        }
                        for (int k = n25; k <= n26; ++k) {
                            fArray3 = fArray[k];
                            for (int i2 = 0; i2 < n6; ++i2) {
                                int n27 = i2;
                                dArray4[n27] = dArray4[n27] + (double)fArray3[i2];
                            }
                        }
                        if (!bl4) continue;
                        double d2 = (double)(n14 - n25 * n3) / (double)n3;
                        double d3 = (double)((n26 + 1) * n3 - n17 - 1) / (double)n3;
                        if (n25 < fArray.length && d2 > 0.0) {
                            fArray4 = fArray[n25];
                            for (n22 = 0; n22 < n6; ++n22) {
                                int n28 = n22;
                                dArray4[n28] = dArray4[n28] - d2 * (double)fArray4[n22];
                            }
                        }
                        if (n26 < fArray.length && d3 > 0.0) {
                            fArray4 = fArray[n26];
                            for (n22 = 0; n22 < n6; ++n22) {
                                int n29 = n22;
                                dArray4[n29] = dArray4[n29] - d3 * (double)fArray4[n22];
                            }
                        }
                        n14 = n23;
                        n17 = n24;
                        n16 = 0;
                    }
                } else {
                    while ((string9 = ((BufferedReader)object5).readLine()) != null) {
                        int n30;
                        float[] fArray5;
                        if (string9.trim().equals("") || !((String)(object4 = (stringArray2 = string9.split("\\s+"))[n18])).equals(string12)) continue;
                        n15 = Integer.parseInt(stringArray2[n19]) - n;
                        n14 = n15 / n3;
                        n17 = Integer.parseInt(stringArray2[n20]) - n2;
                        n16 = n17 / n3;
                        double d4 = bl3 && n21 < stringArray2.length ? Double.parseDouble(stringArray2[n21]) : 1.0;
                        if (bl) {
                            int n31 = (n15 + n17) / (2 * n3);
                            if (n31 >= fArray.length) continue;
                            fArray5 = fArray[n31];
                            for (int j = 0; j < n6; ++j) {
                                int n32 = j;
                                dArray4[n32] = dArray4[n32] + d4 * (double)fArray5[j];
                            }
                            continue;
                        }
                        if (n14 < 0) {
                            n14 = 0;
                        }
                        if (n16 >= fArray.length) {
                            n16 = fArray.length - 1;
                        }
                        for (int j = n14; j <= n16; ++j) {
                            fArray5 = fArray[j];
                            for (int k = 0; k < n6; ++k) {
                                int n33 = k;
                                dArray4[n33] = dArray4[n33] + d4 * (double)fArray5[k];
                            }
                        }
                        if (!bl4) continue;
                        double d5 = (double)(n15 - n14 * n3) / (double)n3;
                        double d6 = (double)((n16 + 1) * n3 - n17 - 1) / (double)n3;
                        if (n14 < fArray.length && d5 > 0.0) {
                            fArray3 = fArray[n14];
                            for (n30 = 0; n30 < n6; ++n30) {
                                int n34 = n30;
                                dArray4[n34] = dArray4[n34] - d4 * d5 * (double)fArray3[n30];
                            }
                        }
                        if (n16 >= fArray.length || !(d6 > 0.0)) continue;
                        fArray3 = fArray[n16];
                        for (n30 = 0; n30 < n6; ++n30) {
                            int n35 = n30;
                            dArray4[n35] = dArray4[n35] - d4 * d6 * (double)fArray3[n30];
                        }
                    }
                }
                ((BufferedReader)object5).close();
            }
        }
        if (!bl8) {
            throw new IllegalArgumentException("no posterior file found for cell type " + string2);
        }
        for (n4 = 0; n4 < dArray3.length; ++n4) {
            object = dArray2[n4];
            for (int i = 0; i < ((Object)object).length; ++i) {
                int n36 = n4;
                dArray3[n36] = dArray3[n36] + object[i];
            }
            if (!(dArray3[n4] < EPSILONOVERLAP)) continue;
            throw new IllegalArgumentException("Coordinates in " + (String)objectArray[n4] + " not assigned to any state. Check if chromosome naming in " + (String)objectArray[n4] + " match those in the posterior files.");
        }
        StateAnalysis.outputenrichment(string6, (String[])objectArray, dArray2, dArray, dArray3, color, bl5, ChromHMM.convertCharOrderToStringOrder(c), string7, 1, string8, c, bl6, false, null);
    }

    public static void enrichmentMax(String string, String string2, String string3, int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3, String string4, boolean bl4, String string5, boolean bl5, Color color, String string6, String string7, boolean bl6, boolean bl7) throws IOException {
        Object[] objectArray;
        Object object;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        Object object2;
        String string8;
        ArrayList<SegmentRec> arrayList = new ArrayList<SegmentRec>();
        ArrayList<short[][]> arrayList2 = new ArrayList<short[][]>();
        if (bl3) {
            bl2 = false;
        }
        HashMap<short[][], Integer> hashMap = new HashMap<short[][], Integer>();
        HashMap<short[][], Integer> hashMap2 = new HashMap<short[][], Integer>();
        HashMap<String, Short> hashMap3 = new HashMap<String, Short>();
        HashMap<String, String> hashMap4 = new HashMap<String, String>();
        int n9 = 0;
        String string9 = "";
        boolean bl8 = false;
        BufferedReader bufferedReader = Util.getBufferedReader(string);
        while ((string8 = bufferedReader.readLine()) != null) {
            StringTokenizer stringTokenizer = bl7 ? new StringTokenizer(string8, "\t") : new StringTokenizer(string8, "\t ");
            object2 = stringTokenizer.nextToken().trim();
            n8 = Integer.parseInt(stringTokenizer.nextToken().trim());
            n7 = Integer.parseInt(stringTokenizer.nextToken().trim());
            if (n8 % n3 != 0) {
                throw new IllegalArgumentException("Binsize of " + n3 + " does not agree with coordinates in input segment " + string8 + ". -b binsize should match parameter value to LearnModel or " + "MakeSegmentation used to produce segmentation. If segmentation is derived from a lift over from another assembly, then the '-b 1' option should be used");
            }
            int n10 = n8 / n3;
            n6 = (n7 - 1) / n3;
            string9 = stringTokenizer.nextToken().trim();
            n5 = -1;
            if (bl7) {
                Object object3;
                block65: {
                    int n11 = string9.indexOf("_");
                    if (n11 >= 0) {
                        object3 = string9.substring(0, n11);
                        try {
                            n5 = Short.parseShort((String)object3);
                            if (n5 > n9) {
                                n9 = n5;
                            }
                            bl8 = true;
                            hashMap3.put(string9, (short)n5);
                            hashMap4.put("" + n5, string9);
                        }
                        catch (NumberFormatException numberFormatException) {
                            try {
                                n5 = Short.parseShort(((String)object3).substring(1));
                                if (n5 > n9) {
                                    n9 = n5;
                                }
                                bl8 = true;
                                hashMap3.put(string9, (short)n5);
                                hashMap4.put("" + n5, string9);
                            }
                            catch (NumberFormatException numberFormatException2) {
                                if (!bl8) break block65;
                                throw new IllegalArgumentException("Not a valid ID before '_' in " + string9 + ", while valid ID found for other entries");
                            }
                        }
                    }
                }
                if (!bl8) {
                    object3 = (Short)hashMap3.get(string9);
                    if (object3 == null) {
                        n9 = hashMap3.size() + 1;
                        n5 = (short)n9;
                        hashMap3.put(string9, (short)n5);
                        hashMap4.put("" + n9, string9);
                    } else {
                        n5 = ((Short)object3).shortValue();
                    }
                }
                arrayList.add(new SegmentRec((String)object2, n10, n6, (short)n5));
            } else {
                try {
                    n5 = Short.parseShort(string9);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        n5 = Short.parseShort(string9.substring(1));
                    }
                    catch (NumberFormatException numberFormatException3) {
                        throw new IllegalArgumentException("In fourth column neither state number or ID found in segmentation file. Use '-labels' option to run overlap enrichment treating fourth column as labels");
                    }
                }
                arrayList.add(new SegmentRec((String)object2, n10, n6, (short)n5));
                if (n5 > n9) {
                    n9 = n5;
                }
            }
            Integer n12 = (Integer)hashMap.get(object2);
            if (n12 == null) {
                hashMap.put((short[][])object2, n6);
                hashMap2.put((short[][])object2, hashMap2.size());
                arrayList2.add((short[][])object2);
                continue;
            }
            int n13 = n12;
            if (n13 >= n6) continue;
            hashMap.put((short[][])object2, n6);
        }
        bufferedReader.close();
        int n14 = arrayList2.size();
        object2 = new short[n14][];
        for (n8 = 0; n8 < n14; ++n8) {
            n7 = (Integer)hashMap.get(arrayList2.get(n8)) + 1;
            object2[n8] = new short[n7];
            short[] sArray = object2[n8];
            for (n6 = 0; n6 < n7; ++n6) {
                sArray[n6] = -1;
            }
        }
        double[] dArray = new double[n9 + 1];
        n7 = arrayList.size();
        for (int i = 0; i < n7; ++i) {
            SegmentRec segmentRec = (SegmentRec)arrayList.get(i);
            n5 = segmentRec.nbegin;
            int n15 = segmentRec.nend;
            short s = segmentRec.slabel;
            int n16 = (Integer)hashMap2.get(segmentRec.szchrom);
            short[] sArray = object2[n16];
            for (n4 = n5; n4 <= n15; ++n4) {
                sArray[n4] = s;
                short s2 = s;
                dArray[s2] = dArray[s2] + 1.0;
            }
        }
        if (string3 == null) {
            object = new File(string2);
            if (((File)object).isDirectory()) {
                int n17;
                String[] stringArray = ((File)object).list();
                int n18 = 0;
                for (n17 = 0; n17 < stringArray.length; ++n17) {
                    if (new File(stringArray[n17]).isHidden()) continue;
                    ++n18;
                }
                n17 = 0;
                objectArray = new String[n18];
                if (n18 == 0) {
                    throw new IllegalArgumentException("No files found in " + string2);
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    if (new File(stringArray[i]).isHidden()) continue;
                    objectArray[n17] = stringArray[i];
                    ++n17;
                }
                Arrays.sort(objectArray);
                string2 = string2 + "/";
            } else {
                objectArray = new String[]{string2};
                string2 = "";
            }
        } else {
            string2 = string2 + "/";
            object = Util.getBufferedReader(string3);
            ArrayList<String> arrayList3 = new ArrayList<String>();
            while ((string8 = ((BufferedReader)object).readLine()) != null) {
                arrayList3.add(string8);
            }
            ((BufferedReader)object).close();
            objectArray = new String[arrayList3.size()];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = (String)arrayList3.get(i);
            }
        }
        object = new double[objectArray.length][n9 + 1];
        double[] dArray2 = new double[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            int n10;
            int n11;
            String string10;
            Object object4;
            Object object5 = object[i];
            int n21 = 0;
            int n22 = 1;
            n4 = 2;
            int n23 = 3;
            if (string4 != null) {
                object4 = new StringTokenizer(string4, ",");
                n21 = Integer.parseInt(((StringTokenizer)object4).nextToken().trim());
                n22 = Integer.parseInt(((StringTokenizer)object4).nextToken().trim());
                n4 = Integer.parseInt(((StringTokenizer)object4).nextToken().trim());
                if (bl3) {
                    n23 = Integer.parseInt(((StringTokenizer)object4).nextToken().trim());
                }
            }
            if (bl2) {
                for (Map.Entry entry : hashMap2.entrySet()) {
                    int n12;
                    Object[] objectArray2;
                    string10 = (String)entry.getKey();
                    n11 = (Integer)entry.getValue();
                    short[] sArray = object2[n11];
                    BufferedReader bufferedReader2 = Util.getBufferedReader(string2 + (String)objectArray[i]);
                    ArrayList<Interval> arrayList3 = new ArrayList<Interval>();
                    while ((string8 = bufferedReader2.readLine()) != null) {
                        if (string8.trim().equals("")) continue;
                        objectArray2 = string8.split("\\s+");
                        if (n22 >= objectArray2.length) {
                            throw new IllegalArgumentException(n22 + " is an invalid index for " + string8 + " in " + string2 + (String)objectArray[i]);
                        }
                        if (n4 >= objectArray2.length) {
                            throw new IllegalArgumentException(n4 + " is an invalid index for " + string8 + " in " + string2 + (String)objectArray[i]);
                        }
                        Object object3 = objectArray2[n21];
                        if (!string10.equals(object3)) continue;
                        n12 = Integer.parseInt((String)objectArray2[n22]) - n;
                        n10 = Integer.parseInt((String)objectArray2[n4]) - n2;
                        if (bl) {
                            n10 = n12 = (n12 + n10) / 2;
                        }
                        arrayList3.add(new Interval(n12, n10));
                    }
                    bufferedReader2.close();
                    objectArray2 = arrayList3.toArray();
                    Arrays.sort(objectArray2, new IntervalCompare());
                    boolean bl9 = true;
                    n12 = -1;
                    n10 = -1;
                    boolean bl10 = false;
                    for (int j = 0; j <= objectArray2.length && objectArray2.length > 0; ++j) {
                        int n13 = -1;
                        int n15 = -1;
                        if (j == objectArray2.length) {
                            bl10 = true;
                        } else {
                            n13 = ((Interval)objectArray2[j]).nstart;
                            n15 = ((Interval)objectArray2[j]).nend;
                            if (j == 0) {
                                n12 = n13;
                                n10 = n15;
                            } else if (n13 <= n10) {
                                if (n15 > n10) {
                                    n10 = n15;
                                }
                            } else {
                                bl10 = true;
                            }
                        }
                        if (!bl10) continue;
                        int n16 = n12 / n3;
                        int n17 = n10 / n3;
                        if (n16 < 0) {
                            n16 = 0;
                        }
                        if (n17 >= sArray.length) {
                            n17 = sArray.length - 1;
                        }
                        for (int k = n16; k <= n17; ++k) {
                            if (sArray[k] < 0) continue;
                            Object object6 = object5;
                            short s = sArray[k];
                            object6[s] = object6[s] + 1.0;
                        }
                        if (bl4) {
                            double d = (double)(n12 - n16 * n3) / (double)n3;
                            double d2 = (double)((n17 + 1) * n3 - n10 - 1) / (double)n3;
                            if (n16 < sArray.length && sArray[n16] >= 0 && d > 0.0) {
                                Object object7 = object5;
                                short s = sArray[n16];
                                object7[s] = object7[s] - d;
                            }
                            if (n17 < sArray.length && sArray[n17] >= 0 && d2 > 0.0) {
                                Object object8 = object5;
                                short s = sArray[n17];
                                object8[s] = object8[s] - d2;
                            }
                        }
                        n12 = n13;
                        n10 = n15;
                        bl10 = false;
                    }
                }
            } else {
                object4 = Util.getBufferedReader(string2 + (String)objectArray[i]);
                while ((string8 = ((BufferedReader)object4).readLine()) != null) {
                    if (string8.trim().equals("")) continue;
                    String[] stringArray = string8.split("\\s+");
                    string10 = stringArray[n21];
                    n11 = Integer.parseInt(stringArray[n22]) - n;
                    int n18 = n11 / n3;
                    int n19 = Integer.parseInt(stringArray[n4]) - n2;
                    int n20 = n19 / n3;
                    double d = bl3 && n23 < stringArray.length ? Double.parseDouble(stringArray[n23]) : 1.0;
                    Integer n24 = (Integer)hashMap2.get(string10);
                    if (n24 == null) continue;
                    n10 = n24;
                    short[] sArray = object2[n10];
                    if (bl) {
                        int d3 = (n11 + n19) / (2 * n3);
                        if (d3 >= sArray.length || sArray[d3] < 0) continue;
                        Object object9 = object5;
                        short s = sArray[d3];
                        object9[s] = object9[s] + d;
                        continue;
                    }
                    if (n18 < 0) {
                        n18 = 0;
                    }
                    if (n20 >= sArray.length) {
                        n20 = sArray.length - 1;
                    }
                    for (int j = n18; j <= n20; ++j) {
                        if (sArray[j] < 0) continue;
                        Object object10 = object5;
                        short s = sArray[j];
                        object10[s] = object10[s] + d;
                    }
                    if (!bl4) continue;
                    double d3 = (double)(n11 - n18 * n3) / (double)n3;
                    double d4 = (double)((n20 + 1) * n3 - n19 - 1) / (double)n3;
                    if (n18 < sArray.length && sArray[n18] >= 0 && d3 > 0.0) {
                        Object object11 = object5;
                        short s = sArray[n18];
                        object11[s] = object11[s] - d * d3;
                    }
                    if (n20 >= sArray.length || sArray[n20] < 0 || !(d4 > 0.0)) continue;
                    Object object12 = object5;
                    short s = sArray[n20];
                    object12[s] = object12[s] - d * d4;
                }
                ((BufferedReader)object4).close();
            }
            for (int j = 0; j < ((Object)object5).length; ++j) {
                int n25 = i;
                dArray2[n25] = dArray2[n25] + object5[j];
            }
            if (!(dArray2[i] < EPSILONOVERLAP)) continue;
            throw new IllegalArgumentException("Coordinates in " + (String)objectArray[i] + " not assigned to any state. Check if chromosome naming in " + (String)objectArray[i] + " match those in the segmentation file.");
        }
        StateAnalysis.outputenrichment(string5, (String[])objectArray, (double[][])object, dArray, dArray2, color, bl5, ChromHMM.convertCharOrderToStringOrder(string9.charAt(0)), string6, 0, string7, string9.charAt(0), bl6, bl7, hashMap4);
    }

    public static void enrichmentMaxLowMem(String string, String string2, String string3, int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3, String string4, boolean bl4, String string5, boolean bl5, Color color, String string6, String string7, boolean bl6, boolean bl7) throws IOException {
        int n4;
        int n5;
        Object object;
        Object object2;
        String string8;
        Object[] objectArray;
        int n6;
        Object object3;
        Serializable serializable;
        if (string3 == null) {
            serializable = new File(string2);
            if (((File)serializable).isDirectory()) {
                int n7;
                object3 = ((File)serializable).list();
                n6 = 0;
                for (n7 = 0; n7 < ((String[])object3).length; ++n7) {
                    if (new File(object3[n7]).isHidden()) continue;
                    ++n6;
                }
                n7 = 0;
                objectArray = new String[n6];
                if (n6 == 0) {
                    throw new IllegalArgumentException("No files found in " + string2);
                }
                for (int i = 0; i < ((Object)object3).length; ++i) {
                    if (new File((String)object3[i]).isHidden()) continue;
                    objectArray[n7] = object3[i];
                    ++n7;
                }
                Arrays.sort(objectArray);
                string2 = string2 + "/";
            } else {
                objectArray = new String[]{string2};
                string2 = "";
            }
        } else {
            string2 = string2 + "/";
            serializable = Util.getBufferedReader(string3);
            object3 = new ArrayList();
            while ((string8 = ((BufferedReader)((Object)serializable)).readLine()) != null) {
                ((ArrayList)object3).add(string8);
            }
            ((BufferedReader)((Object)serializable)).close();
            objectArray = new String[((ArrayList)object3).size()];
            for (n6 = 0; n6 < objectArray.length; ++n6) {
                objectArray[n6] = (String)((ArrayList)object3).get(n6);
            }
        }
        serializable = new ArrayList<Object>();
        if (bl3) {
            bl2 = false;
        }
        object3 = new HashMap();
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        HashMap<String, Short> hashMap2 = new HashMap<String, Short>();
        HashMap<String, String> hashMap3 = new HashMap<String, String>();
        short s = 0;
        String string9 = "";
        boolean bl8 = false;
        BufferedReader bufferedReader = Util.getBufferedReader(string);
        while ((string8 = bufferedReader.readLine()) != null) {
            short s2;
            object2 = bl7 ? new StringTokenizer(string8, "\t") : new StringTokenizer(string8, "\t ");
            object = ((StringTokenizer)object2).nextToken().trim();
            int n8 = Integer.parseInt(((StringTokenizer)object2).nextToken().trim());
            n5 = Integer.parseInt(((StringTokenizer)object2).nextToken().trim());
            if (n8 % n3 != 0) {
                throw new IllegalArgumentException("Binsize of " + n3 + " does not agree with coordinates in input segment " + string8 + ". -b binsize should match parameter value to LearnModel or " + "MakeSegmentation used to produce segmentation. If segmentation is derived from a lift over from another assembly, then the '-b 1' option should be used");
            }
            n4 = (n5 - 1) / n3;
            string9 = ((StringTokenizer)object2).nextToken().trim();
            if (bl7) {
                Object object4;
                block76: {
                    int n9 = string9.indexOf("_");
                    if (n9 >= 0) {
                        object4 = string9.substring(0, n9);
                        try {
                            s2 = Short.parseShort((String)object4);
                            if (s2 > s) {
                                s = s2;
                            }
                            bl8 = true;
                            hashMap2.put(string9, s2);
                            hashMap3.put("" + s2, string9);
                        }
                        catch (NumberFormatException numberFormatException) {
                            try {
                                s2 = Short.parseShort(((String)object4).substring(1));
                                if (s2 > s) {
                                    s = s2;
                                }
                                bl8 = true;
                                hashMap2.put(string9, s2);
                                hashMap3.put("" + s2, string9);
                            }
                            catch (NumberFormatException numberFormatException2) {
                                if (!bl8) break block76;
                                throw new IllegalArgumentException("Not a valid ID before '_' in " + string9 + ", while valid ID found for other entries");
                            }
                        }
                    }
                }
                if (!bl8 && (object4 = (Short)hashMap2.get(string9)) == null) {
                    s = hashMap2.size() + 1;
                    s2 = s;
                    hashMap2.put(string9, s2);
                    hashMap3.put("" + s, string9);
                }
            } else {
                try {
                    s2 = Short.parseShort(string9);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        s2 = Short.parseShort(string9.substring(1));
                    }
                    catch (NumberFormatException numberFormatException3) {
                        throw new IllegalArgumentException("In fourth column neither state number or ID found in segmentation file. Use '-labels' option to run overlap enrichment treating fourth column as labels");
                    }
                }
                if (s2 > s) {
                    s = s2;
                }
            }
            Integer n10 = (Integer)((HashMap)object3).get(object);
            if (n10 == null) {
                ((HashMap)object3).put(object, n4);
                hashMap.put(object, hashMap.size());
                serializable.add(object);
                continue;
            }
            int n11 = n10;
            if (n11 >= n4) continue;
            ((HashMap)object3).put(object, n4);
        }
        bufferedReader.close();
        object2 = new double[objectArray.length][s + 1];
        object = new double[objectArray.length];
        double[] dArray = new double[s + 1];
        n5 = serializable.size();
        for (n4 = 0; n4 < n5; ++n4) {
            Object object5;
            int n12;
            int n13;
            int n14;
            int n15;
            Object object6;
            int n16;
            String string10 = (String)serializable.get(n4);
            int n17 = (Integer)((HashMap)object3).get(string10) + 1;
            short[] sArray = new short[n17];
            for (n16 = 0; n16 < n17; ++n16) {
                sArray[n16] = -1;
            }
            bufferedReader = Util.getBufferedReader(string);
            while ((string8 = bufferedReader.readLine()) != null) {
                int n18;
                StringTokenizer stringTokenizer = bl7 ? new StringTokenizer(string8, "\t") : new StringTokenizer(string8, "\t ");
                object6 = stringTokenizer.nextToken().trim();
                if (!((String)object6).equals(string10)) continue;
                n15 = Integer.parseInt(stringTokenizer.nextToken().trim());
                n14 = Integer.parseInt(stringTokenizer.nextToken().trim());
                n13 = n15 / n3;
                n12 = (n14 - 1) / n3;
                string9 = stringTokenizer.nextToken().trim();
                int n19 = -1;
                if (bl7) {
                    block77: {
                        n18 = string9.indexOf("_");
                        if (n18 >= 0) {
                            object5 = string9.substring(0, n18);
                            try {
                                n19 = Short.parseShort((String)object5);
                                bl8 = true;
                            }
                            catch (NumberFormatException numberFormatException) {
                                try {
                                    n19 = Short.parseShort(((String)object5).substring(1));
                                    bl8 = true;
                                }
                                catch (NumberFormatException numberFormatException4) {
                                    if (!bl8) break block77;
                                    throw new IllegalArgumentException("Not a valid ID before '_' in " + string9 + ", while valid ID found for other entries");
                                }
                            }
                        }
                    }
                    if (!bl8) {
                        object5 = (Short)hashMap2.get(string9);
                        n19 = ((Short)object5).shortValue();
                    }
                } else {
                    try {
                        n19 = Short.parseShort(string9);
                    }
                    catch (NumberFormatException numberFormatException) {
                        try {
                            n19 = Short.parseShort(string9.substring(1));
                        }
                        catch (NumberFormatException numberFormatException5) {
                            throw new IllegalArgumentException("In fourth column neither state number or ID found in segmentation file. Use '-labels' option to run overlap enrichment treating fourth column as labels");
                        }
                    }
                }
                if (n13 < 0) {
                    n13 = 0;
                }
                if (n12 >= sArray.length) {
                    n12 = sArray.length - 1;
                }
                for (n18 = n13; n18 <= n12; ++n18) {
                    sArray[n18] = n19;
                }
                int n20 = n19;
                dArray[n20] = dArray[n20] + (double)(n12 - n13 + 1);
            }
            for (n16 = 0; n16 < objectArray.length; ++n16) {
                int n21;
                int n22;
                Object object7;
                object6 = object2[n16];
                n15 = 0;
                n14 = 1;
                n13 = 2;
                n12 = 3;
                if (string4 != null) {
                    object7 = new StringTokenizer(string4, ",");
                    n15 = Integer.parseInt(((StringTokenizer)object7).nextToken().trim());
                    n14 = Integer.parseInt(((StringTokenizer)object7).nextToken().trim());
                    n13 = Integer.parseInt(((StringTokenizer)object7).nextToken().trim());
                    if (bl3) {
                        n12 = Integer.parseInt(((StringTokenizer)object7).nextToken().trim());
                    }
                }
                if (bl2) {
                    int n23;
                    object7 = Util.getBufferedReader(string2 + (String)objectArray[n16]);
                    ArrayList<Interval> arrayList = new ArrayList<Interval>();
                    while ((string8 = ((BufferedReader)object7).readLine()) != null) {
                        if (string8.trim().equals("")) continue;
                        object5 = string8.split("\\s+");
                        if (n14 >= ((Object[])object5).length) {
                            throw new IllegalArgumentException(n14 + " is an invalid index for " + string8 + " in " + string2 + (String)objectArray[n16]);
                        }
                        if (n13 >= ((Object)object5).length) {
                            throw new IllegalArgumentException(n13 + " is an invalid index for " + string8 + " in " + string2 + (String)objectArray[n16]);
                        }
                        Object object8 = object5[n15];
                        if (!string10.equals(object8)) continue;
                        n23 = Integer.parseInt((String)object5[n14]) - n;
                        n22 = Integer.parseInt((String)object5[n13]) - n2;
                        if (bl) {
                            n22 = n23 = (n23 + n22) / 2;
                        }
                        arrayList.add(new Interval(n23, n22));
                    }
                    ((BufferedReader)object7).close();
                    object5 = arrayList.toArray();
                    Arrays.sort(object5, new IntervalCompare());
                    boolean bl9 = true;
                    n23 = -1;
                    n22 = -1;
                    n21 = 0;
                    for (int i = 0; i <= ((Object)object5).length && ((Object)object5).length > 0; ++i) {
                        int n24 = -1;
                        int n25 = -1;
                        if (i == ((Object)object5).length) {
                            n21 = 1;
                        } else {
                            n24 = ((Interval)object5[i]).nstart;
                            n25 = ((Interval)object5[i]).nend;
                            if (i == 0) {
                                n23 = n24;
                                n22 = n25;
                            } else if (n24 <= n22) {
                                if (n25 > n22) {
                                    n22 = n25;
                                }
                            } else {
                                n21 = 1;
                            }
                        }
                        if (n21 == 0) continue;
                        int n26 = n23 / n3;
                        int n27 = n22 / n3;
                        if (n26 < 0) {
                            n26 = 0;
                        }
                        if (n27 >= sArray.length) {
                            n27 = sArray.length - 1;
                        }
                        for (int j = n26; j <= n27; ++j) {
                            if (sArray[j] < 0) continue;
                            Object object9 = object6;
                            short s3 = sArray[j];
                            object9[s3] = object9[s3] + 1.0;
                        }
                        if (bl4) {
                            double d = (double)(n23 - n26 * n3) / (double)n3;
                            double d2 = (double)((n27 + 1) * n3 - n22 - 1) / (double)n3;
                            if (n26 < sArray.length && sArray[n26] >= 0 && d > 0.0) {
                                Object object10 = object6;
                                short s4 = sArray[n26];
                                object10[s4] = object10[s4] - d;
                            }
                            if (n27 < sArray.length && sArray[n27] >= 0 && d2 > 0.0) {
                                Object object11 = object6;
                                short s5 = sArray[n27];
                                object11[s5] = object11[s5] - d2;
                            }
                        }
                        n23 = n24;
                        n22 = n25;
                        n21 = 0;
                    }
                    continue;
                }
                object7 = Util.getBufferedReader(string2 + (String)objectArray[n16]);
                while ((string8 = ((BufferedReader)object7).readLine()) != null) {
                    String[] stringArray;
                    if (string8.trim().equals("") || !string10.equals(object5 = (stringArray = string8.split("\\s+"))[n15])) continue;
                    int n28 = Integer.parseInt(stringArray[n14]) - n;
                    int n29 = n28 / n3;
                    n22 = Integer.parseInt(stringArray[n13]) - n2;
                    n21 = n22 / n3;
                    double d = bl3 && n12 < stringArray.length ? Double.parseDouble(stringArray[n12]) : 1.0;
                    if (bl) {
                        int n30 = (n28 + n22) / (2 * n3);
                        if (n30 >= sArray.length || sArray[n30] < 0) continue;
                        Object object12 = object6;
                        short s6 = sArray[n30];
                        object12[s6] = object12[s6] + d;
                        continue;
                    }
                    if (n29 < 0) {
                        n29 = 0;
                    }
                    if (n21 >= sArray.length) {
                        n21 = sArray.length - 1;
                    }
                    for (int i = n29; i <= n21; ++i) {
                        if (sArray[i] < 0) continue;
                        Object object13 = object6;
                        short s7 = sArray[i];
                        object13[s7] = object13[s7] + d;
                    }
                    if (!bl4) continue;
                    double d3 = (double)(n28 - n29 * n3) / (double)n3;
                    double d4 = (double)((n21 + 1) * n3 - n22 - 1) / (double)n3;
                    if (n29 < sArray.length && sArray[n29] >= 0 && d3 > 0.0) {
                        Object object14 = object6;
                        short s8 = sArray[n29];
                        object14[s8] = object14[s8] - d * d3;
                    }
                    if (n21 >= sArray.length || sArray[n21] < 0 || !(d4 > 0.0)) continue;
                    Object object15 = object6;
                    short s9 = sArray[n21];
                    object15[s9] = object15[s9] - d * d4;
                }
                ((BufferedReader)object7).close();
            }
        }
        for (n4 = 0; n4 < objectArray.length; ++n4) {
            Object object16 = object2[n4];
            for (int i = 0; i < ((Object)object16).length; ++i) {
                Object object17 = object;
                int n31 = n4;
                object17[n31] = object17[n31] + object16[i];
            }
            if (!(object[n4] < EPSILONOVERLAP)) continue;
            throw new IllegalArgumentException("Coordinates in " + (String)objectArray[n4] + " not assigned to any state. Check if chromosome naming in " + (String)objectArray[n4] + " match those in the segmentation file.");
        }
        StateAnalysis.outputenrichment(string5, (String[])objectArray, (double[][])object2, dArray, (double[])object, color, bl5, ChromHMM.convertCharOrderToStringOrder(string9.charAt(0)), string6, 0, string7, string9.charAt(0), bl6, bl7, hashMap3);
    }

    private static HashMap makeLabelMapping(String string) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string != null) {
            String string2;
            BufferedReader bufferedReader = Util.getBufferedReader(string);
            while ((string2 = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "\t");
                String string3 = stringTokenizer.nextToken().trim();
                String string4 = stringTokenizer.nextToken().trim();
                hashMap.put(string3, string4);
            }
            bufferedReader.close();
        }
        return hashMap;
    }

    private static void outputenrichment(String string, String[] stringArray, double[][] dArray, double[] dArray2, double[] dArray3, Color color, boolean bl, String string2, String string3, int n, String string4, char c, boolean bl2, boolean bl3, HashMap hashMap) throws IOException {
        int n2;
        String[] stringArray2;
        int n3;
        int n4;
        HashMap hashMap2 = StateAnalysis.makeLabelMapping(string4);
        double d = 0.0;
        for (int i = 0; i < dArray2.length; ++i) {
            d += dArray2[i];
        }
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(5);
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumFractionDigits(5);
        NumberFormat numberFormat2 = NumberFormat.getInstance();
        numberFormat2.setMaximumFractionDigits(10);
        numberFormat2.setGroupingUsed(false);
        numberFormat2.setMinimumFractionDigits(10);
        System.out.println("Writing to file " + string + ".txt");
        PrintWriter printWriter = new PrintWriter(new FileWriter(string + ".txt"));
        printWriter.print("State (" + string2 + " order)\tGenome %");
        for (int i = 0; i < stringArray.length; ++i) {
            printWriter.print("\t" + stringArray[i]);
        }
        printWriter.println();
        double[][] dArray4 = bl ? new double[dArray[0].length][dArray.length + 1] : new double[dArray[0].length][dArray.length];
        int n5 = 0;
        for (n4 = 0; n4 < dArray[0].length; ++n4) {
            if (dArray2[n4] > 0.0) {
                if (bl3) {
                    printWriter.print(hashMap.get("" + n4));
                } else {
                    printWriter.print(n4 + n);
                    String string5 = (String)hashMap2.get("" + c + (n4 + n));
                    if (string5 != null) {
                        printWriter.print("_" + string5);
                    }
                }
                if (bl) {
                    dArray4[n4][0] = 100.0 * (dArray2[n4] / d);
                    printWriter.print("\t" + numberFormat.format(dArray4[n4][0]));
                }
                for (n3 = 0; n3 < dArray.length; ++n3) {
                    double d2 = dArray[n3][n4] / dArray3[n3] / (dArray2[n4] / d);
                    if (bl) {
                        dArray4[n4][n3 + 1] = d2;
                    } else {
                        dArray4[n4][n3] = d2;
                    }
                    printWriter.print("\t" + numberFormat.format(d2));
                }
                printWriter.println();
                continue;
            }
            ++n5;
        }
        printWriter.print("Base\t100");
        for (n4 = 0; n4 < dArray.length; ++n4) {
            printWriter.print("\t" + numberFormat2.format(100.0 * (dArray3[n4] / d)));
        }
        printWriter.println();
        printWriter.close();
        if (n5 > 0) {
            double[][] dArray5 = new double[dArray4.length - n5][dArray4[0].length];
            stringArray2 = new String[dArray5.length];
            int n6 = 0;
            for (n2 = 0; n2 < dArray[0].length; ++n2) {
                if (!(dArray2[n2] > 0.0)) continue;
                for (int i = 0; i < dArray4[n2].length; ++i) {
                    dArray5[n6][i] = dArray4[n2][i];
                }
                stringArray2[n6] = bl3 ? (String)hashMap.get("" + n2) : "" + (n2 + n);
                ++n6;
            }
            dArray4 = dArray5;
        } else {
            stringArray2 = new String[dArray[0].length];
            if (bl3) {
                for (n3 = 0; n3 < stringArray2.length; ++n3) {
                    stringArray2[n3] = (String)hashMap.get("" + n3);
                }
            } else {
                for (n3 = 0; n3 < stringArray2.length; ++n3) {
                    stringArray2[n3] = "" + (n3 + n);
                }
            }
        }
        if (!bl3) {
            for (int i = 0; i < stringArray2.length; ++i) {
                String string6 = (String)hashMap2.get("" + c + stringArray2[i]);
                if (string6 == null) continue;
                stringArray2[i] = stringArray2[i] + "_" + string6;
            }
        }
        if (bl) {
            for (int i = 0; i < dArray4[0].length; ++i) {
                int n7;
                double d3 = Double.NEGATIVE_INFINITY;
                double d4 = Double.POSITIVE_INFINITY;
                for (n7 = 0; n7 < dArray4.length; ++n7) {
                    if (dArray4[n7][i] > d3) {
                        d3 = dArray4[n7][i];
                    }
                    if (!(dArray4[n7][i] < d4)) continue;
                    d4 = dArray4[n7][i];
                }
                for (n7 = 0; n7 < dArray4.length; ++n7) {
                    dArray4[n7][i] = (dArray4[n7][i] - d4) / d3;
                }
            }
        }
        String[] stringArray3 = new String[dArray4[0].length];
        if (bl) {
            stringArray3[0] = "Genome %";
        }
        for (int i = 0; i < stringArray.length; ++i) {
            n2 = stringArray[i].indexOf(46);
            if (n2 == -1) {
                if (bl) {
                    stringArray3[i + 1] = stringArray[i];
                    continue;
                }
                stringArray3[i] = stringArray[i];
                continue;
            }
            String string7 = stringArray[i].substring(0, n2);
            if (bl) {
                stringArray3[i + 1] = string7;
                continue;
            }
            stringArray3[i] = string7;
        }
        if (bl2) {
            StateAnalysis.makeEnrichmentHeatMap(dArray4, stringArray3, stringArray2, string, color, string3, "Category", "State (" + string2 + " order)");
        }
    }

    private static RecAnchorIndex getAnchorIndex(String string, boolean bl, boolean bl2) {
        int n = 0;
        int n2 = 1;
        int n3 = 2;
        int n4 = 3;
        if (bl && bl2) {
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                n = Integer.parseInt(stringTokenizer.nextToken().trim());
                n2 = Integer.parseInt(stringTokenizer.nextToken().trim());
                n3 = Integer.parseInt(stringTokenizer.nextToken().trim());
                n4 = Integer.parseInt(stringTokenizer.nextToken().trim());
            }
        } else if (bl && !bl2) {
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                n = Integer.parseInt(stringTokenizer.nextToken().trim());
                n2 = Integer.parseInt(stringTokenizer.nextToken().trim());
                n3 = Integer.parseInt(stringTokenizer.nextToken().trim());
            }
        } else if (!bl && bl2) {
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                n = Integer.parseInt(stringTokenizer.nextToken().trim());
                n2 = Integer.parseInt(stringTokenizer.nextToken().trim());
                n4 = Integer.parseInt(stringTokenizer.nextToken().trim());
            } else {
                n4 = 2;
            }
        } else if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            n = Integer.parseInt(stringTokenizer.nextToken().trim());
            n2 = Integer.parseInt(stringTokenizer.nextToken().trim());
        }
        return new RecAnchorIndex(n, n2, n3, n4);
    }

    public static void neighborhoodMaxLowMem(String string, String string2, int n, int n2, int n3, int n4, boolean bl, boolean bl2, String string3, int n5, String string4, Color color, String string5, String string6, boolean bl3, boolean bl4) throws IOException {
        int n6;
        Object object;
        Object object2;
        String string7;
        boolean bl5 = false;
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        HashMap<double[], Integer> hashMap = new HashMap<double[], Integer>();
        HashMap<double[], Integer> hashMap2 = new HashMap<double[], Integer>();
        HashMap<String, Short> hashMap3 = new HashMap<String, Short>();
        HashMap<String, String> hashMap4 = new HashMap<String, String>();
        int n7 = 0;
        String string8 = "";
        BufferedReader bufferedReader = Util.getBufferedReader(string);
        boolean bl6 = false;
        int n8 = 1 + n2 + n3;
        while ((string7 = bufferedReader.readLine()) != null) {
            object2 = bl4 ? new StringTokenizer(string7, "\t") : new StringTokenizer(string7, "\t ");
            object = ((StringTokenizer)object2).nextToken().trim();
            ((StringTokenizer)object2).nextToken().trim();
            int n9 = (Integer.parseInt(((StringTokenizer)object2).nextToken().trim()) - 1) / n;
            string8 = ((StringTokenizer)object2).nextToken().trim();
            if (bl4) {
                Object object3;
                block45: {
                    int n10 = string8.indexOf("_");
                    if (n10 >= 0) {
                        object3 = string8.substring(0, n10);
                        try {
                            n6 = Short.parseShort((String)object3);
                            if (n6 > n7) {
                                n7 = n6;
                            }
                            bl6 = true;
                            hashMap3.put(string8, (short)n6);
                            hashMap4.put("" + n6, string8);
                        }
                        catch (NumberFormatException numberFormatException) {
                            try {
                                n6 = Short.parseShort(((String)object3).substring(1));
                                if (n6 > n7) {
                                    n7 = n6;
                                }
                                bl6 = true;
                                hashMap3.put(string8, (short)n6);
                                hashMap4.put("" + n6, string8);
                            }
                            catch (NumberFormatException numberFormatException2) {
                                if (!bl6) break block45;
                                throw new IllegalArgumentException("Not a valid ID before '_' in " + string8 + ", while valid ID found for other entries");
                            }
                        }
                    }
                }
                if (!bl6 && (object3 = (Short)hashMap3.get(string8)) == null) {
                    n7 = hashMap3.size() + 1;
                    n6 = (short)n7;
                    hashMap3.put(string8, (short)n6);
                    hashMap4.put("" + n7, string8);
                }
            } else {
                try {
                    n6 = Short.parseShort(string8);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        n6 = Short.parseShort(string8.substring(1));
                    }
                    catch (NumberFormatException numberFormatException3) {
                        throw new IllegalArgumentException("In fourth column neither state number or ID found in segmentation file. Use '-labels' option to run overlap enrichment treating fourth column as labels");
                    }
                }
                if (n6 > n7) {
                    n7 = n6;
                }
            }
            Integer n11 = (Integer)hashMap.get(object);
            if (n11 == null) {
                hashMap.put((double[])object, n9);
                hashMap2.put((double[])object, hashMap2.size());
                arrayList.add((double[])object);
                continue;
            }
            int n12 = n11;
            if (n12 >= n9) continue;
            hashMap.put((double[])object, n9);
        }
        bufferedReader.close();
        object2 = new double[n8][n7 + 1];
        object = new double[n8];
        double[] dArray = new double[n7 + 1];
        n6 = arrayList.size();
        for (int i = 0; i < n6; ++i) {
            int n13;
            int n14;
            Object object4;
            bufferedReader = Util.getBufferedReader(string);
            String string9 = (String)arrayList.get(i);
            int n15 = (Integer)hashMap.get(arrayList.get(i)) + 1;
            short[] sArray = new short[n15];
            for (int j = 0; j < n15; ++j) {
                sArray[j] = -1;
            }
            while ((string7 = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = bl4 ? new StringTokenizer(string7, "\t") : new StringTokenizer(string7, "\t ");
                object4 = stringTokenizer.nextToken().trim();
                if (!string9.equals(object4)) continue;
                bl5 = true;
                int n16 = Integer.parseInt(stringTokenizer.nextToken().trim()) / n;
                int n17 = (Integer.parseInt(stringTokenizer.nextToken().trim()) - 1) / n;
                string8 = stringTokenizer.nextToken().trim();
                n14 = -1;
                if (bl4) {
                    Object object5;
                    block46: {
                        n13 = string8.indexOf("_");
                        if (n13 >= 0) {
                            object5 = string8.substring(0, n13);
                            try {
                                n14 = Short.parseShort((String)object5);
                                bl6 = true;
                            }
                            catch (NumberFormatException numberFormatException) {
                                try {
                                    n14 = Short.parseShort(((String)object5).substring(1));
                                    bl6 = true;
                                }
                                catch (NumberFormatException numberFormatException4) {
                                    if (!bl6) break block46;
                                    throw new IllegalArgumentException("Not a valid ID before '_' in " + string8 + ", while valid ID found for other entries");
                                }
                            }
                        }
                    }
                    if (!bl6) {
                        object5 = (Short)hashMap3.get(string8);
                        n14 = ((Short)object5).shortValue();
                    }
                } else {
                    try {
                        n14 = Short.parseShort(string8);
                    }
                    catch (NumberFormatException numberFormatException) {
                        try {
                            n14 = Short.parseShort(string8.substring(1));
                        }
                        catch (NumberFormatException numberFormatException5) {
                            throw new IllegalArgumentException("In fourth column neither state number or ID found in segmentation file. Use '-labels' option to run overlap enrichment treating fourth column as labels");
                        }
                    }
                }
                for (n13 = n16; n13 <= n17; ++n13) {
                    sArray[n13] = n14;
                }
                if (n14 < 0) continue;
                int n18 = n14;
                dArray[n18] = dArray[n18] + (double)(n17 - n16 + 1);
            }
            bufferedReader.close();
            RecAnchorIndex recAnchorIndex = StateAnalysis.getAnchorIndex(string3, bl, bl2);
            object4 = Util.getBufferedReader(string2);
            while ((string7 = ((BufferedReader)object4).readLine()) != null) {
                int n19;
                int n20;
                int n21;
                String[] stringArray;
                String string10;
                if (string7.trim().equals("") || !(string10 = (stringArray = string7.split("\\s+"))[recAnchorIndex.nchromindex]).equals(string9)) continue;
                n14 = Integer.parseInt(stringArray[recAnchorIndex.npositionindex]) - n5;
                n13 = 1;
                if (bl) {
                    String string11 = stringArray[recAnchorIndex.nstrandindex];
                    if (string11.equals("+")) {
                        n13 = 1;
                    } else if (string11.equals("-")) {
                        n13 = 0;
                    } else {
                        throw new IllegalArgumentException(string11 + " is an invalid strand. Strand should be '+' or '-'");
                    }
                }
                double d = bl2 && recAnchorIndex.nsignalindex < stringArray.length ? Double.parseDouble(stringArray[recAnchorIndex.nsignalindex]) : 1.0;
                if (n13 != 0) {
                    n21 = 0;
                    for (n20 = -n2; n20 <= n3; ++n20) {
                        n19 = (n14 + n4 * n20) / n;
                        if (n19 >= 0 && n19 < sArray.length && sArray[n19] >= 0) {
                            Object object6 = object2[n21];
                            short s = sArray[n19];
                            object6[s] = object6[s] + d;
                        }
                        ++n21;
                    }
                    continue;
                }
                n21 = 0;
                for (n20 = n3; n20 >= -n2; --n20) {
                    n19 = (n14 + n4 * n20) / n;
                    if (n19 >= 0 && n19 < sArray.length && sArray[n19] >= 0) {
                        Object object7 = object2[n21];
                        short s = sArray[n19];
                        object7[s] = object7[s] + d;
                    }
                    ++n21;
                }
            }
            ((BufferedReader)object4).close();
        }
        if (!bl5) {
            throw new IllegalArgumentException("No chromosome name matches found between " + string2 + " and those in the segmentation file.");
        }
        StateAnalysis.outputneighborhood((double[][])object2, dArray, object, string4, n4, n3, n2, color, ChromHMM.convertCharOrderToStringOrder(string8.charAt(0)), string5, 0, string6, string8.charAt(0), bl3, bl4, hashMap4);
    }

    public static void neighborhoodMax(String string, String string2, int n, int n2, int n3, int n4, boolean bl, boolean bl2, String string3, int n5, String string4, Color color, String string5, String string6, boolean bl3, boolean bl4) throws IOException {
        int n6;
        Object object;
        int n7;
        int n8;
        int n9;
        Object object2;
        String string7;
        boolean bl5 = false;
        ArrayList<SegmentRec> arrayList = new ArrayList<SegmentRec>();
        ArrayList<short[][]> arrayList2 = new ArrayList<short[][]>();
        HashMap<short[][], Integer> hashMap = new HashMap<short[][], Integer>();
        HashMap<short[][], Integer> hashMap2 = new HashMap<short[][], Integer>();
        HashMap<String, Short> hashMap3 = new HashMap<String, Short>();
        HashMap<String, String> hashMap4 = new HashMap<String, String>();
        short s = 0;
        String string8 = "";
        boolean bl6 = false;
        BufferedReader bufferedReader = Util.getBufferedReader(string);
        while ((string7 = bufferedReader.readLine()) != null) {
            StringTokenizer stringTokenizer = bl4 ? new StringTokenizer(string7, "\t") : new StringTokenizer(string7, "\t ");
            object2 = stringTokenizer.nextToken().trim();
            n9 = Integer.parseInt(stringTokenizer.nextToken().trim()) / n;
            n8 = (Integer.parseInt(stringTokenizer.nextToken().trim()) - 1) / n;
            string8 = stringTokenizer.nextToken().trim();
            short s2 = -1;
            if (bl4) {
                Object object3;
                block35: {
                    int n10 = string8.indexOf("_");
                    if (n10 >= 0) {
                        object3 = string8.substring(0, n10);
                        try {
                            s2 = Short.parseShort((String)object3);
                            if (s2 > s) {
                                s = s2;
                            }
                            bl6 = true;
                            hashMap3.put(string8, s2);
                            hashMap4.put("" + s2, string8);
                        }
                        catch (NumberFormatException numberFormatException) {
                            try {
                                s2 = Short.parseShort(((String)object3).substring(1));
                                if (s2 > s) {
                                    s = s2;
                                }
                                bl6 = true;
                                hashMap3.put(string8, s2);
                                hashMap4.put("" + s2, string8);
                            }
                            catch (NumberFormatException numberFormatException2) {
                                if (!bl6) break block35;
                                throw new IllegalArgumentException("Not a valid ID before '_' in " + string8 + ", while valid ID found for other entries");
                            }
                        }
                    }
                }
                if (!bl6) {
                    object3 = (Short)hashMap3.get(string8);
                    if (object3 == null) {
                        s = hashMap3.size() + 1;
                        s2 = s;
                        hashMap3.put(string8, s2);
                        hashMap4.put("" + s, string8);
                    } else {
                        s2 = (Short)object3;
                    }
                }
                arrayList.add(new SegmentRec((String)object2, n9, n8, s2));
            } else {
                try {
                    s2 = Short.parseShort(string8);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        s2 = Short.parseShort(string8.substring(1));
                    }
                    catch (NumberFormatException numberFormatException3) {
                        throw new IllegalArgumentException("In fourth column neither state number or ID found in segmentation file. Use '-labels' option to run overlap enrichment treating fourth column as labels");
                    }
                }
                arrayList.add(new SegmentRec((String)object2, n9, n8, s2));
                if (s2 > s) {
                    s = s2;
                }
            }
            Integer n11 = (Integer)hashMap.get(object2);
            if (n11 == null) {
                hashMap.put((short[][])object2, n8);
                hashMap2.put((short[][])object2, hashMap2.size());
                arrayList2.add((short[][])object2);
                continue;
            }
            int n12 = n11;
            if (n12 >= n8) continue;
            hashMap.put((short[][])object2, n8);
        }
        bufferedReader.close();
        int n13 = arrayList2.size();
        object2 = new short[n13][];
        for (n9 = 0; n9 < n13; ++n9) {
            n8 = (Integer)hashMap.get(arrayList2.get(n9)) + 1;
            object2[n9] = new short[n8];
            short[] sArray = object2[n9];
            for (int i = 0; i < n8; ++i) {
                sArray[i] = -1;
            }
        }
        double[] dArray = new double[s + 1];
        n8 = arrayList.size();
        for (n7 = 0; n7 < n8; ++n7) {
            SegmentRec segmentRec = (SegmentRec)arrayList.get(n7);
            int n14 = (Integer)hashMap2.get(segmentRec.szchrom);
            object = object2[n14];
            int n15 = segmentRec.nbegin;
            int n16 = segmentRec.nend;
            short s3 = segmentRec.slabel;
            for (n6 = n15; n6 <= n16; ++n6) {
                object[n6] = s3;
                if (s3 < 0) continue;
                short s4 = s3;
                dArray[s4] = dArray[s4] + 1.0;
            }
        }
        n7 = 1 + n2 + n3;
        double[][] dArray2 = new double[n7][s + 1];
        double[] dArray3 = new double[n7];
        object = StateAnalysis.getAnchorIndex(string3, bl, bl2);
        BufferedReader bufferedReader2 = Util.getBufferedReader(string2);
        while ((string7 = bufferedReader2.readLine()) != null) {
            int n17;
            int n18;
            int n19;
            if (string7.trim().equals("")) continue;
            String[] stringArray = string7.split("\\s+");
            String string9 = stringArray[object.nchromindex];
            n6 = Integer.parseInt(stringArray[object.npositionindex]) - n5;
            boolean bl7 = true;
            if (bl) {
                String string10 = stringArray[object.nstrandindex];
                if (string10.equals("+")) {
                    bl7 = true;
                } else if (string10.equals("-")) {
                    bl7 = false;
                } else {
                    throw new IllegalArgumentException(string10 + " is an invalid strand. Strand should be '+' or '-'");
                }
            }
            double d = bl2 && object.nsignalindex < stringArray.length ? Double.parseDouble(stringArray[object.nsignalindex]) : 1.0;
            Integer n20 = (Integer)hashMap2.get(string9);
            if (n20 == null) continue;
            int n21 = n20;
            short[] sArray = object2[n21];
            bl5 = true;
            if (bl7) {
                n19 = 0;
                for (n18 = -n2; n18 <= n3; ++n18) {
                    n17 = (n6 + n4 * n18) / n;
                    if (n17 >= 0 && n17 < sArray.length && sArray[n17] >= 0) {
                        double[] dArray4 = dArray2[n19];
                        short s5 = sArray[n17];
                        dArray4[s5] = dArray4[s5] + d;
                    }
                    ++n19;
                }
                continue;
            }
            n19 = 0;
            for (n18 = n3; n18 >= -n2; --n18) {
                n17 = (n6 + n4 * n18) / n;
                if (n17 >= 0 && n17 < sArray.length && sArray[n17] >= 0) {
                    double[] dArray5 = dArray2[n19];
                    short s6 = sArray[n17];
                    dArray5[s6] = dArray5[s6] + d;
                }
                ++n19;
            }
        }
        bufferedReader2.close();
        if (!bl5) {
            throw new IllegalArgumentException("No chromosome name matches found between " + string2 + " and those in the segmentation file.");
        }
        StateAnalysis.outputneighborhood(dArray2, dArray, dArray3, string4, n4, n3, n2, color, ChromHMM.convertCharOrderToStringOrder(string8.charAt(0)), string5, 0, string6, string8.charAt(0), bl3, bl4, hashMap4);
    }

    public static void neighborhoodSignal(String string, String string2, String string3, int n, int n2, int n3, int n4, boolean bl, boolean bl2, String string4, int n5, String string5, Color color, String string6, String string7, boolean bl3) throws IOException {
        boolean bl4 = false;
        File file = new File(string);
        if (!file.exists()) {
            throw new IllegalArgumentException(string + " was not found!");
        }
        String[] stringArray = file.list();
        int n6 = 0;
        int n7 = 0;
        char c = '0';
        int n8 = 0;
        boolean bl5 = true;
        int n9 = 1 + n2 + n3;
        double[][] dArray = null;
        double[] dArray2 = null;
        double[] dArray3 = new double[n9];
        String string8 = "";
        boolean bl6 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            float[] fArray;
            String string9 = stringArray[i];
            if (!string9.contains("_signal") || new File(string9).isHidden()) continue;
            BufferedReader bufferedReader = Util.getBufferedReader(string + "/" + string9);
            String string10 = bufferedReader.readLine();
            if (string10 == null) {
                throw new IllegalArgumentException(string + "/" + string9 + " is empty!");
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string10, "\t");
            String string11 = stringTokenizer.nextToken().trim();
            if (!string11.equals(string2) && !string2.equals("")) {
                bufferedReader.close();
                continue;
            }
            bl6 = true;
            String string12 = stringTokenizer.nextToken().trim();
            int n10 = 0;
            string10 = bufferedReader.readLine();
            if (string10 == null) {
                throw new IllegalArgumentException(string + "/" + string9 + " only has one line!");
            }
            stringTokenizer = new StringTokenizer(string10, "\t");
            int n11 = stringTokenizer.countTokens();
            if (bl5) {
                c = stringTokenizer.nextToken().trim().charAt(0);
                bl5 = false;
                n8 = i;
                n7 = n11;
                dArray2 = new double[n7];
                dArray = new double[n9][n7];
            } else if (n7 != n11) {
                throw new IllegalArgumentException("Number of states " + n11 + " in " + string9 + " does not match number of states " + n7 + " in " + stringArray[n8]);
            }
            while ((string10 = bufferedReader.readLine()) != null) {
                ++n10;
            }
            bufferedReader.close();
            n6 += n10;
            float[][] fArray2 = new float[n10][n7];
            bufferedReader = Util.getBufferedReader(string + "/" + string9);
            int n12 = 0;
            bufferedReader.readLine();
            string8 = bufferedReader.readLine();
            while ((string10 = bufferedReader.readLine()) != null) {
                stringTokenizer = new StringTokenizer(string10, "\t ");
                fArray = fArray2[n12];
                int n13 = 0;
                while (n13 < n7) {
                    float f;
                    fArray[n13] = f = Float.parseFloat(stringTokenizer.nextToken());
                    int n14 = n13++;
                    dArray2[n14] = dArray2[n14] + (double)f;
                }
                ++n12;
            }
            bufferedReader.close();
            fArray = null;
            BufferedReader bufferedReader2 = Util.getBufferedReader(string3);
            RecAnchorIndex recAnchorIndex = StateAnalysis.getAnchorIndex(string4, bl, bl2);
            while ((string10 = bufferedReader2.readLine()) != null) {
                int n15;
                double[] dArray4;
                float[] fArray3;
                int n16;
                int n17;
                int n18;
                String[] stringArray2;
                String string13;
                if (string10.trim().equals("") || !(string13 = (stringArray2 = string10.split("\\s+"))[recAnchorIndex.nchromindex]).equals(string12)) continue;
                bl4 = true;
                int n19 = Integer.parseInt(stringArray2[recAnchorIndex.npositionindex]) - n5;
                boolean bl7 = true;
                if (bl) {
                    String string14 = stringArray2[recAnchorIndex.nstrandindex];
                    if (string14.equals("+")) {
                        bl7 = true;
                    } else if (string14.equals("-")) {
                        bl7 = false;
                    } else {
                        throw new IllegalArgumentException(string14 + " is an valid strand. Strand should be '+' or '-'");
                    }
                }
                double d = bl2 && recAnchorIndex.nsignalindex < stringArray2.length ? Double.parseDouble(stringArray2[recAnchorIndex.nsignalindex]) : 1.0;
                if (bl7) {
                    n18 = 0;
                    for (n17 = -n2; n17 <= n3; ++n17) {
                        n16 = (n19 + n4 * n17) / n;
                        if (n16 >= 0 && n16 < fArray2.length) {
                            fArray3 = fArray2[n16];
                            dArray4 = dArray[n18];
                            for (n15 = 0; n15 < n7; ++n15) {
                                int n20 = n15;
                                dArray4[n20] = dArray4[n20] + d * (double)fArray3[n15];
                            }
                            int n21 = n18;
                            dArray3[n21] = dArray3[n21] + 1.0;
                        }
                        ++n18;
                    }
                    continue;
                }
                n18 = 0;
                for (n17 = n3; n17 >= -n2; --n17) {
                    n16 = (n19 + n4 * n17) / n;
                    if (n16 >= 0 && n16 < fArray2.length) {
                        fArray3 = fArray2[n16];
                        dArray4 = dArray[n18];
                        for (n15 = 0; n15 < n7; ++n15) {
                            int n22 = n15;
                            dArray4[n22] = dArray4[n22] + d * (double)fArray3[n15];
                        }
                        int n23 = n18;
                        dArray3[n23] = dArray3[n23] + 1.0;
                    }
                    ++n18;
                }
            }
            bufferedReader2.close();
        }
        if (!bl6) {
            throw new IllegalArgumentException("No posterior file found for cell type " + string2);
        }
        if (!bl4) {
            throw new IllegalArgumentException("No chromosome name matches found between " + string3 + " and those in the segmentation file.");
        }
        StateAnalysis.outputneighborhoodsignal(dArray, dArray2, dArray3, n6, string5, n4, n3, n2, color, ChromHMM.convertCharOrderToStringOrder(c), string6, string8, string7, c, bl3);
    }

    public static void neighborhoodPosterior(String string, String string2, String string3, int n, int n2, int n3, int n4, boolean bl, boolean bl2, String string4, int n5, String string5, Color color, String string6, String string7, boolean bl3) throws IOException {
        boolean bl4 = false;
        File file = new File(string);
        if (!file.exists()) {
            throw new IllegalArgumentException(string + " was not found!");
        }
        String[] stringArray = file.list();
        int n6 = 0;
        char c = '0';
        int n7 = 0;
        boolean bl5 = true;
        int n8 = 1 + n2 + n3;
        double[][] dArray = null;
        double[] dArray2 = null;
        double[] dArray3 = new double[n8];
        boolean bl6 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            float[] fArray;
            String string8 = stringArray[i];
            if (!string8.contains("_posterior") || new File(string8).isHidden()) continue;
            BufferedReader bufferedReader = Util.getBufferedReader(string + "/" + string8);
            String string9 = bufferedReader.readLine();
            if (string9 == null) {
                throw new IllegalArgumentException(string + "/" + string8 + " is empty!");
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string9, "\t");
            String string10 = stringTokenizer.nextToken().trim();
            if (!string10.equals(string2) && !string2.equals("")) {
                bufferedReader.close();
                continue;
            }
            bl6 = true;
            String string11 = stringTokenizer.nextToken().trim();
            int n9 = 0;
            string9 = bufferedReader.readLine();
            if (string9 == null) {
                throw new IllegalArgumentException(string + "/" + string8 + " only has one line!");
            }
            stringTokenizer = new StringTokenizer(string9, "\t");
            int n10 = stringTokenizer.countTokens();
            if (bl5) {
                c = stringTokenizer.nextToken().trim().charAt(0);
                bl5 = false;
                n7 = i;
                n6 = n10;
                dArray2 = new double[n6];
                dArray = new double[n8][n6];
            } else if (n6 != n10) {
                throw new IllegalArgumentException("Number of states " + n10 + " in " + string8 + " does not match number of states " + n6 + " in " + stringArray[n7]);
            }
            while ((string9 = bufferedReader.readLine()) != null) {
                ++n9;
            }
            bufferedReader.close();
            float[][] fArray2 = new float[n9][n6];
            bufferedReader = Util.getBufferedReader(string + "/" + string8);
            int n11 = 0;
            bufferedReader.readLine();
            bufferedReader.readLine();
            while ((string9 = bufferedReader.readLine()) != null) {
                stringTokenizer = new StringTokenizer(string9, "\t ");
                fArray = fArray2[n11];
                int n12 = 0;
                while (n12 < n6) {
                    float f;
                    fArray[n12] = f = Float.parseFloat(stringTokenizer.nextToken());
                    int n13 = n12++;
                    dArray2[n13] = dArray2[n13] + (double)f;
                }
                ++n11;
            }
            bufferedReader.close();
            fArray = null;
            BufferedReader bufferedReader2 = Util.getBufferedReader(string3);
            RecAnchorIndex recAnchorIndex = StateAnalysis.getAnchorIndex(string4, bl, bl2);
            while ((string9 = bufferedReader2.readLine()) != null) {
                int n14;
                double[] dArray4;
                float[] fArray3;
                int n15;
                int n16;
                int n17;
                String[] stringArray2;
                String string12;
                if (string9.trim().equals("") || !(string12 = (stringArray2 = string9.split("\\s+"))[recAnchorIndex.nchromindex]).equals(string11)) continue;
                bl4 = true;
                int n18 = Integer.parseInt(stringArray2[recAnchorIndex.npositionindex]) - n5;
                boolean bl7 = true;
                if (bl) {
                    String string13 = stringArray2[recAnchorIndex.nstrandindex];
                    if (string13.equals("+")) {
                        bl7 = true;
                    } else if (string13.equals("-")) {
                        bl7 = false;
                    } else {
                        throw new IllegalArgumentException(string13 + " is an valid strand. Strand should be '+' or '-'");
                    }
                }
                double d = bl2 && recAnchorIndex.nsignalindex < stringArray2.length ? Double.parseDouble(stringArray2[recAnchorIndex.nsignalindex]) : 1.0;
                if (bl7) {
                    n17 = 0;
                    for (n16 = -n2; n16 <= n3; ++n16) {
                        n15 = (n18 + n4 * n16) / n;
                        if (n15 >= 0 && n15 < fArray2.length) {
                            fArray3 = fArray2[n15];
                            dArray4 = dArray[n17];
                            for (n14 = 0; n14 < n6; ++n14) {
                                int n19 = n14;
                                dArray4[n19] = dArray4[n19] + d * (double)fArray3[n14];
                            }
                        }
                        ++n17;
                    }
                    continue;
                }
                n17 = 0;
                for (n16 = n3; n16 >= -n2; --n16) {
                    n15 = (n18 + n4 * n16) / n;
                    if (n15 >= 0 && n15 < fArray2.length) {
                        fArray3 = fArray2[n15];
                        dArray4 = dArray[n17];
                        for (n14 = 0; n14 < n6; ++n14) {
                            int n20 = n14;
                            dArray4[n20] = dArray4[n20] + d * (double)fArray3[n14];
                        }
                    }
                    ++n17;
                }
            }
            bufferedReader2.close();
        }
        if (!bl6) {
            throw new IllegalArgumentException("No posterior file found for cell type " + string2);
        }
        if (!bl4) {
            throw new IllegalArgumentException("No chromosome name matches found between " + string3 + " and those in the segmentation file.");
        }
        StateAnalysis.outputneighborhood(dArray, dArray2, dArray3, string5, n4, n3, n2, color, ChromHMM.convertCharOrderToStringOrder(c), string6, 1, string7, c, bl3, false, null);
    }

    private static void outputneighborhoodsignal(double[][] dArray, double[] dArray2, double[] dArray3, double d, String string, int n, int n2, int n3, Color color, String string2, String string3, String string4, String string5, char c, boolean bl) throws IOException {
        int n4;
        String[] stringArray;
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(5);
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumFractionDigits(5);
        HashMap hashMap = StateAnalysis.makeLabelMapping(string5);
        String[] stringArray2 = new String[dArray.length];
        System.out.println("Writing to file " + string + ".txt");
        PrintWriter printWriter = new PrintWriter(new FileWriter(string + ".txt"));
        int n5 = 0;
        printWriter.print("State (" + string2 + " order)");
        for (int i = -n * n3; i <= n * n2; i += n) {
            printWriter.print("\t" + i);
            stringArray2[n5] = "" + i;
            ++n5;
        }
        printWriter.println();
        double[][] dArray4 = new double[dArray[0].length][dArray.length];
        int n6 = 0;
        for (int i = 0; i < dArray[0].length; ++i) {
            if (dArray2[i] > 0.0) {
                printWriter.print(i + 1);
                stringArray = (String)hashMap.get("" + c + (i + 1));
                if (stringArray != null) {
                    printWriter.print("_" + (String)stringArray);
                }
                for (n4 = 0; n4 < dArray.length; ++n4) {
                    double d2;
                    dArray4[i][n4] = d2 = dArray[n4][i] / dArray3[n4] / (dArray2[i] / d);
                    printWriter.print("\t" + numberFormat.format(d2));
                }
                printWriter.println();
                continue;
            }
            ++n6;
        }
        printWriter.close();
        StringTokenizer stringTokenizer = new StringTokenizer(string4, "\t");
        if (n6 > 0) {
            double[][] dArray5 = new double[dArray4.length - n6][dArray4[0].length];
            stringArray = new String[dArray5.length];
            int n7 = 0;
            for (int i = 0; i < dArray[0].length; ++i) {
                if (dArray2[i] > 0.0) {
                    for (int j = 0; j < dArray4[i].length; ++j) {
                        dArray5[n7][j] = dArray4[i][j];
                    }
                    stringArray[n7] = stringTokenizer.nextToken().trim();
                    ++n7;
                    continue;
                }
                stringTokenizer.nextToken();
            }
            dArray4 = dArray5;
        } else {
            stringArray = new String[dArray[0].length];
            for (n4 = 0; n4 < stringArray.length; ++n4) {
                stringArray[n4] = "" + stringTokenizer.nextToken().trim();
            }
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string6 = (String)hashMap.get("" + c + stringArray[i]);
            if (string6 == null) continue;
            stringArray[i] = stringArray[i] + "_" + string6;
        }
        if (bl) {
            StateAnalysis.makeEnrichmentHeatMap(dArray4, stringArray2, stringArray, string, color, string3, "Position", "State (" + string2 + " order)");
        }
    }

    private static void outputneighborhood(double[][] dArray, double[] dArray2, double[] dArray3, String string, int n, int n2, int n3, Color color, String string2, String string3, int n4, String string4, char c, boolean bl, boolean bl2, HashMap hashMap) throws IOException {
        String[] stringArray;
        int n5;
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(5);
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumFractionDigits(5);
        HashMap hashMap2 = StateAnalysis.makeLabelMapping(string4);
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                int n6 = i;
                dArray3[n6] = dArray3[n6] + dArray[i][j];
            }
        }
        double d = 0.0;
        for (int i = 0; i < dArray2.length; ++i) {
            d += dArray2[i];
        }
        String[] stringArray2 = new String[dArray.length];
        System.out.println("Writing to file " + string + ".txt");
        PrintWriter printWriter = new PrintWriter(new FileWriter(string + ".txt"));
        int n7 = 0;
        printWriter.print("State (" + string2 + " order)");
        for (int i = -n * n3; i <= n * n2; i += n) {
            printWriter.print("\t" + i);
            stringArray2[n7] = "" + i;
            ++n7;
        }
        printWriter.println();
        double[][] dArray4 = new double[dArray[0].length][dArray.length];
        int n8 = 0;
        for (int i = 0; i < dArray[0].length; ++i) {
            if (dArray2[i] > 0.0) {
                if (bl2) {
                    printWriter.print(hashMap.get("" + i));
                } else {
                    printWriter.print(i + n4);
                    String string5 = (String)hashMap2.get("" + c + (i + n4));
                    if (string5 != null) {
                        printWriter.print("_" + string5);
                    }
                }
                for (n5 = 0; n5 < dArray.length; ++n5) {
                    double d2;
                    dArray4[i][n5] = d2 = dArray[n5][i] / dArray3[n5] / (dArray2[i] / d);
                    printWriter.print("\t" + numberFormat.format(d2));
                }
                printWriter.println();
                continue;
            }
            ++n8;
        }
        printWriter.close();
        if (n8 > 0) {
            double[][] dArray5 = new double[dArray4.length - n8][dArray4[0].length];
            stringArray = new String[dArray5.length];
            int n9 = 0;
            for (int i = 0; i < dArray[0].length; ++i) {
                if (!(dArray2[i] > 0.0)) continue;
                for (int j = 0; j < dArray4[i].length; ++j) {
                    dArray5[n9][j] = dArray4[i][j];
                }
                stringArray[n9] = bl2 ? (String)hashMap.get("" + i) : "" + (i + n4);
                ++n9;
            }
            dArray4 = dArray5;
        } else {
            stringArray = new String[dArray[0].length];
            if (bl2) {
                for (n5 = 0; n5 < stringArray.length; ++n5) {
                    stringArray[n5] = (String)hashMap.get("" + n5);
                }
            } else {
                for (n5 = 0; n5 < stringArray.length; ++n5) {
                    stringArray[n5] = "" + (n5 + n4);
                }
            }
        }
        if (!bl2) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string6 = (String)hashMap2.get(c + stringArray[i]);
                if (string6 == null) continue;
                stringArray[i] = stringArray[i] + "_" + string6;
            }
        }
        if (bl) {
            StateAnalysis.makeEnrichmentHeatMap(dArray4, stringArray2, stringArray, string, color, string3, "Position", "State (" + string2 + " order)");
        }
    }

    public static void makeModelEmissionCompare(String string, String string2, String string3, Color color, boolean bl) throws IOException {
        int n;
        Object object;
        int n2;
        Object object2;
        Object object3;
        String string4;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(5);
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumFractionDigits(5);
        File file = new File(string);
        if (!file.getName().startsWith("emissions_") || !string.endsWith(".txt") && !string.endsWith(".txt.gz")) {
            throw new IllegalArgumentException("Reference set of emission parameters must start with emissions_ and end with .txt or .txt.gz");
        }
        BufferedReader bufferedReader = Util.getBufferedReader(string);
        String string5 = bufferedReader.readLine();
        if (string5 == null) {
            throw new IllegalArgumentException(string + " is empty!");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string5, "\t");
        int n3 = stringTokenizer.countTokens() - 1;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        String string6 = stringTokenizer.nextToken().trim();
        int n4 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            hashMap.put(stringTokenizer.nextToken().trim(), n4);
            ++n4;
        }
        int n5 = 0;
        while ((string4 = bufferedReader.readLine()) != null) {
            ++n5;
        }
        bufferedReader.close();
        double[][] dArray = new double[n5][n3];
        bufferedReader = Util.getBufferedReader(string);
        bufferedReader.readLine();
        Object[] objectArray = new String[n5];
        for (int i = 0; i < n5; ++i) {
            string4 = bufferedReader.readLine();
            if (string4 == null) {
                throw new IllegalArgumentException("Expecting " + n5 + " lines in " + string + " found fewer.");
            }
            object3 = new StringTokenizer(string4, "\t");
            objectArray[i] = ((StringTokenizer)object3).nextToken().trim();
            for (n4 = 0; n4 < n3; ++n4) {
                dArray[i][n4] = Double.parseDouble(((StringTokenizer)object3).nextToken().trim());
            }
        }
        bufferedReader.close();
        int[] nArray = new int[hashMap.size()];
        object3 = new File(string2);
        if (!((File)object3).exists()) {
            throw new IllegalArgumentException(string2 + " was not found!");
        }
        String[] stringArray = ((File)object3).list();
        for (int i = 0; i < stringArray.length; ++i) {
            object2 = new RecEmissionFile();
            if (!stringArray[i].startsWith("emissions_") || !stringArray[i].endsWith(".txt") && !stringArray[i].endsWith(".txt.gz") || new File(stringArray[i]).isHidden()) continue;
            bufferedReader = Util.getBufferedReader(string2 + "/" + stringArray[i]);
            bufferedReader.readLine();
            n2 = 0;
            while ((string4 = bufferedReader.readLine()) != null) {
                ++n2;
            }
            bufferedReader.close();
            ((RecEmissionFile)object2).numstates = n2;
            ((RecEmissionFile)object2).szfilename = stringArray[i];
            bufferedReader = Util.getBufferedReader(string2 + "/" + stringArray[i]);
            string5 = bufferedReader.readLine();
            if (string5 == null) {
                throw new IllegalArgumentException(string2 + "/" + stringArray[i] + " is empty!");
            }
            stringTokenizer = new StringTokenizer(string5, "\t");
            int n6 = stringTokenizer.countTokens() - 1;
            stringTokenizer.nextToken();
            if (n6 != nArray.length) {
                throw new IllegalArgumentException("number of cols invalid found " + n6 + " expecting " + nArray.length);
            }
            n4 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                nArray[n4] = (Integer)hashMap.get(stringTokenizer.nextToken().trim());
                ++n4;
            }
            ((RecEmissionFile)object2).emissionparams = new double[((RecEmissionFile)object2).numstates][n3];
            for (int j = 0; j < ((RecEmissionFile)object2).numstates; ++j) {
                string4 = bufferedReader.readLine();
                if (string4 == null) {
                    throw new IllegalArgumentException("Expecting " + ((RecEmissionFile)object2).numstates + " states in " + string2 + "/" + stringArray[i] + " found fewer");
                }
                StringTokenizer stringTokenizer2 = new StringTokenizer(string4, "\t");
                stringTokenizer2.nextToken();
                for (n4 = 0; n4 < n3; ++n4) {
                    ((RecEmissionFile)object2).emissionparams[j][nArray[n4]] = Double.parseDouble(stringTokenizer2.nextToken().trim());
                }
            }
            arrayList.add(object2);
            bufferedReader.close();
        }
        if (arrayList.size() == 0) {
            throw new IllegalArgumentException("No emission files to compare to found in " + string2);
        }
        RecEmissionFile[] recEmissionFileArray = new RecEmissionFile[arrayList.size()];
        object2 = new double[n5][arrayList.size()];
        for (n2 = 0; n2 < recEmissionFileArray.length; ++n2) {
            recEmissionFileArray[n2] = (RecEmissionFile)arrayList.get(n2);
        }
        Arrays.sort(recEmissionFileArray, new RecEmissionFileCompare());
        for (int i = 0; i < recEmissionFileArray.length; ++i) {
            int n7 = recEmissionFileArray[i].numstates;
            object = recEmissionFileArray[i].emissionparams;
            for (n = 0; n < n5; ++n) {
                double d = -1.0;
                for (int j = 0; j < n7; ++j) {
                    double d2 = Util.correlation(dArray[n], object[j]);
                    if (!(d2 > d)) continue;
                    d = d2;
                }
                object2[n][i] = d;
            }
        }
        String string7 = string3 + ".txt";
        System.out.println("Writing to file " + string7);
        PrintWriter printWriter = new PrintWriter(new FileWriter(string7));
        object = new String[recEmissionFileArray.length];
        printWriter.print("State");
        for (n4 = 0; n4 < recEmissionFileArray.length; ++n4) {
            object[n4] = (double[])("" + recEmissionFileArray[n4].numstates);
        }
        for (n4 = 0; n4 < ((double[][])object).length; ++n4) {
            printWriter.print("\t" + recEmissionFileArray[n4].szfilename);
        }
        printWriter.println();
        for (n = 0; n < n5; ++n) {
            printWriter.print(objectArray[n]);
            for (int i = 0; i < ((Object)object2[n]).length; ++i) {
                printWriter.print("\t" + numberFormat.format((double)object2[n][i]));
            }
            printWriter.println();
        }
        printWriter.close();
        if (bl) {
            HeatChart heatChart = new HeatChart((double[][])object2);
            heatChart.setTitle("Best Emission Parameter Correlation");
            heatChart.setXAxisLabel("Number of States in Model");
            heatChart.setAxisValuesFont(new Font("SansSerif", 0, 20));
            heatChart.setAxisLabelsFont(new Font("SansSerif", 0, 22));
            heatChart.setTitleFont(new Font("SansSerif", 0, 24));
            heatChart.setYAxisLabel(string6);
            heatChart.setXValues((Object[])object);
            heatChart.setYValues(objectArray);
            heatChart.setHighValueColour(color);
            heatChart.saveToFile(new File(string3 + ".png"));
            Util.printImageToSVG(heatChart, string3 + ".svg");
            System.out.println("Writing to file " + string3 + ".png");
            System.out.println("Writing to file " + string3 + ".svg");
        }
    }

    private static class RecAnchorIndex {
        int nchromindex;
        int npositionindex;
        int nstrandindex;
        int nsignalindex;

        RecAnchorIndex(int n, int n2, int n3, int n4) {
            this.nchromindex = n;
            this.npositionindex = n2;
            this.nstrandindex = n3;
            this.nsignalindex = n4;
        }
    }

    public static class IntervalCompare
    implements Comparator,
    Serializable {
        public int compare(Object object, Object object2) {
            Interval interval = (Interval)object;
            Interval interval2 = (Interval)object2;
            if (interval.nstart < interval2.nstart) {
                return -1;
            }
            if (interval.nstart > interval2.nstart) {
                return 1;
            }
            if (interval.nend < interval2.nend) {
                return -1;
            }
            if (interval.nend > interval2.nend) {
                return 1;
            }
            return 0;
        }
    }

    public static class Interval {
        int nstart;
        int nend;

        Interval(int n, int n2) {
            this.nstart = n;
            this.nend = n2;
        }
    }

    public static class RecEmissionFileCompare
    implements Comparator,
    Serializable {
        public int compare(Object object, Object object2) {
            RecEmissionFile recEmissionFile = (RecEmissionFile)object;
            RecEmissionFile recEmissionFile2 = (RecEmissionFile)object2;
            if (recEmissionFile.numstates < recEmissionFile2.numstates) {
                return -1;
            }
            if (recEmissionFile.numstates > recEmissionFile2.numstates) {
                return 1;
            }
            return recEmissionFile.szfilename.compareTo(recEmissionFile2.szfilename);
        }
    }

    static class RecEmissionFile {
        String szfilename;
        int numstates;
        double[][] emissionparams;

        RecEmissionFile() {
        }
    }

    static class SegmentRec {
        String szchrom;
        int nbegin;
        int nend;
        short slabel;

        SegmentRec(String string, int n, int n2, short s) {
            this.szchrom = string;
            this.nbegin = n;
            this.nend = n2;
            this.slabel = s;
        }
    }
}

