/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.compbio.ChromHMM;

import edu.mit.compbio.ChromHMM.BrowserOutput;
import edu.mit.compbio.ChromHMM.ConvertGeneTable;
import edu.mit.compbio.ChromHMM.NestedEliminateInitialize;
import edu.mit.compbio.ChromHMM.Preprocessing;
import edu.mit.compbio.ChromHMM.StateAnalysis;
import edu.mit.compbio.ChromHMM.Util;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.zip.GZIPOutputStream;
import org.tc33.jheatchart.HeatChart;

public class ChromHMM {
    static boolean BVERBOSE = false;
    static double EPSILONEMISSIONS = Math.pow(10.0, -300.0);
    static double EPSILONSTATE = Math.pow(10.0, -300.0);
    static String SZSEGMENTEXTENSION = "_segments.bed";
    static String SZPOSTERIOREXTENSION = "_posterior.txt";
    static String SZSTATEBYLINEEXTENSION = "_statebyline.txt";
    static int DEFAULT_BINSIZEBASEPAIRS = 200;
    static int DEFAULT_NUMSPLITBINS = 5000;
    static int DEFAULT_OVERLAPENRICHMENT_NOFFSETLEFT = 0;
    static int DEFAULT_OVERLAPENRICHMENT_NOFFSETRIGHT = 1;
    static boolean DEFAULT_OVERLAPENRICHMENT_BCENTER = false;
    static boolean DEFAULT_OVERLAPENRICHMENT_BCOUNTMULTI = false;
    static boolean DEFAULT_OVERLAPENRICHMENT_BUSESIGNAL = false;
    static boolean DEFAULT_OVERLAPENRICHMENT_BBASERES = true;
    static boolean DEFAULT_OVERLAPENRICHMENT_BUNIFORMHEAT = false;
    static int DEFAULT_NEIGHBORHOOD_NUMLEFT = 10;
    static int DEFAULT_NEIGHBORHOOD_NUMRIGHT = 10;
    static boolean DEFAULT_NEIGHBORHOOD_BUSESTRAND = true;
    static boolean DEFAULT_NEIGHBORHOOD_BUSESIGNAL = false;
    static int DEFAULT_NEIGHBORHOOD_NOFFSETANCHOR = 0;
    static String ANCHORFILEDIR = "ANCHORFILES";
    static String COORDDIR = "COORDS";
    static String CHROMSIZESDIR = "CHROMSIZES";
    static String SZNEIGHBORHOODEXTENSION = "_neighborhood";
    static String SZOVERLAPEXTENSION = "_overlap";
    static String SZBROWSERDENSEEXTENSION = "_dense";
    static String SZBROWSEREXPANDEDEXTENSION = "_expanded";
    private static double SPARSECUTOFFRATIO = 0.7;
    private static double SPARSECUTOFFLOOSERRATIO = 0.8;
    static int DEFAULTCOLOR_R = 0;
    static int DEFAULTCOLOR_G = 0;
    static int DEFAULTCOLOR_B = 255;
    static String[] ORDERSTRINGS = new String[]{"User", "Emission", "Transition", "Fixed"};
    static char[] ORDERCHARS = new char[]{'U', 'E', 'T', 'F'};
    static int STATEORDER_USER = 0;
    static int STATEORDER_EMISSION = 1;
    static int STATEORDER_TRANSITION = 2;
    static int STATEORDER_FIXED = 3;
    static int INITMETHOD_INFORMATION = 0;
    static int INITMETHOD_RANDOM = 1;
    static int INITMETHOD_LOAD = 2;
    double dloglike;
    double dinformationsmooth;
    String szoutputdir = "";
    String szinputdir = "";
    double[] probinit;
    double[][] transitionprobs;
    int[] transitionprobsnum;
    int[][] transitionprobsindex;
    boolean[][] elim;
    double dconvergediff;
    HashSet hsprefix;
    int nmaxiterations;
    int[] transitionprobsnumCol;
    int[][] transitionprobsindexCol;
    double[][][] emissionprobs;
    private int numbuckets = 2;
    int numstates;
    int[][] traindataObservedIndex;
    boolean[][] traindataObservedValues;
    boolean[][] traindataNotMissing;
    boolean[][] traindataObservedSeqFlags;
    String[] datasets;
    int numdatasets;
    Random theRandom;
    String szInitFile;
    double dloadsmoothtransition;
    double dloadsmoothemission;
    String[] cellSeq;
    String[] chromSeq;
    String szstateorderingfile;
    String szcolumnorderingfile;
    String[] chromfiles;
    int[] stateordering;
    int[] colordering;
    int ninitmethod;
    int nstateorder;
    boolean bordercols;
    boolean borderrows;
    String szinputfilelist;
    boolean bprintposterior;
    boolean bprintsegment;
    boolean bprintstatebyline;
    int nbinsize;
    int nzerotransitionpower;
    Color theColor;
    char chorder;
    String szorder;
    String szoutfileID;
    int nmaxseconds;
    String szchromlengthfile;
    private String szLoadHeader;
    HashMap hmlabelExtend;
    boolean breadposterior;
    boolean breadsegment;
    boolean breadstatebyline;
    String szincludemarks;
    boolean bappend;
    String szsegmentdir;
    String szconfusionfileprefix;
    boolean bnormalEM;
    int nmaxprocessors;
    int[] numtime;
    boolean blowmem;
    int numincludeseq;
    boolean bprintimage;
    boolean bscaleemissions = false;
    boolean bpseudo = false;
    boolean bgzip = false;
    boolean bsplit = false;
    int numsplitbins = DEFAULT_NUMSPLITBINS;
    String szreorderinbedfile;
    String szreorderoutbedfile;
    boolean bscalebeta;
    boolean breordercolsmodel;
    boolean[] threadslots;
    Object objlock = new Object();
    int nlaunched;

    public ChromHMM(String string, String string2, String string3, String string4, int n, int n2, int n3, String string5, double d, double d2, double d3, int n4, double d4, int n5, boolean bl, boolean bl2, boolean bl3, int n6, String string6, int n7, boolean bl4, int n8, Color color, boolean bl5, int n9, boolean bl6, int n10, boolean bl7, boolean bl8, boolean bl9, boolean bl10, boolean bl11, boolean bl12, boolean bl13) throws IOException {
        int n11;
        this.szinputdir = string;
        this.szoutputdir = string2;
        this.szinputfilelist = string3;
        this.szchromlengthfile = string4;
        this.numstates = n;
        this.ninitmethod = n3;
        this.szInitFile = string5;
        this.dloadsmoothemission = d;
        this.dloadsmoothtransition = d2;
        this.dinformationsmooth = d3;
        this.nmaxiterations = n4;
        this.nmaxseconds = n5;
        this.dconvergediff = d4;
        this.bprintposterior = bl;
        this.bprintsegment = bl2;
        this.bprintstatebyline = bl3;
        this.nbinsize = n6;
        this.szoutfileID = string6;
        this.nstateorder = n7;
        this.chorder = ORDERCHARS[n7];
        this.szorder = ORDERSTRINGS[n7];
        this.bordercols = bl4;
        this.borderrows = bl12;
        this.nzerotransitionpower = n8;
        this.theColor = color;
        this.bnormalEM = bl5;
        this.nmaxprocessors = n9;
        this.numincludeseq = n10;
        this.blowmem = bl6;
        this.bprintimage = bl7;
        this.bscaleemissions = bl8;
        this.bpseudo = bl9;
        this.bgzip = bl10;
        this.bscalebeta = bl13;
        this.bsplit = bl11;
        this.hmlabelExtend = new HashMap();
        this.theRandom = new Random(n2);
        if (bl6) {
            this.loadDataFileStubs();
        } else {
            this.loadData();
        }
        this.stateordering = new int[n];
        this.colordering = new int[this.numdatasets];
        for (n11 = 0; n11 < this.stateordering.length; ++n11) {
            this.stateordering[n11] = n11;
        }
        for (n11 = 0; n11 < this.colordering.length; ++n11) {
            this.colordering[n11] = n11;
        }
    }

    private void makeLabelMapping(String string) throws IOException {
        if (string != null) {
            String string2;
            BufferedReader bufferedReader = Util.getBufferedReader(string);
            while ((string2 = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "\t");
                String string3 = stringTokenizer.nextToken().trim();
                String string4 = stringTokenizer.nextToken().trim();
                this.hmlabelExtend.put(string3, string4);
            }
            bufferedReader.close();
        }
    }

    public ChromHMM(String string) throws IOException {
        this.szInitFile = string;
        this.loadModel();
    }

    public ChromHMM(String string, String string2, String string3, String string4, String string5, int n, boolean bl, Color color, String string6, boolean bl2, String string7, String string8, boolean bl3) throws IOException {
        int n2;
        this.szcolumnorderingfile = string4;
        this.szInitFile = string;
        this.szoutputdir = string2;
        this.szstateorderingfile = string3;
        this.szoutfileID = string5;
        this.bprintimage = bl2;
        this.bordercols = bl;
        this.theColor = color;
        this.szreorderinbedfile = string7;
        this.szreorderoutbedfile = string8;
        this.breordercolsmodel = bl3;
        this.hmlabelExtend = new HashMap();
        this.makeLabelMapping(string6);
        this.loadModel();
        if (n != STATEORDER_FIXED) {
            this.nstateorder = n;
        }
        this.chorder = ORDERCHARS[this.nstateorder];
        this.szorder = ORDERSTRINGS[this.nstateorder];
        this.stateordering = new int[this.numstates];
        this.colordering = new int[this.numdatasets];
        for (n2 = 0; n2 < this.stateordering.length; ++n2) {
            this.stateordering[n2] = n2;
        }
        for (n2 = 0; n2 < this.colordering.length; ++n2) {
            this.colordering[n2] = n2;
        }
    }

    public ChromHMM(String string, String string2, String string3, String string4, String string5, String string6, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8) throws IOException {
        int n2;
        this.szinputdir = string;
        this.szinputfilelist = string2;
        this.szchromlengthfile = string3;
        this.bprintposterior = bl;
        this.bprintsegment = bl2;
        this.bprintstatebyline = bl3;
        this.szoutfileID = string6;
        this.szoutputdir = string4;
        this.szInitFile = string5;
        this.nbinsize = n;
        this.blowmem = bl4;
        this.bscaleemissions = bl5;
        this.bgzip = bl6;
        this.bsplit = bl7;
        this.bscalebeta = bl8;
        this.hmlabelExtend = new HashMap();
        if (bl4) {
            this.loadDataFileStubs();
        } else {
            this.loadData();
        }
        this.loadModel();
        this.stateordering = new int[this.numstates];
        this.colordering = new int[this.numdatasets];
        for (n2 = 0; n2 < this.stateordering.length; ++n2) {
            this.stateordering[n2] = n2;
        }
        for (n2 = 0; n2 < this.colordering.length; ++n2) {
            this.colordering[n2] = n2;
        }
    }

    public ChromHMM(String string, String string2, String string3, String string4, String string5, String string6, int n, boolean bl, boolean bl2, boolean bl3, String string7, boolean bl4, Color color, boolean bl5, boolean bl6, boolean bl7, boolean bl8) throws IOException {
        int n2;
        this.bappend = bl4;
        this.szinputdir = string;
        this.szsegmentdir = string2;
        this.szinputfilelist = string3;
        this.breadposterior = bl;
        this.breadsegment = bl2;
        this.breadstatebyline = bl3;
        this.szoutfileID = string6;
        this.szconfusionfileprefix = string4;
        this.szInitFile = string5;
        this.nbinsize = n;
        this.szincludemarks = string7;
        this.theColor = color;
        this.bprintimage = bl5;
        this.blowmem = bl6;
        this.bscaleemissions = bl7;
        this.bscalebeta = bl8;
        this.hmlabelExtend = new HashMap();
        if (bl6) {
            this.loadDataFileStubs();
        } else {
            this.loadData();
        }
        this.loadModel();
        this.stateordering = new int[this.numstates];
        this.colordering = new int[this.numdatasets];
        for (n2 = 0; n2 < this.stateordering.length; ++n2) {
            this.stateordering[n2] = n2;
        }
        for (n2 = 0; n2 < this.colordering.length; ++n2) {
            this.colordering[n2] = n2;
        }
    }

    static String convertCharOrderToStringOrder(char c) {
        for (int i = 1; i < ORDERCHARS.length; ++i) {
            if (ORDERCHARS[i] != c) continue;
            return ORDERSTRINGS[i];
        }
        return ORDERSTRINGS[0];
    }

    public void buildModel() throws IOException {
        if (this.ninitmethod == INITMETHOD_LOAD) {
            this.loadModelSmooth(this.dloadsmoothemission, this.dloadsmoothtransition);
        } else if (this.ninitmethod == INITMETHOD_INFORMATION) {
            if (this.blowmem) {
                this.informationInitializeNestedWithLoad();
            } else {
                this.informationInitializeNested();
            }
        } else if (this.ninitmethod == INITMETHOD_RANDOM) {
            this.randomlyInitializeParams();
        }
        if (this.bnormalEM) {
            if (this.blowmem) {
                this.trainParametersParallelWithLoad();
            } else {
                this.trainParametersParallel();
            }
        } else if (this.blowmem) {
            this.trainParametersWithLoad();
        } else {
            this.trainParameters();
        }
    }

    private void reorderModel() throws IOException {
        int n;
        Object object;
        String string;
        BufferedReader bufferedReader;
        if (this.szstateorderingfile != null) {
            int[] nArray = new int[this.stateordering.length];
            bufferedReader = Util.getBufferedReader(this.szstateorderingfile);
            while ((string = bufferedReader.readLine()) != null) {
                object = new StringTokenizer(string, "\t ");
                n = Integer.parseInt(((StringTokenizer)object).nextToken()) - 1;
                int n2 = Integer.parseInt(((StringTokenizer)object).nextToken()) - 1;
                this.stateordering[n2] = n;
                nArray[n] = n2;
            }
            bufferedReader.close();
            if (this.szreorderinbedfile != null) {
                this.reorderBEDfile(nArray);
            }
        } else {
            this.makeStateOrdering();
        }
        if (this.szcolumnorderingfile != null) {
            int n3 = 0;
            bufferedReader = Util.getBufferedReader(this.szcolumnorderingfile);
            object = new HashMap();
            while ((string = bufferedReader.readLine()) != null) {
                ((HashMap)object).put(string, n3);
                ++n3;
            }
            bufferedReader.close();
            n = 0;
            while (n < this.datasets.length) {
                Integer n4 = (Integer)((HashMap)object).get(this.datasets[n]);
                if (n4 == null) {
                    throw new IllegalArgumentException(this.datasets[n] + " not found!");
                }
                this.colordering[n4.intValue()] = n++;
            }
        } else if (this.bordercols) {
            this.makeColOrdering();
        }
        this.printTransitionTable(-1);
        this.printEmissionTable(-1);
        if (this.bprintimage) {
            this.printEmissionImage(-1);
            this.printTransitionImage(-1);
        }
        this.printParametersToFile(-1);
    }

    private void reorderBEDfile(int[] nArray) throws IOException {
        BufferedReader bufferedReader = Util.getBufferedReader(this.szreorderinbedfile);
        System.out.println("Writing to file " + this.szreorderoutbedfile);
        if (this.szreorderoutbedfile.toLowerCase(Locale.ENGLISH).endsWith(".gz")) {
            String string;
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(new FileOutputStream(this.szreorderoutbedfile));
            while ((string = bufferedReader.readLine()) != null) {
                Object object;
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
                if (stringTokenizer.countTokens() < 4) {
                    string = string.replaceAll("Emission ordered", "User ordered");
                    string = string.replaceAll("Transition ordered", "User ordered");
                    object = string.getBytes();
                    gZIPOutputStream.write((byte[])object, 0, ((byte[])object).length);
                    continue;
                }
                object = new StringBuffer(stringTokenizer.nextToken().trim() + "\t" + stringTokenizer.nextToken().trim() + "\t" + stringTokenizer.nextToken().trim());
                String string2 = stringTokenizer.nextToken().trim();
                String string3 = !Character.isDigit(string2.charAt(0)) ? "" + this.chorder + (nArray[Integer.parseInt(string2.substring(1)) - 1] + 1) : "" + (nArray[Integer.parseInt(string2) - 1] + 1);
                ((StringBuffer)object).append("\t" + string3);
                while (stringTokenizer.hasMoreTokens()) {
                    ((StringBuffer)object).append("\t" + stringTokenizer.nextToken().trim());
                }
                ((StringBuffer)object).append("\n");
                byte[] byArray = ((StringBuffer)object).toString().getBytes();
                gZIPOutputStream.write(byArray, 0, byArray.length);
            }
            gZIPOutputStream.finish();
            gZIPOutputStream.close();
            bufferedReader.close();
        } else {
            String string;
            PrintWriter printWriter = new PrintWriter(new FileWriter(this.szreorderoutbedfile));
            while ((string = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
                if (stringTokenizer.countTokens() < 4) {
                    string = string.replaceAll("Emission ordered", "User ordered");
                    string = string.replaceAll("Transition ordered", "User ordered");
                    printWriter.println(string);
                    continue;
                }
                printWriter.print(stringTokenizer.nextToken().trim() + "\t" + stringTokenizer.nextToken().trim() + "\t" + stringTokenizer.nextToken().trim());
                String string4 = stringTokenizer.nextToken().trim();
                String string5 = !Character.isDigit(string4.charAt(0)) ? "" + this.chorder + (nArray[Integer.parseInt(string4.substring(1)) - 1] + 1) : "" + (nArray[Integer.parseInt(string4) - 1] + 1);
                printWriter.print("\t" + string5);
                while (stringTokenizer.hasMoreTokens()) {
                    printWriter.print("\t" + stringTokenizer.nextToken().trim());
                }
                printWriter.println();
            }
            bufferedReader.close();
            printWriter.close();
        }
    }

    private void makeStateOrdering() {
        if (this.nstateorder == STATEORDER_EMISSION) {
            double[][] dArray = new double[this.numstates][this.numdatasets];
            for (int i = 0; i < this.numstates; ++i) {
                double[] dArray2 = dArray[i];
                double[][] dArray3 = this.emissionprobs[i];
                for (int j = 0; j < this.numdatasets; ++j) {
                    dArray2[j] = dArray3[j][1];
                }
            }
            this.makeOrderingCorrelation(dArray, this.stateordering);
        } else if (this.nstateorder == STATEORDER_TRANSITION) {
            this.makeOrderingTransition(this.stateordering);
        }
    }

    public void makeColOrdering() {
        double[][] dArray = new double[this.numdatasets][this.numstates];
        for (int i = 0; i < this.numdatasets; ++i) {
            double[] dArray2 = dArray[i];
            for (int j = 0; j < this.numstates; ++j) {
                dArray2[j] = this.emissionprobs[j][i][1];
            }
        }
        this.makeOrderingCorrelation(dArray, this.colordering);
    }

    private void makeOrderingTransition(int[] nArray) {
        boolean[] blArray = new boolean[nArray.length];
        int[] nArray2 = new int[nArray.length];
        double d = Double.MAX_VALUE;
        for (int i = 0; i < nArray.length; ++i) {
            int n;
            nArray2[0] = i;
            for (int j = 0; j < blArray.length; ++j) {
                blArray[j] = false;
            }
            blArray[i] = true;
            double d2 = 0.0;
            int n2 = i;
            for (n = 1; n < nArray.length; ++n) {
                double d3 = Double.MAX_VALUE;
                int n3 = 0;
                for (int j = 0; j < nArray.length; ++j) {
                    double d4;
                    if (blArray[j] || !((d4 = 2.0 - (this.transitionprobs[j][n2] + this.transitionprobs[n2][j])) < d3)) continue;
                    d3 = d4;
                    n3 = j;
                }
                d2 += d3;
                nArray2[n] = n3;
                blArray[n3] = true;
                n2 = n3;
            }
            if (!(d2 < d)) continue;
            d = d2;
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = nArray2[n];
            }
        }
    }

    private void makeOrderingCorrelation(double[][] dArray, int[] nArray) {
        int n;
        boolean[] blArray = new boolean[nArray.length];
        int[] nArray2 = new int[nArray.length];
        double d = Double.MAX_VALUE;
        double[][] dArray2 = new double[nArray.length][nArray.length];
        for (n = 0; n < nArray.length; ++n) {
            for (int i = 0; i < nArray.length; ++i) {
                dArray2[n][i] = Math.sqrt(1.0 - Util.correlation(dArray[n], dArray[i]));
            }
        }
        for (n = 0; n < nArray.length; ++n) {
            int n2;
            nArray2[0] = n;
            for (int i = 0; i < blArray.length; ++i) {
                blArray[i] = false;
            }
            blArray[n] = true;
            double d2 = 0.0;
            int n3 = n;
            for (n2 = 1; n2 < nArray.length; ++n2) {
                double d3 = Double.MAX_VALUE;
                int n4 = 0;
                for (int i = 0; i < nArray.length; ++i) {
                    double d4;
                    if (blArray[i] || !((d4 = dArray2[i][n3]) < d3)) continue;
                    d3 = d4;
                    n4 = i;
                }
                d2 += d3;
                nArray2[n2] = n4;
                blArray[n4] = true;
                n3 = n4;
            }
            if (!(d2 < d)) continue;
            d = d2;
            for (n2 = 0; n2 < nArray.length; ++n2) {
                nArray[n2] = nArray2[n2];
            }
        }
    }

    public void printTransitionImage(int n) throws IOException {
        Object object;
        int n2;
        double[][] dArray = new double[this.numstates][this.numstates];
        Object[] objectArray = new String[this.numstates];
        for (n2 = 0; n2 < this.numstates; ++n2) {
            object = dArray[n2];
            double[] dArray2 = this.transitionprobs[this.stateordering[n2]];
            for (int i = 0; i < this.numstates; ++i) {
                object[i] = dArray2[this.stateordering[i]];
            }
        }
        for (n2 = 0; n2 < this.numstates; ++n2) {
            objectArray[n2] = "" + (n2 + 1);
            String string = (String)this.hmlabelExtend.get("" + this.chorder + (n2 + 1));
            object = string;
            if (string == null) continue;
            int n3 = n2;
            objectArray[n3] = objectArray[n3] + "_" + (String)object;
        }
        HeatChart heatChart = new HeatChart(dArray);
        heatChart.setTitle("Transition Parameters");
        heatChart.setXAxisLabel("State To (" + this.szorder + " order)");
        heatChart.setYAxisLabel("State From (" + this.szorder + " order)");
        heatChart.setAxisValuesFont(new Font("SansSerif", 0, 20));
        heatChart.setAxisLabelsFont(new Font("SansSerif", 0, 22));
        heatChart.setTitleFont(new Font("SansSerif", 0, 24));
        if (dArray.length <= 5) {
            heatChart.setChartMargin(125);
        } else {
            heatChart.setChartMargin(50);
        }
        heatChart.setXValues(objectArray);
        heatChart.setYValues(objectArray);
        heatChart.setHighValueColour(this.theColor);
        object = this.szoutfileID.equals("") ? (Object)(this.szoutputdir + "/transitions_" + this.numstates) : (Object)(this.szoutputdir + "/transitions_" + this.numstates + "_" + this.szoutfileID);
        heatChart.saveToFile(new File((String)object + ".png"));
        Util.printImageToSVG(heatChart, (String)object + ".svg");
        if (n <= 1) {
            System.out.println("Writing to file " + (String)object + ".png");
            System.out.println("Writing to file " + (String)object + ".svg");
        }
    }

    public void printEmissionImage(int n) throws IOException {
        int n2;
        double[][] dArray = new double[this.numstates][this.numdatasets];
        Object[] objectArray = new String[this.numdatasets];
        Object[] objectArray2 = new String[this.numstates];
        for (n2 = 0; n2 < dArray.length; ++n2) {
            for (int i = 0; i < dArray[n2].length; ++i) {
                dArray[n2][i] = this.emissionprobs[this.stateordering[n2]][this.colordering[i]][1];
            }
        }
        for (n2 = 0; n2 < this.numdatasets; ++n2) {
            objectArray[n2] = this.datasets[this.colordering[n2]];
        }
        for (n2 = 0; n2 < this.numstates; ++n2) {
            objectArray2[n2] = "" + (n2 + 1);
            String string = (String)this.hmlabelExtend.get("" + this.chorder + (n2 + 1));
            if (string == null) continue;
            int n3 = n2;
            objectArray2[n3] = objectArray2[n3] + "_" + string;
        }
        HeatChart heatChart = new HeatChart(dArray);
        heatChart.setTitle("Emission Parameters");
        heatChart.setXAxisLabel("Mark");
        heatChart.setAxisValuesFont(new Font("SansSerif", 0, 20));
        heatChart.setAxisLabelsFont(new Font("SansSerif", 0, 22));
        heatChart.setTitleFont(new Font("SansSerif", 0, 24));
        heatChart.setYAxisLabel("State (" + this.szorder + " order)");
        if (dArray.length <= 5) {
            heatChart.setChartMargin(125);
        } else {
            heatChart.setChartMargin(50);
        }
        heatChart.setXValues(objectArray);
        heatChart.setYValues(objectArray2);
        heatChart.setHighValueColour(this.theColor);
        String string = this.szoutfileID.equals("") ? this.szoutputdir + "/emissions_" + this.numstates : this.szoutputdir + "/emissions_" + this.numstates + "_" + this.szoutfileID;
        Util.printImageToSVG(heatChart, string + ".svg");
        heatChart.saveToFile(new File(string + ".png"));
        if (n <= 1) {
            System.out.println("Writing to file " + string + ".svg");
            System.out.println("Writing to file " + string + ".png");
        }
    }

    public void printEmissionTable(int n) throws IOException {
        int n2;
        PrintWriter printWriter;
        String string;
        if (this.szoutfileID.equals("")) {
            string = this.szoutputdir + "/emissions_" + this.numstates + ".txt";
            printWriter = new PrintWriter(string);
        } else {
            string = this.szoutputdir + "/emissions_" + this.numstates + "_" + this.szoutfileID + ".txt";
            printWriter = new PrintWriter(string);
        }
        if (n <= 1) {
            System.out.println("Writing to file " + string);
        }
        printWriter.print("State (" + this.szorder + " order)");
        for (n2 = 0; n2 < this.datasets.length; ++n2) {
            printWriter.print("\t" + this.datasets[this.colordering[n2]]);
        }
        printWriter.println();
        for (n2 = 0; n2 < this.numstates; ++n2) {
            printWriter.print(n2 + 1);
            String string2 = (String)this.hmlabelExtend.get("" + this.chorder + (n2 + 1));
            if (string2 != null) {
                printWriter.print("_" + string2);
            }
            for (int i = 0; i < this.emissionprobs[n2].length; ++i) {
                printWriter.print("\t" + this.emissionprobs[this.stateordering[n2]][this.colordering[i]][1]);
            }
            printWriter.println();
        }
        printWriter.close();
    }

    public void printTransitionTable(int n) throws IOException {
        String string;
        int n2;
        PrintWriter printWriter;
        String string2;
        if (this.szoutfileID.equals("")) {
            string2 = this.szoutputdir + "/transitions_" + this.numstates + ".txt";
            printWriter = new PrintWriter(string2);
        } else {
            string2 = this.szoutputdir + "/transitions_" + this.numstates + "_" + this.szoutfileID + ".txt";
            printWriter = new PrintWriter(string2);
        }
        if (n <= 1) {
            System.out.println("Writing to file " + string2);
        }
        printWriter.print("State (from\\to) (" + this.szorder + " order)");
        for (n2 = 0; n2 < this.numstates; ++n2) {
            printWriter.print("\t" + (n2 + 1));
            string = (String)this.hmlabelExtend.get("" + this.chorder + (n2 + 1));
            if (string == null) continue;
            printWriter.print("_" + string);
        }
        printWriter.println();
        for (n2 = 0; n2 < this.numstates; ++n2) {
            printWriter.print("" + (n2 + 1));
            string = (String)this.hmlabelExtend.get("" + this.chorder + (n2 + 1));
            if (string != null) {
                printWriter.print("_" + string);
            }
            double[] dArray = this.transitionprobs[this.stateordering[n2]];
            for (int i = 0; i < this.numstates; ++i) {
                printWriter.print("\t" + dArray[this.stateordering[i]]);
            }
            printWriter.println();
        }
        printWriter.close();
    }

    private void printParametersToFile(int n) throws IOException {
        int n2;
        Object object;
        int n3;
        PrintWriter printWriter;
        String string;
        if (this.szoutfileID.equals("")) {
            string = this.szoutputdir + "/model_" + this.numstates + ".txt";
            printWriter = new PrintWriter(string);
        } else {
            string = this.szoutputdir + "/model_" + this.numstates + "_" + this.szoutfileID + ".txt";
            printWriter = new PrintWriter(string);
        }
        if (n <= 1) {
            System.out.println("Writing to file " + string);
        }
        if (n == -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.szLoadHeader);
            printWriter.print(stringTokenizer.nextToken() + "\t" + stringTokenizer.nextToken() + "\t" + this.chorder);
            stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                printWriter.println("\t" + stringTokenizer.nextToken() + "\t" + stringTokenizer.nextToken());
            }
        } else {
            printWriter.println(this.numstates + "\t" + this.numdatasets + "\t" + this.chorder + "\t" + this.dloglike + "\t" + n);
        }
        for (n3 = 0; n3 < this.numstates; ++n3) {
            printWriter.println("probinit\t" + (n3 + 1) + "\t" + this.probinit[this.stateordering[n3]]);
        }
        for (n3 = 0; n3 < this.transitionprobs.length; ++n3) {
            object = this.transitionprobs[this.stateordering[n3]];
            for (n2 = 0; n2 < ((double[])object).length; ++n2) {
                printWriter.println("transitionprobs\t" + (n3 + 1) + "\t" + (n2 + 1) + "\t" + object[this.stateordering[n2]]);
            }
        }
        for (n3 = 0; n3 < this.numstates; ++n3) {
            object = this.emissionprobs[this.stateordering[n3]];
            for (n2 = 0; n2 < ((double[])object).length; ++n2) {
                String string2;
                double d;
                if (this.breordercolsmodel) {
                    d = object[this.colordering[n2]];
                    string2 = this.datasets[this.colordering[n2]];
                } else {
                    d = object[n2];
                    string2 = this.datasets[n2];
                }
                for (int i = 0; i < ((double)d).length; ++i) {
                    printWriter.println("emissionprobs\t" + (n3 + 1) + "\t" + n2 + "\t" + string2 + "\t" + i + "\t" + (double)d[i]);
                }
            }
        }
        printWriter.close();
    }

    /*
     * Could not resolve type clashes
     */
    public void informationInitializeNestedWithLoad() throws IOException {
        int n;
        int n2;
        Object object;
        Object object2;
        Object object3;
        int n3;
        Object object4;
        Object object5;
        int n4;
        int n5;
        int n6;
        this.probinit = new double[this.numstates];
        this.emissionprobs = new double[this.numstates][this.numdatasets][this.numbuckets];
        this.elim = new boolean[this.numstates][this.numstates];
        this.transitionprobs = new double[this.numstates][this.numstates];
        this.transitionprobsindex = new int[this.numstates][this.numstates];
        this.transitionprobsnum = new int[this.numstates];
        this.transitionprobsindexCol = new int[this.numstates][this.numstates];
        this.transitionprobsnumCol = new int[this.numstates];
        int n7 = 0;
        for (int i = 0; i < this.numtime.length; ++i) {
            if (this.numtime[i] <= n7) continue;
            n7 = this.numtime[i];
        }
        int[][] nArrayArray = new int[this.chromfiles.length][];
        int[] nArray = new int[n7];
        boolean[][] blArray = new boolean[n7][this.numdatasets];
        boolean[][] blArray2 = new boolean[n7][this.numdatasets];
        ArrayList<boolean[]> arrayList = new ArrayList<boolean[]>();
        HashMap<boolean[], Integer> hashMap = new HashMap<boolean[], Integer>();
        int n8 = 0;
        int[] nArray2 = null;
        if (this.numincludeseq >= 1) {
            n6 = Math.min(this.numincludeseq, this.chromfiles.length);
            nArray2 = new int[n6];
        } else {
            n6 = this.chromfiles.length;
        }
        boolean[] blArray3 = new boolean[this.chromfiles.length];
        for (n5 = 0; n5 < blArray3.length; ++n5) {
            blArray3[n5] = true;
        }
        if (this.numincludeseq >= 1) {
            for (n5 = 0; n5 < nArray2.length; ++n5) {
                nArray2[n5] = n5;
            }
            for (n5 = n6; n5 < this.chromfiles.length; ++n5) {
                if (!(this.theRandom.nextDouble() < (double)n6 / ((double)n5 + 1.0))) continue;
                nArray2[this.theRandom.nextInt((int)n6)] = n5;
            }
            for (n5 = 0; n5 < blArray3.length; ++n5) {
                blArray3[n5] = false;
            }
            for (n5 = 0; n5 < nArray2.length; ++n5) {
                blArray3[nArray2[n5]] = true;
            }
        }
        for (n5 = 0; n5 < this.chromfiles.length; ++n5) {
            int n9;
            int n10;
            Object object6;
            Object object7;
            Object object8;
            if (!blArray3[n5]) continue;
            int n11 = this.numtime[n5] - 1;
            HashMap<BigInteger, Integer> hashMap2 = new HashMap<BigInteger, Integer>();
            n4 = 0;
            if (BVERBOSE) {
                System.out.println("reading\t" + this.szinputdir + " " + this.chromfiles[n5]);
            }
            object5 = Util.getBufferedReader(this.szinputdir + "/" + this.chromfiles[n5]);
            String string = ((BufferedReader)object5).readLine();
            ((BufferedReader)object5).readLine();
            object4 = new ArrayList();
            while ((string = ((BufferedReader)object5).readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\t ");
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < this.numdatasets; ++i) {
                    if (!stringTokenizer.hasMoreTokens()) {
                        throw new IllegalArgumentException("Found line without " + this.numdatasets + " values in file " + this.chromfiles[n5]);
                    }
                    object8 = stringTokenizer.nextToken();
                    if (((String)object8).equals("0")) {
                        stringBuffer.append("0");
                        continue;
                    }
                    if (((String)object8).equals("1")) {
                        stringBuffer.append("1");
                        continue;
                    }
                    if (((String)object8).equals("2")) {
                        stringBuffer.append("2");
                        continue;
                    }
                    throw new IllegalArgumentException("Unrecognized value " + (String)object8 + " found in " + this.szinputdir + "/" + this.chromfiles[n5]);
                }
                ((ArrayList)object4).add(stringBuffer.toString());
            }
            ((BufferedReader)object5).close();
            n3 = ((ArrayList)object4).size();
            for (int i = 0; i < n3; ++i) {
                BigInteger bigInteger = new BigInteger((String)((ArrayList)object4).get(i), 3);
                object8 = (Integer)hashMap2.get(bigInteger);
                if (object8 == null) {
                    hashMap2.put(bigInteger, n4);
                    nArray[i] = n4++;
                    continue;
                }
                nArray[i] = (Integer)object8;
            }
            for (Map.Entry entry : hashMap2.entrySet()) {
                int n12;
                object8 = (BigInteger)entry.getKey();
                String string2 = ((BigInteger)object8).toString(3);
                int n13 = (Integer)entry.getValue();
                object7 = blArray[n13];
                object6 = blArray2[n13];
                int n14 = string2.length();
                n10 = this.numdatasets - n14;
                for (n12 = 0; n12 < n10; ++n12) {
                    object7[n12] = false;
                    object6[n12] = true;
                }
                n12 = n10;
                for (n9 = 0; n9 < n14; ++n9) {
                    object3 = string2.charAt(n9);
                    if (object3 == 48) {
                        object7[n12] = false;
                        object6[n12] = true;
                    } else if (object3 == 49) {
                        object7[n12] = true;
                        object6[n12] = true;
                    } else {
                        object7[n12] = false;
                        object6[n12] = false;
                    }
                    ++n12;
                }
            }
            nArrayArray[n5] = new int[n11];
            object2 = nArrayArray[n5];
            object8 = blArray[nArray[0]];
            for (object = 0; object < n11; ++object) {
                boolean[] blArray4 = blArray[nArray[object + 1]];
                object7 = new StringBuffer();
                for (int i = 0; i < this.numdatasets; ++i) {
                    if (object8[i] != false && blArray4[i]) {
                        ((StringBuffer)object7).append("1");
                        continue;
                    }
                    ((StringBuffer)object7).append("0");
                }
                object6 = new BigInteger(((StringBuffer)object7).toString(), 2);
                Object v = hashMap.get(object6);
                if (v == null) {
                    hashMap.put((boolean[])object6, n8);
                    n10 = n8++;
                    boolean[] blArray5 = new boolean[this.numdatasets];
                    for (n9 = 0; n9 < this.numdatasets; ++n9) {
                        blArray5[n9] = object8[n9] != false && blArray4[n9];
                    }
                    arrayList.add(blArray5);
                } else {
                    n10 = (Integer)hashMap.get(object6);
                }
                object2[object] = n10;
                object8 = blArray4;
            }
        }
        n5 = arrayList.size();
        int[] nArray3 = new int[n5];
        int n15 = 0;
        for (n4 = 0; n4 < nArrayArray.length; ++n4) {
            if (!blArray3[n4]) continue;
            object5 = nArrayArray[n4];
            for (int i = 0; i < ((int[])object5).length; ++i) {
                int n16 = object5[i];
                nArray3[n16] = nArray3[n16] + 1;
            }
            n15 += ((int[])object5).length;
        }
        for (n4 = 0; n4 < this.numdatasets; ++n4) {
            this.emissionprobs[0][n4][1] = this.dinformationsmooth * 1.0 / (double)this.numbuckets;
            this.emissionprobs[0][n4][0] = 1.0 - this.emissionprobs[0][n4][1];
        }
        int[] nArray4 = new int[this.numstates];
        nArray4[0] = n15;
        object5 = new int[n5];
        int[] nArray5 = new int[this.numstates];
        object4 = new int[this.numstates - 1][this.numdatasets];
        for (n3 = 1; n3 < this.numstates; ++n3) {
            int n17;
            Object object9;
            Object object10;
            int n18;
            for (n18 = 0; n18 < n3 - 1; ++n18) {
                object2 = object4[n18];
                for (int i = 0; i < this.numdatasets; ++i) {
                    object2[i] = false;
                }
            }
            for (n18 = 0; n18 < nArray3.length; ++n18) {
                object2 = (boolean[])arrayList.get(n18);
                object10 = object5[n18];
                for (object = 0; object < this.numdatasets; ++object) {
                    if (object2[object] == false) continue;
                    Object object11 = object4[object10];
                    Object object12 = object;
                    object11[object12] = object11[object12] + nArray3[n18];
                }
            }
            double d = 0.0;
            object10 = -1;
            object = -1;
            for (object9 = 0; object9 < n3; ++object9) {
                n17 = nArray4[object9];
                double d2 = (double)n17 / (double)n15;
                double d3 = d2 > 0.0 ? d2 * Math.log(d2) : 0.0;
                Object object13 = object4[object9];
                for (object3 = 0; object3 < this.numdatasets; ++object3) {
                    double d4 = (double)(n17 - object13[object3]) / (double)n15;
                    double d5 = (double)object13[object3] / (double)n15;
                    double d6 = d3;
                    if (d4 > 0.0) {
                        d6 -= d4 * Math.log(d4);
                    }
                    if (d5 > 0.0) {
                        d6 -= d5 * Math.log(d5);
                    }
                    if (!(d6 > d)) continue;
                    d = d6;
                    object10 = object9;
                    object = object3;
                }
            }
            if (BVERBOSE) {
                System.out.println("====>\t" + object10 + "\t" + object + "\t" + this.datasets[object] + "\t" + d + "\t" + (int)object4[object10][object] + "\t" + nArray4[object10]);
            }
            if (object10 == -1) {
                throw new IllegalArgumentException("On this data the INFORMATION initialization strategy can only support " + n3 + " states. Check if the binarization was done correctly, and if so use the RANDOM or LOAD options for more states");
            }
            nArray4[n3] = object9 = (Object)object4[object10][object];
            Object object14 = object10;
            nArray4[object14] = nArray4[object14] - object9;
            nArray5[n3] = object10;
            for (n17 = 0; n17 < nArray3.length; ++n17) {
                boolean[] blArray6 = (boolean[])arrayList.get(n17);
                if (object5[n17] != object10 || !blArray6[object]) continue;
                object5[n17] = n3;
            }
        }
        int[][] nArray6 = new int[this.numstates][this.numdatasets];
        for (int i = 0; i < nArray3.length; ++i) {
            object2 = (boolean[])arrayList.get(i);
            for (int j = 0; j < this.numdatasets; ++j) {
                if (object2[j] == false) continue;
                object = object5[i];
                do {
                    int[] nArray7 = nArray6[object];
                    int n19 = j;
                    nArray7[n19] = nArray7[n19] + nArray3[i];
                } while ((object = nArray5[object]) != 0);
            }
        }
        int[] nArray8 = new int[nArray4.length];
        for (n2 = 1; n2 < this.numstates; ++n2) {
            int n20 = n2;
            object = 0;
            int n21 = nArray4[n20];
            do {
                int n22 = n20;
                nArray8[n22] = nArray8[n22] + n21;
            } while ((n20 = nArray5[n20]) != 0);
        }
        for (n2 = 1; n2 < this.numstates; ++n2) {
            for (int i = 0; i < this.numdatasets; ++i) {
                this.emissionprobs[n2][i][1] = this.dinformationsmooth * 1.0 / (double)this.numbuckets + (1.0 - this.dinformationsmooth) * ((double)nArray6[n2][i] / (double)nArray8[n2]);
                this.emissionprobs[n2][i][0] = 1.0 - this.emissionprobs[n2][i][1];
            }
        }
        int[] nArray9 = new int[this.numstates];
        int n23 = 0;
        for (object = 0; object < nArrayArray.length; ++object) {
            if (!blArray3[object] || nArrayArray[object].length <= 0) continue;
            Object object15 = object5[nArrayArray[object][0]];
            nArray9[object15] = nArray9[object15] + 1;
            ++n23;
        }
        for (object = 0; object < this.probinit.length; ++object) {
            this.probinit[object] = this.dinformationsmooth * 1.0 / (double)this.numstates + (1.0 - this.dinformationsmooth) * (double)nArray9[object] / (double)n23;
        }
        int[][] nArray10 = new int[this.numstates][this.numstates];
        for (n = 0; n < nArrayArray.length; ++n) {
            if (!blArray3[n] || nArrayArray[n].length <= 0) continue;
            int[] nArray11 = nArrayArray[n];
            Object object16 = object5[nArray11[0]];
            for (int i = 1; i < nArray11.length; ++i) {
                Object object17 = object5[nArray11[i]];
                int[] nArray12 = nArray10[object16];
                Object object18 = object17;
                nArray12[object18] = nArray12[object18] + 1;
                object16 = object17;
            }
        }
        for (n = 0; n < this.numstates; ++n) {
            int n24;
            double[] dArray = this.transitionprobs[n];
            double d = 0.0;
            int[] nArray13 = nArray10[n];
            for (n24 = 0; n24 < this.numstates; ++n24) {
                d += (double)nArray13[n24];
            }
            for (n24 = 0; n24 < this.numstates; ++n24) {
                this.elim[n][n24] = false;
                dArray[n24] = this.dinformationsmooth * 1.0 / (double)this.numstates + (1.0 - this.dinformationsmooth) * ((double)nArray13[n24] / d);
                this.transitionprobsindex[n][n24] = n24;
                this.transitionprobsindexCol[n][n24] = n24;
            }
            this.transitionprobsnum[n] = this.numstates;
            this.transitionprobsnumCol[n] = this.numstates;
        }
    }

    public void informationInitializeNested() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Object object;
        Object object2;
        int n7;
        Object object3;
        int n8;
        int[] nArray;
        int n9;
        int n10;
        this.probinit = new double[this.numstates];
        this.emissionprobs = new double[this.numstates][this.numdatasets][this.numbuckets];
        this.elim = new boolean[this.numstates][this.numstates];
        this.transitionprobs = new double[this.numstates][this.numstates];
        this.transitionprobsindex = new int[this.numstates][this.numstates];
        this.transitionprobsnum = new int[this.numstates];
        this.transitionprobsindexCol = new int[this.numstates][this.numstates];
        this.transitionprobsnumCol = new int[this.numstates];
        int[][] nArrayArray = new int[this.traindataObservedIndex.length][];
        ArrayList<boolean[]> arrayList = new ArrayList<boolean[]>();
        HashMap<BigInteger, Integer> hashMap = new HashMap<BigInteger, Integer>();
        int n11 = 0;
        int[] nArray2 = null;
        if (this.numincludeseq >= 1) {
            n10 = Math.min(this.numincludeseq, this.chromfiles.length);
            nArray2 = new int[n10];
        } else {
            n10 = this.chromfiles.length;
        }
        boolean[] blArray = new boolean[this.chromfiles.length];
        for (n9 = 0; n9 < blArray.length; ++n9) {
            blArray[n9] = true;
        }
        if (this.numincludeseq >= 1) {
            for (n9 = 0; n9 < nArray2.length; ++n9) {
                nArray2[n9] = n9;
            }
            for (n9 = n10; n9 < this.chromfiles.length; ++n9) {
                if (!(this.theRandom.nextDouble() < (double)n10 / ((double)n9 + 1.0))) continue;
                nArray2[this.theRandom.nextInt((int)n10)] = n9;
            }
            for (n9 = 0; n9 < blArray.length; ++n9) {
                blArray[n9] = false;
            }
            for (n9 = 0; n9 < nArray2.length; ++n9) {
                blArray[nArray2[n9]] = true;
            }
        }
        for (n9 = 0; n9 < this.traindataObservedIndex.length; ++n9) {
            if (!blArray[n9]) continue;
            nArray = this.traindataObservedIndex[n9];
            n8 = nArray.length - 1;
            nArrayArray[n9] = new int[n8];
            int[] nArray3 = nArrayArray[n9];
            object3 = this.traindataObservedValues[nArray[0]];
            for (n7 = 0; n7 < n8; ++n7) {
                object2 = this.traindataObservedValues[nArray[n7 + 1]];
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < this.numdatasets; ++i) {
                    if (object3[i] != 0 && object2[i] != false) {
                        stringBuffer.append("1");
                        continue;
                    }
                    stringBuffer.append("0");
                }
                BigInteger bigInteger = new BigInteger(stringBuffer.toString(), 2);
                object = hashMap.get(bigInteger);
                if (object == null) {
                    hashMap.put(bigInteger, n11);
                    n6 = n11++;
                    boolean[] blArray2 = new boolean[this.numdatasets];
                    for (n5 = 0; n5 < this.numdatasets; ++n5) {
                        blArray2[n5] = object3[n5] != 0 && object2[n5] != false;
                    }
                    arrayList.add(blArray2);
                } else {
                    n6 = (Integer)hashMap.get(bigInteger);
                }
                nArray3[n7] = n6;
                object3 = object2;
            }
        }
        n9 = arrayList.size();
        nArray = new int[n9];
        n8 = 0;
        for (n4 = 0; n4 < nArrayArray.length; ++n4) {
            if (!blArray[n4]) continue;
            object3 = nArrayArray[n4];
            for (n7 = 0; n7 < ((int[])object3).length; ++n7) {
                int n12 = object3[n7];
                nArray[n12] = nArray[n12] + 1;
            }
            n8 += ((int[])object3).length;
        }
        for (n4 = 0; n4 < this.numdatasets; ++n4) {
            this.emissionprobs[0][n4][1] = this.dinformationsmooth * 1.0 / (double)this.numbuckets;
            this.emissionprobs[0][n4][0] = 1.0 - this.emissionprobs[0][n4][1];
        }
        int[] nArray4 = new int[this.numstates];
        nArray4[0] = n8;
        object3 = new int[n9];
        int[] nArray5 = new int[this.numstates];
        object2 = new int[this.numstates - 1][this.numdatasets];
        for (int i = 1; i < this.numstates; ++i) {
            int n13;
            int n14;
            for (n14 = 0; n14 < i - 1; ++n14) {
                object = object2[n14];
                for (n6 = 0; n6 < this.numdatasets; ++n6) {
                    object[n6] = 0;
                }
            }
            for (n14 = 0; n14 < nArray.length; ++n14) {
                object = (boolean[])arrayList.get(n14);
                n6 = object3[n14];
                for (n13 = 0; n13 < this.numdatasets; ++n13) {
                    if (object[n13] == 0) continue;
                    int[] nArray6 = object2[n6];
                    int n15 = n13;
                    nArray6[n15] = nArray6[n15] + nArray[n14];
                }
            }
            double d = 0.0;
            n6 = -1;
            n13 = -1;
            for (n5 = 0; n5 < i; ++n5) {
                n3 = nArray4[n5];
                double d2 = (double)n3 / (double)n8;
                double d3 = d2 > 0.0 ? d2 * Math.log(d2) : 0.0;
                int[] nArray7 = object2[n5];
                for (int j = 0; j < this.numdatasets; ++j) {
                    double d4 = (double)(n3 - nArray7[j]) / (double)n8;
                    double d5 = (double)nArray7[j] / (double)n8;
                    double d6 = d3;
                    if (d4 > 0.0) {
                        d6 -= d4 * Math.log(d4);
                    }
                    if (d5 > 0.0) {
                        d6 -= d5 * Math.log(d5);
                    }
                    if (!(d6 > d)) continue;
                    d = d6;
                    n6 = n5;
                    n13 = j;
                }
            }
            if (BVERBOSE) {
                System.out.println("====>\t" + n6 + "\t" + n13 + "\t" + this.datasets[n13] + "\t" + d + "\t" + object2[n6][n13] + "\t" + nArray4[n6]);
            }
            if (n6 == -1) {
                throw new IllegalArgumentException("On this data the INFORMATION initialization strategy can only support " + i + " states. Check if the binarization was done correctly, and if so use the RANDOM or LOAD options for more states");
            }
            nArray4[i] = n5 = object2[n6][n13];
            int n16 = n6;
            nArray4[n16] = nArray4[n16] - n5;
            nArray5[i] = n6;
            for (n3 = 0; n3 < nArray.length; ++n3) {
                boolean[] blArray3 = (boolean[])arrayList.get(n3);
                if (object3[n3] != n6 || !blArray3[n13]) continue;
                object3[n3] = i;
            }
        }
        int[][] nArray8 = new int[this.numstates][this.numdatasets];
        for (int i = 0; i < nArray.length; ++i) {
            object = (boolean[])arrayList.get(i);
            for (n6 = 0; n6 < this.numdatasets; ++n6) {
                if (object[n6] == 0) continue;
                int n17 = object3[i];
                do {
                    int[] nArray9 = nArray8[n17];
                    int n18 = n6;
                    nArray9[n18] = nArray9[n18] + nArray[i];
                } while ((n17 = nArray5[n17]) != 0);
            }
        }
        int[] nArray10 = new int[nArray4.length];
        for (n2 = 1; n2 < this.numstates; ++n2) {
            n6 = n2;
            boolean bl = false;
            n5 = nArray4[n6];
            do {
                int n19 = n6;
                nArray10[n19] = nArray10[n19] + n5;
            } while ((n6 = nArray5[n6]) != 0);
        }
        for (n2 = 1; n2 < this.numstates; ++n2) {
            for (n6 = 0; n6 < this.numdatasets; ++n6) {
                this.emissionprobs[n2][n6][1] = this.dinformationsmooth * 1.0 / (double)this.numbuckets + (1.0 - this.dinformationsmooth) * ((double)nArray8[n2][n6] / (double)nArray10[n2]);
                this.emissionprobs[n2][n6][0] = 1.0 - this.emissionprobs[n2][n6][1];
            }
        }
        int[] nArray11 = new int[this.numstates];
        n6 = 0;
        for (n = 0; n < nArrayArray.length; ++n) {
            if (!blArray[n] || nArrayArray[n].length <= 0) continue;
            int n20 = object3[nArrayArray[n][0]];
            nArray11[n20] = nArray11[n20] + 1;
            ++n6;
        }
        for (n = 0; n < this.probinit.length; ++n) {
            this.probinit[n] = this.dinformationsmooth * 1.0 / (double)this.numstates + (1.0 - this.dinformationsmooth) * (double)nArray11[n] / (double)n6;
        }
        int[][] nArray12 = new int[this.numstates][this.numstates];
        for (n3 = 0; n3 < nArrayArray.length; ++n3) {
            if (!blArray[n3] || nArrayArray[n3].length <= 0) continue;
            int[] nArray13 = nArrayArray[n3];
            int n21 = object3[nArray13[0]];
            for (int i = 1; i < nArray13.length; ++i) {
                n5 = object3[nArray13[i]];
                int[] nArray14 = nArray12[n21];
                int n22 = n5;
                nArray14[n22] = nArray14[n22] + 1;
                n21 = n5;
            }
        }
        for (n3 = 0; n3 < this.numstates; ++n3) {
            int n23;
            double[] dArray = this.transitionprobs[n3];
            double d = 0.0;
            int[] nArray15 = nArray12[n3];
            for (n23 = 0; n23 < this.numstates; ++n23) {
                d += (double)nArray15[n23];
            }
            for (n23 = 0; n23 < this.numstates; ++n23) {
                this.elim[n3][n23] = false;
                dArray[n23] = this.dinformationsmooth * 1.0 / (double)this.numstates + (1.0 - this.dinformationsmooth) * ((double)nArray15[n23] / d);
                this.transitionprobsindex[n3][n23] = n23;
                this.transitionprobsindexCol[n3][n23] = n23;
            }
            this.transitionprobsnum[n3] = this.numstates;
            this.transitionprobsnumCol[n3] = this.numstates;
        }
    }

    public void randomlyInitializeParams() {
        int n;
        Object object;
        int n2;
        double d = 0.0;
        this.probinit = new double[this.numstates];
        for (n2 = 0; n2 < this.probinit.length; ++n2) {
            this.probinit[n2] = this.theRandom.nextDouble();
            d += this.probinit[n2];
        }
        n2 = 0;
        while (n2 < this.probinit.length) {
            int n3 = n2++;
            this.probinit[n3] = this.probinit[n3] / d;
        }
        this.elim = new boolean[this.numstates][this.numstates];
        this.transitionprobs = new double[this.numstates][this.numstates];
        this.transitionprobsindex = new int[this.numstates][this.numstates];
        this.transitionprobsnum = new int[this.numstates];
        this.transitionprobsindexCol = new int[this.numstates][this.numstates];
        this.transitionprobsnumCol = new int[this.numstates];
        for (n2 = 0; n2 < this.transitionprobs.length; ++n2) {
            d = 0.0;
            object = this.transitionprobs[n2];
            for (n = 0; n < ((double[])object).length; ++n) {
                double d2;
                this.elim[n2][n] = false;
                object[n] = d2 = this.theRandom.nextDouble();
                d += object[n];
                this.transitionprobsindex[n2][n] = n;
                this.transitionprobsindexCol[n2][n] = n;
            }
            this.transitionprobsnum[n2] = this.numstates;
            this.transitionprobsnumCol[n2] = this.numstates;
            n = 0;
            while (n < ((double[])object).length) {
                int n4 = n++;
                object[n4] = object[n4] / d;
            }
        }
        this.emissionprobs = new double[this.numstates][this.numdatasets][this.numbuckets];
        for (n2 = 0; n2 < this.emissionprobs.length; ++n2) {
            object = this.emissionprobs[n2];
            for (n = 0; n < ((double[])object).length; ++n) {
                int n5;
                double d3 = object[n];
                d = 0.0;
                for (n5 = 0; n5 < ((double)d3).length; ++n5) {
                    double d4 = this.theRandom.nextDouble();
                    d += d4;
                    d3[n5] = d4;
                }
                n5 = 0;
                while (n5 < ((double)d3).length) {
                    double d5 = d3;
                    int n6 = n5++;
                    d5[n6] = d5[n6] / d;
                }
            }
        }
    }

    public void loadModel() throws IOException {
        this.loadModelSmooth(0.0, 0.0);
    }

    public void loadModelSmooth(double d, double d2) throws IOException {
        int n;
        int n2;
        String string;
        int n3;
        BufferedReader bufferedReader = Util.getBufferedReader(this.szInitFile);
        this.szLoadHeader = bufferedReader.readLine();
        if (this.szLoadHeader == null) {
            throw new IllegalArgumentException(this.szLoadHeader + " is empty!");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.szLoadHeader, "\t");
        this.numstates = Integer.parseInt(stringTokenizer.nextToken().trim());
        this.numdatasets = Integer.parseInt(stringTokenizer.nextToken().trim());
        if (this.datasets == null) {
            this.datasets = new String[this.numdatasets];
        }
        this.chorder = stringTokenizer.nextToken().trim().charAt(0);
        if (this.nstateorder != STATEORDER_TRANSITION && this.nstateorder != STATEORDER_EMISSION && this.nstateorder != STATEORDER_FIXED) {
            this.nstateorder = -1;
            for (n3 = 0; n3 < ORDERCHARS.length; ++n3) {
                if (this.chorder != ORDERCHARS[n3]) continue;
                this.nstateorder = n3;
                break;
            }
            if (this.nstateorder == -1) {
                throw new IllegalArgumentException(this.chorder + " is an invalid order type");
            }
            this.szorder = ORDERSTRINGS[this.nstateorder];
        }
        this.probinit = new double[this.numstates];
        this.elim = new boolean[this.numstates][this.numstates];
        this.transitionprobs = new double[this.numstates][this.numstates];
        this.transitionprobsindex = new int[this.numstates][this.numstates];
        this.transitionprobsnum = new int[this.numstates];
        this.transitionprobsindexCol = new int[this.numstates][this.numstates];
        this.transitionprobsnumCol = new int[this.numstates];
        for (n3 = 0; n3 < this.transitionprobs.length; ++n3) {
            for (int i = 0; i < this.transitionprobs[n3].length; ++i) {
                this.elim[n3][i] = false;
                this.transitionprobsindex[n3][i] = i;
                this.transitionprobsindexCol[n3][i] = i;
            }
            this.transitionprobsnum[n3] = this.numstates;
            this.transitionprobsnumCol[n3] = this.numstates;
        }
        this.emissionprobs = new double[this.numstates][this.numdatasets][this.numbuckets];
        n3 = 0;
        while ((string = bufferedReader.readLine()) != null) {
            stringTokenizer = new StringTokenizer(string, "\t");
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.equalsIgnoreCase("probinit")) {
                double d3;
                n2 = Integer.parseInt(stringTokenizer.nextToken().trim()) - 1;
                this.probinit[n2] = d3 = Double.parseDouble(stringTokenizer.nextToken().trim());
                continue;
            }
            if (string2.equalsIgnoreCase("transitionprobs")) {
                n2 = Integer.parseInt(stringTokenizer.nextToken().trim()) - 1;
                int n4 = Integer.parseInt(stringTokenizer.nextToken().trim()) - 1;
                double d4 = Double.parseDouble(stringTokenizer.nextToken().trim());
                this.transitionprobs[n2][n4] = d2 / (double)this.transitionprobs.length + (1.0 - d2) * d4;
                if (this.transitionprobs[n2][n4] != 0.0) continue;
                n3 = 1;
                this.elim[n2][n4] = true;
                continue;
            }
            if (string2.equalsIgnoreCase("emissionprobs")) {
                n2 = Integer.parseInt(stringTokenizer.nextToken().trim()) - 1;
                int n5 = Integer.parseInt(stringTokenizer.nextToken().trim());
                String string3 = stringTokenizer.nextToken().trim();
                if (this.datasets[n5] == null) {
                    this.datasets[n5] = string3;
                } else if (!string3.equals(this.datasets[n5])) {
                    throw new IllegalArgumentException("For mark " + n5 + " in model file found " + string3 + ", but expecting " + this.datasets[n5] + ". This might be because columns of binarized file are in a different order from model learning.");
                }
                n = Integer.parseInt(stringTokenizer.nextToken().trim());
                double d5 = Double.parseDouble(stringTokenizer.nextToken().trim());
                this.emissionprobs[n2][n5][n] = d / (double)this.numbuckets + (1.0 - d) * d5;
                continue;
            }
            throw new IllegalArgumentException(string2 + " is not recognized in the input model file");
        }
        bufferedReader.close();
        if (n3 != 0) {
            int n6;
            for (n6 = 0; n6 < this.transitionprobs.length; ++n6) {
                n2 = 0;
                boolean[] blArray = this.elim[n6];
                int[] nArray = this.transitionprobsindex[n6];
                for (n = 0; n < nArray.length; ++n) {
                    if (blArray[n]) continue;
                    nArray[n2] = n;
                    ++n2;
                }
                this.transitionprobsnum[n6] = n2;
            }
            for (n6 = 0; n6 < this.transitionprobs.length; ++n6) {
                n2 = 0;
                for (int i = 0; i < this.numstates; ++i) {
                    if (this.elim[i][n6]) continue;
                    this.transitionprobsindexCol[n6][n2] = i;
                    ++n2;
                }
                this.transitionprobsnumCol[n6] = n2;
            }
        }
    }

    public void makeSegmentationConfusion() throws IOException {
        int n;
        int n2;
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(4);
        int n3 = (int)((double)this.numstates * SPARSECUTOFFRATIO);
        int[] nArray = new int[this.traindataObservedIndex.length];
        int n4 = 0;
        for (int i = 0; i < this.traindataObservedIndex.length; ++i) {
            nArray[i] = this.traindataObservedIndex[i].length;
            if (nArray[i] <= n4) continue;
            n4 = nArray[i];
        }
        double[][] dArray = null;
        int[] nArray2 = null;
        double[][] dArray2 = new double[this.numstates][this.numstates];
        double[][] dArray3 = new double[this.numstates][this.numstates];
        if (this.breadposterior) {
            dArray = new double[n4][this.numstates];
        }
        if (this.breadstatebyline || this.breadsegment) {
            nArray2 = new int[n4];
        }
        if (BVERBOSE) {
            System.out.println("Maximum number of locations\t" + n4);
        }
        double[][] dArray4 = new double[this.traindataObservedValues.length][this.numstates];
        double[] dArray5 = new double[this.numstates];
        double[][] dArray6 = new double[n4][this.numstates];
        double[][] dArray7 = new double[n4][this.numstates];
        double[] dArray8 = new double[this.numstates];
        double[] dArray9 = new double[this.numstates];
        double[] dArray10 = new double[n4];
        double[][] dArray11 = new double[this.numstates][this.numstates];
        boolean[] blArray = new boolean[this.numdatasets];
        double[] dArray12 = new double[this.numstates];
        double[] dArray13 = new double[this.numstates];
        double[] dArray14 = new double[this.numstates];
        if (this.szincludemarks.length() != this.numdatasets) {
            throw new IllegalArgumentException("Number of marks in " + this.szincludemarks + " of " + this.szincludemarks.length() + " does not equal expected number of " + this.numdatasets);
        }
        if (this.breadstatebyline || this.breadsegment) {
            nArray2 = new int[n4];
        } else {
            dArray = new double[n4][this.numstates];
        }
        String string = "";
        for (int i = 0; i < blArray.length; ++i) {
            if (this.szincludemarks.charAt(i) == '1') {
                blArray[i] = true;
                if (string.equals("")) {
                    string = string + this.datasets[i];
                    continue;
                }
                string = string + "," + this.datasets[i];
                continue;
            }
            if (this.szincludemarks.charAt(i) == '0') {
                blArray[i] = false;
                continue;
            }
            throw new IllegalArgumentException(this.szincludemarks + " is not a valid bit string for includemarks!");
        }
        RecIntString[] recIntStringArray = new RecIntString[this.chromfiles.length];
        for (n2 = 0; n2 < recIntStringArray.length; ++n2) {
            recIntStringArray[n2] = new RecIntString(n2, this.chromfiles[n2]);
        }
        Arrays.sort(recIntStringArray, new RecIntStringCompare());
        this.hsprefix = new HashSet();
        for (n2 = 0; n2 < this.traindataObservedIndex.length; ++n2) {
            double d;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            n = recIntStringArray[n2].nindex;
            int[] nArray3 = this.traindataObservedIndex[n];
            boolean[] blArray2 = this.traindataObservedSeqFlags[n];
            String string2 = "";
            if (!this.cellSeq[n].equals("")) {
                string2 = string2 + this.cellSeq[n] + "_";
            }
            string2 = string2 + this.numstates;
            if (!this.szoutfileID.equals("")) {
                string2 = string2 + "_" + this.szoutfileID;
            }
            this.hsprefix.add(string2);
            if (this.breadposterior) {
                String string3;
                object4 = null;
                object3 = this.szsegmentdir + "/POSTERIOR/" + string2 + "_" + this.chromSeq[n] + SZPOSTERIOREXTENSION;
                object2 = new File((String)object3);
                object = new File((String)object3 + ".gz");
                if (!((File)object2).exists() && object.exists()) {
                    object3 = (String)object3 + ".gz";
                }
                object4 = Util.getBufferedReader((String)object3);
                ((BufferedReader)object4).readLine();
                ((BufferedReader)object4).readLine();
                n11 = 0;
                while ((string3 = ((BufferedReader)object4).readLine()) != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string3, "\t ");
                    for (n10 = 0; n10 < this.numstates; ++n10) {
                        dArray[n11][n10] = Double.parseDouble(stringTokenizer.nextToken());
                    }
                    ++n11;
                }
                ((BufferedReader)object4).close();
            } else if (this.breadstatebyline) {
                String string4;
                object4 = this.chromSeq[n];
                String string5 = this.szsegmentdir + "/STATEBYLINE/" + string2 + "_" + (String)object4 + SZSTATEBYLINEEXTENSION;
                object2 = new File(string5);
                object = new File(string5 + ".gz");
                if (!((File)object2).exists() && object.exists()) {
                    string5 = string5 + ".gz";
                }
                BufferedReader bufferedReader = Util.getBufferedReader(string5);
                bufferedReader.readLine();
                bufferedReader.readLine();
                int n12 = 0;
                while ((string4 = bufferedReader.readLine()) != null) {
                    nArray2[n12] = Integer.parseInt(string4) - 1;
                    ++n12;
                }
                bufferedReader.close();
            } else if (this.breadsegment) {
                String string6;
                object4 = null;
                String string7 = this.chromSeq[n];
                object2 = this.szsegmentdir + "/" + string2 + SZSEGMENTEXTENSION;
                object = new File((String)object2);
                File file = new File((String)object2 + ".gz");
                if (!object.exists() && file.exists()) {
                    object2 = (String)object2 + ".gz";
                }
                object4 = Util.getBufferedReader((String)object2);
                while ((string6 = ((BufferedReader)object4).readLine()) != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string6, "\t");
                    String string8 = stringTokenizer.nextToken().trim();
                    if (!string8.equals(string7)) continue;
                    n9 = Integer.parseInt(stringTokenizer.nextToken().trim()) / this.nbinsize;
                    n8 = (Integer.parseInt(stringTokenizer.nextToken().trim()) - 1) / this.nbinsize;
                    int n13 = Integer.parseInt(stringTokenizer.nextToken().trim().substring(1)) - 1;
                    for (int i = n9; i <= n8; ++i) {
                        nArray2[i] = n13;
                    }
                }
                ((BufferedReader)object4).close();
            }
            if (this.bscaleemissions) {
                for (n7 = 0; n7 < dArray4.length; ++n7) {
                    int n14;
                    if (!blArray2[n7]) continue;
                    object3 = dArray4[n7];
                    object2 = this.traindataObservedValues[n7];
                    object = this.traindataNotMissing[n7];
                    for (n14 = 0; n14 < this.numstates; ++n14) {
                        object3[n14] = 1.0;
                    }
                    for (n14 = 0; n14 < this.numdatasets; ++n14) {
                        for (n11 = 0; n11 < this.numstates; ++n11) {
                            if (object[n14] == false || !blArray[n14]) continue;
                            if (object2[n14] != false) {
                                Object object5 = object3;
                                int n15 = n11;
                                object5[n15] = object5[n15] * this.emissionprobs[n11][n14][1];
                                continue;
                            }
                            Object object6 = object3;
                            int n16 = n11;
                            object6[n16] = object6[n16] * this.emissionprobs[n11][n14][0];
                        }
                        Object object7 = 0.0;
                        for (n10 = 0; n10 < this.numstates; ++n10) {
                            if (!(object3[n10] > object7)) continue;
                            object7 = object3[n10];
                        }
                        if (object7 <= 0.0) {
                            for (n10 = 0; n10 < this.numstates; ++n10) {
                                object3[n10] = 1.0;
                            }
                            continue;
                        }
                        n10 = 0;
                        while (n10 < this.numstates) {
                            Object object8 = object3;
                            int n17 = n10++;
                            object8[n17] = object8[n17] / object7;
                        }
                    }
                }
            } else {
                for (n7 = 0; n7 < dArray4.length; ++n7) {
                    if (!blArray2[n7]) continue;
                    object3 = dArray4[n7];
                    object2 = this.traindataObservedValues[n7];
                    object = this.traindataNotMissing[n7];
                    boolean bl = true;
                    for (n11 = 0; n11 < this.numstates; ++n11) {
                        double d2 = 1.0;
                        double[][] dArray15 = this.emissionprobs[n11];
                        for (n8 = 0; n8 < this.numdatasets; ++n8) {
                            if (object[n8] == false || !blArray[n8]) continue;
                            if (object2[n8] != false) {
                                d2 *= dArray15[n8][1];
                                continue;
                            }
                            d2 *= dArray15[n8][0];
                        }
                        object3[n11] = d2;
                        if (!(d2 >= EPSILONEMISSIONS)) continue;
                        bl = false;
                    }
                    if (!bl) continue;
                    for (n11 = 0; n11 < this.numstates; ++n11) {
                        object3[n11] = EPSILONEMISSIONS;
                    }
                }
            }
            object4 = dArray6[0];
            double d3 = 0.0;
            object = dArray4[nArray3[0]];
            for (n6 = 0; n6 < this.numstates; ++n6) {
                object4[n6] = this.probinit[n6] * object[n6];
                d3 += object4[n6];
            }
            dArray10[0] = d3;
            if (this.bscalebeta) {
                for (n6 = 0; n6 < this.numstates; ++n6) {
                    Object object9 = object4;
                    int n18 = n6;
                    object9[n18] = object9[n18] / d3;
                    if (!(object4[n6] < EPSILONSTATE) || !(object[n6] > 0.0)) continue;
                    object4[n6] = EPSILONSTATE;
                }
            } else {
                n6 = 0;
                while (n6 < this.numstates) {
                    Object object10 = object4;
                    int n19 = n6++;
                    object10[n19] = object10[n19] / d3;
                }
            }
            for (n6 = 0; n6 < this.numstates; ++n6) {
                double[] dArray16 = dArray11[n6];
                for (int i = 0; i < this.numstates; ++i) {
                    dArray16[i] = this.transitionprobs[i][n6];
                }
            }
            n6 = nArray[n];
            for (n11 = 1; n11 < n6; ++n11) {
                double[] dArray17 = dArray6[n11 - 1];
                object4 = dArray6[n11];
                d3 = 0.0;
                object = dArray4[nArray3[n11]];
                for (n10 = 0; n10 < this.numstates; ++n10) {
                    int n20;
                    int n21 = this.transitionprobsnumCol[n10];
                    int[] nArray4 = this.transitionprobsindexCol[n10];
                    double[] dArray18 = dArray11[n10];
                    double d4 = 0.0;
                    if (n21 < n3) {
                        for (n20 = 0; n20 < n21; ++n20) {
                            int n22 = nArray4[n20];
                            d4 += dArray18[n22] * dArray17[n22];
                        }
                    } else {
                        for (n20 = 0; n20 < this.numstates; ++n20) {
                            d4 += dArray18[n20] * dArray17[n20];
                        }
                    }
                    double d5 = d4 * object[n10];
                    object4[n10] = d5;
                    d3 += d5;
                }
                dArray10[n11] = d3;
                if (this.bscalebeta) {
                    for (n10 = 0; n10 < this.numstates; ++n10) {
                        Object object11 = object4;
                        int n23 = n10;
                        object11[n23] = object11[n23] / d3;
                        if (!(object4[n10] < EPSILONSTATE) || !(object[n10] > 0.0)) continue;
                        object4[n10] = EPSILONSTATE;
                    }
                    continue;
                }
                n10 = 0;
                while (n10 < this.numstates) {
                    Object object12 = object4;
                    int n24 = n10++;
                    object12[n24] = object12[n24] / d3;
                }
            }
            n11 = n6 - 1;
            double d6 = this.bscalebeta ? 1.0 / (double)this.numstates : 1.0 / dArray10[n11];
            for (n9 = 0; n9 < this.numstates; ++n9) {
                dArray9[n9] = d6;
            }
            double d7 = 0.0;
            double[] dArray19 = dArray7[n11];
            for (n5 = 0; n5 < dArray19.length; ++n5) {
                double d8 = dArray6[n11][n5] * dArray9[n5];
                d7 += d8;
                dArray19[n5] = d8;
            }
            n5 = 0;
            while (n5 < dArray19.length) {
                int n25 = n5++;
                dArray19[n25] = dArray19[n25] / d7;
            }
            for (n5 = n11 - 1; n5 >= 0; --n5) {
                double d9;
                int n26;
                dArray19 = dArray7[n5];
                int n27 = n5 + 1;
                double[] dArray20 = dArray4[nArray3[n27]];
                double d10 = 0.0;
                d = dArray10[n5];
                for (n26 = 0; n26 < this.numstates; ++n26) {
                    dArray5[n26] = dArray9[n26] * dArray20[n26];
                }
                for (n26 = 0; n26 < this.numstates; ++n26) {
                    int n28;
                    d9 = 0.0;
                    int[] nArray5 = this.transitionprobsindex[n26];
                    double[] dArray21 = this.transitionprobs[n26];
                    int n29 = this.transitionprobsnum[n26];
                    if (n29 < n3) {
                        for (n28 = 0; n28 < n29; ++n28) {
                            n9 = nArray5[n28];
                            d9 += dArray21[n9] * dArray5[n9];
                        }
                    } else {
                        for (n28 = 0; n28 < this.numstates; ++n28) {
                            d9 += dArray21[n28] * dArray5[n28];
                        }
                    }
                    if (this.bscalebeta) {
                        dArray8[n26] = d9;
                        d10 += d9;
                        continue;
                    }
                    double d11 = d9 / d;
                    dArray8[n26] = d11 > Double.MAX_VALUE ? Double.MAX_VALUE : d11;
                }
                if (this.bscalebeta) {
                    for (n26 = 0; n26 < this.numstates; ++n26) {
                        int n30 = n26;
                        dArray8[n30] = dArray8[n30] / d10;
                        if (!(dArray8[n26] < EPSILONSTATE)) continue;
                        dArray8[n26] = EPSILONSTATE;
                    }
                }
                d7 = 0.0;
                object4 = dArray6[n5];
                for (n26 = 0; n26 < dArray19.length; ++n26) {
                    d9 = (double)(object4[n26] * dArray8[n26]);
                    d7 += d9;
                    dArray19[n26] = d9;
                }
                n26 = 0;
                while (n26 < dArray19.length) {
                    int n31 = n26++;
                    dArray19[n31] = dArray19[n31] / d7;
                }
                dArray9 = dArray8;
            }
            for (n5 = 0; n5 < n6; ++n5) {
                int n32;
                dArray19 = dArray7[n5];
                if (this.breadsegment || this.breadstatebyline) {
                    double d12 = 0.0;
                    int n33 = 0;
                    for (n32 = 0; n32 < dArray19.length; ++n32) {
                        d = dArray19[n32];
                        if (!(d > d12)) continue;
                        d12 = d;
                        n33 = n32;
                    }
                    double[] dArray22 = dArray2[nArray2[n5]];
                    int n34 = n33;
                    dArray22[n34] = dArray22[n34] + 1.0;
                    continue;
                }
                double[] dArray23 = dArray[n5];
                for (int i = 0; i < this.numstates; ++i) {
                    double d13 = dArray23[i];
                    d = dArray19[i];
                    if (d13 >= d) {
                        int n35 = i;
                        dArray14[n35] = dArray14[n35] + d;
                        dArray13[i] = d13 - d;
                        dArray12[i] = 0.0;
                        continue;
                    }
                    int n36 = i;
                    dArray14[n36] = dArray14[n36] + d13;
                    dArray12[i] = d - d13;
                    dArray13[i] = 0.0;
                }
                double d14 = 0.0;
                for (n32 = 0; n32 < dArray12.length; ++n32) {
                    d14 += dArray12[n32];
                }
                n32 = 0;
                while (n32 < dArray12.length) {
                    int n37 = n32++;
                    dArray12[n37] = dArray12[n37] / d14;
                }
                for (n32 = 0; n32 < dArray2.length; ++n32) {
                    double[] dArray24 = dArray2[n32];
                    if (!(dArray13[n32] > 0.0)) continue;
                    double d15 = dArray13[n32];
                    for (int i = 0; i < dArray24.length; ++i) {
                        int n38 = i;
                        dArray24[n38] = dArray24[n38] + d15 * dArray12[i];
                    }
                }
                for (n32 = 0; n32 < dArray2.length; ++n32) {
                    dArray2[n32][n32] = dArray14[n32];
                }
            }
        }
        System.out.println("Writing to file " + this.szconfusionfileprefix + ".txt");
        if (this.bprintimage) {
            System.out.println("Writing to file " + this.szconfusionfileprefix + ".svg");
            System.out.println("Writing to file " + this.szconfusionfileprefix + ".png");
        }
        PrintWriter printWriter = new PrintWriter(new FileWriter(this.szconfusionfileprefix + ".txt", this.bappend));
        printWriter.print("EvalSubset\t" + this.szincludemarks);
        printWriter.println("\t" + string);
        for (n = 0; n < dArray2.length; ++n) {
            printWriter.print("\t" + this.chorder + (n + 1));
        }
        printWriter.println();
        for (n = 0; n < dArray2.length; ++n) {
            int n39;
            printWriter.print("" + this.chorder + (n + 1));
            double d = 0.0;
            for (n39 = 0; n39 < dArray2[n].length; ++n39) {
                d += dArray2[n][n39];
            }
            for (n39 = 0; n39 < dArray2[n].length; ++n39) {
                dArray3[n][n39] = dArray2[n][n39] / d;
                printWriter.print("\t" + numberFormat.format(dArray3[n][n39]));
            }
            printWriter.println();
        }
        printWriter.close();
        if (this.bprintimage) {
            this.printConfusionImage(dArray3, this.szconfusionfileprefix, this.szincludemarks);
        }
    }

    /*
     * Could not resolve type clashes
     */
    public void makeSegmentationConfusionWithLoad() throws IOException {
        int n;
        int n2;
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(4);
        int n3 = (int)((double)this.numstates * SPARSECUTOFFRATIO);
        int n4 = 0;
        for (int i = 0; i < this.numtime.length; ++i) {
            if (this.numtime[i] <= n4) continue;
            n4 = this.numtime[i];
        }
        double[][] dArray = null;
        int[] nArray = null;
        double[][] dArray2 = new double[this.numstates][this.numstates];
        double[][] dArray3 = new double[this.numstates][this.numstates];
        if (this.breadposterior) {
            dArray = new double[n4][this.numstates];
        }
        if (this.breadstatebyline || this.breadsegment) {
            nArray = new int[n4];
        }
        if (BVERBOSE) {
            System.out.println("Maximum number of locations\t" + n4);
        }
        double[][] dArray4 = new double[n4][this.numstates];
        double[] dArray5 = new double[this.numstates];
        double[][] dArray6 = new double[n4][this.numstates];
        double[][] dArray7 = new double[n4][this.numstates];
        double[] dArray8 = new double[this.numstates];
        double[] dArray9 = new double[this.numstates];
        double[] dArray10 = new double[n4];
        double[][] dArray11 = new double[this.numstates][this.numstates];
        int[] nArray2 = new int[n4];
        boolean[][] blArray = new boolean[n4][this.numdatasets];
        boolean[][] blArray2 = new boolean[n4][this.numdatasets];
        boolean[] blArray3 = new boolean[this.numdatasets];
        double[] dArray12 = new double[this.numstates];
        double[] dArray13 = new double[this.numstates];
        double[] dArray14 = new double[this.numstates];
        if (this.szincludemarks.length() != this.numdatasets) {
            throw new IllegalArgumentException("Number of marks in " + this.szincludemarks + " of " + this.szincludemarks.length() + " does not equal expected number of " + this.numdatasets);
        }
        if (this.breadstatebyline || this.breadsegment) {
            nArray = new int[n4];
        } else {
            dArray = new double[n4][this.numstates];
        }
        String string = "";
        for (int i = 0; i < blArray3.length; ++i) {
            if (this.szincludemarks.charAt(i) == '1') {
                blArray3[i] = true;
                if (string.equals("")) {
                    string = string + this.datasets[i];
                    continue;
                }
                string = string + "," + this.datasets[i];
                continue;
            }
            if (this.szincludemarks.charAt(i) == '0') {
                blArray3[i] = false;
                continue;
            }
            throw new IllegalArgumentException(this.szincludemarks + " is not a valid bit string for includemarks!");
        }
        RecIntString[] recIntStringArray = new RecIntString[this.chromfiles.length];
        for (n2 = 0; n2 < recIntStringArray.length; ++n2) {
            recIntStringArray[n2] = new RecIntString(n2, this.chromfiles[n2]);
        }
        Arrays.sort(recIntStringArray, new RecIntStringCompare());
        this.hsprefix = new HashSet();
        for (n2 = 0; n2 < this.chromfiles.length; ++n2) {
            double d;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            String string2;
            n = recIntStringArray[n2].nindex;
            HashMap<BigInteger, Integer> hashMap = new HashMap<BigInteger, Integer>();
            int n13 = 0;
            if (BVERBOSE) {
                System.out.println("reading\t" + this.szinputdir + " " + this.chromfiles[n]);
            }
            BufferedReader bufferedReader = Util.getBufferedReader(this.szinputdir + "/" + this.chromfiles[n]);
            bufferedReader.readLine();
            bufferedReader.readLine();
            ArrayList<String> arrayList = new ArrayList<String>();
            while ((string2 = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "\t ");
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < this.numdatasets; ++i) {
                    if (!stringTokenizer.hasMoreTokens()) {
                        throw new IllegalArgumentException("Found line without " + this.numdatasets + " values in file " + this.chromfiles[n]);
                    }
                    object4 = stringTokenizer.nextToken();
                    if (((String)object4).equals("0")) {
                        stringBuffer.append("0");
                        continue;
                    }
                    if (((String)object4).equals("1")) {
                        stringBuffer.append("1");
                        continue;
                    }
                    if (((String)object4).equals("2")) {
                        stringBuffer.append("2");
                        continue;
                    }
                    throw new IllegalArgumentException("Unrecognized value " + (String)object4 + " found in " + this.szinputdir + "/" + this.chromfiles[n]);
                }
                arrayList.add(stringBuffer.toString());
            }
            bufferedReader.close();
            int n14 = arrayList.size();
            for (int i = 0; i < n14; ++i) {
                BigInteger bigInteger = new BigInteger((String)arrayList.get(i), 3);
                object4 = (Integer)hashMap.get(bigInteger);
                if (object4 == null) {
                    hashMap.put(bigInteger, n13);
                    nArray2[i] = n13++;
                    continue;
                }
                nArray2[i] = (Integer)object4;
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                object4 = (BigInteger)entry.getKey();
                object3 = ((BigInteger)object4).toString(3);
                int n15 = (Integer)entry.getValue();
                object2 = blArray[n15];
                object = blArray2[n15];
                n12 = ((String)object3).length();
                n11 = this.numdatasets - n12;
                for (n10 = 0; n10 < n11; ++n10) {
                    object2[n10] = false;
                    object[n10] = true;
                }
                n10 = n11;
                for (n9 = 0; n9 < n12; ++n9) {
                    n8 = ((String)object3).charAt(n9);
                    if (n8 == 48) {
                        object2[n10] = false;
                        object[n10] = true;
                    } else if (n8 == 49) {
                        object2[n10] = true;
                        object[n10] = true;
                    } else {
                        object2[n10] = false;
                        object[n10] = false;
                    }
                    ++n10;
                }
            }
            String string3 = "";
            if (!this.cellSeq[n].equals("")) {
                string3 = string3 + this.cellSeq[n] + "_";
            }
            string3 = string3 + this.numstates;
            if (!this.szoutfileID.equals("")) {
                string3 = string3 + "_" + this.szoutfileID;
            }
            this.hsprefix.add(string3);
            if (this.breadposterior) {
                object4 = null;
                object3 = this.szsegmentdir + "/POSTERIOR/" + string3 + "_" + this.chromSeq[n] + SZPOSTERIOREXTENSION;
                File file = new File((String)object3);
                object2 = new File((String)object3 + ".gz");
                if (!file.exists() && object2.exists()) {
                    object3 = (String)object3 + ".gz";
                }
                object4 = Util.getBufferedReader((String)object3);
                ((BufferedReader)object4).readLine();
                ((BufferedReader)object4).readLine();
                n12 = 0;
                while ((object = ((BufferedReader)object4).readLine()) != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer((String)object, "\t ");
                    for (n10 = 0; n10 < this.numstates; ++n10) {
                        dArray[n12][n10] = Double.parseDouble(stringTokenizer.nextToken());
                    }
                    ++n12;
                }
                ((BufferedReader)object4).close();
            } else if (this.breadstatebyline) {
                String string4;
                object4 = this.chromSeq[n];
                object3 = this.szsegmentdir + "/STATEBYLINE/" + string3 + "_" + (String)object4 + SZSTATEBYLINEEXTENSION;
                File file = new File((String)object3);
                object2 = new File((String)object3 + ".gz");
                if (!file.exists() && object2.exists()) {
                    object3 = (String)object3 + ".gz";
                }
                object = Util.getBufferedReader((String)object3);
                ((BufferedReader)object).readLine();
                ((BufferedReader)object).readLine();
                n11 = 0;
                while ((string4 = ((BufferedReader)object).readLine()) != null) {
                    nArray[n11] = Integer.parseInt(string4) - 1;
                    ++n11;
                }
                ((BufferedReader)object).close();
            } else if (this.breadsegment) {
                String string5;
                object4 = null;
                object3 = this.chromSeq[n];
                String string6 = this.szsegmentdir + "/" + string3 + SZSEGMENTEXTENSION;
                object2 = new File(string6);
                object = new File(string6 + ".gz");
                if (!object2.exists() && ((File)object).exists()) {
                    string6 = string6 + ".gz";
                }
                object4 = Util.getBufferedReader(string6);
                while ((string5 = ((BufferedReader)object4).readLine()) != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string5, "\t");
                    String string7 = stringTokenizer.nextToken().trim();
                    if (!string7.equals(object3)) continue;
                    n9 = Integer.parseInt(stringTokenizer.nextToken().trim()) / this.nbinsize;
                    n8 = (Integer.parseInt(stringTokenizer.nextToken().trim()) - 1) / this.nbinsize;
                    int n16 = Integer.parseInt(stringTokenizer.nextToken().trim().substring(1)) - 1;
                    for (int i = n9; i <= n8; ++i) {
                        nArray[i] = n16;
                    }
                }
                ((BufferedReader)object4).close();
            }
            if (this.bscaleemissions) {
                for (n7 = 0; n7 < n13; ++n7) {
                    int n17;
                    object3 = dArray4[n7];
                    boolean[] blArray4 = blArray[n7];
                    object2 = blArray2[n7];
                    for (n17 = 0; n17 < this.numstates; ++n17) {
                        object3[n17] = 1.0;
                    }
                    for (n17 = 0; n17 < this.numdatasets; ++n17) {
                        int n18;
                        for (int i = 0; i < this.numstates; ++i) {
                            if (object2[n17] == false || !blArray3[n17]) continue;
                            if (blArray4[n17]) {
                                Object object5 = object3;
                                int n19 = i;
                                object5[n19] = object5[n19] * this.emissionprobs[i][n17][1];
                                continue;
                            }
                            Object object6 = object3;
                            int n20 = i;
                            object6[n20] = object6[n20] * this.emissionprobs[i][n17][0];
                        }
                        Object object7 = 0.0;
                        for (n18 = 0; n18 < this.numstates; ++n18) {
                            if (!(object3[n18] > object7)) continue;
                            object7 = object3[n18];
                        }
                        if (object7 <= 0.0) {
                            for (n18 = 0; n18 < this.numstates; ++n18) {
                                object3[n18] = 1.0;
                            }
                            continue;
                        }
                        n18 = 0;
                        while (n18 < this.numstates) {
                            Object object8 = object3;
                            int n21 = n18++;
                            object8[n21] = object8[n21] / object7;
                        }
                    }
                }
            } else {
                for (n7 = 0; n7 < n13; ++n7) {
                    int n22;
                    object3 = dArray4[n7];
                    boolean[] blArray5 = blArray[n7];
                    object2 = blArray2[n7];
                    boolean bl = true;
                    for (n22 = 0; n22 < this.numstates; ++n22) {
                        double d2 = 1.0;
                        double[][] dArray15 = this.emissionprobs[n22];
                        for (n8 = 0; n8 < this.numdatasets; ++n8) {
                            if (object2[n8] == false || !blArray3[n8]) continue;
                            if (blArray5[n8]) {
                                d2 *= dArray15[n8][1];
                                continue;
                            }
                            d2 *= dArray15[n8][0];
                        }
                        object3[n22] = d2;
                        if (!(d2 >= EPSILONEMISSIONS)) continue;
                        bl = false;
                    }
                    if (!bl) continue;
                    for (n22 = 0; n22 < this.numstates; ++n22) {
                        object3[n22] = EPSILONEMISSIONS;
                    }
                }
            }
            object4 = dArray6[0];
            double d3 = 0.0;
            object2 = dArray4[nArray2[0]];
            for (n6 = 0; n6 < this.numstates; ++n6) {
                object4[n6] = this.probinit[n6] * object2[n6];
                d3 += object4[n6];
            }
            dArray10[0] = d3;
            if (this.bscalebeta) {
                for (n6 = 0; n6 < this.numstates; ++n6) {
                    Object object9 = object4;
                    int n23 = n6;
                    object9[n23] = object9[n23] / d3;
                    if (!(object4[n6] < EPSILONSTATE) || !(object2[n6] > 0.0)) continue;
                    object4[n6] = EPSILONSTATE;
                }
            } else {
                n6 = 0;
                while (n6 < this.numstates) {
                    Object object10 = object4;
                    int n24 = n6++;
                    object10[n24] = object10[n24] / d3;
                }
            }
            for (n6 = 0; n6 < this.numstates; ++n6) {
                double[] dArray16 = dArray11[n6];
                for (int i = 0; i < this.numstates; ++i) {
                    dArray16[i] = this.transitionprobs[i][n6];
                }
            }
            n6 = this.numtime[n];
            for (n12 = 1; n12 < n6; ++n12) {
                int n25;
                double[] dArray17 = dArray6[n12 - 1];
                object4 = dArray6[n12];
                d3 = 0.0;
                object2 = dArray4[nArray2[n12]];
                for (n25 = 0; n25 < this.numstates; ++n25) {
                    int n26;
                    int n27 = this.transitionprobsnumCol[n25];
                    int[] nArray3 = this.transitionprobsindexCol[n25];
                    double[] dArray18 = dArray11[n25];
                    double d4 = 0.0;
                    if (n27 < n3) {
                        for (n26 = 0; n26 < n27; ++n26) {
                            int n28 = nArray3[n26];
                            d4 += dArray18[n28] * dArray17[n28];
                        }
                    } else {
                        for (n26 = 0; n26 < this.numstates; ++n26) {
                            d4 += dArray18[n26] * dArray17[n26];
                        }
                    }
                    double d5 = d4 * object2[n25];
                    object4[n25] = d5;
                    d3 += d5;
                }
                dArray10[n12] = d3;
                if (this.bscalebeta) {
                    for (n25 = 0; n25 < this.numstates; ++n25) {
                        Object object11 = object4;
                        int n29 = n25;
                        object11[n29] = object11[n29] / d3;
                        if (!(object4[n25] < EPSILONSTATE) || !(object2[n25] > 0.0)) continue;
                        object4[n25] = EPSILONSTATE;
                    }
                    continue;
                }
                n25 = 0;
                while (n25 < this.numstates) {
                    Object object12 = object4;
                    int n30 = n25++;
                    object12[n30] = object12[n30] / d3;
                }
            }
            n12 = n6 - 1;
            double d6 = this.bscalebeta ? 1.0 / (double)this.numstates : 1.0 / dArray10[n12];
            for (n9 = 0; n9 < this.numstates; ++n9) {
                dArray9[n9] = d6;
            }
            double d7 = 0.0;
            double[] dArray19 = dArray7[n12];
            for (n5 = 0; n5 < dArray19.length; ++n5) {
                double d8 = dArray6[n12][n5] * dArray9[n5];
                d7 += d8;
                dArray19[n5] = d8;
            }
            n5 = 0;
            while (n5 < dArray19.length) {
                int n31 = n5++;
                dArray19[n31] = dArray19[n31] / d7;
            }
            for (n5 = n12 - 1; n5 >= 0; --n5) {
                double d9;
                int n32;
                dArray19 = dArray7[n5];
                int n33 = n5 + 1;
                double[] dArray20 = dArray4[nArray2[n33]];
                double d10 = 0.0;
                d = dArray10[n5];
                for (n32 = 0; n32 < this.numstates; ++n32) {
                    dArray5[n32] = dArray9[n32] * dArray20[n32];
                }
                for (n32 = 0; n32 < this.numstates; ++n32) {
                    int n34;
                    d9 = 0.0;
                    int[] nArray4 = this.transitionprobsindex[n32];
                    double[] dArray21 = this.transitionprobs[n32];
                    int n35 = this.transitionprobsnum[n32];
                    if (n35 < n3) {
                        for (n34 = 0; n34 < n35; ++n34) {
                            n9 = nArray4[n34];
                            d9 += dArray21[n9] * dArray5[n9];
                        }
                    } else {
                        for (n34 = 0; n34 < this.numstates; ++n34) {
                            d9 += dArray21[n34] * dArray5[n34];
                        }
                    }
                    if (this.bscalebeta) {
                        dArray8[n32] = d9;
                        d10 += d9;
                        continue;
                    }
                    double d11 = d9 / d;
                    dArray8[n32] = d11 > Double.MAX_VALUE ? Double.MAX_VALUE : d11;
                }
                if (this.bscalebeta) {
                    for (n32 = 0; n32 < this.numstates; ++n32) {
                        int n36 = n32;
                        dArray8[n36] = dArray8[n36] / d10;
                        if (!(dArray8[n32] < EPSILONSTATE)) continue;
                        dArray8[n32] = EPSILONSTATE;
                    }
                }
                d7 = 0.0;
                object4 = dArray6[n5];
                for (n32 = 0; n32 < dArray19.length; ++n32) {
                    d9 = (double)(object4[n32] * dArray8[n32]);
                    d7 += d9;
                    dArray19[n32] = d9;
                }
                n32 = 0;
                while (n32 < dArray19.length) {
                    int n37 = n32++;
                    dArray19[n37] = dArray19[n37] / d7;
                }
                dArray9 = dArray8;
            }
            for (n5 = 0; n5 < n6; ++n5) {
                int n38;
                dArray19 = dArray7[n5];
                if (this.breadsegment || this.breadstatebyline) {
                    double d12 = 0.0;
                    int n39 = 0;
                    for (n38 = 0; n38 < dArray19.length; ++n38) {
                        d = dArray19[n38];
                        if (!(d > d12)) continue;
                        d12 = d;
                        n39 = n38;
                    }
                    double[] dArray22 = dArray2[nArray[n5]];
                    int n40 = n39;
                    dArray22[n40] = dArray22[n40] + 1.0;
                    continue;
                }
                double[] dArray23 = dArray[n5];
                for (int i = 0; i < this.numstates; ++i) {
                    double d13 = dArray23[i];
                    d = dArray19[i];
                    if (d13 >= d) {
                        int n41 = i;
                        dArray14[n41] = dArray14[n41] + d;
                        dArray13[i] = d13 - d;
                        dArray12[i] = 0.0;
                        continue;
                    }
                    int n42 = i;
                    dArray14[n42] = dArray14[n42] + d13;
                    dArray12[i] = d - d13;
                    dArray13[i] = 0.0;
                }
                double d14 = 0.0;
                for (n38 = 0; n38 < dArray12.length; ++n38) {
                    d14 += dArray12[n38];
                }
                n38 = 0;
                while (n38 < dArray12.length) {
                    int n43 = n38++;
                    dArray12[n43] = dArray12[n43] / d14;
                }
                for (n38 = 0; n38 < dArray2.length; ++n38) {
                    double[] dArray24 = dArray2[n38];
                    if (!(dArray13[n38] > 0.0)) continue;
                    double d15 = dArray13[n38];
                    for (int i = 0; i < dArray24.length; ++i) {
                        int n44 = i;
                        dArray24[n44] = dArray24[n44] + d15 * dArray12[i];
                    }
                }
                for (n38 = 0; n38 < dArray2.length; ++n38) {
                    dArray2[n38][n38] = dArray14[n38];
                }
            }
        }
        System.out.println("Writing to file " + this.szconfusionfileprefix + ".txt");
        if (this.bprintimage) {
            System.out.println("Writing to file " + this.szconfusionfileprefix + ".svg");
            System.out.println("Writing to file " + this.szconfusionfileprefix + ".png");
        }
        PrintWriter printWriter = new PrintWriter(new FileWriter(this.szconfusionfileprefix + ".txt", this.bappend));
        printWriter.print("EvalSubset\t" + this.szincludemarks);
        printWriter.println("\t" + string);
        for (n = 0; n < dArray2.length; ++n) {
            printWriter.print("\t" + this.chorder + (n + 1));
        }
        printWriter.println();
        for (n = 0; n < dArray2.length; ++n) {
            int n45;
            printWriter.print("" + this.chorder + (n + 1));
            double d = 0.0;
            for (n45 = 0; n45 < dArray2[n].length; ++n45) {
                d += dArray2[n][n45];
            }
            for (n45 = 0; n45 < dArray2[n].length; ++n45) {
                dArray3[n][n45] = dArray2[n][n45] / d;
                printWriter.print("\t" + numberFormat.format(dArray3[n][n45]));
            }
            printWriter.println();
        }
        printWriter.close();
        if (this.bprintimage) {
            this.printConfusionImage(dArray3, this.szconfusionfileprefix, this.szincludemarks);
        }
    }

    public void printConfusionImage(double[][] dArray, String string, String string2) throws IOException {
        Object[] objectArray = new String[this.numstates];
        for (int i = 0; i < this.numstates; ++i) {
            objectArray[i] = "" + (i + 1);
            String string3 = (String)this.hmlabelExtend.get("" + this.chorder + (i + 1));
            if (string3 == null) continue;
            int n = i;
            objectArray[n] = objectArray[n] + "_" + string3;
        }
        HeatChart heatChart = new HeatChart(dArray);
        heatChart.setTitle("Confusion Matrix");
        heatChart.setXAxisLabel("State Subset of Marks (" + string2 + ")");
        heatChart.setAxisValuesFont(new Font("SansSerif", 0, 20));
        heatChart.setAxisLabelsFont(new Font("SansSerif", 0, 22));
        heatChart.setTitleFont(new Font("SansSerif", 0, 24));
        heatChart.setYAxisLabel("State All Marks");
        if (dArray.length <= 5) {
            heatChart.setChartMargin(125);
        } else {
            heatChart.setChartMargin(100);
        }
        heatChart.setXValues(objectArray);
        heatChart.setYValues(objectArray);
        heatChart.setHighValueColour(this.theColor);
        Util.printImageToSVG(heatChart, string + ".svg");
        heatChart.saveToFile(new File(string + ".png"));
    }

    /*
     * Could not resolve type clashes
     */
    public void makeSegmentationWithLoad() throws IOException {
        block130: {
            Object object;
            int n;
            Object object2;
            Object object3;
            Object object4;
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
            numberFormat.setMaximumFractionDigits(4);
            int n2 = (int)((double)this.numstates * SPARSECUTOFFRATIO);
            int n3 = 0;
            for (int i = 0; i < this.numtime.length; ++i) {
                if (this.numtime[i] <= n3) continue;
                n3 = this.numtime[i];
            }
            HashMap<String, Integer> hashMap = null;
            if (this.szchromlengthfile != null) {
                hashMap = new HashMap<String, Integer>();
                object4 = Util.getBufferedReader(this.szchromlengthfile);
                while (true) {
                    String string = ((BufferedReader)object4).readLine();
                    object3 = string;
                    if (string == null) break;
                    object2 = new StringTokenizer((String)object3, "\t ");
                    hashMap.put(((StringTokenizer)object2).nextToken(), Integer.valueOf(((StringTokenizer)object2).nextToken()));
                }
                ((BufferedReader)object4).close();
            }
            if (BVERBOSE) {
                System.out.println("Maximum number of locations\t" + n3);
            }
            object4 = new double[n3][this.numstates];
            object3 = new double[this.numstates];
            object2 = new double[n3][this.numstates];
            double[][] dArray = new double[n3][this.numstates];
            double[] dArray2 = new double[this.numstates];
            double[] dArray3 = new double[this.numstates];
            double[] dArray4 = new double[n3];
            double[][] dArray5 = new double[this.numstates][this.numstates];
            int[] nArray = new int[n3];
            boolean[][] blArray = new boolean[n3][this.numdatasets];
            boolean[][] blArray2 = new boolean[n3][this.numdatasets];
            HashMap<String, Object> hashMap2 = null;
            if (this.bprintsegment) {
                hashMap2 = new HashMap<String, Object>();
            }
            RecIntString[] recIntStringArray = null;
            RecIntStringSplit[] recIntStringSplitArray = null;
            if (this.bsplit) {
                recIntStringSplitArray = new RecIntStringSplit[this.chromfiles.length];
                for (n = 0; n < recIntStringSplitArray.length; ++n) {
                    int n4 = this.chromSeq[n].lastIndexOf(46);
                    if (n4 == -1) {
                        throw new IllegalArgumentException("No period found in chromosome " + this.chromSeq[n] + " despite split being specified");
                    }
                    object = this.chromSeq[n].substring(0, n4);
                    int n5 = Integer.parseInt(this.chromSeq[n].substring(n4 + 1));
                    recIntStringSplitArray[n] = new RecIntStringSplit(n, this.cellSeq[n], (String)object, n5);
                }
                Arrays.sort(recIntStringSplitArray, new RecIntStringSplitCompare());
            } else {
                recIntStringArray = new RecIntString[this.chromfiles.length];
                for (n = 0; n < recIntStringArray.length; ++n) {
                    recIntStringArray[n] = new RecIntString(n, this.chromfiles[n]);
                }
                Arrays.sort(recIntStringArray, new RecIntStringCompare());
            }
            this.hsprefix = new HashSet();
            GZIPOutputStream gZIPOutputStream = null;
            GZIPOutputStream gZIPOutputStream2 = null;
            object = null;
            PrintWriter printWriter = null;
            PrintWriter printWriter2 = null;
            PrintWriter printWriter3 = null;
            int n6 = 0;
            boolean bl = true;
            boolean bl2 = true;
            int n7 = 0;
            int n8 = -1;
            int n9 = 0;
            for (int i = 0; i < this.chromfiles.length; ++i) {
                int n10;
                int n11;
                int n12;
                int n13;
                int n14;
                int n15;
                int n16;
                int n17;
                int n18;
                Object object5;
                String string;
                int n19;
                Object object6;
                String string2;
                String string3;
                int n20;
                if (this.bsplit) {
                    n20 = recIntStringSplitArray[i].nindex;
                    string3 = recIntStringSplitArray[i].szchrom;
                } else {
                    n20 = recIntStringArray[i].nindex;
                    string3 = this.chromSeq[n20];
                }
                if (this.bsplit) {
                    if (recIntStringSplitArray[i].nsplitbinindex == 0) {
                        n6 = 0;
                        bl2 = true;
                    } else {
                        n6 += n9;
                        if (i >= 1 && recIntStringSplitArray[i].nsplitbinindex != recIntStringSplitArray[i - 1].nsplitbinindex + 1) {
                            throw new IllegalArgumentException("For " + recIntStringSplitArray[i].szcell + "_" + recIntStringSplitArray[i].szchrom + " found a file with split index " + recIntStringSplitArray[i].nsplitbinindex + ", but not " + (recIntStringSplitArray[i].nsplitbinindex - 1));
                        }
                        bl2 = false;
                    }
                    bl = i + 1 == recIntStringSplitArray.length || recIntStringSplitArray[i + 1].nsplitbinindex == 0;
                }
                HashMap<BigInteger, Integer> hashMap3 = new HashMap<BigInteger, Integer>();
                int n21 = 0;
                if (BVERBOSE) {
                    System.out.println("reading\t" + this.szinputdir + " " + this.chromfiles[n20]);
                }
                BufferedReader bufferedReader = Util.getBufferedReader(this.szinputdir + "/" + this.chromfiles[n20]);
                bufferedReader.readLine();
                bufferedReader.readLine();
                ArrayList<String> arrayList = new ArrayList<String>();
                while ((string2 = bufferedReader.readLine()) != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, "\t ");
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int j = 0; j < this.numdatasets; ++j) {
                        if (!stringTokenizer.hasMoreTokens()) {
                            throw new IllegalArgumentException("Found line without " + this.numdatasets + " values in file " + this.chromfiles[n20]);
                        }
                        object6 = stringTokenizer.nextToken();
                        if (((String)object6).equals("0")) {
                            stringBuffer.append("0");
                            continue;
                        }
                        if (((String)object6).equals("1")) {
                            stringBuffer.append("1");
                            continue;
                        }
                        if (((String)object6).equals("2")) {
                            stringBuffer.append("2");
                            continue;
                        }
                        throw new IllegalArgumentException("Unrecognized value " + (String)object6 + " found in " + this.szinputdir + "/" + this.chromfiles[n20]);
                    }
                    arrayList.add(stringBuffer.toString());
                }
                bufferedReader.close();
                n9 = n19 = arrayList.size();
                for (int j = 0; j < n19; ++j) {
                    BigInteger bigInteger = new BigInteger((String)arrayList.get(j), 3);
                    object6 = (Integer)hashMap3.get(bigInteger);
                    if (object6 == null) {
                        hashMap3.put(bigInteger, n21);
                        nArray[j] = n21++;
                        continue;
                    }
                    nArray[j] = (Integer)object6;
                }
                for (Map.Entry entry : hashMap3.entrySet()) {
                    object6 = (BigInteger)entry.getKey();
                    string = ((BigInteger)object6).toString(3);
                    int n22 = (Integer)entry.getValue();
                    object5 = blArray[n22];
                    boolean[] blArray3 = blArray2[n22];
                    int n23 = string.length();
                    n18 = this.numdatasets - n23;
                    for (n17 = 0; n17 < n18; ++n17) {
                        object5[n17] = false;
                        blArray3[n17] = true;
                    }
                    n17 = n18;
                    for (n16 = 0; n16 < n23; ++n16) {
                        char c = string.charAt(n16);
                        if (c == '0') {
                            object5[n17] = false;
                            blArray3[n17] = true;
                        } else if (c == '1') {
                            object5[n17] = true;
                            blArray3[n17] = true;
                        } else {
                            object5[n17] = false;
                            blArray3[n17] = false;
                        }
                        ++n17;
                    }
                }
                if (bl2) {
                    String string4 = "";
                    if (!this.cellSeq[n20].equals("")) {
                        string4 = string4 + this.cellSeq[n20] + "_";
                    }
                    string4 = string4 + this.numstates;
                    if (!this.szoutfileID.equals("")) {
                        string4 = string4 + "_" + this.szoutfileID;
                    }
                    this.hsprefix.add(string4);
                    if (this.bgzip) {
                        if (this.bprintposterior) {
                            object6 = this.szoutputdir + "/POSTERIOR/" + string4 + "_" + string3 + SZPOSTERIOREXTENSION + ".gz";
                            System.out.println("Writing to file " + (String)object6);
                            gZIPOutputStream = new GZIPOutputStream(new FileOutputStream((String)object6));
                            string = this.cellSeq[n20] + "\t" + string3 + "\n";
                            byte[] byArray = string.getBytes();
                            gZIPOutputStream.write(byArray, 0, byArray.length);
                            object5 = new StringBuffer();
                            for (int j = 0; j < this.numstates - 1; ++j) {
                                ((StringBuffer)object5).append("" + this.chorder + (j + 1) + "\t");
                            }
                            ((StringBuffer)object5).append("" + this.chorder + this.numstates + "\n");
                            byArray = ((StringBuffer)object5).toString().getBytes();
                            gZIPOutputStream.write(byArray, 0, byArray.length);
                        }
                        if (this.bprintstatebyline) {
                            object6 = this.szoutputdir + "/STATEBYLINE/" + string4 + "_" + string3 + SZSTATEBYLINEEXTENSION + ".gz";
                            System.out.println("Writing to file " + (String)object6);
                            gZIPOutputStream2 = new GZIPOutputStream(new FileOutputStream((String)object6));
                            string = this.cellSeq[n20] + "\t" + string3 + "\n";
                            byte[] byArray = string.getBytes();
                            gZIPOutputStream2.write(byArray, 0, byArray.length);
                            string = "MaxState " + this.chorder + "\n";
                            byArray = string.getBytes();
                            gZIPOutputStream2.write(byArray, 0, byArray.length);
                        }
                        if (this.bprintsegment && (object = (GZIPOutputStream)hashMap2.get(this.cellSeq[n20])) == null) {
                            object6 = this.szoutputdir + "/" + string4 + SZSEGMENTEXTENSION + ".gz";
                            object = new GZIPOutputStream(new FileOutputStream((String)object6));
                            System.out.println("Writing to file " + (String)object6);
                            hashMap2.put(this.cellSeq[n20], object);
                        }
                    } else {
                        if (this.bprintposterior) {
                            object6 = this.szoutputdir + "/POSTERIOR/" + string4 + "_" + string3 + SZPOSTERIOREXTENSION;
                            System.out.println("Writing to file " + (String)object6);
                            printWriter = new PrintWriter((String)object6);
                            printWriter.println(this.cellSeq[n20] + "\t" + string3);
                            for (int j = 0; j < this.numstates - 1; ++j) {
                                printWriter.print("" + this.chorder + (j + 1) + "\t");
                            }
                            printWriter.println("" + this.chorder + this.numstates);
                        }
                        if (this.bprintstatebyline) {
                            object6 = this.szoutputdir + "/STATEBYLINE/" + string4 + "_" + string3 + SZSTATEBYLINEEXTENSION;
                            System.out.println("Writing to file " + (String)object6);
                            printWriter2 = new PrintWriter((String)object6);
                            printWriter2.println(this.cellSeq[n20] + "\t" + string3);
                            printWriter2.println("MaxState " + this.chorder);
                        }
                        if (this.bprintsegment && (printWriter3 = (PrintWriter)hashMap2.get(this.cellSeq[n20])) == null) {
                            object6 = this.szoutputdir + "/" + string4 + SZSEGMENTEXTENSION;
                            printWriter3 = new PrintWriter((String)object6);
                            System.out.println("Writing to file " + (String)object6);
                            hashMap2.put(this.cellSeq[n20], printWriter3);
                        }
                    }
                }
                if (this.bscaleemissions) {
                    for (n15 = 0; n15 < n21; ++n15) {
                        int n24;
                        object6 = object4[n15];
                        boolean[] blArray4 = blArray[n15];
                        boolean[] blArray5 = blArray2[n15];
                        for (n24 = 0; n24 < this.numstates; ++n24) {
                            object6[n24] = 1.0;
                        }
                        for (n24 = 0; n24 < this.numdatasets; ++n24) {
                            for (int j = 0; j < this.numstates; ++j) {
                                if (!blArray5[n24]) continue;
                                if (blArray4[n24]) {
                                    Object object7 = object6;
                                    int n25 = j;
                                    object7[n25] = object7[n25] * this.emissionprobs[j][n24][1];
                                    continue;
                                }
                                Object object8 = object6;
                                int n26 = j;
                                object8[n26] = object8[n26] * this.emissionprobs[j][n24][0];
                            }
                            Object object9 = 0.0;
                            for (n18 = 0; n18 < this.numstates; ++n18) {
                                if (!(object6[n18] > object9)) continue;
                                object9 = object6[n18];
                            }
                            if (object9 <= 0.0) {
                                for (n18 = 0; n18 < this.numstates; ++n18) {
                                    object6[n18] = 1.0;
                                }
                                continue;
                            }
                            n18 = 0;
                            while (n18 < this.numstates) {
                                Object object10 = object6;
                                int n27 = n18++;
                                object10[n27] = object10[n27] / object9;
                            }
                        }
                    }
                } else {
                    for (n15 = 0; n15 < n21; ++n15) {
                        int n28;
                        object6 = object4[n15];
                        boolean[] blArray6 = blArray[n15];
                        boolean[] blArray7 = blArray2[n15];
                        boolean bl3 = true;
                        for (n28 = 0; n28 < this.numstates; ++n28) {
                            double d = 1.0;
                            double[][] dArray6 = this.emissionprobs[n28];
                            for (n16 = 0; n16 < this.numdatasets; ++n16) {
                                if (!blArray7[n16]) continue;
                                if (blArray6[n16]) {
                                    d *= dArray6[n16][1];
                                    continue;
                                }
                                d *= dArray6[n16][0];
                            }
                            object6[n28] = d;
                            if (!(d >= EPSILONEMISSIONS)) continue;
                            bl3 = false;
                        }
                        if (!bl3) continue;
                        for (n28 = 0; n28 < this.numstates; ++n28) {
                            object6[n28] = EPSILONEMISSIONS;
                        }
                    }
                }
                Object object11 = object2[0];
                double d = 0.0;
                Object object12 = object4[nArray[0]];
                for (n14 = 0; n14 < this.numstates; ++n14) {
                    object11[n14] = this.probinit[n14] * object12[n14];
                    d += object11[n14];
                }
                dArray4[0] = d;
                if (this.bscalebeta) {
                    for (n14 = 0; n14 < this.numstates; ++n14) {
                        Object object13 = object11;
                        int n29 = n14;
                        object13[n29] = object13[n29] / d;
                        if (!(object11[n14] < EPSILONSTATE) || !(object12[n14] > 0.0)) continue;
                        object11[n14] = EPSILONSTATE;
                    }
                } else {
                    n14 = 0;
                    while (n14 < this.numstates) {
                        Object object14 = object11;
                        int n30 = n14++;
                        object14[n30] = object14[n30] / d;
                    }
                }
                for (n14 = 0; n14 < this.numstates; ++n14) {
                    double[] dArray7 = dArray5[n14];
                    for (int j = 0; j < this.numstates; ++j) {
                        dArray7[j] = this.transitionprobs[j][n14];
                    }
                }
                n14 = this.numtime[n20];
                for (n13 = 1; n13 < n14; ++n13) {
                    Object object15 = object2[n13 - 1];
                    object11 = object2[n13];
                    d = 0.0;
                    object12 = object4[nArray[n13]];
                    for (n18 = 0; n18 < this.numstates; ++n18) {
                        int n31;
                        int n32 = this.transitionprobsnumCol[n18];
                        int[] nArray2 = this.transitionprobsindexCol[n18];
                        double[] dArray8 = dArray5[n18];
                        double d2 = 0.0;
                        if (n32 < n2) {
                            for (n31 = 0; n31 < n32; ++n31) {
                                n12 = nArray2[n31];
                                d2 += dArray8[n12] * object15[n12];
                            }
                        } else {
                            for (n31 = 0; n31 < this.numstates; ++n31) {
                                d2 += dArray8[n31] * object15[n31];
                            }
                        }
                        double d3 = d2 * object12[n18];
                        object11[n18] = d3;
                        d += d3;
                    }
                    dArray4[n13] = d;
                    if (this.bscalebeta) {
                        for (n18 = 0; n18 < this.numstates; ++n18) {
                            Object object16 = object11;
                            int n33 = n18;
                            object16[n33] = object16[n33] / d;
                            if (!(object11[n18] < EPSILONSTATE) || !(object12[n18] > 0.0)) continue;
                            object11[n18] = EPSILONSTATE;
                        }
                        continue;
                    }
                    n18 = 0;
                    while (n18 < this.numstates) {
                        Object object17 = object11;
                        int n34 = n18++;
                        object17[n34] = object17[n34] / d;
                    }
                }
                n13 = n14 - 1;
                double d4 = this.bscalebeta ? 1.0 / (double)this.numstates : 1.0 / dArray4[n13];
                for (n17 = 0; n17 < this.numstates; ++n17) {
                    dArray3[n17] = d4;
                }
                double d5 = 0.0;
                double[] dArray9 = dArray[n13];
                for (n11 = 0; n11 < dArray9.length; ++n11) {
                    reference var54_101 = object2[n13][n11] * dArray3[n11];
                    d5 += var54_101;
                    dArray9[n11] = (double)var54_101;
                }
                n11 = 0;
                while (n11 < dArray9.length) {
                    int n35 = n11++;
                    dArray9[n35] = dArray9[n35] / d5;
                }
                for (n11 = n13 - 1; n11 >= 0; --n11) {
                    double d6;
                    int n36;
                    dArray9 = dArray[n11];
                    int n37 = n11 + 1;
                    Object object18 = object4[nArray[n37]];
                    double d7 = 0.0;
                    double d8 = dArray4[n11];
                    for (n36 = 0; n36 < this.numstates; ++n36) {
                        object3[n36] = dArray3[n36] * object18[n36];
                    }
                    for (n36 = 0; n36 < this.numstates; ++n36) {
                        int n38;
                        d6 = 0.0;
                        int[] nArray3 = this.transitionprobsindex[n36];
                        double[] dArray10 = this.transitionprobs[n36];
                        int n39 = this.transitionprobsnum[n36];
                        if (n39 < n2) {
                            for (n38 = 0; n38 < n39; ++n38) {
                                n17 = nArray3[n38];
                                d6 += dArray10[n17] * object3[n17];
                            }
                        } else {
                            for (n38 = 0; n38 < this.numstates; ++n38) {
                                d6 += dArray10[n38] * object3[n38];
                            }
                        }
                        if (this.bscalebeta) {
                            dArray2[n36] = d6;
                            d7 += d6;
                            continue;
                        }
                        double d9 = d6 / d8;
                        dArray2[n36] = d9 > Double.MAX_VALUE ? Double.MAX_VALUE : d9;
                    }
                    if (this.bscalebeta) {
                        for (n36 = 0; n36 < this.numstates; ++n36) {
                            int n40 = n36;
                            dArray2[n40] = dArray2[n40] / d7;
                            if (!(dArray2[n36] < EPSILONSTATE)) continue;
                            dArray2[n36] = EPSILONSTATE;
                        }
                    }
                    d5 = 0.0;
                    object11 = object2[n11];
                    for (n36 = 0; n36 < dArray9.length; ++n36) {
                        d6 = (double)(object11[n36] * dArray2[n36]);
                        d5 += d6;
                        dArray9[n36] = d6;
                    }
                    n36 = 0;
                    while (n36 < dArray9.length) {
                        int n41 = n36++;
                        dArray9[n41] = dArray9[n41] / d5;
                    }
                    dArray3 = dArray2;
                }
                dArray9 = dArray[0];
                double d10 = 0.0;
                n12 = 0;
                int n42 = 0;
                if (this.bgzip) {
                    byte[] byArray;
                    double d11;
                    if (bl2) {
                        for (n10 = 0; n10 < dArray9.length; ++n10) {
                            int n43 = this.stateordering[n10];
                            d11 = dArray9[n43];
                            if (this.bprintposterior) {
                                String string5 = n10 > 0 ? "\t" + numberFormat.format(d11) : numberFormat.format(d11);
                                byArray = string5.getBytes();
                                gZIPOutputStream.write(byArray, 0, byArray.length);
                            }
                            if (!(d11 > d10)) continue;
                            d10 = d11;
                            n12 = n10;
                        }
                        if (this.bprintposterior) {
                            String string6 = "\n";
                            byte[] byArray2 = string6.getBytes();
                            gZIPOutputStream.write(byArray2, 0, byArray2.length);
                        }
                        if (this.bprintstatebyline) {
                            String string7 = n12 + 1 + "\n";
                            byte[] byArray3 = string7.getBytes();
                            gZIPOutputStream2.write(byArray3, 0, byArray3.length);
                        }
                        n8 = n12;
                        n42 = 1;
                        n7 = 0;
                    }
                    while (n42 < n14) {
                        dArray9 = dArray[n42];
                        d10 = 0.0;
                        n12 = 0;
                        for (n10 = 0; n10 < dArray9.length; ++n10) {
                            int n44 = this.stateordering[n10];
                            d11 = dArray9[n44];
                            if (this.bprintposterior) {
                                String string8 = n10 > 0 ? "\t" + numberFormat.format(d11) : numberFormat.format(d11);
                                byArray = string8.getBytes();
                                gZIPOutputStream.write(byArray, 0, byArray.length);
                            }
                            if (!(d11 > d10)) continue;
                            d10 = d11;
                            n12 = n10;
                        }
                        if (this.bprintposterior) {
                            String string9 = "\n";
                            byte[] byArray4 = string9.getBytes();
                            gZIPOutputStream.write(byArray4, 0, byArray4.length);
                        }
                        if (this.bprintstatebyline) {
                            String string10 = "" + (n12 + 1) + "\n";
                            byte[] byArray5 = string10.getBytes();
                            gZIPOutputStream2.write(byArray5, 0, byArray5.length);
                        }
                        if (this.bprintsegment && n8 != n12) {
                            String string11 = string3 + "\t" + n7 * this.nbinsize + "\t" + (n42 + n6) * this.nbinsize + "\t" + this.chorder + (n8 + 1) + "\n";
                            byte[] byArray6 = string11.getBytes();
                            ((GZIPOutputStream)object).write(byArray6, 0, byArray6.length);
                            n7 = n42 + n6;
                            n8 = n12;
                        }
                        ++n42;
                    }
                    if (!bl) continue;
                    if (this.bprintsegment) {
                        Integer n45 = null;
                        if (hashMap != null) {
                            n45 = (Integer)hashMap.get(string3);
                        }
                        n10 = n45 != null ? Math.min((n14 + n6) * this.nbinsize, n45) : (n14 + n6) * this.nbinsize;
                        String string12 = string3 + "\t" + n7 * this.nbinsize + "\t" + n10 + "\t" + this.chorder + (n8 + 1) + "\n";
                        byte[] byArray7 = string12.getBytes();
                        ((GZIPOutputStream)object).write(byArray7, 0, byArray7.length);
                    }
                    if (this.bprintstatebyline) {
                        gZIPOutputStream2.finish();
                        gZIPOutputStream2.close();
                    }
                    if (!this.bprintposterior) continue;
                    gZIPOutputStream.finish();
                    gZIPOutputStream.close();
                    continue;
                }
                if (bl2) {
                    for (n10 = 0; n10 < dArray9.length; ++n10) {
                        int n46 = this.stateordering[n10];
                        double d12 = dArray9[n46];
                        if (this.bprintposterior) {
                            if (n10 > 0) {
                                printWriter.print("\t" + numberFormat.format(d12));
                            } else {
                                printWriter.print(numberFormat.format(d12));
                            }
                        }
                        if (!(d12 > d10)) continue;
                        d10 = d12;
                        n12 = n10;
                    }
                    if (this.bprintposterior) {
                        printWriter.println();
                    }
                    if (this.bprintstatebyline) {
                        printWriter2.println("" + (n12 + 1));
                    }
                    n8 = n12;
                    n42 = 1;
                    n7 = 0;
                }
                while (n42 < n14) {
                    dArray9 = dArray[n42];
                    d10 = 0.0;
                    n12 = 0;
                    for (n10 = 0; n10 < dArray9.length; ++n10) {
                        int n47 = this.stateordering[n10];
                        double d13 = dArray9[n47];
                        if (this.bprintposterior) {
                            if (n10 > 0) {
                                printWriter.print("\t" + numberFormat.format(d13));
                            } else {
                                printWriter.print(numberFormat.format(d13));
                            }
                        }
                        if (!(d13 > d10)) continue;
                        d10 = d13;
                        n12 = n10;
                    }
                    if (this.bprintposterior) {
                        printWriter.println();
                    }
                    if (this.bprintstatebyline) {
                        printWriter2.println("" + (n12 + 1));
                    }
                    if (this.bprintsegment && n8 != n12) {
                        printWriter3.println(string3 + "\t" + n7 * this.nbinsize + "\t" + (n42 + n6) * this.nbinsize + "\t" + this.chorder + (n8 + 1));
                        n7 = n42 + n6;
                        n8 = n12;
                    }
                    ++n42;
                }
                if (!bl) continue;
                if (this.bprintsegment) {
                    Integer n48 = null;
                    if (hashMap != null) {
                        n48 = (Integer)hashMap.get(string3);
                    }
                    n10 = n48 != null ? Math.min((n14 + n6) * this.nbinsize, n48) : (n14 + n6) * this.nbinsize;
                    printWriter3.println(string3 + "\t" + n7 * this.nbinsize + "\t" + n10 + "\t" + this.chorder + (n8 + 1));
                }
                if (this.bprintstatebyline) {
                    printWriter2.close();
                }
                if (!this.bprintposterior) continue;
                printWriter.close();
            }
            if (!this.bprintsegment) break block130;
            Iterator iterator = hashMap2.values().iterator();
            if (this.bgzip) {
                while (iterator.hasNext()) {
                    GZIPOutputStream gZIPOutputStream3 = (GZIPOutputStream)iterator.next();
                    gZIPOutputStream3.finish();
                    gZIPOutputStream3.close();
                }
            } else {
                while (iterator.hasNext()) {
                    PrintWriter printWriter4 = (PrintWriter)iterator.next();
                    printWriter4.close();
                }
            }
        }
    }

    /*
     * Could not resolve type clashes
     */
    public void makeSegmentation() throws IOException {
        block114: {
            Object object;
            int n;
            Object object2;
            Object object3;
            Object object4;
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
            numberFormat.setMaximumFractionDigits(4);
            int n2 = (int)((double)this.numstates * SPARSECUTOFFRATIO);
            int[] nArray = new int[this.traindataObservedIndex.length];
            int n3 = 0;
            for (int i = 0; i < this.traindataObservedIndex.length; ++i) {
                nArray[i] = this.traindataObservedIndex[i].length;
                if (nArray[i] <= n3) continue;
                n3 = nArray[i];
            }
            HashMap<String, Integer> hashMap = null;
            if (this.szchromlengthfile != null) {
                hashMap = new HashMap<String, Integer>();
                object4 = Util.getBufferedReader(this.szchromlengthfile);
                while ((object3 = ((BufferedReader)object4).readLine()) != null) {
                    object2 = new StringTokenizer((String)object3, "\t ");
                    hashMap.put(((StringTokenizer)object2).nextToken(), Integer.valueOf(((StringTokenizer)object2).nextToken()));
                }
                ((BufferedReader)object4).close();
            }
            if (BVERBOSE) {
                System.out.println("Maximum number of locations\t" + n3);
            }
            object4 = new double[this.traindataObservedValues.length][this.numstates];
            object3 = new double[this.numstates];
            object2 = new double[n3][this.numstates];
            double[][] dArray = new double[n3][this.numstates];
            double[] dArray2 = new double[this.numstates];
            double[] dArray3 = new double[this.numstates];
            double[] dArray4 = new double[n3];
            double[][] dArray5 = new double[this.numstates][this.numstates];
            HashMap<String, Object> hashMap2 = null;
            if (this.bprintsegment) {
                hashMap2 = new HashMap<String, Object>();
            }
            RecIntString[] recIntStringArray = null;
            RecIntStringSplit[] recIntStringSplitArray = null;
            if (this.bsplit) {
                recIntStringSplitArray = new RecIntStringSplit[this.chromfiles.length];
                for (n = 0; n < recIntStringSplitArray.length; ++n) {
                    int n4 = this.chromSeq[n].lastIndexOf(46);
                    if (n4 == -1) {
                        throw new IllegalArgumentException("No period found in chromosome " + this.chromSeq[n] + " despite split being specified");
                    }
                    object = this.chromSeq[n].substring(0, n4);
                    int n5 = Integer.parseInt(this.chromSeq[n].substring(n4 + 1));
                    recIntStringSplitArray[n] = new RecIntStringSplit(n, this.cellSeq[n], (String)object, n5);
                }
                Arrays.sort(recIntStringSplitArray, new RecIntStringSplitCompare());
            } else {
                recIntStringArray = new RecIntString[this.chromfiles.length];
                for (n = 0; n < recIntStringArray.length; ++n) {
                    recIntStringArray[n] = new RecIntString(n, this.chromfiles[n]);
                }
                Arrays.sort(recIntStringArray, new RecIntStringCompare());
            }
            this.hsprefix = new HashSet();
            GZIPOutputStream gZIPOutputStream = null;
            GZIPOutputStream gZIPOutputStream2 = null;
            object = null;
            PrintWriter printWriter = null;
            PrintWriter printWriter2 = null;
            PrintWriter printWriter3 = null;
            int n6 = 0;
            boolean bl = true;
            boolean bl2 = true;
            int n7 = 0;
            int n8 = -1;
            int n9 = 0;
            for (int i = 0; i < this.traindataObservedIndex.length; ++i) {
                int n10;
                int n11;
                int n12;
                int n13;
                int n14;
                double d;
                int n15;
                int n16;
                int n17;
                Object object5;
                Object object6;
                Object object7;
                String string;
                int n18;
                if (this.bsplit) {
                    n18 = recIntStringSplitArray[i].nindex;
                    string = recIntStringSplitArray[i].szchrom;
                } else {
                    n18 = recIntStringArray[i].nindex;
                    string = this.chromSeq[n18];
                }
                int[] nArray2 = this.traindataObservedIndex[n18];
                boolean[] blArray = this.traindataObservedSeqFlags[n18];
                if (this.bsplit) {
                    if (recIntStringSplitArray[i].nsplitbinindex == 0) {
                        n6 = 0;
                        bl2 = true;
                    } else {
                        n6 += n9;
                        if (i >= 1 && recIntStringSplitArray[i].nsplitbinindex != recIntStringSplitArray[i - 1].nsplitbinindex + 1) {
                            throw new IllegalArgumentException("For " + recIntStringSplitArray[i].szcell + "_" + recIntStringSplitArray[i].szchrom + " found a file with split index " + recIntStringSplitArray[i].nsplitbinindex + ", but not " + (recIntStringSplitArray[i].nsplitbinindex - 1));
                        }
                        bl2 = false;
                    }
                    boolean bl3 = bl = i + 1 == recIntStringSplitArray.length || recIntStringSplitArray[i + 1].nsplitbinindex == 0;
                }
                if (bl2) {
                    object7 = "";
                    if (!this.cellSeq[n18].equals("")) {
                        object7 = (String)object7 + this.cellSeq[n18] + "_";
                    }
                    object7 = (String)object7 + this.numstates;
                    if (!this.szoutfileID.equals("")) {
                        object7 = (String)object7 + "_" + this.szoutfileID;
                    }
                    this.hsprefix.add(object7);
                    if (this.bgzip) {
                        String string2;
                        if (this.bprintposterior) {
                            object6 = this.szoutputdir + "/POSTERIOR/" + (String)object7 + "_" + string + SZPOSTERIOREXTENSION + ".gz";
                            System.out.println("Writing to file " + (String)object6);
                            gZIPOutputStream = new GZIPOutputStream(new FileOutputStream((String)object6));
                            string2 = this.cellSeq[n18] + "\t" + string + "\n";
                            object5 = string2.getBytes();
                            gZIPOutputStream.write((byte[])object5, 0, ((Object)object5).length);
                            StringBuffer stringBuffer = new StringBuffer();
                            for (n17 = 0; n17 < this.numstates - 1; ++n17) {
                                stringBuffer.append("" + this.chorder + (n17 + 1) + "\t");
                            }
                            stringBuffer.append("" + this.chorder + this.numstates + "\n");
                            object5 = stringBuffer.toString().getBytes();
                            gZIPOutputStream.write((byte[])object5, 0, ((Object)object5).length);
                        }
                        if (this.bprintstatebyline) {
                            object6 = this.szoutputdir + "/STATEBYLINE/" + (String)object7 + "_" + string + SZSTATEBYLINEEXTENSION + ".gz";
                            System.out.println("Writing to file " + (String)object6);
                            gZIPOutputStream2 = new GZIPOutputStream(new FileOutputStream((String)object6));
                            string2 = this.cellSeq[n18] + "\t" + string + "\n";
                            object5 = string2.getBytes();
                            gZIPOutputStream2.write((byte[])object5, 0, ((Object)object5).length);
                            string2 = "MaxState " + this.chorder + "\n";
                            object5 = string2.getBytes();
                            gZIPOutputStream2.write((byte[])object5, 0, ((Object)object5).length);
                        }
                        if (this.bprintsegment && (object = (GZIPOutputStream)hashMap2.get(this.cellSeq[n18])) == null) {
                            object6 = this.szoutputdir + "/" + (String)object7 + SZSEGMENTEXTENSION + ".gz";
                            object = new GZIPOutputStream(new FileOutputStream((String)object6));
                            System.out.println("Writing to file " + (String)object6);
                            hashMap2.put(this.cellSeq[n18], object);
                        }
                    } else {
                        if (this.bprintposterior) {
                            String string3 = this.szoutputdir + "/POSTERIOR/" + (String)object7 + "_" + string + SZPOSTERIOREXTENSION;
                            System.out.println("Writing to file " + string3);
                            printWriter = new PrintWriter(string3);
                            printWriter.println(this.cellSeq[n18] + "\t" + this.chromSeq[n18]);
                            for (int j = 0; j < this.numstates - 1; ++j) {
                                printWriter.print("" + this.chorder + (j + 1) + "\t");
                            }
                            printWriter.println("" + this.chorder + this.numstates);
                        }
                        if (this.bprintstatebyline) {
                            String string4 = this.szoutputdir + "/STATEBYLINE/" + (String)object7 + "_" + string + SZSTATEBYLINEEXTENSION;
                            System.out.println("Writing to file " + string4);
                            printWriter2 = new PrintWriter(string4);
                            printWriter2.println(this.cellSeq[n18] + "\t" + string);
                            printWriter2.println("MaxState " + this.chorder);
                        }
                        if (this.bprintsegment && (printWriter3 = (PrintWriter)hashMap2.get(this.cellSeq[n18])) == null) {
                            String string5 = this.szoutputdir + "/" + (String)object7 + SZSEGMENTEXTENSION;
                            printWriter3 = new PrintWriter(string5);
                            System.out.println("Writing to file " + string5);
                            hashMap2.put(this.cellSeq[n18], printWriter3);
                        }
                    }
                }
                if (this.bscaleemissions) {
                    for (n16 = 0; n16 < ((Object)object4).length; ++n16) {
                        int n19;
                        if (!blArray[n16]) continue;
                        object6 = object4[n16];
                        boolean[] blArray2 = this.traindataObservedValues[n16];
                        object5 = this.traindataNotMissing[n16];
                        for (n19 = 0; n19 < this.numstates; ++n19) {
                            object6[n19] = 1.0;
                        }
                        for (n19 = 0; n19 < this.numdatasets; ++n19) {
                            for (n17 = 0; n17 < this.numstates; ++n17) {
                                if (object5[n19] == false) continue;
                                if (blArray2[n19]) {
                                    Object object8 = object6;
                                    int n20 = n17;
                                    object8[n20] = object8[n20] * this.emissionprobs[n17][n19][1];
                                    continue;
                                }
                                Object object9 = object6;
                                int n21 = n17;
                                object9[n21] = object9[n21] * this.emissionprobs[n17][n19][0];
                            }
                            Object object10 = 0.0;
                            for (n15 = 0; n15 < this.numstates; ++n15) {
                                if (!(object6[n15] > object10)) continue;
                                object10 = object6[n15];
                            }
                            if (object10 <= 0.0) {
                                for (n15 = 0; n15 < this.numstates; ++n15) {
                                    object6[n15] = 1.0;
                                }
                                continue;
                            }
                            n15 = 0;
                            while (n15 < this.numstates) {
                                Object object11 = object6;
                                int n22 = n15++;
                                object11[n22] = object11[n22] / object10;
                            }
                        }
                    }
                } else {
                    for (n16 = 0; n16 < ((Object)object4).length; ++n16) {
                        if (!blArray[n16]) continue;
                        object6 = object4[n16];
                        boolean[] blArray3 = this.traindataObservedValues[n16];
                        object5 = this.traindataNotMissing[n16];
                        boolean bl4 = true;
                        for (n17 = 0; n17 < this.numstates; ++n17) {
                            d = 1.0;
                            double[][] dArray6 = this.emissionprobs[n17];
                            for (int j = 0; j < this.numdatasets; ++j) {
                                if (object5[j] == false) continue;
                                if (blArray3[j]) {
                                    d *= dArray6[j][1];
                                    continue;
                                }
                                d *= dArray6[j][0];
                            }
                            object6[n17] = d;
                            if (!(d >= EPSILONEMISSIONS)) continue;
                            bl4 = false;
                        }
                        if (!bl4) continue;
                        for (n17 = 0; n17 < this.numstates; ++n17) {
                            object6[n17] = EPSILONEMISSIONS;
                        }
                    }
                }
                object7 = object2[0];
                double d2 = 0.0;
                object5 = object4[nArray2[0]];
                for (n14 = 0; n14 < this.numstates; ++n14) {
                    object7[n14] = this.probinit[n14] * object5[n14];
                    d2 += object7[n14];
                }
                dArray4[0] = d2;
                if (this.bscalebeta) {
                    for (n14 = 0; n14 < this.numstates; ++n14) {
                        Object object12 = object7;
                        int n23 = n14;
                        object12[n23] = object12[n23] / d2;
                        if (!(object7[n14] < EPSILONSTATE) || !(object5[n14] > 0.0)) continue;
                        object7[n14] = EPSILONSTATE;
                    }
                } else {
                    n14 = 0;
                    while (n14 < this.numstates) {
                        Object object13 = object7;
                        int n24 = n14++;
                        object13[n24] = object13[n24] / d2;
                    }
                }
                for (n14 = 0; n14 < this.numstates; ++n14) {
                    double[] dArray7 = dArray5[n14];
                    for (int j = 0; j < this.numstates; ++j) {
                        dArray7[j] = this.transitionprobs[j][n14];
                    }
                }
                n9 = n14 = nArray[n18];
                for (n17 = 1; n17 < n14; ++n17) {
                    Object object14 = object2[n17 - 1];
                    object7 = object2[n17];
                    d2 = 0.0;
                    object5 = object4[nArray2[n17]];
                    for (n15 = 0; n15 < this.numstates; ++n15) {
                        int n25;
                        int n26 = this.transitionprobsnumCol[n15];
                        int[] nArray3 = this.transitionprobsindexCol[n15];
                        double[] dArray8 = dArray5[n15];
                        double d3 = 0.0;
                        if (n26 < n2) {
                            for (n25 = 0; n25 < n26; ++n25) {
                                n13 = nArray3[n25];
                                d3 += dArray8[n13] * object14[n13];
                            }
                        } else {
                            for (n25 = 0; n25 < this.numstates; ++n25) {
                                d3 += dArray8[n25] * object14[n25];
                            }
                        }
                        double d4 = d3 * object5[n15];
                        object7[n15] = d4;
                        d2 += d4;
                    }
                    dArray4[n17] = d2;
                    if (this.bscalebeta) {
                        for (n15 = 0; n15 < this.numstates; ++n15) {
                            Object object15 = object7;
                            int n27 = n15;
                            object15[n27] = object15[n27] / d2;
                            if (!(object7[n15] < EPSILONSTATE) || !(object5[n15] > 0.0)) continue;
                            object7[n15] = EPSILONSTATE;
                        }
                        continue;
                    }
                    n15 = 0;
                    while (n15 < this.numstates) {
                        Object object16 = object7;
                        int n28 = n15++;
                        object16[n28] = object16[n28] / d2;
                    }
                }
                n17 = n14 - 1;
                d = this.bscalebeta ? 1.0 / (double)this.numstates : 1.0 / dArray4[n17];
                for (n12 = 0; n12 < this.numstates; ++n12) {
                    dArray3[n12] = d;
                }
                double d5 = 0.0;
                double[] dArray9 = dArray[n17];
                for (n11 = 0; n11 < dArray9.length; ++n11) {
                    reference var47_79 = object2[n17][n11] * dArray3[n11];
                    d5 += var47_79;
                    dArray9[n11] = (double)var47_79;
                }
                n11 = 0;
                while (n11 < dArray9.length) {
                    int n29 = n11++;
                    dArray9[n29] = dArray9[n29] / d5;
                }
                for (n11 = n17 - 1; n11 >= 0; --n11) {
                    double d6;
                    int n30;
                    dArray9 = dArray[n11];
                    int n31 = n11 + 1;
                    Object object17 = object4[nArray2[n31]];
                    double d7 = 0.0;
                    double d8 = dArray4[n11];
                    for (n30 = 0; n30 < this.numstates; ++n30) {
                        object3[n30] = dArray3[n30] * object17[n30];
                    }
                    for (n30 = 0; n30 < this.numstates; ++n30) {
                        int n32;
                        d6 = 0.0;
                        int[] nArray4 = this.transitionprobsindex[n30];
                        double[] dArray10 = this.transitionprobs[n30];
                        int n33 = this.transitionprobsnum[n30];
                        if (n33 < n2) {
                            for (n32 = 0; n32 < n33; ++n32) {
                                n12 = nArray4[n32];
                                d6 += dArray10[n12] * object3[n12];
                            }
                        } else {
                            for (n32 = 0; n32 < this.numstates; ++n32) {
                                d6 += dArray10[n32] * object3[n32];
                            }
                        }
                        if (this.bscalebeta) {
                            dArray2[n30] = d6;
                            d7 += d6;
                            continue;
                        }
                        double d9 = d6 / d8;
                        dArray2[n30] = d9 > Double.MAX_VALUE ? Double.MAX_VALUE : d9;
                    }
                    if (this.bscalebeta) {
                        for (n30 = 0; n30 < this.numstates; ++n30) {
                            int n34 = n30;
                            dArray2[n34] = dArray2[n34] / d7;
                            if (!(dArray2[n30] < EPSILONSTATE)) continue;
                            dArray2[n30] = EPSILONSTATE;
                        }
                    }
                    d5 = 0.0;
                    object7 = object2[n11];
                    for (n30 = 0; n30 < dArray9.length; ++n30) {
                        d6 = (double)(object7[n30] * dArray2[n30]);
                        d5 += d6;
                        dArray9[n30] = d6;
                    }
                    n30 = 0;
                    while (n30 < dArray9.length) {
                        int n35 = n30++;
                        dArray9[n35] = dArray9[n35] / d5;
                    }
                    dArray3 = dArray2;
                }
                dArray9 = dArray[0];
                double d10 = 0.0;
                n13 = 0;
                int n36 = 0;
                if (this.bgzip) {
                    byte[] byArray;
                    double d11;
                    if (bl2) {
                        for (n10 = 0; n10 < dArray9.length; ++n10) {
                            int n37 = this.stateordering[n10];
                            d11 = dArray9[n37];
                            if (this.bprintposterior) {
                                String string6 = n10 > 0 ? "\t" + numberFormat.format(d11) : numberFormat.format(d11);
                                byArray = string6.getBytes();
                                gZIPOutputStream.write(byArray, 0, byArray.length);
                            }
                            if (!(d11 > d10)) continue;
                            d10 = d11;
                            n13 = n10;
                        }
                        if (this.bprintposterior) {
                            String string7 = "\n";
                            byte[] byArray2 = string7.getBytes();
                            gZIPOutputStream.write(byArray2, 0, byArray2.length);
                        }
                        if (this.bprintstatebyline) {
                            String string8 = "" + (n13 + 1) + "\n";
                            byte[] byArray3 = string8.getBytes();
                            gZIPOutputStream2.write(byArray3, 0, byArray3.length);
                        }
                        n8 = n13;
                        n36 = 1;
                        n7 = 0;
                    }
                    while (n36 < n14) {
                        dArray9 = dArray[n36];
                        d10 = 0.0;
                        n13 = 0;
                        for (n10 = 0; n10 < dArray9.length; ++n10) {
                            int n38 = this.stateordering[n10];
                            d11 = dArray9[n38];
                            if (this.bprintposterior) {
                                String string9 = n10 > 0 ? "\t" + numberFormat.format(d11) : numberFormat.format(d11);
                                byArray = string9.getBytes();
                                gZIPOutputStream.write(byArray, 0, byArray.length);
                            }
                            if (!(d11 > d10)) continue;
                            d10 = d11;
                            n13 = n10;
                        }
                        if (this.bprintposterior) {
                            String string10 = "\n";
                            byte[] byArray4 = string10.getBytes();
                            gZIPOutputStream.write(byArray4, 0, byArray4.length);
                        }
                        if (this.bprintstatebyline) {
                            String string11 = n13 + 1 + "\n";
                            byte[] byArray5 = string11.getBytes();
                            gZIPOutputStream2.write(byArray5, 0, byArray5.length);
                        }
                        if (this.bprintsegment && n8 != n13) {
                            String string12 = string + "\t" + n7 * this.nbinsize + "\t" + (n36 + n6) * this.nbinsize + "\t" + this.chorder + (n8 + 1) + "\n";
                            byte[] byArray6 = string12.getBytes();
                            ((GZIPOutputStream)object).write(byArray6, 0, byArray6.length);
                            n7 = n36 + n6;
                            n8 = n13;
                        }
                        ++n36;
                    }
                    if (!bl) continue;
                    if (this.bprintsegment) {
                        Integer n39 = null;
                        if (hashMap != null) {
                            n39 = (Integer)hashMap.get(string);
                        }
                        n10 = n39 != null ? Math.min((n14 + n6) * this.nbinsize, n39) : (n14 + n6) * this.nbinsize;
                        String string13 = string + "\t" + n7 * this.nbinsize + "\t" + n10 + "\t" + this.chorder + (n8 + 1) + "\n";
                        byte[] byArray7 = string13.getBytes();
                        ((GZIPOutputStream)object).write(byArray7, 0, byArray7.length);
                    }
                    if (this.bprintstatebyline) {
                        gZIPOutputStream2.finish();
                        gZIPOutputStream2.close();
                    }
                    if (!this.bprintposterior) continue;
                    gZIPOutputStream.finish();
                    gZIPOutputStream.close();
                    continue;
                }
                if (bl2) {
                    for (n10 = 0; n10 < dArray9.length; ++n10) {
                        int n40 = this.stateordering[n10];
                        double d12 = dArray9[n40];
                        if (this.bprintposterior) {
                            if (n10 > 0) {
                                printWriter.print("\t" + numberFormat.format(d12));
                            } else {
                                printWriter.print(numberFormat.format(d12));
                            }
                        }
                        if (!(d12 > d10)) continue;
                        d10 = d12;
                        n13 = n10;
                    }
                    if (this.bprintposterior) {
                        printWriter.println();
                    }
                    if (this.bprintstatebyline) {
                        printWriter2.println("" + (n13 + 1));
                    }
                    n8 = n13;
                    n36 = 1;
                    n7 = 0;
                }
                while (n36 < n14) {
                    dArray9 = dArray[n36];
                    d10 = 0.0;
                    n13 = 0;
                    for (n10 = 0; n10 < dArray9.length; ++n10) {
                        int n41 = this.stateordering[n10];
                        double d13 = dArray9[n41];
                        if (this.bprintposterior) {
                            if (n10 > 0) {
                                printWriter.print("\t" + numberFormat.format(d13));
                            } else {
                                printWriter.print(numberFormat.format(d13));
                            }
                        }
                        if (!(d13 > d10)) continue;
                        d10 = d13;
                        n13 = n10;
                    }
                    if (this.bprintposterior) {
                        printWriter.println();
                    }
                    if (this.bprintstatebyline) {
                        printWriter2.println("" + (n13 + 1));
                    }
                    if (this.bprintsegment && n8 != n13) {
                        printWriter3.println(string + "\t" + n7 * this.nbinsize + "\t" + (n36 + n6) * this.nbinsize + "\t" + this.chorder + (n8 + 1));
                        n7 = n36 + n6;
                        n8 = n13;
                    }
                    ++n36;
                }
                if (!bl) continue;
                if (this.bprintsegment) {
                    Integer n42 = null;
                    if (hashMap != null) {
                        n42 = (Integer)hashMap.get(string);
                    }
                    n10 = n42 != null ? Math.min((n14 + n6) * this.nbinsize, n42) : (n14 + n6) * this.nbinsize;
                    printWriter3.println(string + "\t" + n7 * this.nbinsize + "\t" + n10 + "\t" + this.chorder + (n8 + 1));
                }
                if (this.bprintstatebyline) {
                    printWriter2.close();
                }
                if (!this.bprintposterior) continue;
                printWriter.close();
            }
            if (!this.bprintsegment) break block114;
            Iterator iterator = hashMap2.values().iterator();
            if (this.bgzip) {
                while (iterator.hasNext()) {
                    GZIPOutputStream gZIPOutputStream3 = (GZIPOutputStream)iterator.next();
                    gZIPOutputStream3.finish();
                    gZIPOutputStream3.close();
                }
            } else {
                while (iterator.hasNext()) {
                    PrintWriter printWriter4 = (PrintWriter)iterator.next();
                    printWriter4.close();
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public int getMaxStateAtPos(int[][] nArray, int n) throws IOException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Object object;
        Object object2;
        Object object3;
        int n8;
        Serializable serializable;
        if (n < 0 || n >= nArray.length) {
            throw new IllegalArgumentException(n + " is not in range of data");
        }
        int n9 = (int)((double)this.numstates * SPARSECUTOFFRATIO);
        double[] dArray = new double[this.numstates];
        double[][] dArray2 = new double[nArray.length][this.numstates];
        double[] dArray3 = new double[this.numstates];
        double[] dArray4 = new double[this.numstates];
        double[] dArray5 = new double[nArray.length];
        double[][] dArray6 = new double[this.numstates][this.numstates];
        int n10 = nArray[0].length;
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            serializable = new StringBuffer();
            int[] nArray2 = nArray[i];
            for (n8 = 0; n8 < n10; ++n8) {
                int n11 = nArray2[n8];
                if (n11 == 0) {
                    ((StringBuffer)serializable).append("0");
                    continue;
                }
                if (n11 == 1) {
                    ((StringBuffer)serializable).append("1");
                    continue;
                }
                if (n11 == 2) {
                    ((StringBuffer)serializable).append("2");
                    continue;
                }
                throw new IllegalArgumentException("Unrecognized value " + n11 + " in input data");
            }
            stringArray[i] = ((StringBuffer)serializable).toString();
        }
        this.traindataObservedIndex = new int[1][nArray.length];
        int[] nArray3 = this.traindataObservedIndex[0];
        serializable = new HashMap();
        int n12 = 0;
        for (n8 = 0; n8 < stringArray.length; ++n8) {
            BigInteger bigInteger = new BigInteger(stringArray[n8], 3);
            ObservedRec object4 = (ObservedRec)((HashMap)serializable).get(bigInteger);
            if (object4 == null) {
                ((HashMap)serializable).put(bigInteger, new ObservedRec(n12, null));
                nArray3[n8] = n12++;
                continue;
            }
            nArray3[n8] = object4.nobserved;
        }
        this.traindataObservedValues = new boolean[n12][n10];
        double[][] dArray7 = new double[this.traindataObservedValues.length][this.numstates];
        this.traindataNotMissing = new boolean[n12][n10];
        for (Map.Entry dArray9 : ((HashMap)serializable).entrySet()) {
            object3 = (BigInteger)dArray9.getKey();
            object2 = ((BigInteger)object3).toString(3);
            object = (ObservedRec)dArray9.getValue();
            n6 = ((ObservedRec)object).nobserved;
            boolean[] blArray = this.traindataObservedValues[n6];
            boolean[] blArray2 = this.traindataNotMissing[n6];
            n5 = ((String)object2).length();
            n4 = n10 - n5;
            for (n3 = 0; n3 < n4; ++n3) {
                blArray[n3] = false;
                blArray2[n3] = true;
            }
            n3 = n4;
            for (int i = 0; i < n5; ++i) {
                char c = ((String)object2).charAt(i);
                if (c == '0') {
                    blArray[n3] = false;
                    blArray2[n3] = true;
                } else if (c == '1') {
                    blArray[n3] = true;
                    blArray2[n3] = true;
                } else {
                    blArray[n3] = false;
                    blArray2[n3] = false;
                }
                ++n3;
            }
        }
        if (this.bscaleemissions) {
            void var17_26;
            boolean bl = false;
            while (var17_26 < dArray7.length) {
                object3 = dArray7[var17_26];
                object2 = this.traindataObservedValues[var17_26];
                object = this.traindataNotMissing[var17_26];
                for (n6 = 0; n6 < this.numstates; ++n6) {
                    object3[n6] = 1.0;
                }
                for (n6 = 0; n6 < n10; ++n6) {
                    for (int i = 0; i < this.numstates; ++i) {
                        if (object[n6] == false) continue;
                        if (object2[n6] != false) {
                            Object object4 = object3;
                            int n7 = i;
                            object4[n7] = object4[n7] * this.emissionprobs[i][n6][1];
                            continue;
                        }
                        Object object5 = object3;
                        int n11 = i;
                        object5[n11] = object5[n11] * this.emissionprobs[i][n6][0];
                    }
                    Object object6 = 0.0;
                    for (n5 = 0; n5 < this.numstates; ++n5) {
                        if (!(object3[n5] > object6)) continue;
                        object6 = object3[n5];
                    }
                    if (object6 <= 0.0) {
                        for (n5 = 0; n5 < this.numstates; ++n5) {
                            object3[n5] = 1.0;
                        }
                        continue;
                    }
                    n5 = 0;
                    while (n5 < this.numstates) {
                        Object object7 = object3;
                        int n13 = n5++;
                        object7[n13] = object7[n13] / object6;
                    }
                }
                ++var17_26;
            }
        } else {
            void var17_28;
            boolean bl = false;
            while (var17_28 < dArray7.length) {
                int n14;
                object3 = dArray7[var17_28];
                object2 = this.traindataObservedValues[var17_28];
                object = this.traindataNotMissing[var17_28];
                n6 = 1;
                for (n14 = 0; n14 < this.numstates; ++n14) {
                    double d = 1.0;
                    double[][] dArray8 = this.emissionprobs[n14];
                    for (n3 = 0; n3 < n10; ++n3) {
                        if (object[n3] == false) continue;
                        if (object2[n3] != false) {
                            d *= dArray8[n3][1];
                            continue;
                        }
                        d *= dArray8[n3][0];
                    }
                    object3[n14] = d;
                    if (!(d >= EPSILONEMISSIONS)) continue;
                    n6 = 0;
                }
                if (n6 != 0) {
                    for (n14 = 0; n14 < this.numstates; ++n14) {
                        object3[n14] = EPSILONEMISSIONS;
                    }
                }
                ++var17_28;
            }
        }
        double[] dArray9 = dArray2[0];
        double d = 0.0;
        object = dArray7[nArray3[0]];
        for (n6 = 0; n6 < this.numstates; ++n6) {
            dArray9[n6] = this.probinit[n6] * object[n6];
            d += dArray9[n6];
        }
        dArray5[0] = d;
        if (this.bscalebeta) {
            for (n6 = 0; n6 < this.numstates; ++n6) {
                int n15 = n6;
                dArray9[n15] = dArray9[n15] / d;
                if (!(dArray9[n6] < EPSILONSTATE) || !(object[n6] > 0.0)) continue;
                dArray9[n6] = EPSILONSTATE;
            }
        } else {
            n6 = 0;
            while (n6 < this.numstates) {
                int n16 = n6++;
                dArray9[n16] = dArray9[n16] / d;
            }
        }
        for (n6 = 0; n6 < this.numstates; ++n6) {
            double[] dArray10 = dArray6[n6];
            for (int i = 0; i < this.numstates; ++i) {
                dArray10[i] = this.transitionprobs[i][n6];
            }
        }
        n6 = nArray.length;
        for (n2 = 1; n2 < n6; ++n2) {
            double[] dArray11 = dArray2[n2 - 1];
            double[] dArray12 = dArray2[n2];
            d = 0.0;
            object = dArray7[nArray3[n2]];
            for (n5 = 0; n5 < this.numstates; ++n5) {
                double d2;
                int n17;
                n4 = this.transitionprobsnumCol[n5];
                int[] nArray2 = this.transitionprobsindexCol[n5];
                double[] dArray13 = dArray6[n5];
                double d3 = 0.0;
                if (n4 < n9) {
                    for (n17 = 0; n17 < n4; ++n17) {
                        int n18 = nArray2[n17];
                        d3 += dArray13[n18] * dArray11[n18];
                    }
                } else {
                    for (n17 = 0; n17 < this.numstates; ++n17) {
                        d3 += dArray13[n17] * dArray11[n17];
                    }
                }
                dArray12[n5] = d2 = d3 * object[n5];
                d += d2;
            }
            dArray5[n2] = d;
            if (this.bscalebeta) {
                for (n5 = 0; n5 < this.numstates; ++n5) {
                    int n19 = n5;
                    dArray12[n19] = dArray12[n19] / d;
                    if (!(dArray12[n5] < EPSILONSTATE) || !(object[n5] > 0.0)) continue;
                    dArray12[n5] = EPSILONSTATE;
                }
                continue;
            }
            n5 = 0;
            while (n5 < this.numstates) {
                int n20 = n5++;
                dArray12[n20] = dArray12[n20] / d;
            }
        }
        n2 = n6 - 1;
        double d4 = this.bscalebeta ? 1.0 / (double)this.numstates : 1.0 / dArray5[n2];
        for (n4 = 0; n4 < this.numstates; ++n4) {
            dArray4[n4] = d4;
        }
        for (int i = n2 - 1; i >= n; --i) {
            int n21;
            int n22 = i + 1;
            double[] dArray14 = dArray7[nArray3[n22]];
            double d5 = 0.0;
            double d6 = dArray5[i];
            for (n21 = 0; n21 < this.numstates; ++n21) {
                dArray[n21] = dArray4[n21] * dArray14[n21];
            }
            for (n21 = 0; n21 < this.numstates; ++n21) {
                int n23;
                double d7 = 0.0;
                int[] nArray4 = this.transitionprobsindex[n21];
                double[] dArray15 = this.transitionprobs[n21];
                int n24 = this.transitionprobsnum[n21];
                if (n24 < n9) {
                    for (n23 = 0; n23 < n24; ++n23) {
                        n4 = nArray4[n23];
                        d7 += dArray15[n4] * dArray[n4];
                    }
                } else {
                    for (n23 = 0; n23 < this.numstates; ++n23) {
                        d7 += dArray15[n23] * dArray[n23];
                    }
                }
                if (this.bscalebeta) {
                    dArray3[n21] = d7;
                    d5 += d7;
                    continue;
                }
                double d8 = d7 / d6;
                dArray3[n21] = d8 > Double.MAX_VALUE ? Double.MAX_VALUE : d8;
            }
            if (this.bscalebeta) {
                for (n21 = 0; n21 < this.numstates; ++n21) {
                    int n25 = n21;
                    dArray3[n25] = dArray3[n25] / d5;
                    if (!(dArray3[n21] < EPSILONSTATE)) continue;
                    dArray3[n21] = EPSILONSTATE;
                }
            }
            dArray4 = dArray3;
        }
        double d9 = 0.0;
        int n26 = 0;
        double[] dArray16 = dArray2[n];
        for (int i = 0; i < dArray16.length; ++i) {
            double d10 = dArray16[i] * dArray4[i];
            if (!(d10 > d9)) continue;
            d9 = d10;
            n26 = i;
        }
        return n26 + 1;
    }

    /*
     * Could not resolve type clashes
     */
    public void trainParametersWithLoad() throws IOException {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(3);
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumFractionDigits(3);
        NumberFormat numberFormat2 = NumberFormat.getInstance();
        numberFormat2.setMaximumFractionDigits(1);
        numberFormat2.setMinimumFractionDigits(1);
        numberFormat2.setGroupingUsed(false);
        int n = 1;
        boolean bl = false;
        double d = Math.pow(10.0, -this.nzerotransitionpower);
        int n2 = (int)((double)this.numstates * SPARSECUTOFFRATIO);
        int n3 = (int)((double)this.numstates * SPARSECUTOFFLOOSERRATIO);
        int n4 = 0;
        for (int i = 0; i < this.numtime.length; ++i) {
            if (this.numtime[i] <= n4) continue;
            n4 = this.numtime[i];
        }
        if (BVERBOSE) {
            System.out.println("Maximum number of locations\t" + n4);
        }
        double[][] dArray = new double[n4][this.numstates];
        double[] dArray2 = null;
        if (this.bscaleemissions) {
            dArray2 = new double[n4];
        }
        double[] dArray3 = new double[this.numstates];
        double[][] dArray4 = new double[n4][this.numstates];
        double[] dArray5 = new double[this.numstates];
        double[] dArray6 = new double[this.numstates];
        double[] dArray7 = new double[this.numstates];
        double[] dArray8 = new double[n4];
        double[][] dArray9 = new double[this.numstates][this.numstates];
        double[][] dArray10 = new double[this.chromfiles.length][this.numstates];
        double[][][] dArray11 = new double[this.chromfiles.length][this.numstates][this.numstates];
        double[][][][] dArray12 = new double[this.chromfiles.length][this.numstates][this.numdatasets][this.numbuckets];
        double[][] dArray13 = new double[this.numstates][this.numstates];
        double[][] dArray14 = new double[n4][this.numstates];
        int[] nArray = new int[n4];
        boolean[][] blArray = new boolean[n4][this.numdatasets];
        boolean[][] blArray2 = new boolean[n4][this.numdatasets];
        int n5 = 0;
        long l = System.currentTimeMillis();
        double d2 = Double.NEGATIVE_INFINITY;
        do {
            this.dloglike = 0.0;
            for (int i = 0; i < this.chromfiles.length; ++i) {
                int n6;
                int n7;
                int n8;
                int n9;
                reference var53_86;
                double[] dArray15;
                int n10;
                int n11;
                int n12;
                int n13;
                Object[] objectArray;
                int n14;
                Object object;
                Object object2;
                String string;
                HashMap<BigInteger, Integer> hashMap = new HashMap<BigInteger, Integer>();
                int n15 = 0;
                if (BVERBOSE) {
                    System.out.println("reading\t" + this.szinputdir + " " + this.chromfiles[i]);
                }
                BufferedReader bufferedReader = Util.getBufferedReader(this.szinputdir + "/" + this.chromfiles[i]);
                bufferedReader.readLine();
                bufferedReader.readLine();
                ArrayList<String> arrayList = new ArrayList<String>();
                while ((string = bufferedReader.readLine()) != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "\t ");
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int j = 0; j < this.numdatasets; ++j) {
                        if (!stringTokenizer.hasMoreTokens()) {
                            throw new IllegalArgumentException("Found line without " + this.numdatasets + " values in file " + this.chromfiles[i]);
                        }
                        object2 = stringTokenizer.nextToken();
                        if (((String)object2).equals("0")) {
                            stringBuffer.append("0");
                            continue;
                        }
                        if (((String)object2).equals("1")) {
                            stringBuffer.append("1");
                            continue;
                        }
                        if (((String)object2).equals("2")) {
                            stringBuffer.append("2");
                            continue;
                        }
                        throw new IllegalArgumentException("Unrecognized value " + (String)object2 + " found in " + this.szinputdir + "/" + this.chromfiles[i]);
                    }
                    arrayList.add(stringBuffer.toString());
                }
                bufferedReader.close();
                int n16 = arrayList.size();
                for (int j = 0; j < n16; ++j) {
                    BigInteger bigInteger = new BigInteger((String)arrayList.get(j), 3);
                    object2 = (Integer)hashMap.get(bigInteger);
                    if (object2 == null) {
                        hashMap.put(bigInteger, n15);
                        nArray[j] = n15++;
                        continue;
                    }
                    nArray[j] = (Integer)object2;
                }
                for (Map.Entry entry : hashMap.entrySet()) {
                    int n17;
                    object2 = (BigInteger)entry.getKey();
                    object = ((BigInteger)object2).toString(3);
                    n14 = (Integer)entry.getValue();
                    boolean[] blArray3 = blArray[n14];
                    objectArray = blArray2[n14];
                    n13 = ((String)object).length();
                    n12 = this.numdatasets - n13;
                    for (n17 = 0; n17 < n12; ++n17) {
                        blArray3[n17] = false;
                        objectArray[n17] = true;
                    }
                    n17 = n12;
                    for (n11 = 0; n11 < n13; ++n11) {
                        char c = ((String)object).charAt(n11);
                        if (c == '0') {
                            blArray3[n17] = false;
                            objectArray[n17] = true;
                        } else if (c == '1') {
                            blArray3[n17] = true;
                            objectArray[n17] = true;
                        } else {
                            blArray3[n17] = false;
                            objectArray[n17] = false;
                        }
                        ++n17;
                    }
                }
                double[][][] dArray16 = dArray12[i];
                for (int j = 0; j < dArray16.length; ++j) {
                    object = dArray16[j];
                    for (n14 = 0; n14 < ((Object)object).length; ++n14) {
                        for (int k = 0; k < this.numbuckets; ++k) {
                            object[n14][k] = 0.0;
                        }
                    }
                }
                object2 = dArray11[i];
                for (n10 = 0; n10 < ((Object)object2).length; ++n10) {
                    Object object3 = object2[n10];
                    for (int j = 0; j < ((Object)object3).length; ++j) {
                        object3[j] = 0.0;
                    }
                }
                for (n10 = 0; n10 < n15; ++n10) {
                    double[] dArray17 = dArray14[n10];
                    for (int j = 0; j < dArray17.length; ++j) {
                        dArray17[j] = 0.0;
                    }
                }
                if (this.bscaleemissions) {
                    for (n10 = 0; n10 < n15; ++n10) {
                        double[] dArray18 = dArray[n10];
                        boolean[] blArray4 = blArray[n10];
                        objectArray = blArray2[n10];
                        for (n13 = 0; n13 < this.numstates; ++n13) {
                            dArray18[n13] = 1.0;
                        }
                        dArray2[n10] = 0.0;
                        for (n13 = 0; n13 < this.numdatasets; ++n13) {
                            for (int j = 0; j < this.numstates; ++j) {
                                if (!objectArray[n13] || !blArray4[n13]) continue;
                                int n18 = j;
                                dArray18[n18] = dArray18[n18] * this.emissionprobs[j][n13][1];
                            }
                            double d3 = 0.0;
                            for (n11 = 0; n11 < this.numstates; ++n11) {
                                if (!(dArray18[n11] > d3)) continue;
                                d3 = dArray18[n11];
                            }
                            if (d3 <= 0.0) {
                                for (n11 = 0; n11 < this.numstates; ++n11) {
                                    dArray18[n11] = 1.0;
                                }
                                int n19 = n10;
                                dArray2[n19] = dArray2[n19] + Math.log(EPSILONEMISSIONS);
                                continue;
                            }
                            n11 = 0;
                            while (n11 < this.numstates) {
                                int n20 = n11++;
                                dArray18[n20] = dArray18[n20] / d3;
                            }
                            int n21 = n10;
                            dArray2[n21] = dArray2[n21] + Math.log(d3);
                        }
                    }
                } else {
                    for (n10 = 0; n10 < n15; ++n10) {
                        double[] dArray19 = dArray[n10];
                        boolean[] blArray5 = blArray[n10];
                        objectArray = blArray2[n10];
                        n13 = 1;
                        for (n12 = 0; n12 < this.numstates; ++n12) {
                            double d4 = 1.0;
                            double[][] dArray20 = this.emissionprobs[n12];
                            for (int j = 0; j < this.numdatasets; ++j) {
                                if (!objectArray[j]) continue;
                                if (blArray5[j]) {
                                    d4 *= dArray20[j][1];
                                    continue;
                                }
                                d4 *= dArray20[j][0];
                            }
                            dArray19[n12] = d4;
                            if (!(d4 >= EPSILONEMISSIONS)) continue;
                            n13 = 0;
                        }
                        if (n13 == 0) continue;
                        for (n12 = 0; n12 < this.numstates; ++n12) {
                            dArray19[n12] = EPSILONEMISSIONS;
                        }
                    }
                }
                object = dArray4[0];
                double d5 = 0.0;
                objectArray = dArray[nArray[0]];
                for (n13 = 0; n13 < this.numstates; ++n13) {
                    object[n13] = this.probinit[n13] * objectArray[n13];
                    d5 += object[n13];
                }
                dArray8[0] = d5;
                if (this.bscalebeta) {
                    for (n13 = 0; n13 < this.numstates; ++n13) {
                        Object object4 = object;
                        int n22 = n13;
                        object4[n22] = object4[n22] / d5;
                        if (!(object[n13] < EPSILONSTATE) || !(objectArray[n13] > 0.0)) continue;
                        object[n13] = EPSILONSTATE;
                    }
                } else {
                    n13 = 0;
                    while (n13 < this.numstates) {
                        Object object5 = object;
                        int n23 = n13++;
                        object5[n23] = object5[n23] / d5;
                    }
                }
                this.dloglike += Math.log(d5);
                if (this.bscaleemissions) {
                    this.dloglike += dArray2[nArray[0]];
                }
                for (n13 = 0; n13 < this.numstates; ++n13) {
                    double[] dArray21 = dArray9[n13];
                    for (int j = 0; j < this.numstates; ++j) {
                        dArray21[j] = this.transitionprobs[j][n13];
                    }
                }
                n13 = this.numtime[i];
                for (n12 = 1; n12 < n13; ++n12) {
                    double[] dArray22 = dArray4[n12 - 1];
                    object = dArray4[n12];
                    d5 = 0.0;
                    objectArray = dArray[nArray[n12]];
                    for (n11 = 0; n11 < this.numstates; ++n11) {
                        reference var55_91;
                        int n24;
                        int n25 = this.transitionprobsnumCol[n11];
                        int[] nArray2 = this.transitionprobsindexCol[n11];
                        dArray15 = dArray9[n11];
                        var53_86 = (reference)0.0;
                        if (n25 < n2) {
                            for (n24 = 0; n24 < n25; ++n24) {
                                int n26 = nArray2[n24];
                                var53_86 += dArray15[n26] * dArray22[n26];
                            }
                        } else {
                            for (n24 = 0; n24 < this.numstates; ++n24) {
                                var53_86 += dArray15[n24] * dArray22[n24];
                            }
                        }
                        object[n11] = var55_91 = var53_86 * objectArray[n11];
                        d5 += var55_91;
                    }
                    dArray8[n12] = d5;
                    if (this.bscalebeta) {
                        for (n11 = 0; n11 < this.numstates; ++n11) {
                            Object object6 = object;
                            int n27 = n11;
                            object6[n27] = object6[n27] / d5;
                            if (!(object[n11] < EPSILONSTATE) || !(objectArray[n11] > 0.0)) continue;
                            object[n11] = EPSILONSTATE;
                        }
                    } else {
                        n11 = 0;
                        while (n11 < this.numstates) {
                            Object object7 = object;
                            int n28 = n11++;
                            object7[n28] = object7[n28] / d5;
                        }
                    }
                    this.dloglike += Math.log(d5);
                    if (!this.bscaleemissions) continue;
                    this.dloglike += dArray2[nArray[n12]];
                }
                n12 = n13 - 1;
                double d6 = this.bscalebeta ? 1.0 / (double)this.numstates : 1.0 / dArray8[n12];
                for (int j = 0; j < this.numstates; ++j) {
                    dArray7[j] = d6;
                }
                double d7 = 0.0;
                object = dArray4[n12];
                for (n9 = 0; n9 < dArray5.length; ++n9) {
                    var53_86 = object[n9] * dArray7[n9];
                    d7 += var53_86;
                    dArray5[n9] = (double)var53_86;
                }
                n9 = 0;
                while (n9 < dArray5.length) {
                    int n29 = n9++;
                    dArray5[n29] = dArray5[n29] / d7;
                }
                dArray15 = dArray14[nArray[n12]];
                for (n8 = 0; n8 < this.numstates; ++n8) {
                    int n30 = n8;
                    dArray15[n30] = dArray15[n30] + dArray5[n8];
                }
                for (n8 = n12 - 1; n8 >= 0; --n8) {
                    Object[] objectArray2;
                    Object[] objectArray3;
                    double d8;
                    int n31;
                    n7 = n8 + 1;
                    double[] dArray23 = dArray[nArray[n7]];
                    for (int j = 0; j < this.numstates; ++j) {
                        dArray3[j] = dArray7[j] * dArray23[j];
                    }
                    double d9 = 0.0;
                    double d10 = dArray8[n8];
                    for (n31 = 0; n31 < this.numstates; ++n31) {
                        int n32;
                        d8 = 0.0;
                        objectArray3 = this.transitionprobsindex[n31];
                        objectArray2 = this.transitionprobs[n31];
                        int n33 = this.transitionprobsnum[n31];
                        if (n33 < n2) {
                            for (n32 = 0; n32 < n33; ++n32) {
                                int n34 = objectArray3[n32];
                                d8 += objectArray2[n34] * dArray3[n34];
                            }
                        } else {
                            for (n32 = 0; n32 < this.numstates; ++n32) {
                                d8 += objectArray2[n32] * dArray3[n32];
                            }
                        }
                        if (this.bscalebeta) {
                            dArray6[n31] = d8;
                            d9 += d8;
                            continue;
                        }
                        double d11 = d8 / d10;
                        dArray6[n31] = d11 > Double.MAX_VALUE ? Double.MAX_VALUE : d11;
                    }
                    if (this.bscalebeta) {
                        for (n31 = 0; n31 < this.numstates; ++n31) {
                            int n35 = n31;
                            dArray6[n35] = dArray6[n35] / d9;
                            if (!(dArray6[n31] < EPSILONSTATE)) continue;
                            dArray6[n31] = EPSILONSTATE;
                        }
                    }
                    d7 = 0.0;
                    object = dArray4[n8];
                    for (n31 = 0; n31 < dArray5.length; ++n31) {
                        d8 = (double)(object[n31] * dArray6[n31]);
                        d7 += d8;
                        dArray5[n31] = d8;
                    }
                    n31 = 0;
                    while (n31 < dArray5.length) {
                        int n36 = n31++;
                        dArray5[n36] = dArray5[n36] / d7;
                    }
                    dArray15 = dArray14[nArray[n8]];
                    for (n31 = 0; n31 < this.numstates; ++n31) {
                        int n37 = n31;
                        dArray15[n37] = dArray15[n37] + dArray5[n31];
                    }
                    double d12 = 0.0;
                    for (n6 = 0; n6 < this.numstates; ++n6) {
                        int n38;
                        objectArray3 = dArray13[n6];
                        objectArray2 = this.transitionprobsindex[n6];
                        double[] dArray24 = this.transitionprobs[n6];
                        int n39 = this.transitionprobsnum[n6];
                        Object object8 = object[n6];
                        if (n39 < n3) {
                            for (n38 = 0; n38 < n39; ++n38) {
                                double d13 = objectArray2[n38];
                                double d14 = dArray24[d13] * object8 * dArray3[d13];
                                d12 += d14;
                                objectArray3[d13] = (int)d14;
                            }
                            continue;
                        }
                        for (n38 = 0; n38 < this.numstates; ++n38) {
                            double d15 = dArray24[n38] * object8 * dArray3[n38];
                            d12 += d15;
                            objectArray3[n38] = (int)d15;
                        }
                    }
                    for (n6 = 0; n6 < this.numstates; ++n6) {
                        int n40;
                        objectArray3 = this.transitionprobsindex[n6];
                        objectArray2 = dArray13[n6];
                        Object object9 = object2[n6];
                        int n41 = this.transitionprobsnum[n6];
                        if (n41 < n2) {
                            for (n40 = 0; n40 < n41; ++n40) {
                                int n42 = objectArray3[n40];
                                Object object10 = object9;
                                int n43 = n42;
                                object10[n43] = object10[n43] + objectArray2[n42] / d12;
                            }
                            continue;
                        }
                        for (n40 = 0; n40 < this.numstates; ++n40) {
                            Object object11 = object9;
                            int n44 = n40;
                            object11[n44] = object11[n44] + objectArray2[n40] / d12;
                        }
                    }
                    dArray7 = dArray6;
                }
                double[] dArray25 = dArray10[i];
                for (n7 = 0; n7 < this.numstates; ++n7) {
                    dArray25[n7] = dArray5[n7];
                }
                for (n7 = 0; n7 < n15; ++n7) {
                    boolean[] blArray6 = blArray[n7];
                    boolean[] blArray7 = blArray2[n7];
                    double[] dArray26 = dArray14[n7];
                    for (int j = 0; j < this.numstates; ++j) {
                        double[][] dArray27 = dArray16[j];
                        double d16 = dArray26[j];
                        for (n6 = 0; n6 < this.numdatasets; ++n6) {
                            if (!blArray7[n6]) continue;
                            if (blArray6[n6]) {
                                double[] dArray28 = dArray27[n6];
                                dArray28[1] = dArray28[1] + d16;
                                continue;
                            }
                            double[] dArray29 = dArray27[n6];
                            dArray29[0] = dArray29[0] + d16;
                        }
                    }
                }
                if (n > 1 || i == this.chromfiles.length - 1) {
                    int n45;
                    int n46;
                    double d17 = 0.0;
                    for (n46 = 0; n46 < this.numstates; ++n46) {
                        double d18 = 0.0;
                        for (int j = 0; j < this.chromfiles.length; ++j) {
                            d18 += dArray10[j][n46];
                        }
                        if (this.bpseudo) {
                            d18 += 1.0;
                        }
                        this.probinit[n46] = d18;
                        d17 += d18;
                    }
                    n46 = 0;
                    while (n46 < this.numstates) {
                        int n47 = n46++;
                        this.probinit[n47] = this.probinit[n47] / d17;
                    }
                    n46 = 0;
                    for (n45 = 0; n45 < this.transitionprobs.length; ++n45) {
                        int n48;
                        d17 = 0.0;
                        int[] nArray3 = this.transitionprobsindex[n45];
                        double[] dArray30 = this.transitionprobs[n45];
                        int n49 = this.transitionprobsnum[n45];
                        for (n48 = 0; n48 < n49; ++n48) {
                            n6 = nArray3[n48];
                            double d19 = 0.0;
                            for (int j = 0; j < this.chromfiles.length; ++j) {
                                d19 += dArray11[j][n45][n6];
                            }
                            if (this.bpseudo) {
                                d19 += 1.0;
                            }
                            dArray30[n6] = d19;
                            d17 += d19;
                        }
                        for (n48 = 0; n48 < n49; ++n48) {
                            int n50 = n6 = nArray3[n48];
                            dArray30[n50] = dArray30[n50] / d17;
                            if (!(dArray30[n6] < d) || n45 == n6) continue;
                            this.elim[n45][n6] = true;
                            n46 = 1;
                            ++n5;
                            dArray30[n6] = 0.0;
                        }
                    }
                    if (n46 != 0) {
                        for (n45 = 0; n45 < this.transitionprobs.length; ++n45) {
                            int n51 = 0;
                            d7 = 0.0;
                            boolean[] blArray8 = this.elim[n45];
                            double[] dArray31 = this.transitionprobs[n45];
                            int[] nArray4 = this.transitionprobsindex[n45];
                            for (n6 = 0; n6 < dArray31.length; ++n6) {
                                if (blArray8[n6]) continue;
                                nArray4[n51] = n6;
                                d7 += dArray31[n6];
                                ++n51;
                            }
                            n6 = 0;
                            while (n6 < dArray31.length) {
                                int n52 = n6++;
                                dArray31[n52] = dArray31[n52] / d7;
                            }
                            this.transitionprobsnum[n45] = n51;
                        }
                        for (n45 = 0; n45 < this.transitionprobs.length; ++n45) {
                            int n53 = 0;
                            int[] nArray5 = this.transitionprobsindexCol[n45];
                            for (int j = 0; j < this.transitionprobs[n45].length; ++j) {
                                if (this.elim[j][n45]) continue;
                                nArray5[n53] = j;
                                ++n53;
                            }
                            this.transitionprobsnumCol[n45] = n53;
                        }
                    }
                    for (n45 = 0; n45 < this.numstates; ++n45) {
                        double[][] dArray32 = this.emissionprobs[n45];
                        for (int j = 0; j < dArray32.length; ++j) {
                            int n54;
                            double[] dArray33 = dArray32[j];
                            double d20 = 0.0;
                            for (n54 = 0; n54 < this.numbuckets; ++n54) {
                                dArray33[n54] = 0.0;
                                for (int k = 0; k < this.chromfiles.length; ++k) {
                                    int n55 = n54;
                                    dArray33[n55] = dArray33[n55] + dArray12[k][n45][j][n54];
                                }
                                if (this.bpseudo) {
                                    int n56 = n54;
                                    dArray33[n56] = dArray33[n56] + 1.0;
                                }
                                d20 += dArray33[n54];
                            }
                            if (!(d20 > 0.0)) continue;
                            n54 = 0;
                            while (n54 < this.numbuckets) {
                                int n57 = n54++;
                                dArray33[n57] = dArray33[n57] / d20;
                            }
                        }
                    }
                }
                if (!BVERBOSE) continue;
                System.out.println("\t" + n + "\t" + this.dloglike);
            }
            double d21 = this.dloglike - d2;
            d2 = this.dloglike;
            if (this.borderrows) {
                this.makeStateOrdering();
            }
            if (this.bordercols) {
                this.makeColOrdering();
            }
            this.printTransitionTable(n);
            this.printEmissionTable(n);
            if (this.bprintimage) {
                this.printEmissionImage(n);
                this.printTransitionImage(n);
            }
            this.printParametersToFile(n);
            long l2 = System.currentTimeMillis();
            double d22 = (double)(l2 - l) / 1000.0;
            boolean bl2 = bl = n >= this.nmaxiterations || d21 < this.dconvergediff && this.dconvergediff >= 0.0 || d22 > (double)this.nmaxseconds && this.nmaxseconds >= 0;
            if (BVERBOSE) {
                System.out.println(n + "\tTime Iteration\t" + d22 + "\t\tElim\t" + n5);
                System.out.println("Full " + n + "\t" + this.dloglike + "\t" + d2 + "\t" + d21);
            }
            if (n == 1) {
                System.out.format("%10s %25s %10s %20s%n", "Iteration", "Estimated Log Likelihood", "Change", "Total Time (secs)");
                System.out.format("%10s %25s %10s %20s%n", "" + n, "" + numberFormat.format(this.dloglike), "-", "" + numberFormat2.format(d22));
            } else {
                System.out.format("%10s %25s %10s %20s%n", "" + n, "" + numberFormat.format(this.dloglike), "" + numberFormat.format(d21), "" + numberFormat2.format(d22));
            }
            ++n;
        } while (!bl);
    }

    /*
     * Could not resolve type clashes
     */
    public void trainParameters() throws IOException {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(3);
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumFractionDigits(3);
        NumberFormat numberFormat2 = NumberFormat.getInstance();
        numberFormat2.setMaximumFractionDigits(1);
        numberFormat2.setMinimumFractionDigits(1);
        numberFormat2.setGroupingUsed(false);
        int n = 1;
        boolean bl = false;
        double d = Math.pow(10.0, -this.nzerotransitionpower);
        int n2 = (int)((double)this.numstates * SPARSECUTOFFRATIO);
        int n3 = (int)((double)this.numstates * SPARSECUTOFFLOOSERRATIO);
        int[] nArray = new int[this.traindataObservedIndex.length];
        int n4 = 0;
        for (int i = 0; i < this.traindataObservedIndex.length; ++i) {
            nArray[i] = this.traindataObservedIndex[i].length;
            if (nArray[i] <= n4) continue;
            n4 = nArray[i];
        }
        if (BVERBOSE) {
            System.out.println("Maximum number of locations\t" + n4);
        }
        double[][] dArray = new double[this.traindataObservedValues.length][this.numstates];
        double[] dArray2 = null;
        if (this.bscaleemissions) {
            dArray2 = new double[this.traindataObservedValues.length];
        }
        double[] dArray3 = new double[this.numstates];
        double[][] dArray4 = new double[n4][this.numstates];
        double[] dArray5 = new double[this.numstates];
        double[] dArray6 = new double[this.numstates];
        double[] dArray7 = new double[this.numstates];
        double[] dArray8 = new double[n4];
        double[][] dArray9 = new double[this.numstates][this.numstates];
        double[][] dArray10 = new double[this.traindataObservedIndex.length][this.numstates];
        double[][][] dArray11 = new double[this.traindataObservedIndex.length][this.numstates][this.numstates];
        double[][][][] dArray12 = new double[this.traindataObservedIndex.length][this.numstates][this.numdatasets][this.numbuckets];
        double[][] dArray13 = new double[this.numstates][this.numstates];
        double[][] dArray14 = new double[this.traindataObservedValues.length][this.numstates];
        int n5 = 0;
        long l = System.currentTimeMillis();
        double d2 = Double.NEGATIVE_INFINITY;
        do {
            this.dloglike = 0.0;
            for (int i = 0; i < this.traindataObservedIndex.length; ++i) {
                int n6;
                int n7;
                int n8;
                int n9;
                reference var46_68;
                double[] dArray15;
                double d3;
                int n10;
                int n11;
                int n12;
                Object[] objectArray;
                int n13;
                int n14;
                Object object;
                int[] nArray2 = this.traindataObservedIndex[i];
                boolean[] blArray = this.traindataObservedSeqFlags[i];
                double[][][] dArray16 = dArray12[i];
                for (int j = 0; j < dArray16.length; ++j) {
                    object = dArray16[j];
                    for (int k = 0; k < ((double[][])object).length; ++k) {
                        for (n14 = 0; n14 < this.numbuckets; ++n14) {
                            object[k][n14] = 0.0;
                        }
                    }
                }
                double[][] dArray17 = dArray11[i];
                for (n13 = 0; n13 < dArray17.length; ++n13) {
                    double[] dArray18 = dArray17[n13];
                    for (n14 = 0; n14 < dArray18.length; ++n14) {
                        dArray18[n14] = 0.0;
                    }
                }
                for (n13 = 0; n13 < dArray14.length; ++n13) {
                    double[] dArray19 = dArray14[n13];
                    for (n14 = 0; n14 < dArray19.length; ++n14) {
                        dArray19[n14] = 0.0;
                    }
                }
                if (this.bscaleemissions) {
                    for (n13 = 0; n13 < dArray.length; ++n13) {
                        if (!blArray[n13]) continue;
                        double[] dArray20 = dArray[n13];
                        boolean[] blArray2 = this.traindataObservedValues[n13];
                        objectArray = this.traindataNotMissing[n13];
                        for (n12 = 0; n12 < this.numstates; ++n12) {
                            dArray20[n12] = 1.0;
                        }
                        dArray2[n13] = 0.0;
                        for (n12 = 0; n12 < this.numdatasets; ++n12) {
                            for (int j = 0; j < this.numstates; ++j) {
                                if (objectArray[n12] == false) continue;
                                if (blArray2[n12]) {
                                    int n15 = j;
                                    dArray20[n15] = dArray20[n15] * this.emissionprobs[j][n12][1];
                                    continue;
                                }
                                int n16 = j;
                                dArray20[n16] = dArray20[n16] * this.emissionprobs[j][n12][0];
                            }
                            double d4 = 0.0;
                            for (n11 = 0; n11 < this.numstates; ++n11) {
                                if (!(dArray20[n11] > d4)) continue;
                                d4 = dArray20[n11];
                            }
                            if (d4 <= 0.0) {
                                for (n11 = 0; n11 < this.numstates; ++n11) {
                                    dArray20[n11] = 1.0;
                                }
                                int n17 = n13;
                                dArray2[n17] = dArray2[n17] + Math.log(EPSILONEMISSIONS);
                                continue;
                            }
                            n11 = 0;
                            while (n11 < this.numstates) {
                                int n18 = n11++;
                                dArray20[n18] = dArray20[n18] / d4;
                            }
                            int n19 = n13;
                            dArray2[n19] = dArray2[n19] + Math.log(d4);
                        }
                    }
                } else {
                    for (n13 = 0; n13 < dArray.length; ++n13) {
                        if (!blArray[n13]) continue;
                        double[] dArray21 = dArray[n13];
                        boolean[] blArray3 = this.traindataObservedValues[n13];
                        objectArray = this.traindataNotMissing[n13];
                        n12 = 1;
                        for (n10 = 0; n10 < this.numstates; ++n10) {
                            d3 = 1.0;
                            double[][] dArray22 = this.emissionprobs[n10];
                            for (int j = 0; j < this.numdatasets; ++j) {
                                if (objectArray[j] == false) continue;
                                if (blArray3[j]) {
                                    d3 *= dArray22[j][1];
                                    continue;
                                }
                                d3 *= dArray22[j][0];
                            }
                            dArray21[n10] = d3;
                            if (!(d3 >= EPSILONEMISSIONS)) continue;
                            n12 = 0;
                        }
                        if (n12 == 0) continue;
                        for (n10 = 0; n10 < this.numstates; ++n10) {
                            dArray21[n10] = EPSILONEMISSIONS;
                        }
                    }
                }
                object = dArray4[0];
                double d5 = 0.0;
                objectArray = dArray[nArray2[0]];
                for (n12 = 0; n12 < this.numstates; ++n12) {
                    object[n12] = (double[])(this.probinit[n12] * objectArray[n12]);
                    d5 += object[n12];
                }
                dArray8[0] = d5;
                if (this.bscalebeta) {
                    for (n12 = 0; n12 < this.numstates; ++n12) {
                        int n20 = n12;
                        object[n20] = object[n20] / d5;
                        if (!(object[n12] < EPSILONSTATE) || !(objectArray[n12] > 0.0)) continue;
                        object[n12] = (double[])EPSILONSTATE;
                    }
                } else {
                    n12 = 0;
                    while (n12 < this.numstates) {
                        int n21 = n12++;
                        object[n21] = object[n21] / d5;
                    }
                }
                this.dloglike += Math.log(d5);
                if (this.bscaleemissions) {
                    this.dloglike += dArray2[nArray2[0]];
                }
                for (n12 = 0; n12 < this.numstates; ++n12) {
                    double[] dArray23 = dArray9[n12];
                    for (int j = 0; j < this.numstates; ++j) {
                        dArray23[j] = this.transitionprobs[j][n12];
                    }
                }
                n12 = nArray[i];
                for (n10 = 1; n10 < n12; ++n10) {
                    double[] dArray24 = dArray4[n10 - 1];
                    object = dArray4[n10];
                    d5 = 0.0;
                    objectArray = dArray[nArray2[n10]];
                    for (n11 = 0; n11 < this.numstates; ++n11) {
                        int n22;
                        int n23 = this.transitionprobsnumCol[n11];
                        int[] nArray3 = this.transitionprobsindexCol[n11];
                        dArray15 = dArray9[n11];
                        var46_68 = (reference)0.0;
                        if (n23 < n2) {
                            for (n22 = 0; n22 < n23; ++n22) {
                                int n24 = nArray3[n22];
                                var46_68 += dArray15[n24] * dArray24[n24];
                            }
                        } else {
                            for (n22 = 0; n22 < this.numstates; ++n22) {
                                var46_68 += dArray15[n22] * dArray24[n22];
                            }
                        }
                        reference var48_73 = var46_68 * objectArray[n11];
                        object[n11] = var48_73;
                        d5 += var48_73;
                    }
                    dArray8[n10] = d5;
                    if (this.bscalebeta) {
                        for (n11 = 0; n11 < this.numstates; ++n11) {
                            int n25 = n11;
                            object[n25] = object[n25] / d5;
                            if (!(object[n11] < EPSILONSTATE) || !(objectArray[n11] > 0.0)) continue;
                            object[n11] = (double[])EPSILONSTATE;
                        }
                    } else {
                        n11 = 0;
                        while (n11 < this.numstates) {
                            int n26 = n11++;
                            object[n26] = object[n26] / d5;
                        }
                    }
                    this.dloglike += Math.log(d5);
                    if (!this.bscaleemissions) continue;
                    this.dloglike += dArray2[nArray2[n10]];
                }
                n10 = n12 - 1;
                d3 = this.bscalebeta ? 1.0 / (double)this.numstates : 1.0 / dArray8[n10];
                for (int j = 0; j < this.numstates; ++j) {
                    dArray7[j] = d3;
                }
                double d6 = 0.0;
                object = dArray4[n10];
                for (n9 = 0; n9 < dArray5.length; ++n9) {
                    var46_68 = object[n9] * dArray7[n9];
                    d6 += var46_68;
                    dArray5[n9] = (double)var46_68;
                }
                n9 = 0;
                while (n9 < dArray5.length) {
                    int n27 = n9++;
                    dArray5[n27] = dArray5[n27] / d6;
                }
                dArray15 = dArray14[nArray2[n10]];
                for (n8 = 0; n8 < this.numstates; ++n8) {
                    int n28 = n8;
                    dArray15[n28] = dArray15[n28] + dArray5[n8];
                }
                for (n8 = n10 - 1; n8 >= 0; --n8) {
                    Object[] objectArray2;
                    Object[] objectArray3;
                    double d7;
                    int n29;
                    n7 = n8 + 1;
                    double[] dArray25 = dArray[nArray2[n7]];
                    for (int j = 0; j < this.numstates; ++j) {
                        dArray3[j] = dArray7[j] * dArray25[j];
                    }
                    double d8 = 0.0;
                    double d9 = dArray8[n8];
                    for (n29 = 0; n29 < this.numstates; ++n29) {
                        int n30;
                        d7 = 0.0;
                        objectArray3 = this.transitionprobsindex[n29];
                        objectArray2 = this.transitionprobs[n29];
                        int n31 = this.transitionprobsnum[n29];
                        if (n31 < n2) {
                            for (n30 = 0; n30 < n31; ++n30) {
                                int n32 = objectArray3[n30];
                                d7 += objectArray2[n32] * dArray3[n32];
                            }
                        } else {
                            for (n30 = 0; n30 < this.numstates; ++n30) {
                                d7 += objectArray2[n30] * dArray3[n30];
                            }
                        }
                        if (this.bscalebeta) {
                            dArray6[n29] = d7;
                            d8 += d7;
                            continue;
                        }
                        double d10 = d7 / d9;
                        dArray6[n29] = d10 > Double.MAX_VALUE ? Double.MAX_VALUE : d10;
                    }
                    if (this.bscalebeta) {
                        for (n29 = 0; n29 < this.numstates; ++n29) {
                            int n33 = n29;
                            dArray6[n33] = dArray6[n33] / d8;
                            if (!(dArray6[n29] < EPSILONSTATE)) continue;
                            dArray6[n29] = EPSILONSTATE;
                        }
                    }
                    d6 = 0.0;
                    object = dArray4[n8];
                    for (n29 = 0; n29 < dArray5.length; ++n29) {
                        d7 = (double)(object[n29] * dArray6[n29]);
                        d6 += d7;
                        dArray5[n29] = d7;
                    }
                    n29 = 0;
                    while (n29 < dArray5.length) {
                        int n34 = n29++;
                        dArray5[n34] = dArray5[n34] / d6;
                    }
                    dArray15 = dArray14[nArray2[n8]];
                    for (n29 = 0; n29 < this.numstates; ++n29) {
                        int n35 = n29;
                        dArray15[n35] = dArray15[n35] + dArray5[n29];
                    }
                    double d11 = 0.0;
                    for (n6 = 0; n6 < this.numstates; ++n6) {
                        int n36;
                        objectArray3 = dArray13[n6];
                        objectArray2 = this.transitionprobsindex[n6];
                        double[] dArray26 = this.transitionprobs[n6];
                        int n37 = this.transitionprobsnum[n6];
                        double[] dArray27 = object[n6];
                        if (n37 < n3) {
                            for (n36 = 0; n36 < n37; ++n36) {
                                double d12 = objectArray2[n36];
                                double d13 = dArray26[d12] * dArray27 * dArray3[d12];
                                d11 += d13;
                                objectArray3[d12] = (int)d13;
                            }
                            continue;
                        }
                        for (n36 = 0; n36 < this.numstates; ++n36) {
                            double d14 = dArray26[n36] * dArray27 * dArray3[n36];
                            d11 += d14;
                            objectArray3[n36] = (int)d14;
                        }
                    }
                    for (n6 = 0; n6 < this.numstates; ++n6) {
                        int n38;
                        objectArray3 = this.transitionprobsindex[n6];
                        objectArray2 = dArray13[n6];
                        double[] dArray28 = dArray17[n6];
                        int n39 = this.transitionprobsnum[n6];
                        if (n39 < n2) {
                            for (n38 = 0; n38 < n39; ++n38) {
                                int n40;
                                int n41 = n40 = objectArray3[n38];
                                dArray28[n41] = dArray28[n41] + objectArray2[n40] / d11;
                            }
                            continue;
                        }
                        for (n38 = 0; n38 < this.numstates; ++n38) {
                            int n42 = n38;
                            dArray28[n42] = dArray28[n42] + objectArray2[n38] / d11;
                        }
                    }
                    dArray7 = dArray6;
                }
                double[] dArray29 = dArray10[i];
                for (n7 = 0; n7 < this.numstates; ++n7) {
                    dArray29[n7] = dArray5[n7];
                }
                for (n7 = 0; n7 < dArray14.length; ++n7) {
                    if (!blArray[n7]) continue;
                    boolean[] blArray4 = this.traindataObservedValues[n7];
                    boolean[] blArray5 = this.traindataNotMissing[n7];
                    double[] dArray30 = dArray14[n7];
                    for (int j = 0; j < this.numstates; ++j) {
                        double[][] dArray31 = dArray16[j];
                        double d15 = dArray30[j];
                        for (n6 = 0; n6 < this.numdatasets; ++n6) {
                            if (!blArray5[n6]) continue;
                            if (blArray4[n6]) {
                                double[] dArray32 = dArray31[n6];
                                dArray32[1] = dArray32[1] + d15;
                                continue;
                            }
                            double[] dArray33 = dArray31[n6];
                            dArray33[0] = dArray33[0] + d15;
                        }
                    }
                }
                if (n > 1 || i == this.traindataObservedIndex.length - 1) {
                    int n43;
                    int n44;
                    double d16 = 0.0;
                    for (n44 = 0; n44 < this.numstates; ++n44) {
                        double d17 = 0.0;
                        for (int j = 0; j < this.traindataObservedIndex.length; ++j) {
                            d17 += dArray10[j][n44];
                        }
                        if (this.bpseudo) {
                            d17 += 1.0;
                        }
                        this.probinit[n44] = d17;
                        d16 += d17;
                    }
                    n44 = 0;
                    while (n44 < this.numstates) {
                        int n45 = n44++;
                        this.probinit[n45] = this.probinit[n45] / d16;
                    }
                    n44 = 0;
                    for (n43 = 0; n43 < this.transitionprobs.length; ++n43) {
                        int n46;
                        d16 = 0.0;
                        int[] nArray4 = this.transitionprobsindex[n43];
                        double[] dArray34 = this.transitionprobs[n43];
                        int n47 = this.transitionprobsnum[n43];
                        for (n46 = 0; n46 < n47; ++n46) {
                            n6 = nArray4[n46];
                            double d18 = 0.0;
                            for (int j = 0; j < this.traindataObservedIndex.length; ++j) {
                                d18 += dArray11[j][n43][n6];
                            }
                            if (this.bpseudo) {
                                d18 += 1.0;
                            }
                            dArray34[n6] = d18;
                            d16 += d18;
                        }
                        for (n46 = 0; n46 < n47; ++n46) {
                            int n48 = n6 = nArray4[n46];
                            dArray34[n48] = dArray34[n48] / d16;
                            if (!(dArray34[n6] < d) || n43 == n6) continue;
                            this.elim[n43][n6] = true;
                            n44 = 1;
                            ++n5;
                            dArray34[n6] = 0.0;
                        }
                    }
                    if (n44 != 0) {
                        for (n43 = 0; n43 < this.transitionprobs.length; ++n43) {
                            int n49 = 0;
                            d6 = 0.0;
                            boolean[] blArray6 = this.elim[n43];
                            double[] dArray35 = this.transitionprobs[n43];
                            int[] nArray5 = this.transitionprobsindex[n43];
                            for (n6 = 0; n6 < dArray35.length; ++n6) {
                                if (blArray6[n6]) continue;
                                nArray5[n49] = n6;
                                d6 += dArray35[n6];
                                ++n49;
                            }
                            n6 = 0;
                            while (n6 < dArray35.length) {
                                int n50 = n6++;
                                dArray35[n50] = dArray35[n50] / d6;
                            }
                            this.transitionprobsnum[n43] = n49;
                        }
                        for (n43 = 0; n43 < this.transitionprobs.length; ++n43) {
                            int n51 = 0;
                            int[] nArray6 = this.transitionprobsindexCol[n43];
                            for (int j = 0; j < this.transitionprobs[n43].length; ++j) {
                                if (this.elim[j][n43]) continue;
                                nArray6[n51] = j;
                                ++n51;
                            }
                            this.transitionprobsnumCol[n43] = n51;
                        }
                    }
                    for (n43 = 0; n43 < this.numstates; ++n43) {
                        double[][] dArray36 = this.emissionprobs[n43];
                        for (int j = 0; j < dArray36.length; ++j) {
                            int n52;
                            double[] dArray37 = dArray36[j];
                            double d19 = 0.0;
                            for (n52 = 0; n52 < this.numbuckets; ++n52) {
                                dArray37[n52] = 0.0;
                                for (int k = 0; k < this.traindataObservedIndex.length; ++k) {
                                    int n53 = n52;
                                    dArray37[n53] = dArray37[n53] + dArray12[k][n43][j][n52];
                                }
                                if (this.bpseudo) {
                                    int n54 = n52;
                                    dArray37[n54] = dArray37[n54] + 1.0;
                                }
                                d19 += dArray37[n52];
                            }
                            if (!(d19 > 0.0)) continue;
                            n52 = 0;
                            while (n52 < this.numbuckets) {
                                int n55 = n52++;
                                dArray37[n55] = dArray37[n55] / d19;
                            }
                        }
                    }
                }
                if (!BVERBOSE) continue;
                System.out.println("\t" + n + "\t" + this.dloglike);
            }
            double d20 = this.dloglike - d2;
            d2 = this.dloglike;
            if (this.borderrows) {
                this.makeStateOrdering();
            }
            if (this.bordercols) {
                this.makeColOrdering();
            }
            this.printTransitionTable(n);
            this.printEmissionTable(n);
            if (this.bprintimage) {
                this.printEmissionImage(n);
                this.printTransitionImage(n);
            }
            this.printParametersToFile(n);
            long l2 = System.currentTimeMillis();
            double d21 = (double)(l2 - l) / 1000.0;
            boolean bl2 = bl = n >= this.nmaxiterations || d20 < this.dconvergediff && this.dconvergediff >= 0.0 || d21 > (double)this.nmaxseconds && this.nmaxseconds >= 0;
            if (BVERBOSE) {
                System.out.println(n + "\tTime Iteration\t" + d21 + "\t\tElim\t" + n5);
                System.out.println("Full " + n + "\t" + this.dloglike + "\t" + d2 + "\t" + d20);
            }
            if (n == 1) {
                System.out.format("%10s %25s %10s %20s%n", "Iteration", "Estimated Log Likelihood", "Change", "Total Time (secs)");
                System.out.format("%10s %25s %10s %20s%n", "" + n, "" + numberFormat.format(this.dloglike), "-", "" + numberFormat2.format(d21));
            } else {
                System.out.format("%10s %25s %10s %20s%n", "" + n, "" + numberFormat.format(this.dloglike), "" + numberFormat.format(d20), "" + numberFormat2.format(d21));
            }
            ++n;
        } while (!bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trainParametersParallelWithLoad() throws IOException {
        int n;
        int n2;
        int n3;
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(3);
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumFractionDigits(3);
        NumberFormat numberFormat2 = NumberFormat.getInstance();
        numberFormat2.setMaximumFractionDigits(1);
        numberFormat2.setMinimumFractionDigits(1);
        numberFormat2.setGroupingUsed(false);
        int n4 = 1;
        boolean bl = false;
        double d = Math.pow(10.0, -this.nzerotransitionpower);
        int n5 = (int)((double)this.numstates * SPARSECUTOFFRATIO);
        int n6 = (int)((double)this.numstates * SPARSECUTOFFLOOSERRATIO);
        int n7 = 0;
        for (n3 = 0; n3 < this.numtime.length; ++n3) {
            if (this.numtime[n3] <= n7) continue;
            n7 = this.numtime[n3];
        }
        if (BVERBOSE) {
            System.out.println("Maximum number of locations\t" + n7);
        }
        if ((n3 = this.nmaxprocessors <= 0 ? Math.min(this.numtime.length, Runtime.getRuntime().availableProcessors()) : Math.min(this.numtime.length, Math.min(this.nmaxprocessors, Runtime.getRuntime().availableProcessors()))) == 1) {
            System.out.println("Using " + n3 + " thread for Baum-Welch training");
        } else {
            System.out.println("Using " + n3 + " threads for Baum-Welch training");
        }
        this.threadslots = new boolean[n3];
        int[] nArray = null;
        if (this.numincludeseq >= 1) {
            n2 = Math.min(this.numincludeseq, this.chromfiles.length);
            nArray = new int[n2];
        } else {
            n2 = this.chromfiles.length;
        }
        double[][][] dArray = new double[n3][n7][this.numstates];
        Object object = this.bscaleemissions ? (Object)new double[n3][n7] : new double[n3][];
        double[][] dArray2 = new double[n3][this.numstates];
        double[][][] dArray3 = new double[n3][n7][this.numstates];
        double[][] dArray4 = new double[n3][this.numstates];
        double[][] dArray5 = new double[n3][this.numstates];
        double[][] dArray6 = new double[n3][this.numstates];
        double[][] dArray7 = new double[n3][n7];
        double[][] dArray8 = new double[this.numstates][this.numstates];
        double[][] dArray9 = new double[n2][this.numstates];
        double[][][] dArray10 = new double[n2][this.numstates][this.numstates];
        double[][][][] dArray11 = new double[n2][this.numstates][this.numdatasets][this.numbuckets];
        double[][][] dArray12 = new double[n3][this.numstates][this.numstates];
        double[][][] dArray13 = new double[n3][n7][this.numstates];
        int[][] nArray2 = new int[n3][n7];
        boolean[][][] blArray = new boolean[n3][n7][this.numdatasets];
        boolean[][][] blArray2 = new boolean[n3][n7][this.numdatasets];
        double[] dArray14 = new double[n2];
        int n8 = 0;
        long l = System.currentTimeMillis();
        double d2 = Double.NEGATIVE_INFINITY;
        boolean[] blArray3 = new boolean[this.chromfiles.length];
        for (n = 0; n < blArray3.length; ++n) {
            blArray3[n] = true;
        }
        do {
            int n9;
            int n10;
            Object object2;
            int n11;
            if (this.numincludeseq >= 1) {
                for (n = 0; n < nArray.length; ++n) {
                    nArray[n] = n;
                }
                for (n = n2; n < this.chromfiles.length; ++n) {
                    if (!(this.theRandom.nextDouble() < (double)n2 / ((double)n + 1.0))) continue;
                    nArray[this.theRandom.nextInt((int)n2)] = n;
                }
                for (n = 0; n < blArray3.length; ++n) {
                    blArray3[n] = false;
                }
                for (n = 0; n < nArray.length; ++n) {
                    blArray3[nArray[n]] = true;
                }
            }
            for (n = 0; n < this.numstates; ++n) {
                double[] dArray15 = dArray8[n];
                for (int i = 0; i < this.numstates; ++i) {
                    dArray15[i] = this.transitionprobs[i][n];
                }
            }
            Object object3 = this.objlock;
            synchronized (object3) {
                this.nlaunched = n2;
            }
            n = 0;
            for (int i = 0; i < this.chromfiles.length; ++i) {
                if (!blArray3[i]) continue;
                double[][] dArray16 = dArray10[n];
                n11 = this.numtime[i];
                String string = this.chromfiles[i];
                object2 = dArray11[n];
                double[] dArray17 = dArray9[n];
                NewThreadWithLoad newThreadWithLoad = new NewThreadWithLoad(string, nArray2, blArray, blArray2, (double[][][])object2, dArray16, n11, dArray17, dArray13, dArray3, dArray, dArray4, dArray8, dArray7, dArray5, dArray6, dArray2, dArray12, n5, n6, dArray14, n, (double[][])object);
                ++n;
                new Thread(newThreadWithLoad).start();
            }
            Object object4 = this.objlock;
            synchronized (object4) {
                while (this.nlaunched > 0) {
                    try {
                        this.objlock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            double d3 = 0.0;
            for (n11 = 0; n11 < this.numstates; ++n11) {
                double d4 = 0.0;
                for (int i = 0; i < n2; ++i) {
                    d4 += dArray9[i][n11];
                }
                if (this.bpseudo) {
                    d4 += 1.0;
                }
                this.probinit[n11] = d4;
                d3 += d4;
            }
            n11 = 0;
            while (n11 < this.numstates) {
                int n12 = n11++;
                this.probinit[n12] = this.probinit[n12] / d3;
            }
            n11 = 0;
            for (n10 = 0; n10 < this.transitionprobs.length; ++n10) {
                double[][] dArray18;
                int n13;
                d3 = 0.0;
                object2 = this.transitionprobsindex[n10];
                double[] dArray19 = this.transitionprobs[n10];
                int n14 = this.transitionprobsnum[n10];
                for (n13 = 0; n13 < n14; ++n13) {
                    dArray18 = object2[n13];
                    double d5 = 0.0;
                    for (int i = 0; i < n2; ++i) {
                        d5 += dArray10[i][n10][dArray18];
                    }
                    if (this.bpseudo) {
                        d5 += 1.0;
                    }
                    dArray19[dArray18] = d5;
                    d3 += d5;
                }
                for (n13 = 0; n13 < n14; ++n13) {
                    dArray18 = object2[n13];
                    dArray19[dArray18] = dArray19[dArray18] / d3;
                    if (!(dArray19[dArray18] < d) || n10 == dArray18) continue;
                    this.elim[n10][dArray18] = true;
                    n11 = 1;
                    ++n8;
                    dArray19[dArray18] = 0.0;
                }
            }
            if (n11 != 0) {
                for (n10 = 0; n10 < this.transitionprobs.length; ++n10) {
                    int n15 = 0;
                    double d6 = 0.0;
                    boolean[] blArray4 = this.elim[n10];
                    double[] dArray20 = this.transitionprobs[n10];
                    int[] nArray3 = this.transitionprobsindex[n10];
                    for (n9 = 0; n9 < dArray20.length; ++n9) {
                        if (blArray4[n9]) continue;
                        nArray3[n15] = n9;
                        d6 += dArray20[n9];
                        ++n15;
                    }
                    n9 = 0;
                    while (n9 < dArray20.length) {
                        int n16 = n9++;
                        dArray20[n16] = dArray20[n16] / d6;
                    }
                    this.transitionprobsnum[n10] = n15;
                }
                for (n10 = 0; n10 < this.transitionprobs.length; ++n10) {
                    int n17 = 0;
                    int[] nArray4 = this.transitionprobsindexCol[n10];
                    for (int i = 0; i < this.transitionprobs[n10].length; ++i) {
                        if (this.elim[i][n10]) continue;
                        nArray4[n17] = i;
                        ++n17;
                    }
                    this.transitionprobsnumCol[n10] = n17;
                }
            }
            for (n10 = 0; n10 < this.numstates; ++n10) {
                double[][] dArray21 = this.emissionprobs[n10];
                for (int i = 0; i < dArray21.length; ++i) {
                    int n18;
                    double[] dArray22 = dArray21[i];
                    double d7 = 0.0;
                    for (n18 = 0; n18 < this.numbuckets; ++n18) {
                        dArray22[n18] = 0.0;
                        for (n9 = 0; n9 < n2; ++n9) {
                            int n19 = n18;
                            dArray22[n19] = dArray22[n19] + dArray11[n9][n10][i][n18];
                        }
                        if (this.bpseudo) {
                            int n20 = n18;
                            dArray22[n20] = dArray22[n20] + 1.0;
                        }
                        d7 += dArray22[n18];
                    }
                    if (!(d7 > 0.0)) continue;
                    n18 = 0;
                    while (n18 < this.numbuckets) {
                        int n21 = n18++;
                        dArray22[n21] = dArray22[n21] / d7;
                    }
                }
            }
            if (BVERBOSE) {
                System.out.println("\t" + n4 + "\t" + this.dloglike);
            }
            this.dloglike = 0.0;
            for (n10 = 0; n10 < dArray14.length; ++n10) {
                this.dloglike += dArray14[n10];
            }
            double d8 = this.dloglike - d2;
            d2 = this.dloglike;
            if (this.borderrows) {
                this.makeStateOrdering();
            }
            if (this.bordercols) {
                this.makeColOrdering();
            }
            this.printTransitionTable(n4);
            this.printEmissionTable(n4);
            if (this.bprintimage) {
                this.printEmissionImage(n4);
                this.printTransitionImage(n4);
            }
            this.printParametersToFile(n4);
            long l2 = System.currentTimeMillis();
            double d9 = (double)(l2 - l) / 1000.0;
            boolean bl2 = bl = n4 >= this.nmaxiterations || d8 < this.dconvergediff && this.dconvergediff >= 0.0 || d9 > (double)this.nmaxseconds && this.nmaxseconds >= 0;
            if (BVERBOSE) {
                System.out.println(n4 + "\tTime Iteration\t" + d9 + "\t\tElim\t" + n8);
                System.out.println("Full " + n4 + "\t" + this.dloglike + "\t" + d2 + "\t" + d8);
            }
            if (n4 == 1) {
                System.out.format("%10s %25s %10s %20s%n", "Iteration", "Estimated Log Likelihood", "Change", "Total Time (secs)");
                System.out.format("%10s %25s %10s %20s%n", "" + n4, "" + numberFormat.format(this.dloglike), "-", "" + numberFormat2.format(d9));
            } else {
                System.out.format("%10s %25s %10s %20s%n", "" + n4, "" + numberFormat.format(this.dloglike), "" + numberFormat.format(d8), "" + numberFormat2.format(d9));
            }
            ++n4;
        } while (!bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trainParametersParallel() throws IOException {
        int n;
        int n2;
        int n3;
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(3);
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumFractionDigits(3);
        NumberFormat numberFormat2 = NumberFormat.getInstance();
        numberFormat2.setMaximumFractionDigits(1);
        numberFormat2.setMinimumFractionDigits(1);
        numberFormat2.setGroupingUsed(false);
        int n4 = 1;
        boolean bl = false;
        double d = Math.pow(10.0, -this.nzerotransitionpower);
        int n5 = (int)((double)this.numstates * SPARSECUTOFFRATIO);
        int n6 = (int)((double)this.numstates * SPARSECUTOFFLOOSERRATIO);
        int[] nArray = new int[this.traindataObservedIndex.length];
        int n7 = 0;
        for (n3 = 0; n3 < this.traindataObservedIndex.length; ++n3) {
            nArray[n3] = this.traindataObservedIndex[n3].length;
            if (nArray[n3] <= n7) continue;
            n7 = nArray[n3];
        }
        if (BVERBOSE) {
            System.out.println("Maximum number of locations\t" + n7);
        }
        if ((n3 = this.nmaxprocessors <= 0 ? Math.min(this.traindataObservedIndex.length, Runtime.getRuntime().availableProcessors()) : Math.min(this.traindataObservedIndex.length, Math.min(this.nmaxprocessors, Runtime.getRuntime().availableProcessors()))) == 1) {
            System.out.println("Using " + n3 + " thread for Baum-Welch training");
        } else {
            System.out.println("Using " + n3 + " threads for Baum-Welch training");
        }
        this.threadslots = new boolean[n3];
        int[] nArray2 = null;
        if (this.numincludeseq >= 1) {
            n2 = Math.min(this.numincludeseq, this.chromfiles.length);
            nArray2 = new int[n2];
        } else {
            n2 = this.chromfiles.length;
        }
        double[][] dArray = new double[this.traindataObservedValues.length][this.numstates];
        double[] dArray2 = null;
        if (this.bscaleemissions) {
            dArray2 = new double[this.traindataObservedValues.length];
        }
        double[][] dArray3 = new double[n3][this.numstates];
        double[][][] dArray4 = new double[n3][n7][this.numstates];
        double[][] dArray5 = new double[n3][this.numstates];
        double[][] dArray6 = new double[n3][this.numstates];
        double[][] dArray7 = new double[n3][this.numstates];
        double[][] dArray8 = new double[n3][n7];
        double[][] dArray9 = new double[this.numstates][this.numstates];
        double[][] dArray10 = new double[n2][this.numstates];
        double[][][] dArray11 = new double[n2][this.numstates][this.numstates];
        double[][][][] dArray12 = new double[n2][this.numstates][this.numdatasets][this.numbuckets];
        double[][][] dArray13 = new double[n3][this.numstates][this.numstates];
        double[][][] dArray14 = new double[n3][this.traindataObservedValues.length][this.numstates];
        double[] dArray15 = new double[n2];
        int n8 = 0;
        long l = System.currentTimeMillis();
        double d2 = Double.NEGATIVE_INFINITY;
        boolean[] blArray = new boolean[this.chromfiles.length];
        for (n = 0; n < blArray.length; ++n) {
            blArray[n] = true;
        }
        do {
            int n9;
            int n10;
            int n11;
            int n12;
            double[] dArray16;
            if (this.numincludeseq >= 1) {
                for (n = 0; n < nArray2.length; ++n) {
                    nArray2[n] = n;
                }
                for (n = n2; n < this.chromfiles.length; ++n) {
                    if (!(this.theRandom.nextDouble() < (double)n2 / ((double)n + 1.0))) continue;
                    nArray2[this.theRandom.nextInt((int)n2)] = n;
                }
                for (n = 0; n < blArray.length; ++n) {
                    blArray[n] = false;
                }
                for (n = 0; n < nArray2.length; ++n) {
                    blArray[nArray2[n]] = true;
                }
            }
            if (this.bscaleemissions) {
                for (n = 0; n < dArray.length; ++n) {
                    int n13;
                    dArray16 = dArray[n];
                    boolean[] blArray2 = this.traindataObservedValues[n];
                    boolean[] blArray3 = this.traindataNotMissing[n];
                    for (n13 = 0; n13 < this.numstates; ++n13) {
                        dArray16[n13] = 1.0;
                    }
                    dArray2[n] = 0.0;
                    for (n13 = 0; n13 < this.numdatasets; ++n13) {
                        int n14;
                        for (int i = 0; i < this.numstates; ++i) {
                            if (!blArray3[n13]) continue;
                            if (blArray2[n13]) {
                                int n15 = i;
                                dArray16[n15] = dArray16[n15] * this.emissionprobs[i][n13][1];
                                continue;
                            }
                            int n16 = i;
                            dArray16[n16] = dArray16[n16] * this.emissionprobs[i][n13][0];
                        }
                        double d3 = 0.0;
                        for (n14 = 0; n14 < this.numstates; ++n14) {
                            if (!(dArray16[n14] > d3)) continue;
                            d3 = dArray16[n14];
                        }
                        if (d3 <= 0.0) {
                            for (n14 = 0; n14 < this.numstates; ++n14) {
                                dArray16[n14] = 1.0;
                            }
                            int n17 = n;
                            dArray2[n17] = dArray2[n17] + Math.log(EPSILONEMISSIONS);
                            continue;
                        }
                        n14 = 0;
                        while (n14 < this.numstates) {
                            int n18 = n14++;
                            dArray16[n18] = dArray16[n18] / d3;
                        }
                        int n19 = n;
                        dArray2[n19] = dArray2[n19] + Math.log(d3);
                    }
                }
            } else {
                for (n = 0; n < dArray.length; ++n) {
                    int n20;
                    double[] dArray17 = dArray[n];
                    boolean[] blArray4 = this.traindataObservedValues[n];
                    boolean[] blArray5 = this.traindataNotMissing[n];
                    boolean bl2 = true;
                    for (n20 = 0; n20 < this.numstates; ++n20) {
                        double d4 = 1.0;
                        double[][] dArray18 = this.emissionprobs[n20];
                        for (n12 = 0; n12 < this.numdatasets; ++n12) {
                            if (!blArray5[n12]) continue;
                            if (blArray4[n12]) {
                                d4 *= dArray18[n12][1];
                                continue;
                            }
                            d4 *= dArray18[n12][0];
                        }
                        dArray17[n20] = d4;
                        if (!(d4 >= EPSILONEMISSIONS)) continue;
                        bl2 = false;
                    }
                    if (!bl2) continue;
                    for (n20 = 0; n20 < this.numstates; ++n20) {
                        dArray17[n20] = EPSILONEMISSIONS;
                    }
                }
            }
            for (n = 0; n < this.numstates; ++n) {
                dArray16 = dArray9[n];
                for (int i = 0; i < this.numstates; ++i) {
                    dArray16[i] = this.transitionprobs[i][n];
                }
            }
            Object object = this.objlock;
            synchronized (object) {
                this.nlaunched = n2;
            }
            n = 0;
            for (int i = 0; i < this.traindataObservedIndex.length; ++i) {
                if (!blArray[i]) continue;
                double[][] dArray19 = dArray11[n];
                int n21 = nArray[i];
                int[] nArray3 = this.traindataObservedIndex[i];
                boolean[] blArray6 = this.traindataObservedSeqFlags[i];
                double[][][] dArray20 = dArray12[n];
                double[] dArray21 = dArray10[n];
                NewThread newThread = new NewThread(nArray3, blArray6, dArray20, dArray19, n21, dArray21, dArray14, dArray4, dArray, dArray5, dArray9, dArray8, dArray6, dArray7, dArray3, dArray13, n5, n6, dArray15, n, dArray2);
                ++n;
                new Thread(newThread).start();
            }
            Object object2 = this.objlock;
            synchronized (object2) {
                while (this.nlaunched > 0) {
                    try {
                        this.objlock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            double d5 = 0.0;
            for (n11 = 0; n11 < this.numstates; ++n11) {
                double d6 = 0.0;
                for (int i = 0; i < n2; ++i) {
                    d6 += dArray10[i][n11];
                }
                if (this.bpseudo) {
                    d6 += 1.0;
                }
                this.probinit[n11] = d6;
                d5 += d6;
            }
            n11 = 0;
            while (n11 < this.numstates) {
                int n22 = n11++;
                this.probinit[n22] = this.probinit[n22] / d5;
            }
            n11 = 0;
            for (n10 = 0; n10 < this.transitionprobs.length; ++n10) {
                int n23;
                d5 = 0.0;
                int[] nArray4 = this.transitionprobsindex[n10];
                double[] dArray22 = this.transitionprobs[n10];
                int n24 = this.transitionprobsnum[n10];
                for (n23 = 0; n23 < n24; ++n23) {
                    n12 = nArray4[n23];
                    double d7 = 0.0;
                    for (int i = 0; i < n2; ++i) {
                        d7 += dArray11[i][n10][n12];
                    }
                    if (this.bpseudo) {
                        d7 += 1.0;
                    }
                    dArray22[n12] = d7;
                    d5 += d7;
                }
                for (n23 = 0; n23 < n24; ++n23) {
                    int n25 = n12 = nArray4[n23];
                    dArray22[n25] = dArray22[n25] / d5;
                    if (!(dArray22[n12] < d) || n10 == n12) continue;
                    this.elim[n10][n12] = true;
                    n11 = 1;
                    ++n8;
                    dArray22[n12] = 0.0;
                }
            }
            if (n11 != 0) {
                for (n10 = 0; n10 < this.transitionprobs.length; ++n10) {
                    int n26 = 0;
                    double d8 = 0.0;
                    boolean[] blArray7 = this.elim[n10];
                    double[] dArray23 = this.transitionprobs[n10];
                    int[] nArray5 = this.transitionprobsindex[n10];
                    for (n9 = 0; n9 < dArray23.length; ++n9) {
                        if (blArray7[n9]) continue;
                        nArray5[n26] = n9;
                        d8 += dArray23[n9];
                        ++n26;
                    }
                    n9 = 0;
                    while (n9 < dArray23.length) {
                        int n27 = n9++;
                        dArray23[n27] = dArray23[n27] / d8;
                    }
                    this.transitionprobsnum[n10] = n26;
                }
                for (n10 = 0; n10 < this.transitionprobs.length; ++n10) {
                    int n28 = 0;
                    int[] nArray6 = this.transitionprobsindexCol[n10];
                    for (int i = 0; i < this.transitionprobs[n10].length; ++i) {
                        if (this.elim[i][n10]) continue;
                        nArray6[n28] = i;
                        ++n28;
                    }
                    this.transitionprobsnumCol[n10] = n28;
                }
            }
            for (n10 = 0; n10 < this.numstates; ++n10) {
                double[][] dArray24 = this.emissionprobs[n10];
                for (int i = 0; i < dArray24.length; ++i) {
                    int n29;
                    double[] dArray25 = dArray24[i];
                    double d9 = 0.0;
                    for (n29 = 0; n29 < this.numbuckets; ++n29) {
                        dArray25[n29] = 0.0;
                        for (n9 = 0; n9 < n2; ++n9) {
                            int n30 = n29;
                            dArray25[n30] = dArray25[n30] + dArray12[n9][n10][i][n29];
                        }
                        if (this.bpseudo) {
                            int n31 = n29;
                            dArray25[n31] = dArray25[n31] + 1.0;
                        }
                        d9 += dArray25[n29];
                    }
                    if (!(d9 > 0.0)) continue;
                    n29 = 0;
                    while (n29 < this.numbuckets) {
                        int n32 = n29++;
                        dArray25[n32] = dArray25[n32] / d9;
                    }
                }
            }
            if (BVERBOSE) {
                System.out.println("\t" + n4 + "\t" + this.dloglike);
            }
            this.dloglike = 0.0;
            for (n10 = 0; n10 < dArray15.length; ++n10) {
                this.dloglike += dArray15[n10];
            }
            double d10 = this.dloglike - d2;
            d2 = this.dloglike;
            if (this.borderrows) {
                this.makeStateOrdering();
            }
            if (this.bordercols) {
                this.makeColOrdering();
            }
            this.printTransitionTable(n4);
            this.printEmissionTable(n4);
            if (this.bprintimage) {
                this.printEmissionImage(n4);
                this.printTransitionImage(n4);
            }
            this.printParametersToFile(n4);
            long l2 = System.currentTimeMillis();
            double d11 = (double)(l2 - l) / 1000.0;
            boolean bl3 = bl = n4 >= this.nmaxiterations || d10 < this.dconvergediff && this.dconvergediff >= 0.0 || d11 > (double)this.nmaxseconds && this.nmaxseconds >= 0;
            if (BVERBOSE) {
                System.out.println(n4 + "\tTime Iteration\t" + d11 + "\t\tElim\t" + n8);
                System.out.println("Full " + n4 + "\t" + this.dloglike + "\t" + d2 + "\t" + d10);
            }
            if (n4 == 1) {
                System.out.format("%10s %25s %10s %20s%n", "Iteration", "Estimated Log Likelihood", "Change", "Total Time (secs)");
                System.out.format("%10s %25s %10s %20s%n", "" + n4, "" + numberFormat.format(this.dloglike), "-", "" + numberFormat2.format(d11));
            } else {
                System.out.format("%10s %25s %10s %20s%n", "" + n4, "" + numberFormat.format(this.dloglike), "" + numberFormat.format(d10), "" + numberFormat2.format(d11));
            }
            ++n4;
        } while (!bl);
    }

    public void loadDataFileStubs() throws IOException {
        int n;
        int n2;
        Object object;
        String[] stringArray;
        Object object2;
        if (this.szinputfilelist == null) {
            object2 = new File(this.szinputdir);
            stringArray = object2.list();
            if (stringArray == null) {
                throw new IllegalArgumentException(this.szinputdir + " is not a valid directory!");
            }
            object = new ArrayList();
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                if (!stringArray[n2].contains("_binary") || new File(stringArray[n2]).isHidden()) continue;
                ((ArrayList)object).add(stringArray[n2]);
            }
            if (((ArrayList)object).size() == 0) {
                throw new IllegalArgumentException("No files found in " + this.szinputdir + " containing '_binary' that are not Hidden");
            }
            this.chromfiles = new String[((ArrayList)object).size()];
            for (n2 = 0; n2 < this.chromfiles.length; ++n2) {
                this.chromfiles[n2] = (String)((ArrayList)object).get(n2);
            }
        } else {
            object2 = Util.getBufferedReader(this.szinputfilelist);
            stringArray = new ArrayList();
            while ((object = object2.readLine()) != null) {
                stringArray.add(object);
            }
            object2.close();
            this.chromfiles = new String[stringArray.size()];
            for (n2 = 0; n2 < this.chromfiles.length; ++n2) {
                this.chromfiles[n2] = (String)stringArray.get(n2);
            }
        }
        Arrays.sort(this.chromfiles);
        object2 = new RecIntDouble[this.chromfiles.length];
        stringArray = new String[this.chromfiles.length];
        for (n = 0; n < this.chromfiles.length; ++n) {
            stringArray[n] = this.chromfiles[n];
            object2[n] = this.theRandom == null ? new RecIntDouble(n, n) : new RecIntDouble(n, this.theRandom.nextDouble());
        }
        if (this.theRandom != null) {
            Arrays.sort(object2, new RecIntDoubleCompare());
        }
        this.cellSeq = new String[this.chromfiles.length];
        this.chromSeq = new String[this.chromfiles.length];
        for (n = 0; n < this.chromfiles.length; ++n) {
            this.chromfiles[n] = stringArray[object2[n].nindex];
        }
        this.traindataObservedIndex = new int[this.chromfiles.length][];
        this.numtime = new int[this.chromfiles.length];
        n = 0;
        for (n2 = 0; n2 < this.chromfiles.length; ++n2) {
            int n3;
            BufferedReader bufferedReader;
            String string;
            if (BVERBOSE) {
                System.out.println("reading\t" + this.szinputdir + " " + this.chromfiles[n2]);
            }
            if ((string = (bufferedReader = Util.getBufferedReader(this.szinputdir + "/" + this.chromfiles[n2])).readLine()) == null) {
                throw new IllegalArgumentException(this.szinputdir + "/" + this.chromfiles[n2] + " is empty!");
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
            if (!stringTokenizer.hasMoreTokens()) {
                throw new IllegalArgumentException("First line must contain cell type and chromosome. No entries found.");
            }
            this.cellSeq[n2] = stringTokenizer.nextToken().trim();
            if (!stringTokenizer.hasMoreTokens()) {
                throw new IllegalArgumentException("First line must contain cell type and chromosome. Only one entry found.");
            }
            this.chromSeq[n2] = stringTokenizer.nextToken().trim();
            if (stringTokenizer.hasMoreTokens()) {
                throw new IllegalArgumentException("First line should only contain cell type and chromosome");
            }
            string = bufferedReader.readLine();
            if (string == null) {
                throw new IllegalArgumentException(this.szinputdir + "/" + this.chromfiles[n2] + " only has one line!");
            }
            stringTokenizer = new StringTokenizer(string, "\t");
            int n4 = stringTokenizer.countTokens();
            if (n2 == 0) {
                this.datasets = new String[n4];
                n3 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    this.datasets[n3] = stringTokenizer.nextToken().trim();
                    ++n3;
                }
                this.numdatasets = this.datasets.length;
            } else {
                if (n4 != this.datasets.length) {
                    throw new IllegalArgumentException(" found a file with header with " + n4 + " entries, which does not match another with " + this.datasets.length);
                }
                n3 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken().trim();
                    if (!this.datasets[n3].equals(string2)) {
                        System.out.println("WARNING headers do not match between " + this.chromfiles[n2] + " and " + this.chromfiles[0]);
                    }
                    ++n3;
                }
            }
            n3 = 0;
            while ((string = bufferedReader.readLine()) != null) {
                ++n3;
            }
            bufferedReader.close();
            this.numtime[n2] = n3;
        }
    }

    public void loadData() throws IOException {
        boolean[] blArray;
        int n;
        Object[] objectArray;
        Object object;
        Object object2;
        int n2;
        int n3;
        Object object3;
        String[] stringArray;
        Object object4;
        if (this.szinputfilelist == null) {
            object4 = new File(this.szinputdir);
            stringArray = object4.list();
            if (stringArray == null) {
                throw new IllegalArgumentException(this.szinputdir + " is not a valid directory!");
            }
            object3 = new ArrayList();
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                if (!stringArray[n3].contains("_binary") || new File(stringArray[n3]).isHidden()) continue;
                ((ArrayList)object3).add(stringArray[n3]);
            }
            if (((ArrayList)object3).size() == 0) {
                throw new IllegalArgumentException("No files found in " + this.szinputdir + " containing '_binary' that are not Hidden");
            }
            this.chromfiles = new String[((ArrayList)object3).size()];
            for (n3 = 0; n3 < this.chromfiles.length; ++n3) {
                this.chromfiles[n3] = (String)((ArrayList)object3).get(n3);
            }
        } else {
            object4 = Util.getBufferedReader(this.szinputfilelist);
            stringArray = new ArrayList();
            while ((object3 = object4.readLine()) != null) {
                stringArray.add(object3);
            }
            object4.close();
            this.chromfiles = new String[stringArray.size()];
            for (n3 = 0; n3 < this.chromfiles.length; ++n3) {
                this.chromfiles[n3] = (String)stringArray.get(n3);
            }
        }
        Arrays.sort(this.chromfiles);
        object4 = new RecIntDouble[this.chromfiles.length];
        stringArray = new String[this.chromfiles.length];
        for (n2 = 0; n2 < this.chromfiles.length; ++n2) {
            stringArray[n2] = this.chromfiles[n2];
            object4[n2] = this.theRandom == null ? new RecIntDouble(n2, n2) : new RecIntDouble(n2, this.theRandom.nextDouble());
        }
        if (this.theRandom != null) {
            Arrays.sort(object4, new RecIntDoubleCompare());
        }
        this.cellSeq = new String[this.chromfiles.length];
        this.chromSeq = new String[this.chromfiles.length];
        for (n2 = 0; n2 < this.chromfiles.length; ++n2) {
            this.chromfiles[n2] = stringArray[object4[n2].nindex];
        }
        this.traindataObservedIndex = new int[this.chromfiles.length][];
        HashMap<BigInteger, ObservedRec> hashMap = new HashMap<BigInteger, ObservedRec>();
        n3 = 0;
        for (int i = 0; i < this.chromfiles.length; ++i) {
            CharSequence charSequence;
            int n4;
            BufferedReader object5;
            if (BVERBOSE) {
                System.out.println("reading\t" + this.szinputdir + " " + this.chromfiles[i]);
            }
            if ((object2 = (object5 = Util.getBufferedReader(this.szinputdir + "/" + this.chromfiles[i])).readLine()) == null) {
                throw new IllegalArgumentException(this.szinputdir + "/" + this.chromfiles[i] + " is empty!");
            }
            object = new StringTokenizer((String)object2, "\t");
            if (!((StringTokenizer)object).hasMoreTokens()) {
                throw new IllegalArgumentException("First line must contain cell type and chromosome. No entries found.");
            }
            this.cellSeq[i] = ((StringTokenizer)object).nextToken().trim();
            if (!((StringTokenizer)object).hasMoreTokens()) {
                throw new IllegalArgumentException("First line must contain cell type and chromosome. Only one entry found.");
            }
            this.chromSeq[i] = ((StringTokenizer)object).nextToken().trim();
            if (((StringTokenizer)object).hasMoreTokens()) {
                throw new IllegalArgumentException("First line should only contain cell type and chromosome");
            }
            object2 = object5.readLine();
            if (object2 == null) {
                throw new IllegalArgumentException(this.szinputdir + "/" + this.chromfiles[i] + " only has one line!");
            }
            object = new StringTokenizer((String)object2, "\t");
            int n5 = ((StringTokenizer)object).countTokens();
            if (i == 0) {
                this.datasets = new String[n5];
                n4 = 0;
                while (((StringTokenizer)object).hasMoreTokens()) {
                    this.datasets[n4] = ((StringTokenizer)object).nextToken().trim();
                    ++n4;
                }
            } else {
                if (n5 != this.datasets.length) {
                    throw new IllegalArgumentException(" found a file with header with " + n5 + " entries, which does not match another with " + this.datasets.length);
                }
                n4 = 0;
                while (((StringTokenizer)object).hasMoreTokens()) {
                    charSequence = ((StringTokenizer)object).nextToken().trim();
                    if (!this.datasets[n4].equals(charSequence)) {
                        System.out.println("WARNING headers do not match between " + this.chromfiles[i] + " and " + this.chromfiles[0]);
                    }
                    ++n4;
                }
            }
            this.numdatasets = this.datasets.length;
            ArrayList<String> n9 = new ArrayList<String>();
            while ((object2 = object5.readLine()) != null) {
                object = new StringTokenizer((String)object2, "\t ");
                charSequence = new StringBuffer();
                for (int j = 0; j < this.numdatasets; ++j) {
                    if (!((StringTokenizer)object).hasMoreTokens()) {
                        throw new IllegalArgumentException("Found line without " + this.numdatasets + " values in file " + this.chromfiles[i]);
                    }
                    String string = ((StringTokenizer)object).nextToken();
                    if (string.equals("0")) {
                        ((StringBuffer)charSequence).append("0");
                        continue;
                    }
                    if (string.equals("1")) {
                        ((StringBuffer)charSequence).append("1");
                        continue;
                    }
                    if (string.equals("2")) {
                        ((StringBuffer)charSequence).append("2");
                        continue;
                    }
                    throw new IllegalArgumentException("Unrecognized value " + string + " found in " + this.szinputdir + "/" + this.chromfiles[i]);
                }
                n9.add(((StringBuffer)charSequence).toString());
            }
            object5.close();
            int blArray2 = n9.size();
            this.traindataObservedIndex[i] = new int[blArray2];
            objectArray = this.traindataObservedIndex[i];
            for (n = 0; n < blArray2; ++n) {
                BigInteger bigInteger = new BigInteger((String)n9.get(n), 3);
                ObservedRec observedRec = (ObservedRec)hashMap.get(bigInteger);
                if (observedRec == null) {
                    blArray = new boolean[this.chromfiles.length];
                    blArray[i] = true;
                    hashMap.put(bigInteger, new ObservedRec(n3, blArray));
                    objectArray[n] = n3++;
                    continue;
                }
                observedRec.flagA[i] = true;
                objectArray[n] = observedRec.nobserved;
            }
        }
        this.traindataObservedValues = new boolean[n3][this.numdatasets];
        this.traindataNotMissing = new boolean[n3][this.numdatasets];
        this.traindataObservedSeqFlags = new boolean[this.chromfiles.length][this.traindataObservedValues.length];
        for (Map.Entry entry : hashMap.entrySet()) {
            int n6;
            int n7;
            object2 = (BigInteger)entry.getKey();
            object = ((BigInteger)object2).toString(3);
            ObservedRec observedRec = (ObservedRec)entry.getValue();
            int n8 = observedRec.nobserved;
            boolean[] blArray2 = this.traindataObservedValues[n8];
            objectArray = this.traindataNotMissing[n8];
            n = ((String)object).length();
            int n9 = this.numdatasets - n;
            for (n7 = 0; n7 < n9; ++n7) {
                blArray2[n7] = false;
                objectArray[n7] = true;
            }
            n7 = n9;
            for (int i = 0; i < n; ++i) {
                n6 = ((String)object).charAt(i);
                if (n6 == 48) {
                    blArray2[n7] = false;
                    objectArray[n7] = true;
                } else if (n6 == 49) {
                    blArray2[n7] = true;
                    objectArray[n7] = true;
                } else {
                    blArray2[n7] = false;
                    objectArray[n7] = false;
                }
                ++n7;
            }
            blArray = observedRec.flagA;
            for (n6 = 0; n6 < this.chromfiles.length; ++n6) {
                this.traindataObservedSeqFlags[n6][n8] = blArray[n6];
            }
        }
    }

    public static void main(String[] stringArray) throws IOException {
        boolean bl = true;
        String string = "";
        if (stringArray.length >= 1) {
            string = stringArray[0];
        } else {
            bl = false;
        }
        if (string.equalsIgnoreCase("Version")) {
            System.out.println("This is Version 1.23 of ChromHMM (c) Copyright 2008-2012 Massachusetts Institute of Technology");
        } else if (string.equals("BinarizeBam") || string.equalsIgnoreCase("BinarizeBed")) {
            Object object;
            int n;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            String string2 = null;
            int n2 = 5;
            int n3 = 100;
            boolean bl7 = false;
            int n4 = 0;
            int n5 = 1;
            double d = 1.0E-4;
            double d2 = 0.0;
            double d3 = 0.0;
            boolean bl8 = true;
            boolean bl9 = true;
            int n6 = DEFAULT_BINSIZEBASEPAIRS;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            int n7 = 1;
            boolean bl10 = false;
            int n8 = DEFAULT_NUMSPLITBINS;
            int n9 = -1;
            boolean bl11 = false;
            boolean bl12 = false;
            boolean bl13 = false;
            boolean bl14 = false;
            int n10 = 10;
            int n11 = -1;
            if (stringArray.length <= 4) {
                bl = false;
            } else {
                try {
                    for (n = 1; n < stringArray.length - 4; ++n) {
                        if (stringArray[n].equals("-b")) {
                            n6 = Integer.parseInt(stringArray[++n]);
                            continue;
                        }
                        if (stringArray[n].equals("-c")) {
                            string2 = stringArray[++n];
                            continue;
                        }
                        if (stringArray[n].equals("-colfields") && string.equalsIgnoreCase("BinarizeBed")) {
                            string3 = stringArray[++n];
                            continue;
                        }
                        if (stringArray[n].equals("-e")) {
                            n5 = Integer.parseInt(stringArray[++n]);
                            continue;
                        }
                        if (stringArray[n].equals("-f")) {
                            d2 = Double.parseDouble(stringArray[++n]);
                            continue;
                        }
                        if (stringArray[n].equals("-g")) {
                            d3 = Double.parseDouble(stringArray[++n]);
                            continue;
                        }
                        if (stringArray[n].equals("-gzip")) {
                            bl3 = true;
                            continue;
                        }
                        if (stringArray[n].equals("-i")) {
                            n9 = Integer.parseInt(stringArray[++n]);
                            continue;
                        }
                        if (stringArray[n].equals("-j")) {
                            n8 = Integer.parseInt(stringArray[++n]);
                            bl12 = true;
                            continue;
                        }
                        if (stringArray[n].equals("-k")) {
                            n11 = Integer.parseInt(stringArray[++n]);
                            bl13 = true;
                            continue;
                        }
                        if (stringArray[n].equals("-m")) {
                            n10 = Integer.parseInt(stringArray[++n]);
                            bl13 = true;
                            continue;
                        }
                        if (stringArray[n].equals("-n")) {
                            n3 = Integer.parseInt(stringArray[++n]);
                            bl11 = true;
                            continue;
                        }
                        if (stringArray[n].equals("-o")) {
                            if (((File)(object = new File(string4 = stringArray[++n]))).exists() || ((File)object).mkdirs()) continue;
                            throw new IllegalArgumentException(string4 + " does not exist and could not be created!");
                        }
                        if (stringArray[n].equals("-p")) {
                            d = Double.parseDouble(stringArray[++n]);
                            continue;
                        }
                        if (stringArray[n].equals("-s")) {
                            n4 = Integer.parseInt(stringArray[++n]);
                            continue;
                        }
                        if (stringArray[n].equals("-splitrows")) {
                            bl6 = true;
                            continue;
                        }
                        if (stringArray[n].equals("-splitcols")) {
                            bl14 = true;
                            continue;
                        }
                        if (stringArray[n].equals("-stacked")) {
                            bl2 = true;
                            continue;
                        }
                        if (stringArray[n].equals("-strictthresh")) {
                            bl8 = false;
                            continue;
                        }
                        if (stringArray[n].equals("-t")) {
                            if (((File)(object = new File(string5 = stringArray[++n]))).exists() || ((File)object).mkdirs()) continue;
                            throw new IllegalArgumentException(string5 + " does not exist and could not be created!");
                        }
                        if (stringArray[n].equals("-u")) {
                            n7 = Integer.parseInt(stringArray[++n]);
                            continue;
                        }
                        if (stringArray[n].equals("-center")) {
                            bl7 = true;
                            continue;
                        }
                        if (stringArray[n].equals("-peaks")) {
                            bl10 = true;
                            continue;
                        }
                        if (stringArray[n].equals("-paired") && string.equalsIgnoreCase("BinarizeBam")) {
                            bl4 = true;
                            continue;
                        }
                        if (stringArray[n].equals("-mixed") && string.equalsIgnoreCase("BinarizeBam")) {
                            bl5 = true;
                            continue;
                        }
                        if (stringArray[n].equals("-w")) {
                            n2 = Integer.parseInt(stringArray[++n]);
                            continue;
                        }
                        bl = false;
                        break;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    bl = false;
                }
            }
            if (bl4 && (bl5 || bl7 || bl11 || bl10)) {
                bl = false;
            }
            if (!bl6 && bl12) {
                bl = false;
            }
            if (!bl14 && bl13) {
                bl = false;
            }
            if (bl && n == stringArray.length - 4) {
                String string6;
                Object object2;
                object = stringArray[n++];
                String string7 = stringArray[n++];
                String string8 = stringArray[n++];
                String string9 = stringArray[n];
                File file = new File(string9);
                if (!file.exists() && !file.mkdirs()) {
                    throw new IllegalArgumentException(string9 + " does not exist and could not be created!");
                }
                if (string2 == null) {
                    string2 = string7;
                }
                int n12 = 0;
                if (bl14) {
                    int n13 = 0;
                    object2 = Util.getBufferedReader(string8);
                    HashSet<String> hashSet = new HashSet<String>();
                    while ((string6 = ((BufferedReader)object2).readLine()) != null) {
                        if (string6.trim().equals("")) continue;
                        StringTokenizer stringTokenizer = new StringTokenizer(string6, "\t");
                        if (stringTokenizer.countTokens() < 3) {
                            throw new IllegalArgumentException("In " + string8 + " " + string6 + " does not have at least three columns");
                        }
                        String string10 = stringTokenizer.nextToken().trim();
                        String string11 = stringTokenizer.nextToken().trim();
                        if (hashSet.contains(string10 + "\t" + string11)) {
                            throw new IllegalArgumentException("In " + string8 + " " + string10 + "\t" + string11 + " found twice, but -splitcols specified");
                        }
                        hashSet.add(string10 + "\t" + string11);
                        if (n13 % n10 == 0) {
                            ++n12;
                        }
                        ++n13;
                    }
                    ((BufferedReader)object2).close();
                }
                if (n9 >= 0) {
                    if (bl10) {
                        if (bl14 && n11 == -1) {
                            for (n11 = 0; n11 < n12; ++n11) {
                                string6 = string9 + "/SET" + (n11 + 1);
                                file = new File(string6);
                                if (!file.exists() && !file.mkdirs()) {
                                    throw new IllegalArgumentException(string6 + " does not exist and could not be created!");
                                }
                                Preprocessing.makeBinaryDataFromPeaksSplit((String)object, string7, string9, string8, n6, bl3, n8, n9, n4, n5, bl14, n10, n11, bl2);
                            }
                        } else {
                            if (bl14) {
                                if (n11 >= n12) {
                                    throw new IllegalArgumentException("nmarksplitindex value of " + n11 + " is greater than the maximum of " + (n12 - 1));
                                }
                                file = new File(string9 = string9 + "/SET" + (n11 + 1));
                                if (!file.exists() && !file.mkdirs()) {
                                    throw new IllegalArgumentException(string9 + " does not exist and could not be created!");
                                }
                            }
                            Preprocessing.makeBinaryDataFromPeaksSplit((String)object, string7, string9, string8, n6, bl3, n8, n9, n4, n5, bl14, n10, n11, bl2);
                        }
                    } else {
                        bl = false;
                    }
                } else if (bl14 && n11 == -1) {
                    for (n11 = 0; n11 < n12; ++n11) {
                        string6 = string9 + "/SET" + (n11 + 1);
                        file = new File(string6);
                        if (!file.exists() && !file.mkdirs()) {
                            throw new IllegalArgumentException(string6 + " does not exist and could not be created!");
                        }
                        String string12 = null;
                        if (string5 != null && !(file = new File(string12 = string5 + "/SET" + (n11 + 1))).exists() && !file.mkdirs()) {
                            throw new IllegalArgumentException(string12 + " does not exist and could not be created!");
                        }
                        object2 = null;
                        if (object2 != null && !(file = new File((String)(object2 = string4 + "/SET" + (n11 + 1)))).exists() && !file.mkdirs()) {
                            throw new IllegalArgumentException((String)object2 + " does not exist and could not be created!");
                        }
                        Preprocessing.makeBinaryDataFromBed((String)object, string7, string2, n2, string8, n3, bl7, n4, n5, string5, string6, string4, d, d2, bl8, n7, n6, string3, bl10, d3, string.equalsIgnoreCase("BinarizeBam"), bl4, bl3, bl6, n8, bl14, n10, n11, bl2, bl5);
                    }
                } else {
                    if (bl14) {
                        if (n11 >= n12) {
                            throw new IllegalArgumentException("nmarksplitindex value of " + n11 + " is greater than the maximum of " + (n12 - 1));
                        }
                        file = new File(string9 = string9 + "/SET" + (n11 + 1));
                        if (!file.exists() && !file.mkdirs()) {
                            throw new IllegalArgumentException(string9 + " does not exist and could not be created!");
                        }
                        if (string5 != null && !(file = new File(string5 = string5 + "/SET" + (n11 + 1))).exists() && !file.mkdirs()) {
                            throw new IllegalArgumentException(string5 + " does not exist and could not be created!");
                        }
                        if (string4 != null && !(file = new File(string4 = string4 + "/SET" + (n11 + 1))).exists() && !file.mkdirs()) {
                            throw new IllegalArgumentException(string4 + " does not exist and could not be created!");
                        }
                    }
                    Preprocessing.makeBinaryDataFromBed((String)object, string7, string2, n2, string8, n3, bl7, n4, n5, string5, string9, string4, d, d2, bl8, n7, n6, string3, bl10, d3, string.equalsIgnoreCase("BinarizeBam"), bl4, bl3, bl6, n8, bl14, n10, n11, bl2, bl5);
                }
            } else {
                bl = false;
            }
            if (!bl) {
                if (string.equalsIgnoreCase("BinarizeBed")) {
                    System.out.println("usage BinarizeBed [-b binsize][-c controldir][-center][-colfields chromosome,start,end[,strand]][-e offsetend][-f foldthresh][-g signalthresh][-gzip][-n shift][-o outputcontroldir][-p poissonthresh][-peaks [-i splitrowindex]][-s offsetstart][-splitcols [-k splitcolindex][-m numsplitcols]][-splitrows [-j numsplitbins]][-stacked][-strictthresh][-t outputsignaldir][-u pseudocountcontrol][-w flankwidthcontrol] chromosomelengthfile inputbeddir cellmarkfiletable outputbinarydir");
                } else {
                    System.out.println("usage BinarizeBam [-b binsize][-c controldir][-e offsetend][-f foldthresh][-g signalthresh][-gzip][[-o outputcontroldir][-p poissonthresh][-paired|[-mixed][-center][-n shift][-peaks [-i splitindex]][-s offsetstart][-splitcols [-k splitcolindex][-m numsplitcols]][-splitrows [-j numsplitbins]][-stacked][-strictthresh][-t outputsignaldir][-u pseudocountcontrol][-w flankwidthcontrol] chromosomelengthfile inputbamdir cellmarkfiletable outputbinarydir");
                }
            }
        } else if (string.equalsIgnoreCase("BinarizeSignal")) {
            boolean bl15 = true;
            boolean bl16 = false;
            boolean bl17 = false;
            double d = 0.0;
            double d4 = 0.0;
            double d5 = 1.0E-4;
            int n = 5;
            int n14 = 1;
            int n15 = DEFAULT_NUMSPLITBINS;
            boolean bl18 = false;
            String string13 = null;
            String string14 = null;
            String string15 = null;
            if (stringArray.length <= 2) {
                bl = false;
            } else {
                int n16;
                try {
                    for (n16 = 1; n16 < stringArray.length - 2; ++n16) {
                        if (stringArray[n16].equals("-c")) {
                            string15 = stringArray[++n16];
                            continue;
                        }
                        if (stringArray[n16].equals("-f")) {
                            d = Double.parseDouble(stringArray[++n16]);
                            continue;
                        }
                        if (stringArray[n16].equals("-g")) {
                            d4 = Double.parseDouble(stringArray[++n16]);
                            continue;
                        }
                        if (stringArray[n16].equals("-gzip")) {
                            bl16 = true;
                            continue;
                        }
                        if (stringArray[n16].equals("-j")) {
                            n15 = Integer.parseInt(stringArray[++n16]);
                            bl18 = true;
                            continue;
                        }
                        if (stringArray[n16].equals("-p")) {
                            d5 = Double.parseDouble(stringArray[++n16]);
                            continue;
                        }
                        if (stringArray[n16].equals("-splitrows")) {
                            bl17 = true;
                            continue;
                        }
                        if (stringArray[n16].equals("-strictthresh")) {
                            bl15 = false;
                            continue;
                        }
                        if (stringArray[n16].equals("-u")) {
                            n14 = Integer.parseInt(stringArray[++n16]);
                            continue;
                        }
                        if (stringArray[n16].equals("-w")) {
                            n = Integer.parseInt(stringArray[++n16]);
                            continue;
                        }
                        bl = false;
                        break;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    bl = false;
                }
                if (!bl17 && bl18) {
                    bl = false;
                }
                if (bl && n16 == stringArray.length - 2) {
                    string13 = stringArray[n16++];
                    string14 = stringArray[n16];
                    File file = new File(string14);
                    if (!file.exists() && !file.mkdirs()) {
                        throw new IllegalArgumentException(string14 + " does not exist and could not be created!");
                    }
                    if (string15 != null) {
                        Preprocessing.makeBinaryDataFromSignalAgainstControl(string13, string15, string14, d5, d, bl15, n, n14, d4, bl16, bl17, n15);
                    } else {
                        Preprocessing.makeBinaryDataFromSignalUniform(string13, string14, d5, d, bl15, d4, bl16, bl17, n15);
                    }
                } else {
                    bl = false;
                }
            }
            if (!bl) {
                System.out.println("usage BinarizeSignal [-c controldir][-f foldthresh][-g signalthresh][-gzip][-p poissonthresh][-splitrows [-j numsplitbins]][-strictthresh][-u pseudocountcontrol][-w flankwidth] signaldir outputdir");
            }
        } else if (string.equalsIgnoreCase("MergeBinary")) {
            boolean bl19 = false;
            int n = DEFAULT_NUMSPLITBINS;
            boolean bl20 = false;
            String string16 = null;
            String string17 = "binary";
            String string18 = null;
            String string19 = null;
            boolean bl21 = false;
            if (stringArray.length <= 2) {
                bl = false;
            } else {
                int n17;
                try {
                    for (n17 = 1; n17 < stringArray.length - 2; ++n17) {
                        if (stringArray[n17].equals("-f")) {
                            string16 = stringArray[++n17];
                            continue;
                        }
                        if (stringArray[n17].equals("-t")) {
                            string17 = stringArray[++n17];
                            continue;
                        }
                        if (stringArray[n17].equals("-j")) {
                            n = Integer.parseInt(stringArray[++n17]);
                            bl21 = true;
                            continue;
                        }
                        if (stringArray[n17].equals("-splitrows")) {
                            bl20 = true;
                            continue;
                        }
                        if (stringArray[n17].equals("-gzip")) {
                            bl19 = true;
                            continue;
                        }
                        bl = false;
                        break;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    bl = false;
                }
                if (!bl20 && bl21) {
                    bl = false;
                }
                if (bl && n17 == stringArray.length - 2) {
                    string18 = stringArray[n17++];
                    string19 = stringArray[n17];
                    File file = new File(string19);
                    if (!file.exists() && !file.mkdirs()) {
                        throw new IllegalArgumentException(string19 + " does not exist and could not be created!");
                    }
                    Preprocessing.mergeBinarizedFiles(string18, string19, string16, bl20, n, bl19, string17);
                } else {
                    bl = false;
                }
            }
            if (!bl) {
                System.out.println("usage MergeBinary [-f dirlistfile][-gzip][-splitrows [-j numsplitbins]][-t type] inputdir outputdir");
            }
        } else if (string.equalsIgnoreCase("CompareModels")) {
            int n;
            int n18 = DEFAULTCOLOR_R;
            int n19 = DEFAULTCOLOR_G;
            int n20 = DEFAULTCOLOR_B;
            boolean bl22 = true;
            if (stringArray.length <= 2) {
                bl = false;
            } else {
                try {
                    for (n = 1; n < stringArray.length - 3; ++n) {
                        if (stringArray[n].equals("-color")) {
                            String string20;
                            StringTokenizer stringTokenizer;
                            if ((stringTokenizer = new StringTokenizer(string20 = stringArray[++n], ",")).countTokens() == 3) {
                                n18 = Integer.parseInt(stringTokenizer.nextToken().trim());
                                n19 = Integer.parseInt(stringTokenizer.nextToken().trim());
                                n20 = Integer.parseInt(stringTokenizer.nextToken().trim());
                                continue;
                            }
                            bl = false;
                            continue;
                        }
                        if (stringArray[n].equals("-noimage")) {
                            bl22 = false;
                            continue;
                        }
                        bl = false;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    bl = false;
                }
            }
            if (n != stringArray.length - 3) {
                bl = false;
            }
            if (bl) {
                String string21 = stringArray[n++];
                String string22 = stringArray[n++];
                String string23 = stringArray[n];
                StateAnalysis.makeModelEmissionCompare(string21, string22, string23, new Color(n18, n19, n20), bl22);
            }
            if (!bl) {
                System.out.println("usage CompareModels [-color r,g,b][-noimage] referencemodelemissions comparedir outputprefix");
            }
        } else if (string.equalsIgnoreCase("StatePruning")) {
            boolean bl23 = true;
            int n = 1;
            if (n >= stringArray.length) {
                bl = false;
            } else {
                if (stringArray[n].equals("-correlation")) {
                    bl23 = false;
                    ++n;
                }
                if (n + 1 == stringArray.length - 1) {
                    String string24 = stringArray[n++];
                    String string25 = stringArray[n];
                    File file = new File(string25);
                    if (!file.exists() && !file.mkdirs()) {
                        throw new IllegalArgumentException(string25 + " does not exist and could not be created!");
                    }
                    NestedEliminateInitialize.nestedEliminateInitialize(string24, string25, bl23);
                } else {
                    bl = false;
                }
            }
            if (!bl) {
                System.out.println("usage: StatePruning [-correlation] inputdir outputdir");
            }
        } else if (string.equalsIgnoreCase("EvalSubset")) {
            String string26;
            Object object;
            int n;
            int n21 = DEFAULTCOLOR_R;
            int n22 = DEFAULTCOLOR_G;
            int n23 = DEFAULTCOLOR_B;
            Color color = new Color(n21, n22, n23);
            String string27 = null;
            boolean bl24 = false;
            boolean bl25 = false;
            boolean bl26 = false;
            boolean bl27 = true;
            boolean bl28 = false;
            boolean bl29 = false;
            Object var14_138 = null;
            int n24 = DEFAULT_BINSIZEBASEPAIRS;
            String string28 = "";
            boolean bl30 = false;
            boolean bl31 = false;
            try {
                for (n = 1; n < stringArray.length - 5; ++n) {
                    if (stringArray[n].equals("-color")) {
                        if (((StringTokenizer)(object = new StringTokenizer(string26 = stringArray[++n], ","))).countTokens() == 3) {
                            n21 = Integer.parseInt(((StringTokenizer)object).nextToken().trim());
                            n22 = Integer.parseInt(((StringTokenizer)object).nextToken().trim());
                            n23 = Integer.parseInt(((StringTokenizer)object).nextToken().trim());
                            continue;
                        }
                        bl = false;
                        continue;
                    }
                    if (stringArray[n].equals("-b")) {
                        n24 = Integer.parseInt(stringArray[++n]);
                        continue;
                    }
                    if (stringArray[n].equals("-f")) {
                        string27 = stringArray[++n];
                        continue;
                    }
                    if (stringArray[n].equals("-i")) {
                        string28 = stringArray[++n];
                        continue;
                    }
                    if (stringArray[n].equals("-lowmem")) {
                        bl31 = true;
                        continue;
                    }
                    if (stringArray[n].equals("-append")) {
                        bl30 = true;
                        continue;
                    }
                    if (stringArray[n].equals("-many")) {
                        bl28 = true;
                        continue;
                    }
                    if (stringArray[n].equals("-noimage")) {
                        bl27 = false;
                        continue;
                    }
                    if (stringArray[n].equals("-readposterior")) {
                        bl24 = true;
                        continue;
                    }
                    if (stringArray[n].equals("-readstatesbyline") || stringArray[n].equals("-readstatebyline")) {
                        bl25 = true;
                        continue;
                    }
                    if (stringArray[n].equals("-scalebeta")) {
                        bl29 = true;
                        continue;
                    }
                    bl = false;
                    break;
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
            if (bl && n == stringArray.length - 5) {
                boolean bl32;
                string26 = stringArray[n++];
                object = stringArray[n++];
                String string29 = stringArray[n++];
                String string30 = stringArray[n++];
                String string31 = stringArray[n];
                boolean bl33 = bl32 = !bl25 && !bl24;
                if (bl24 && bl25) {
                    System.out.println("Invalid to specify both -readposterior and -readstatesbyline output");
                } else {
                    ChromHMM chromHMM = new ChromHMM((String)object, string29, string27, string30, string26, string28, n24, bl24, bl32, bl25, string31, bl30, color, bl27, bl31, bl28, bl29);
                    if (bl31) {
                        chromHMM.makeSegmentationConfusionWithLoad();
                    } else {
                        chromHMM.makeSegmentationConfusion();
                    }
                }
            } else {
                bl = false;
            }
            if (!bl) {
                System.out.println("usage: EvalSubset [-append][-b binsize][-f inputfilelist][-i outfileID][-lowmem][-many][-noimage][-readposterior|-readstatesbyline][-scalebeta]  inputmodel inputdir segmentdir outconfusionfileprefix includemarks");
            }
        } else if (string.equalsIgnoreCase("MakeSegmentation")) {
            int n;
            String string32 = null;
            boolean bl34 = false;
            boolean bl35 = false;
            boolean bl36 = false;
            boolean bl37 = false;
            boolean bl38 = false;
            String string33 = null;
            int n25 = DEFAULT_BINSIZEBASEPAIRS;
            String string34 = "";
            boolean bl39 = false;
            boolean bl40 = false;
            boolean bl41 = false;
            try {
                for (n = 1; n < stringArray.length - 3; ++n) {
                    if (stringArray[n].equals("-b")) {
                        n25 = Integer.parseInt(stringArray[++n]);
                        continue;
                    }
                    if (stringArray[n].equals("-f")) {
                        string32 = stringArray[++n];
                        continue;
                    }
                    if (stringArray[n].equals("-gzip")) {
                        bl40 = true;
                        continue;
                    }
                    if (stringArray[n].equals("-i")) {
                        string34 = stringArray[++n];
                        continue;
                    }
                    if (stringArray[n].equals("-l")) {
                        string33 = stringArray[++n];
                        continue;
                    }
                    if (stringArray[n].equals("-lowmem")) {
                        bl39 = true;
                        continue;
                    }
                    if (stringArray[n].equals("-many")) {
                        bl34 = true;
                        continue;
                    }
                    if (stringArray[n].equals("-nobed")) {
                        bl37 = true;
                        continue;
                    }
                    if (stringArray[n].equals("-printposterior")) {
                        bl35 = true;
                        continue;
                    }
                    if (stringArray[n].equals("-printstatesbyline") || stringArray[n].equals("-printstatebyline")) {
                        bl36 = true;
                        continue;
                    }
                    if (stringArray[n].equals("-scalebeta")) {
                        bl38 = true;
                        continue;
                    }
                    if (stringArray[n].equals("-splitrows")) {
                        bl41 = true;
                        continue;
                    }
                    bl = false;
                    break;
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
            if (bl && n == stringArray.length - 3) {
                boolean bl42;
                File file;
                String string35 = stringArray[n++];
                String string36 = stringArray[n++];
                String string37 = stringArray[n];
                File file2 = new File(string37);
                if (!file2.exists() && !file2.mkdirs()) {
                    throw new IllegalArgumentException(string37 + " does not exist and could not be created!");
                }
                if (bl35 && !(file = new File(string37 + "/POSTERIOR")).exists() && !file.mkdirs()) {
                    throw new IllegalArgumentException(string37 + "POSTERIOR does not exist and could not be created!");
                }
                if (bl36 && !(file = new File(string37 + "/STATEBYLINE")).exists() && !file.mkdirs()) {
                    throw new IllegalArgumentException(string37 + " STATEBYLINE does not exist and could not be created!");
                }
                boolean bl43 = bl42 = !bl37;
                if (bl42 || bl35 || bl36) {
                    ChromHMM chromHMM = new ChromHMM(string36, string32, string33, string37, string35, string34, n25, bl35, bl42, bl36, bl39, bl34, bl40, bl41, bl38);
                    if (bl39) {
                        chromHMM.makeSegmentationWithLoad();
                    } else {
                        chromHMM.makeSegmentation();
                    }
                } else {
                    System.out.println("No output type was requested!");
                }
            } else {
                bl = false;
            }
            if (!bl) {
                System.out.println("usage: MakeSegmentation [-b binsize][-f inputfilelist][-gzip][-i outfileID][-l chromosomelengthfile][-lowmem][-many][-nobed][-printposterior][-printstatebyline][-scalebeta][-splitrows]  modelfile inputdir outputdir");
            }
        } else if (string.equalsIgnoreCase("MakeBrowserFiles")) {
            int n;
            String string38 = null;
            String string39 = null;
            boolean bl44 = false;
            boolean bl45 = false;
            int n26 = -1;
            for (n = 1; n < stringArray.length - 3; ++n) {
                if (stringArray[n].equals("-c")) {
                    string38 = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-gzip")) {
                    bl44 = true;
                    continue;
                }
                if (stringArray[n].equals("-l") || stringArray[n].equals("-m")) {
                    string39 = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-lowmem")) {
                    bl45 = true;
                    continue;
                }
                if (stringArray[n].equals("-n")) {
                    n26 = Integer.parseInt(stringArray[++n]);
                    continue;
                }
                bl = false;
                break;
            }
            if (bl && n == stringArray.length - 3) {
                String string40 = stringArray[n++];
                String string41 = stringArray[n++];
                String string42 = stringArray[n];
                BrowserOutput browserOutput = new BrowserOutput(string40, string38, string39, string41, string42, n26, bl44);
                browserOutput.makebrowserdense();
                if (bl45) {
                    browserOutput.makebrowserexpandedLowMem();
                } else {
                    browserOutput.makebrowserexpanded();
                }
            } else {
                bl = false;
            }
            if (!bl) {
                System.out.println("usage: MakeBrowserFiles [-c colormappingfile][-gzip][-lowmem][-m labelmappingfile][-n numstates] segmentfile segmentationname outputfileprefix");
            }
        } else if (string.equalsIgnoreCase("OverlapEnrichment")) {
            int n;
            String string43 = "";
            String string44 = null;
            String string45 = null;
            int n27 = DEFAULT_OVERLAPENRICHMENT_NOFFSETLEFT;
            int n28 = DEFAULT_OVERLAPENRICHMENT_NOFFSETRIGHT;
            int n29 = DEFAULT_BINSIZEBASEPAIRS;
            boolean bl46 = DEFAULT_OVERLAPENRICHMENT_BCENTER;
            boolean bl47 = DEFAULT_OVERLAPENRICHMENT_BCOUNTMULTI;
            boolean bl48 = DEFAULT_OVERLAPENRICHMENT_BUSESIGNAL;
            String string46 = null;
            boolean bl49 = DEFAULT_OVERLAPENRICHMENT_BBASERES;
            boolean bl50 = DEFAULT_OVERLAPENRICHMENT_BUNIFORMHEAT;
            boolean bl51 = false;
            String string47 = "Fold Enrichments";
            boolean bl52 = true;
            boolean bl53 = false;
            boolean bl54 = true;
            int n30 = DEFAULTCOLOR_R;
            int n31 = DEFAULTCOLOR_G;
            int n32 = DEFAULTCOLOR_B;
            try {
                for (n = 1; n < stringArray.length - 3; ++n) {
                    if (stringArray[n].equals("-a")) {
                        string43 = stringArray[++n];
                        continue;
                    }
                    if (stringArray[n].equals("-b")) {
                        n29 = Integer.parseInt(stringArray[++n]);
                        continue;
                    }
                    if (stringArray[n].equals("-color")) {
                        String string48;
                        StringTokenizer stringTokenizer;
                        if ((stringTokenizer = new StringTokenizer(string48 = stringArray[++n], ",")).countTokens() == 3) {
                            n30 = Integer.parseInt(stringTokenizer.nextToken().trim());
                            n31 = Integer.parseInt(stringTokenizer.nextToken().trim());
                            n32 = Integer.parseInt(stringTokenizer.nextToken().trim());
                            continue;
                        }
                        bl = false;
                        continue;
                    }
                    if (stringArray[n].equals("-colfields")) {
                        string46 = stringArray[++n];
                        continue;
                    }
                    if (stringArray[n].equals("-binres")) {
                        bl49 = false;
                        continue;
                    }
                    if (stringArray[n].equals("-f")) {
                        string44 = stringArray[++n];
                        continue;
                    }
                    if (stringArray[n].equals("-signal")) {
                        bl48 = true;
                        continue;
                    }
                    if (stringArray[n].equals("-uniformscale")) {
                        bl50 = true;
                        continue;
                    }
                    if (stringArray[n].equals("-s")) {
                        n27 = Integer.parseInt(stringArray[++n]);
                        continue;
                    }
                    if (stringArray[n].equals("-center")) {
                        bl46 = true;
                        continue;
                    }
                    if (stringArray[n].equals("-labels")) {
                        bl51 = true;
                        continue;
                    }
                    if (stringArray[n].equals("-m")) {
                        string45 = stringArray[++n];
                        continue;
                    }
                    if (stringArray[n].equals("-multicount")) {
                        bl47 = true;
                        continue;
                    }
                    if (stringArray[n].equals("-noimage")) {
                        bl54 = false;
                        continue;
                    }
                    if (stringArray[n].equals("-posterior")) {
                        bl52 = false;
                        continue;
                    }
                    if (stringArray[n].equals("-e")) {
                        n28 = Integer.parseInt(stringArray[++n]);
                        continue;
                    }
                    if (stringArray[n].equals("-t")) {
                        string47 = stringArray[++n];
                        continue;
                    }
                    if (stringArray[n].equals("-lowmem")) {
                        bl53 = true;
                        continue;
                    }
                    bl = false;
                    break;
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
            if (n == stringArray.length - 3 && bl) {
                String string49 = stringArray[n++];
                String string50 = stringArray[n++];
                String string51 = stringArray[n];
                boolean bl55 = !bl47;
                boolean bl56 = !bl50;
                Color color = new Color(n30, n31, n32);
                System.out.println("Computing Enrichments...");
                if (bl52) {
                    if (bl53) {
                        StateAnalysis.enrichmentMaxLowMem(string49, string50, string44, n27, n28, n29, bl46, bl55, bl48, string46, bl49, string51, bl56, color, string47, string45, bl54, bl51);
                    } else {
                        StateAnalysis.enrichmentMax(string49, string50, string44, n27, n28, n29, bl46, bl55, bl48, string46, bl49, string51, bl56, color, string47, string45, bl54, bl51);
                    }
                } else {
                    StateAnalysis.enrichmentPosterior(string49, string43, string50, string44, n27, n28, n29, bl46, bl55, bl48, string46, bl49, string51, bl56, color, string47, string45, bl54);
                }
            } else {
                bl = false;
            }
            if (!bl) {
                System.out.println("usage OverlapEnrichment [-a cell][-b binsize][-binres][-color r,g,b][-center][-colfields chromosome,start,end[,signal]][-e offsetend][-f coordlistfile][-labels][-lowmem][-m labelmappingfile][-multicount][-noimage][-posterior][-s offsetstart][-signal][-t title][-uniformscale] inputsegment inputcoorddir outfileprefix");
            }
        } else if (string.equalsIgnoreCase("NeighborhoodEnrichment") || string.equalsIgnoreCase("NeighborhoodSignal")) {
            Object object;
            int n;
            int n33 = DEFAULT_BINSIZEBASEPAIRS;
            int n34 = DEFAULT_NEIGHBORHOOD_NUMLEFT;
            int n35 = DEFAULT_NEIGHBORHOOD_NUMRIGHT;
            int n36 = DEFAULT_BINSIZEBASEPAIRS;
            String string52 = null;
            boolean bl57 = DEFAULT_NEIGHBORHOOD_BUSESTRAND;
            boolean bl58 = DEFAULT_NEIGHBORHOOD_BUSESIGNAL;
            boolean bl59 = false;
            String string53 = null;
            int n37 = DEFAULT_NEIGHBORHOOD_NOFFSETANCHOR;
            String string54 = "Fold Enrichments";
            String string55 = "";
            int n38 = DEFAULTCOLOR_R;
            int n39 = DEFAULTCOLOR_G;
            int n40 = DEFAULTCOLOR_B;
            boolean bl60 = true;
            boolean bl61 = false;
            boolean bl62 = true;
            boolean bl63 = false;
            try {
                for (n = 1; n < stringArray.length - 3; ++n) {
                    if (stringArray[n].equals("-a")) {
                        string55 = stringArray[++n];
                        continue;
                    }
                    if (stringArray[n].equals("-b")) {
                        n33 = Integer.parseInt(stringArray[++n]);
                        continue;
                    }
                    if (stringArray[n].equals("-color")) {
                        StringTokenizer stringTokenizer;
                        if ((stringTokenizer = new StringTokenizer((String)(object = stringArray[++n]), ",")).countTokens() == 3) {
                            n38 = Integer.parseInt(stringTokenizer.nextToken().trim());
                            n39 = Integer.parseInt(stringTokenizer.nextToken().trim());
                            n40 = Integer.parseInt(stringTokenizer.nextToken().trim());
                            continue;
                        }
                        bl = false;
                        continue;
                    }
                    if (stringArray[n].equals("-colfields")) {
                        string53 = stringArray[++n];
                        continue;
                    }
                    if (stringArray[n].equals("-signal")) {
                        bl58 = true;
                        continue;
                    }
                    if (stringArray[n].equals("-l")) {
                        n34 = Integer.parseInt(stringArray[++n]);
                        continue;
                    }
                    if (stringArray[n].equals("-labels")) {
                        bl59 = true;
                        continue;
                    }
                    if (stringArray[n].equals("-lowmem")) {
                        bl61 = true;
                        continue;
                    }
                    if (stringArray[n].equals("-m")) {
                        string52 = stringArray[++n];
                        continue;
                    }
                    if (stringArray[n].equals("-noimage")) {
                        bl62 = false;
                        continue;
                    }
                    if (stringArray[n].equals("-o")) {
                        n37 = Integer.parseInt(stringArray[++n]);
                        continue;
                    }
                    if (stringArray[n].equals("-posterior")) {
                        bl60 = false;
                        continue;
                    }
                    if (stringArray[n].equals("-r")) {
                        n35 = Integer.parseInt(stringArray[++n]);
                        continue;
                    }
                    if (stringArray[n].equals("-s")) {
                        n36 = Integer.parseInt(stringArray[++n]);
                        bl63 = true;
                        continue;
                    }
                    if (stringArray[n].equals("-nostrand")) {
                        bl57 = false;
                        continue;
                    }
                    if (stringArray[n].equals("-t")) {
                        string54 = stringArray[++n];
                        continue;
                    }
                    bl = false;
                    break;
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
            if (!bl63) {
                n36 = n33;
            }
            if (n == stringArray.length - 3 && bl) {
                object = new Color(n38, n39, n40);
                String string56 = stringArray[n++];
                String string57 = stringArray[n++];
                String string58 = stringArray[n];
                System.out.println("Computing Enrichments...");
                if (string.equalsIgnoreCase("NeighborhoodSignal")) {
                    StateAnalysis.neighborhoodSignal(string56, string55, string57, n33, n34, n35, n36, bl57, bl58, string53, n37, string58, (Color)object, string54, string52, bl62);
                } else if (bl60) {
                    if (bl61) {
                        StateAnalysis.neighborhoodMaxLowMem(string56, string57, n33, n34, n35, n36, bl57, bl58, string53, n37, string58, (Color)object, string54, string52, bl62, bl59);
                    } else {
                        StateAnalysis.neighborhoodMax(string56, string57, n33, n34, n35, n36, bl57, bl58, string53, n37, string58, (Color)object, string54, string52, bl62, bl59);
                    }
                } else {
                    StateAnalysis.neighborhoodPosterior(string56, string55, string57, n33, n34, n35, n36, bl57, bl58, string53, n37, string58, (Color)object, string54, string52, bl62);
                }
            } else {
                bl = false;
            }
            if (!bl) {
                System.out.println("usage NeighborhoodEnrichment [-a cell][-b binsize][-color r,g,b][-colfields chromosome,position[,optionalcol1|,optionalcol1,optionalcol2][-l numleftintervals][-labels][-lowmem][-m labelmappingfile][-noimage][-nostrand][-o anchoroffset][-posterior][-r numrightintervals][-s spacing][-signal][-t title] inputsegment anchorpositions outfileprefix");
            }
        } else if (string.equalsIgnoreCase("LearnModel")) {
            Object object;
            Object object3;
            int n;
            String string59 = ChromHMM.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            String string60 = URLDecoder.decode(string59, "UTF-8");
            String string61 = string60.substring(0, string60.lastIndexOf("/") + 1);
            String string62 = string61 + "/" + COORDDIR;
            String string63 = string61 + "/" + ANCHORFILEDIR;
            int n41 = 999;
            int n42 = 200;
            int n43 = 8;
            String string64 = null;
            int n44 = INITMETHOD_INFORMATION;
            double d = 0.001;
            double d6 = 0.02;
            double d7 = 0.02;
            double d8 = 0.5;
            boolean bl64 = true;
            boolean bl65 = false;
            boolean bl66 = false;
            boolean bl67 = false;
            boolean bl68 = true;
            boolean bl69 = true;
            boolean bl70 = true;
            boolean bl71 = false;
            boolean bl72 = false;
            boolean bl73 = false;
            boolean bl74 = false;
            boolean bl75 = false;
            int n45 = DEFAULT_NUMSPLITBINS;
            boolean bl76 = DEFAULT_NEIGHBORHOOD_BUSESTRAND;
            String string65 = null;
            String string66 = null;
            int n46 = DEFAULT_BINSIZEBASEPAIRS;
            String string67 = "";
            int n47 = STATEORDER_EMISSION;
            boolean bl77 = false;
            boolean bl78 = false;
            int n48 = -1;
            int n49 = 0;
            int n50 = 0;
            boolean bl79 = false;
            boolean bl80 = false;
            int n51 = DEFAULTCOLOR_R;
            int n52 = DEFAULTCOLOR_G;
            int n53 = DEFAULTCOLOR_B;
            try {
                for (n = 1; n < stringArray.length - 4; ++n) {
                    if (stringArray[n].equals("-b")) {
                        n46 = Integer.parseInt(stringArray[++n]);
                        continue;
                    }
                    if (stringArray[n].equals("-color")) {
                        if (((StringTokenizer)(object3 = new StringTokenizer((String)(object = stringArray[++n]), ","))).countTokens() == 3) {
                            n51 = Integer.parseInt(((StringTokenizer)object3).nextToken().trim());
                            n52 = Integer.parseInt(((StringTokenizer)object3).nextToken().trim());
                            n53 = Integer.parseInt(((StringTokenizer)object3).nextToken().trim());
                            continue;
                        }
                        bl = false;
                        continue;
                    }
                    if (stringArray[n].equals("-d")) {
                        d = Double.parseDouble(stringArray[++n]);
                        continue;
                    }
                    if (stringArray[n].equals("-e")) {
                        d7 = Double.parseDouble(stringArray[++n]);
                        continue;
                    }
                    if (stringArray[n].equals("-f")) {
                        string65 = stringArray[++n];
                        continue;
                    }
                    if (stringArray[n].equals("-nostrand")) {
                        bl76 = false;
                        continue;
                    }
                    if (stringArray[n].equals("-gzip")) {
                        bl74 = true;
                        continue;
                    }
                    if (stringArray[n].equals("-h")) {
                        d6 = Double.parseDouble(stringArray[++n]);
                        continue;
                    }
                    if (stringArray[n].equals("-i")) {
                        string67 = stringArray[++n];
                        continue;
                    }
                    if (stringArray[n].equals("-init")) {
                        if (((String)(object = stringArray[++n])).equals("information") || ((String)object).equals("0")) {
                            n44 = INITMETHOD_INFORMATION;
                            continue;
                        }
                        if (((String)object).equals("random") || ((String)object).equals("1")) {
                            n44 = INITMETHOD_RANDOM;
                            continue;
                        }
                        if (((String)object).equals("load") || ((String)object).equals("2")) {
                            n44 = INITMETHOD_LOAD;
                            continue;
                        }
                        bl = false;
                        break;
                    }
                    if (stringArray[n].equals("-l")) {
                        string66 = stringArray[++n];
                        continue;
                    }
                    if (stringArray[n].equals("-m")) {
                        string64 = stringArray[++n];
                        continue;
                    }
                    if (stringArray[n].equals("-many")) {
                        bl72 = true;
                        continue;
                    }
                    if (stringArray[n].equals("-n")) {
                        n50 = Integer.parseInt(stringArray[++n]);
                        continue;
                    }
                    if (stringArray[n].equals("-noautoopen")) {
                        bl64 = false;
                        continue;
                    }
                    if (stringArray[n].equals("-nobed")) {
                        bl67 = true;
                        continue;
                    }
                    if (stringArray[n].equals("-nobrowser")) {
                        bl68 = false;
                        continue;
                    }
                    if (stringArray[n].equals("-noenrich")) {
                        bl69 = false;
                        continue;
                    }
                    if (stringArray[n].equals("-noimage")) {
                        bl70 = false;
                        continue;
                    }
                    if (stringArray[n].equals("-p")) {
                        bl79 = true;
                        n49 = Integer.parseInt(stringArray[++n]);
                        continue;
                    }
                    if (stringArray[n].equals("-pseudo")) {
                        bl73 = true;
                        continue;
                    }
                    if (stringArray[n].equals("-stateordering")) {
                        if (((String)(object = stringArray[++n])).equals("emission")) {
                            n47 = STATEORDER_EMISSION;
                            continue;
                        }
                        if (((String)object).equals("transition")) {
                            n47 = STATEORDER_TRANSITION;
                            continue;
                        }
                        bl = false;
                        break;
                    }
                    if (stringArray[n].equals("-printposterior")) {
                        bl65 = true;
                        continue;
                    }
                    if (stringArray[n].equals("-lowmem")) {
                        bl71 = true;
                        continue;
                    }
                    if (stringArray[n].equals("-r")) {
                        n42 = Integer.parseInt(stringArray[++n]);
                        continue;
                    }
                    if (stringArray[n].equals("-s")) {
                        n41 = Integer.parseInt(stringArray[++n]);
                        continue;
                    }
                    if (stringArray[n].equals("-scalebeta")) {
                        bl80 = true;
                        continue;
                    }
                    if (stringArray[n].equals("-t")) {
                        d8 = Double.parseDouble(stringArray[++n]);
                        continue;
                    }
                    if (stringArray[n].equals("-holdcolumnorder")) {
                        bl77 = true;
                        continue;
                    }
                    if (stringArray[n].equals("-holdroworder")) {
                        bl78 = true;
                        n47 = STATEORDER_FIXED;
                        continue;
                    }
                    if (stringArray[n].equals("-printstatebyline") || stringArray[n].equals("-printstatesbyline")) {
                        bl66 = true;
                        continue;
                    }
                    if (stringArray[n].equals("-splitrows")) {
                        bl75 = true;
                        continue;
                    }
                    if (stringArray[n].equals("-u")) {
                        string62 = stringArray[++n];
                        continue;
                    }
                    if (stringArray[n].equals("-v")) {
                        string63 = stringArray[++n];
                        continue;
                    }
                    if (stringArray[n].equals("-x")) {
                        n48 = Integer.parseInt(stringArray[++n]);
                        continue;
                    }
                    if (stringArray[n].equals("-z")) {
                        n43 = Integer.parseInt(stringArray[++n]);
                        continue;
                    }
                    bl = false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
            if (bl && n == stringArray.length - 4) {
                File file;
                String string68;
                File file3;
                object = new Color(n51, n52, n53);
                object3 = stringArray[n++];
                if (!(file3 = new File(string68 = stringArray[n++])).exists() && !file3.mkdirs()) {
                    throw new IllegalArgumentException(string68 + " does not exist and could not be created!");
                }
                if (bl65 && !(file = new File(string68 + "/POSTERIOR")).exists() && !file.mkdirs()) {
                    throw new IllegalArgumentException(string68 + "/POSTERIOR does not exist and could not be created!");
                }
                if (bl66 && !(file = new File(string68 + "/STATEBYLINE")).exists() && !file.mkdirs()) {
                    throw new IllegalArgumentException(string68 + "/STATEBYLINE does not exist and could not be created!");
                }
                int n54 = 0;
                try {
                    n54 = Integer.parseInt(stringArray[n++]);
                }
                catch (NumberFormatException numberFormatException) {
                    bl = false;
                }
                if (bl) {
                    Object object4;
                    boolean bl81;
                    String string69 = stringArray[n++];
                    boolean bl82 = !bl67;
                    boolean bl83 = !bl77;
                    boolean bl84 = bl81 = !bl78;
                    if (string67.equals("") && n44 == INITMETHOD_RANDOM) {
                        string67 = "" + n41;
                    }
                    if (string66 == null && ((File)(object4 = new File(string61 + "/" + CHROMSIZESDIR + "/" + string69 + ".txt"))).exists()) {
                        string66 = string61 + "/" + CHROMSIZESDIR + "/" + string69 + ".txt";
                    }
                    object4 = new ChromHMM((String)object3, string68, string65, string66, n54, n41, n44, string64, d7, d8, d6, n42, d, n48, bl65, bl82, bl66, n46, string67, n47, bl83, n43, (Color)object, bl79, n49, bl71, n50, bl70, bl72, bl73, bl74, bl75, bl81, bl80);
                    ((ChromHMM)object4).buildModel();
                    String string70 = string67.equals("") ? "" : "_" + string67;
                    String string71 = string68 + "/webpage_" + n54 + string70 + ".html";
                    PrintWriter printWriter = new PrintWriter(new FileWriter(string71));
                    printWriter.println("<center><h1>ChromHMM Report</h1></center>");
                    printWriter.println("Input Directory: " + (String)object3 + "<br>");
                    printWriter.println("Output Directory: " + string68 + "<br>");
                    printWriter.println("Number of States: " + n54 + "<br>");
                    printWriter.println("Assembly: " + string69 + "<br>");
                    printWriter.print("Full ChromHMM command: ");
                    for (int i = 0; i < stringArray.length - 1; ++i) {
                        printWriter.print(stringArray[i] + " ");
                    }
                    printWriter.println(stringArray[stringArray.length - 1] + "");
                    printWriter.println("<h1>Model Parameters</h1>");
                    if (bl70) {
                        printWriter.println("<img src=\"emissions_" + n54 + string70 + ".png\"><br>");
                        printWriter.println("<li><a href=\"emissions_" + n54 + string70 + ".svg\">Emission Parameter SVG File</a><br>");
                    }
                    printWriter.println("<li><a href=\"emissions_" + n54 + string70 + ".txt\">Emission Parameter Tab-Delimited Text File</a><br>");
                    if (bl70) {
                        printWriter.println("<img src=\"transitions_" + n54 + string70 + ".png\"><br>");
                        printWriter.println("<li><a href=\"transitions_" + n54 + string70 + ".svg\">Transition Parameter SVG File</a><br>");
                    }
                    printWriter.println("<li><a href=\"transitions_" + n54 + string70 + ".txt\">Transition Parameter Tab-Delimited Text File</a><br><br>");
                    printWriter.println("<li><a href=\"model_" + n54 + string70 + ".txt\">All Model Parameters Tab-Delimited Text File</a> <br>");
                    printWriter.println("<h1>Genome Segmentation Files</h1>");
                    if (bl82 || bl65 || bl66) {
                        if (bl71) {
                            ((ChromHMM)object4).makeSegmentationWithLoad();
                        } else {
                            ((ChromHMM)object4).makeSegmentation();
                        }
                        if (bl82) {
                            Object object5;
                            String string72;
                            Object object6;
                            int n55;
                            Iterator iterator = ((ChromHMM)object4).hsprefix.iterator();
                            Object[] objectArray = new String[((ChromHMM)object4).hsprefix.size()];
                            int n56 = 0;
                            while (iterator.hasNext()) {
                                objectArray[n56] = (String)iterator.next();
                                ++n56;
                            }
                            Arrays.sort(objectArray);
                            for (n55 = 0; n55 < objectArray.length; ++n55) {
                                object6 = bl74 ? (String)objectArray[n55] + SZSEGMENTEXTENSION + ".gz" : (String)objectArray[n55] + SZSEGMENTEXTENSION;
                                printWriter.println("<li><a href=\"" + (String)object6 + "\">" + (String)objectArray[n55] + " Segmentation File (Four Column Bed File)</a><br>");
                            }
                            if (bl66) {
                                printWriter.println("<li><a href=\"STATEBYLINE\"> Directory of Maximum States Assignments Line By Line</a><br>");
                            }
                            if (bl65) {
                                printWriter.println("<li><a href=\"POSTERIOR\"> Directory of Posterior Files</a><br>");
                            }
                            if (bl68) {
                                printWriter.println("<br>");
                                printWriter.println("Custom Tracks for loading into the <a href=\"http://genome.ucsc.edu\">UCSC Genome Browser</a>:<br>");
                                for (n55 = 0; n55 < objectArray.length; ++n55) {
                                    object6 = objectArray[n55];
                                    string72 = bl74 ? string68 + "/" + (String)object6 + SZSEGMENTEXTENSION + ".gz" : string68 + "/" + (String)object6 + SZSEGMENTEXTENSION;
                                    object5 = new BrowserOutput(string72, null, null, (String)object6, string68 + "/" + (String)object6, n54, bl74);
                                    ((BrowserOutput)object5).makebrowserdense();
                                    if (bl71) {
                                        ((BrowserOutput)object5).makebrowserexpandedLowMem();
                                    } else {
                                        ((BrowserOutput)object5).makebrowserexpanded();
                                    }
                                    if (bl74) {
                                        printWriter.println("<li><a href=" + (String)object6 + SZBROWSERDENSEEXTENSION + ".bed.gz>" + (String)object6 + " Browser Custom Track Dense File</a> <br>");
                                        printWriter.println("<li><a href=" + (String)object6 + SZBROWSEREXPANDEDEXTENSION + ".bed.gz>" + (String)object6 + " Browser Custom Track Expanded File</a><br>");
                                        continue;
                                    }
                                    printWriter.println("<li><a href=" + (String)object6 + SZBROWSERDENSEEXTENSION + ".bed>" + (String)object6 + " Browser Custom Track Dense File</a> <br>");
                                    printWriter.println("<li><a href=" + (String)object6 + SZBROWSEREXPANDEDEXTENSION + ".bed>" + (String)object6 + " Browser Custom Track Expanded File</a><br>");
                                }
                            }
                            if (bl69) {
                                printWriter.println("<h1>State Enrichments</h1>");
                                for (n55 = 0; n55 < objectArray.length; ++n55) {
                                    Object object7;
                                    object6 = objectArray[n55];
                                    printWriter.println("<h2>" + (String)object6 + " Enrichments</h2>");
                                    string72 = bl74 ? string68 + "/" + (String)object6 + SZSEGMENTEXTENSION + ".gz" : string68 + "/" + (String)object6 + SZSEGMENTEXTENSION;
                                    object5 = new File(string62 + "/" + string69);
                                    if (((File)object5).exists()) {
                                        if (bl71) {
                                            StateAnalysis.enrichmentMaxLowMem(string72, string62 + "/" + string69, null, DEFAULT_OVERLAPENRICHMENT_NOFFSETLEFT, DEFAULT_OVERLAPENRICHMENT_NOFFSETRIGHT, n46, DEFAULT_OVERLAPENRICHMENT_BCENTER, !DEFAULT_OVERLAPENRICHMENT_BCOUNTMULTI, DEFAULT_OVERLAPENRICHMENT_BUSESIGNAL, null, DEFAULT_OVERLAPENRICHMENT_BBASERES, string68 + "/" + (String)object6 + SZOVERLAPEXTENSION, !DEFAULT_OVERLAPENRICHMENT_BUNIFORMHEAT, (Color)object, "Fold Enrichment " + (String)object6, null, bl70, false);
                                        } else {
                                            StateAnalysis.enrichmentMax(string72, string62 + "/" + string69, null, DEFAULT_OVERLAPENRICHMENT_NOFFSETLEFT, DEFAULT_OVERLAPENRICHMENT_NOFFSETRIGHT, n46, DEFAULT_OVERLAPENRICHMENT_BCENTER, !DEFAULT_OVERLAPENRICHMENT_BCOUNTMULTI, DEFAULT_OVERLAPENRICHMENT_BUSESIGNAL, null, DEFAULT_OVERLAPENRICHMENT_BBASERES, string68 + "/" + (String)object6 + SZOVERLAPEXTENSION, !DEFAULT_OVERLAPENRICHMENT_BUNIFORMHEAT, (Color)object, "Fold Enrichment " + (String)object6, null, bl70, false);
                                        }
                                        object7 = (String)object6 + SZOVERLAPEXTENSION + ".txt";
                                        if (bl70) {
                                            printWriter.println("<img src=\"" + (String)object6 + SZOVERLAPEXTENSION + ".png\"> <br>");
                                            printWriter.println("<li><a href=\"" + (String)object6 + SZOVERLAPEXTENSION + ".svg\">" + (String)object6 + " Overlap Enrichment SVG File</a><br>");
                                        }
                                        printWriter.println("<li><a href=\"" + (String)object7 + "\">" + (String)object6 + " Overlap Enrichment Tab-Delimited Text File</a><br>");
                                    } else {
                                        System.out.println("Warning: No coordinate directory found for assembly " + string69 + " in " + string62);
                                    }
                                    object7 = new File(string63 + "/" + string69);
                                    if (((File)object7).exists()) {
                                        String[] stringArray2 = ((File)object7).list();
                                        for (int i = 0; i < stringArray2.length; ++i) {
                                            File file4 = new File(stringArray2[i]);
                                            if (file4.isHidden()) continue;
                                            int n57 = stringArray2[i].indexOf(".");
                                            String string73 = n57 == -1 ? stringArray2[i] : stringArray2[i].substring(0, n57);
                                            if (bl71) {
                                                StateAnalysis.neighborhoodMaxLowMem(string72, string63 + "/" + string69 + "/" + stringArray2[i], n46, DEFAULT_NEIGHBORHOOD_NUMLEFT, DEFAULT_NEIGHBORHOOD_NUMRIGHT, n46, bl76, DEFAULT_NEIGHBORHOOD_BUSESIGNAL, null, DEFAULT_NEIGHBORHOOD_NOFFSETANCHOR, string68 + "/" + (String)object6 + "_" + string73 + "_neighborhood", (Color)object, "Fold Enrichment " + (String)object6 + " " + string73, null, bl70, false);
                                            } else {
                                                StateAnalysis.neighborhoodMax(string72, string63 + "/" + string69 + "/" + stringArray2[i], n46, DEFAULT_NEIGHBORHOOD_NUMLEFT, DEFAULT_NEIGHBORHOOD_NUMRIGHT, n46, bl76, DEFAULT_NEIGHBORHOOD_BUSESIGNAL, null, DEFAULT_NEIGHBORHOOD_NOFFSETANCHOR, string68 + "/" + (String)object6 + "_" + string73 + "_neighborhood", (Color)object, "Fold Enrichment " + (String)object6 + " " + string73, null, bl70, false);
                                            }
                                            String string74 = (String)object6 + "_" + string73 + SZNEIGHBORHOODEXTENSION;
                                            if (bl70) {
                                                printWriter.println("<img src=\"" + string74 + ".png\"> <br>");
                                                printWriter.println("<li><a href=\"" + string74 + ".svg\">" + string74 + " Enrichment SVG File</a><br>");
                                            }
                                            printWriter.println("<li><a href=\"" + string74 + ".txt\">" + string74 + " Enrichment Tab-Delimited Text File</a><br>");
                                        }
                                        continue;
                                    }
                                    System.out.println("Warning: No coordinate directory found for assembly " + string69 + " in " + string63);
                                }
                            }
                        }
                    }
                    printWriter.close();
                    if (bl64) {
                        try {
                            Desktop.getDesktop().browse(new File(string71).toURI());
                        }
                        catch (Exception exception) {
                            System.out.println("Warning could not automatically open in a browser " + string71);
                        }
                    }
                }
            } else {
                bl = false;
            }
            if (!bl) {
                System.out.println("usage: LearnModel [-b binsize][-color r,g,b][-d convergedelta][-e loadsmoothemission][-f inputfilelist][-gzip][-h informationsmooth][-holdcolumnorder][-holdroworder][-i outfileID][-init information|random|load][-l chromosomelengthfile][-lowmem][-m modelinitialfile][-many][-n numseq][-noautoopen][-nobed][-nobrowser][-noenrich][-noimage][-p maxprocessors][-pseudo][-printposterior][-printstatebyline][-r maxiterations][-s seed][-scalebeta][-splitrows][-stateordering emission|transition][-t loadsmoothtransition][-u coorddir][-v anchorfiledir][-x maxseconds][-z zerotransitionpower] inputdir outputdir numstates assembly");
            }
        } else if (string.equalsIgnoreCase("Reorder")) {
            Object object;
            Object object8;
            int n;
            int n58 = INITMETHOD_INFORMATION;
            String string75 = "";
            String string76 = null;
            String string77 = null;
            String string78 = null;
            int n59 = STATEORDER_FIXED;
            boolean bl85 = false;
            boolean bl86 = false;
            boolean bl87 = true;
            String string79 = null;
            String string80 = null;
            boolean bl88 = false;
            int n60 = DEFAULTCOLOR_R;
            int n61 = DEFAULTCOLOR_G;
            int n62 = DEFAULTCOLOR_B;
            try {
                for (n = 1; n < stringArray.length - 2; ++n) {
                    if (stringArray[n].equals("-color")) {
                        if (((StringTokenizer)(object8 = new StringTokenizer((String)(object = stringArray[++n]), ","))).countTokens() == 3) {
                            n60 = Integer.parseInt(((StringTokenizer)object8).nextToken().trim());
                            n61 = Integer.parseInt(((StringTokenizer)object8).nextToken().trim());
                            n62 = Integer.parseInt(((StringTokenizer)object8).nextToken().trim());
                            continue;
                        }
                        bl = false;
                        continue;
                    }
                    if (stringArray[n].equals("-f")) {
                        string78 = stringArray[++n];
                        continue;
                    }
                    if (stringArray[n].equals("-i")) {
                        string75 = stringArray[++n];
                        continue;
                    }
                    if (stringArray[n].equals("-m")) {
                        string76 = stringArray[++n];
                        continue;
                    }
                    if (stringArray[n].equals("-noimage")) {
                        bl87 = false;
                        continue;
                    }
                    if (stringArray[n].equals("-reordercolsmodelfile")) {
                        bl88 = true;
                        continue;
                    }
                    if (stringArray[n].equals("-o")) {
                        string77 = stringArray[++n];
                        n59 = STATEORDER_USER;
                        continue;
                    }
                    if (stringArray[n].equals("-r")) {
                        string79 = stringArray[++n];
                        if (n + 1 == stringArray.length) {
                            bl = false;
                            break;
                        }
                        if (!string79.equals(string80 = stringArray[++n])) continue;
                        System.out.println("bedfilein cannot be the same as bedfileout");
                        bl = false;
                        continue;
                    }
                    if (stringArray[n].equals("-stateordering")) {
                        if (((String)(object = stringArray[++n])).equals("emission")) {
                            n59 = STATEORDER_EMISSION;
                            continue;
                        }
                        if (((String)object).equals("transition")) {
                            n59 = STATEORDER_TRANSITION;
                            continue;
                        }
                        bl = false;
                        break;
                    }
                    if (stringArray[n].equals("-holdcolumnorder")) {
                        bl85 = true;
                        continue;
                    }
                    bl = false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
            if (string77 == null && string79 != null) {
                bl = false;
            }
            if (bl && n == stringArray.length - 2) {
                String string81;
                File file;
                object = new Color(n60, n61, n62);
                object8 = stringArray[n++];
                if (!(file = new File(string81 = stringArray[n++])).exists() && !file.mkdirs()) {
                    throw new IllegalArgumentException(string81 + " does not exist and could not be created!");
                }
                if (bl) {
                    boolean bl89 = !bl86;
                    boolean bl90 = !bl85;
                    ChromHMM chromHMM = new ChromHMM((String)object8, string81, string77, string78, string75, n59, bl90, (Color)object, string76, bl87, string79, string80, bl88);
                    chromHMM.reorderModel();
                }
            } else {
                bl = false;
            }
            if (!bl) {
                System.out.println("usage: Reorder [-color r,g,b][-f columnorderingfile][-holdcolumnorder][-i outfileID][-m labelmappingfile][-noimage][-o stateorderingfile [-r bedfilein bedfileout]][-reordercolsmodelfile][-stateordering emission|transition] inputmodel outputdir");
            }
        } else if (string.equalsIgnoreCase("ConvertGeneTable")) {
            int n;
            String string82 = ChromHMM.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            String string83 = URLDecoder.decode(string82, "UTF-8");
            String string84 = string83.substring(0, string83.lastIndexOf("/") + 1);
            String string85 = string84 + "/" + COORDDIR;
            String string86 = string84 + "/" + ANCHORFILEDIR;
            String string87 = null;
            int n63 = 2000;
            boolean bl91 = false;
            try {
                for (n = 1; n < stringArray.length - 3; ++n) {
                    if (stringArray[n].equals("-gzip")) {
                        bl91 = true;
                        continue;
                    }
                    if (stringArray[n].equals("-l")) {
                        string87 = stringArray[++n];
                        continue;
                    }
                    if (stringArray[n].equals("-u")) {
                        string85 = stringArray[++n];
                        continue;
                    }
                    if (stringArray[n].equals("-v")) {
                        string86 = stringArray[++n];
                        continue;
                    }
                    if (stringArray[n].equals("-w")) {
                        n63 = Integer.parseInt(stringArray[++n]);
                        continue;
                    }
                    bl = false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
            if (bl && n == stringArray.length - 3) {
                String string88 = stringArray[n++];
                String string89 = stringArray[n++];
                String string90 = stringArray[n++];
                String string91 = string85 + "/" + string90;
                String string92 = string86 + "/" + string90;
                File file = new File(string91);
                if (!file.exists() && !file.mkdirs()) {
                    throw new IllegalArgumentException(string91 + " does not exist and could not be created!");
                }
                file = new File(string92);
                if (!file.exists() && !file.mkdirs()) {
                    throw new IllegalArgumentException(string92 + " does not exist and could not be created!");
                }
                if (string87 == null) {
                    String string93 = string84 + "/" + CHROMSIZESDIR + "/" + string90 + ".txt";
                    File file5 = new File(string93);
                    if (file5.exists()) {
                        string87 = string93;
                    } else {
                        throw new IllegalArgumentException("chromosome length file not specified and default " + string93 + " not found");
                    }
                }
                ConvertGeneTable.convertGeneTableToAnnotations(string88, string89, string90, string91, string92, string87, n63, bl91);
            } else {
                bl = false;
            }
            if (!bl) {
                System.out.println("usage: ConvertGeneTable [-gzip][-l chromosomelengthfile][-u coorddir][-v anchordir][-w promoterwindow] inputgenetable prefix assembly");
            }
        } else {
            System.out.println("Need to specify the mode BinarizeBam|BinarizeBed|BinarizeSignal|CompareModels|ConvertGeneTable|EvalSubset|LearnModel|MakeBrowserFiles|MakeSegmentation|MergeBinary|NeighborhoodEnrichment|StatePruning|OverlapEnrichment|Reorder|Version");
        }
    }

    class NewThreadWithLoad
    implements Runnable {
        double[][][] gammaksum_nseq;
        double[][] sxi_nseq;
        int numtime_nseq;
        String chromfiles_nseq;
        double[] gammainitstore_nseq;
        double[][][] gammaObservedSum_Pool;
        double[][][] alpha_Pool;
        double[][] gamma_nt_Pool;
        double[][] coltransitionprobs;
        double[][] scale_Pool;
        double[][] beta_nt_Pool;
        double[][] beta_ntp1_Pool;
        double[][] tempproductbetaemiss_Pool;
        int nsparsecutoff;
        int nsparsecutofflooser;
        double[][][] sumforsxi_Pool;
        double[] dloglikeA;
        int nseq;
        int[][] traindataObservedIndex_Pool;
        boolean[][][] traindataObservedValues_Pool;
        boolean[][][] traindataNotMissing_Pool;
        double[][][] emissionproducts_Pool;
        double[][] emissionproducts_scale_Pool;

        NewThreadWithLoad(String string, int[][] nArray, boolean[][][] blArray, boolean[][][] blArray2, double[][][] dArray, double[][] dArray2, int n, double[] dArray3, double[][][] dArray4, double[][][] dArray5, double[][][] dArray6, double[][] dArray7, double[][] dArray8, double[][] dArray9, double[][] dArray10, double[][] dArray11, double[][] dArray12, double[][][] dArray13, int n2, int n3, double[] dArray14, int n4, double[][] dArray15) {
            this.emissionproducts_Pool = dArray6;
            this.emissionproducts_scale_Pool = dArray15;
            this.chromfiles_nseq = string;
            this.traindataObservedIndex_Pool = nArray;
            this.traindataObservedValues_Pool = blArray;
            this.traindataNotMissing_Pool = blArray2;
            this.gammaksum_nseq = dArray;
            this.sxi_nseq = dArray2;
            this.numtime_nseq = n;
            this.gammainitstore_nseq = dArray3;
            this.gammaObservedSum_Pool = dArray4;
            this.alpha_Pool = dArray5;
            this.gamma_nt_Pool = dArray7;
            this.coltransitionprobs = dArray8;
            this.scale_Pool = dArray9;
            this.beta_nt_Pool = dArray10;
            this.beta_ntp1_Pool = dArray11;
            this.tempproductbetaemiss_Pool = dArray12;
            this.nsparsecutoff = n2;
            this.nsparsecutofflooser = n3;
            this.sumforsxi_Pool = dArray13;
            this.dloglikeA = dArray14;
            this.nseq = n4;
        }

        private int slotavailable() {
            for (int i = 0; i < ChromHMM.this.threadslots.length; ++i) {
                if (ChromHMM.this.threadslots[i]) continue;
                ChromHMM.this.threadslots[i] = true;
                return i;
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int n;
            Object object = ChromHMM.this.objlock;
            synchronized (object) {
                while ((n = this.slotavailable()) == -1) {
                    try {
                        ChromHMM.this.objlock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            try {
                this.estep(this.emissionproducts_Pool[n], this.traindataObservedIndex_Pool[n], this.traindataObservedValues_Pool[n], this.traindataNotMissing_Pool[n], this.gammaObservedSum_Pool[n], this.alpha_Pool[n], this.gamma_nt_Pool[n], this.scale_Pool[n], this.beta_nt_Pool[n], this.beta_ntp1_Pool[n], this.tempproductbetaemiss_Pool[n], this.sumforsxi_Pool[n], this.emissionproducts_scale_Pool[n]);
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.out);
            }
            object = ChromHMM.this.objlock;
            synchronized (object) {
                --ChromHMM.this.nlaunched;
                ChromHMM.this.threadslots[n] = false;
                ChromHMM.this.objlock.notifyAll();
            }
        }

        public void estep(double[][] dArray, int[] nArray, boolean[][] blArray, boolean[][] blArray2, double[][] dArray2, double[][] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, double[] dArray7, double[] dArray8, double[][] dArray9, double[] dArray10) throws IOException {
            int n;
            int n2;
            double d;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            Object object;
            Object object2;
            String string;
            HashMap<BigInteger, Integer> hashMap = new HashMap<BigInteger, Integer>();
            int n8 = 0;
            if (BVERBOSE) {
                System.out.println("reading\t" + ChromHMM.this.szinputdir + " " + this.chromfiles_nseq);
            }
            BufferedReader bufferedReader = Util.getBufferedReader(ChromHMM.this.szinputdir + "/" + this.chromfiles_nseq);
            bufferedReader.readLine();
            bufferedReader.readLine();
            ArrayList<String> arrayList = new ArrayList<String>();
            while ((string = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\t ");
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < ChromHMM.this.numdatasets; ++i) {
                    if (!stringTokenizer.hasMoreTokens()) {
                        throw new IllegalArgumentException("Found line without " + ChromHMM.this.numdatasets + " values in file " + this.chromfiles_nseq);
                    }
                    object2 = stringTokenizer.nextToken();
                    if (((String)object2).equals("0")) {
                        stringBuffer.append("0");
                        continue;
                    }
                    if (((String)object2).equals("1")) {
                        stringBuffer.append("1");
                        continue;
                    }
                    if (((String)object2).equals("2")) {
                        stringBuffer.append("2");
                        continue;
                    }
                    throw new IllegalArgumentException("Unrecognized value " + (String)object2 + " found in " + ChromHMM.this.szinputdir + "/" + this.chromfiles_nseq);
                }
                arrayList.add(stringBuffer.toString());
            }
            bufferedReader.close();
            int n9 = arrayList.size();
            for (int i = 0; i < n9; ++i) {
                BigInteger bigInteger = new BigInteger((String)arrayList.get(i), 3);
                object2 = (Integer)hashMap.get(bigInteger);
                if (object2 == null) {
                    hashMap.put(bigInteger, n8);
                    nArray[i] = n8++;
                    continue;
                }
                nArray[i] = (Integer)object2;
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                int n10;
                object2 = (BigInteger)entry.getKey();
                object = ((BigInteger)object2).toString(3);
                int n11 = (Integer)entry.getValue();
                boolean[] blArray3 = blArray[n11];
                boolean[] blArray4 = blArray2[n11];
                n7 = ((String)object).length();
                n6 = ChromHMM.this.numdatasets - n7;
                for (n10 = 0; n10 < n6; ++n10) {
                    blArray3[n10] = false;
                    blArray4[n10] = true;
                }
                n10 = n6;
                for (n5 = 0; n5 < n7; ++n5) {
                    char c = ((String)object).charAt(n5);
                    if (c == '0') {
                        blArray3[n10] = false;
                        blArray4[n10] = true;
                    } else if (c == '1') {
                        blArray3[n10] = true;
                        blArray4[n10] = true;
                    } else {
                        blArray3[n10] = false;
                        blArray4[n10] = false;
                    }
                    ++n10;
                }
            }
            if (ChromHMM.this.bscaleemissions) {
                for (n4 = 0; n4 < n8; ++n4) {
                    int n12;
                    object2 = dArray[n4];
                    object = blArray[n4];
                    boolean[] blArray5 = blArray2[n4];
                    for (n12 = 0; n12 < ChromHMM.this.numstates; ++n12) {
                        object2[n12] = 1.0;
                    }
                    dArray10[n4] = 0.0;
                    for (n12 = 0; n12 < ChromHMM.this.numdatasets; ++n12) {
                        for (int i = 0; i < ChromHMM.this.numstates; ++i) {
                            if (!blArray5[n12]) continue;
                            if (object[n12] != false) {
                                Object object3 = object2;
                                int n13 = i;
                                object3[n13] = object3[n13] * ChromHMM.this.emissionprobs[i][n12][1];
                                continue;
                            }
                            Object object4 = object2;
                            int n14 = i;
                            object4[n14] = object4[n14] * ChromHMM.this.emissionprobs[i][n12][0];
                        }
                        Object object5 = 0.0;
                        for (n6 = 0; n6 < ChromHMM.this.numstates; ++n6) {
                            if (!(object2[n6] > object5)) continue;
                            object5 = object2[n6];
                        }
                        if (object5 <= 0.0) {
                            for (n6 = 0; n6 < ChromHMM.this.numstates; ++n6) {
                                object2[n6] = 1.0;
                            }
                            int n15 = n4;
                            dArray10[n15] = dArray10[n15] + Math.log(EPSILONEMISSIONS);
                            continue;
                        }
                        n6 = 0;
                        while (n6 < ChromHMM.this.numstates) {
                            Object object6 = object2;
                            int n16 = n6++;
                            object6[n16] = object6[n16] / object5;
                        }
                        int n17 = n4;
                        dArray10[n17] = dArray10[n17] + Math.log(object5);
                    }
                }
            } else {
                for (n4 = 0; n4 < n8; ++n4) {
                    int n18;
                    object2 = dArray[n4];
                    object = blArray[n4];
                    boolean[] blArray6 = blArray2[n4];
                    boolean bl = true;
                    for (n18 = 0; n18 < ChromHMM.this.numstates; ++n18) {
                        double d2 = 1.0;
                        double[][] dArray11 = ChromHMM.this.emissionprobs[n18];
                        for (n5 = 0; n5 < ChromHMM.this.numdatasets; ++n5) {
                            if (!blArray6[n5]) continue;
                            if (object[n5] != false) {
                                d2 *= dArray11[n5][1];
                                continue;
                            }
                            d2 *= dArray11[n5][0];
                        }
                        object2[n18] = d2;
                        if (!(d2 >= EPSILONEMISSIONS)) continue;
                        bl = false;
                    }
                    if (!bl) continue;
                    for (n18 = 0; n18 < ChromHMM.this.numstates; ++n18) {
                        object2[n18] = EPSILONEMISSIONS;
                    }
                }
            }
            double d3 = 0.0;
            for (n3 = 0; n3 < this.gammaksum_nseq.length; ++n3) {
                double[][] dArray12 = this.gammaksum_nseq[n3];
                for (int i = 0; i < dArray12.length; ++i) {
                    for (int j = 0; j < ChromHMM.this.numbuckets; ++j) {
                        dArray12[i][j] = 0.0;
                    }
                }
            }
            for (n3 = 0; n3 < this.sxi_nseq.length; ++n3) {
                double[] dArray13 = this.sxi_nseq[n3];
                for (int i = 0; i < dArray13.length; ++i) {
                    dArray13[i] = 0.0;
                }
            }
            for (n3 = 0; n3 < n8; ++n3) {
                double[] dArray14 = dArray2[n3];
                for (int i = 0; i < dArray14.length; ++i) {
                    dArray14[i] = 0.0;
                }
            }
            double[] dArray15 = dArray3[0];
            double d4 = 0.0;
            double[] dArray16 = dArray[nArray[0]];
            for (n7 = 0; n7 < ChromHMM.this.numstates; ++n7) {
                dArray15[n7] = ChromHMM.this.probinit[n7] * dArray16[n7];
                d4 += dArray15[n7];
            }
            dArray5[0] = d4;
            if (ChromHMM.this.bscalebeta) {
                for (n7 = 0; n7 < ChromHMM.this.numstates; ++n7) {
                    int n19 = n7;
                    dArray15[n19] = dArray15[n19] / d4;
                    if (!(dArray15[n7] < EPSILONSTATE) || !(dArray16[n7] > 0.0)) continue;
                    dArray15[n7] = EPSILONSTATE;
                }
            } else {
                n7 = 0;
                while (n7 < ChromHMM.this.numstates) {
                    int n20 = n7++;
                    dArray15[n20] = dArray15[n20] / d4;
                }
            }
            d3 += Math.log(d4);
            if (ChromHMM.this.bscaleemissions) {
                d3 += dArray10[nArray[0]];
            }
            for (n7 = 1; n7 < this.numtime_nseq; ++n7) {
                int n21;
                double[] dArray17 = dArray3[n7 - 1];
                dArray15 = dArray3[n7];
                d4 = 0.0;
                dArray16 = dArray[nArray[n7]];
                for (n21 = 0; n21 < ChromHMM.this.numstates; ++n21) {
                    double d5;
                    int n22;
                    n5 = ChromHMM.this.transitionprobsnumCol[n21];
                    int[] nArray2 = ChromHMM.this.transitionprobsindexCol[n21];
                    double[] dArray18 = this.coltransitionprobs[n21];
                    d = 0.0;
                    if (n5 < this.nsparsecutoff) {
                        for (n22 = 0; n22 < n5; ++n22) {
                            int n23 = nArray2[n22];
                            d += dArray18[n23] * dArray17[n23];
                        }
                    } else {
                        for (n22 = 0; n22 < ChromHMM.this.numstates; ++n22) {
                            d += dArray18[n22] * dArray17[n22];
                        }
                    }
                    dArray15[n21] = d5 = d * dArray16[n21];
                    d4 += d5;
                }
                dArray5[n7] = d4;
                if (ChromHMM.this.bscalebeta) {
                    for (n21 = 0; n21 < ChromHMM.this.numstates; ++n21) {
                        int n24 = n21;
                        dArray15[n24] = dArray15[n24] / d4;
                        if (!(dArray15[n21] < EPSILONSTATE) || !(dArray16[n21] > 0.0)) continue;
                        dArray15[n21] = EPSILONSTATE;
                    }
                } else {
                    n21 = 0;
                    while (n21 < ChromHMM.this.numstates) {
                        int n25 = n21++;
                        dArray15[n25] = dArray15[n25] / d4;
                    }
                }
                d3 += Math.log(d4);
                if (!ChromHMM.this.bscaleemissions) continue;
                d3 += dArray10[nArray[n7]];
            }
            n7 = this.numtime_nseq - 1;
            double d6 = ChromHMM.this.bscalebeta ? 1.0 / (double)ChromHMM.this.numstates : 1.0 / dArray5[n7];
            for (n5 = 0; n5 < ChromHMM.this.numstates; ++n5) {
                dArray7[n5] = d6;
            }
            double d7 = 0.0;
            dArray15 = dArray3[n7];
            for (n2 = 0; n2 < dArray4.length; ++n2) {
                d = dArray15[n2] * dArray7[n2];
                d7 += d;
                dArray4[n2] = d;
            }
            n2 = 0;
            while (n2 < dArray4.length) {
                int n26 = n2++;
                dArray4[n26] = dArray4[n26] / d7;
            }
            double[] dArray19 = dArray2[nArray[n7]];
            for (n = 0; n < ChromHMM.this.numstates; ++n) {
                int n27 = n;
                dArray19[n27] = dArray19[n27] + dArray4[n];
            }
            for (n = n7 - 1; n >= 0; --n) {
                int n28;
                Object[] objectArray;
                Object[] objectArray2;
                double d8;
                int n29;
                int n30 = n + 1;
                double[] dArray20 = dArray[nArray[n30]];
                for (int i = 0; i < ChromHMM.this.numstates; ++i) {
                    dArray8[i] = dArray7[i] * dArray20[i];
                }
                double d9 = 0.0;
                double d10 = dArray5[n];
                for (n29 = 0; n29 < ChromHMM.this.numstates; ++n29) {
                    int n31;
                    d8 = 0.0;
                    objectArray2 = ChromHMM.this.transitionprobsindex[n29];
                    objectArray = ChromHMM.this.transitionprobs[n29];
                    int n32 = ChromHMM.this.transitionprobsnum[n29];
                    if (n32 < this.nsparsecutoff) {
                        for (n31 = 0; n31 < n32; ++n31) {
                            int n33 = objectArray2[n31];
                            d8 += objectArray[n33] * dArray8[n33];
                        }
                    } else {
                        for (n31 = 0; n31 < ChromHMM.this.numstates; ++n31) {
                            d8 += objectArray[n31] * dArray8[n31];
                        }
                    }
                    if (ChromHMM.this.bscalebeta) {
                        dArray6[n29] = d8;
                        d9 += d8;
                        continue;
                    }
                    double d11 = d8 / d10;
                    dArray6[n29] = d11 > Double.MAX_VALUE ? Double.MAX_VALUE : d11;
                }
                if (ChromHMM.this.bscalebeta) {
                    for (n29 = 0; n29 < ChromHMM.this.numstates; ++n29) {
                        int n34 = n29;
                        dArray6[n34] = dArray6[n34] / d9;
                        if (!(dArray6[n29] < EPSILONSTATE)) continue;
                        dArray6[n29] = EPSILONSTATE;
                    }
                }
                d7 = 0.0;
                dArray15 = dArray3[n];
                for (n29 = 0; n29 < dArray4.length; ++n29) {
                    d8 = dArray15[n29] * dArray6[n29];
                    d7 += d8;
                    dArray4[n29] = d8;
                }
                n29 = 0;
                while (n29 < dArray4.length) {
                    int n35 = n29++;
                    dArray4[n35] = dArray4[n35] / d7;
                }
                dArray19 = dArray2[nArray[n]];
                for (n29 = 0; n29 < ChromHMM.this.numstates; ++n29) {
                    int n36 = n29;
                    dArray19[n36] = dArray19[n36] + dArray4[n29];
                }
                double d12 = 0.0;
                for (n28 = 0; n28 < ChromHMM.this.numstates; ++n28) {
                    int n37;
                    objectArray2 = dArray9[n28];
                    objectArray = ChromHMM.this.transitionprobsindex[n28];
                    double[] dArray21 = ChromHMM.this.transitionprobs[n28];
                    int n38 = ChromHMM.this.transitionprobsnum[n28];
                    double d13 = dArray15[n28];
                    if (n38 < this.nsparsecutofflooser) {
                        for (n37 = 0; n37 < n38; ++n37) {
                            double d14 = objectArray[n37];
                            double d15 = dArray21[d14] * d13 * dArray8[d14];
                            d12 += d15;
                            objectArray2[d14] = (int)d15;
                        }
                        continue;
                    }
                    for (n37 = 0; n37 < ChromHMM.this.numstates; ++n37) {
                        double d16 = dArray21[n37] * d13 * dArray8[n37];
                        d12 += d16;
                        objectArray2[n37] = (int)d16;
                    }
                }
                for (n28 = 0; n28 < ChromHMM.this.numstates; ++n28) {
                    int n39;
                    objectArray2 = ChromHMM.this.transitionprobsindex[n28];
                    objectArray = dArray9[n28];
                    double[] dArray22 = this.sxi_nseq[n28];
                    int n40 = ChromHMM.this.transitionprobsnum[n28];
                    if (n40 < this.nsparsecutoff) {
                        for (n39 = 0; n39 < n40; ++n39) {
                            int n41;
                            int n42 = n41 = objectArray2[n39];
                            dArray22[n42] = dArray22[n42] + objectArray[n41] / d12;
                        }
                        continue;
                    }
                    for (n39 = 0; n39 < ChromHMM.this.numstates; ++n39) {
                        int n43 = n39;
                        dArray22[n43] = dArray22[n43] + objectArray[n39] / d12;
                    }
                }
                dArray7 = dArray6;
            }
            for (n = 0; n < ChromHMM.this.numstates; ++n) {
                this.gammainitstore_nseq[n] = dArray4[n];
            }
            for (n = 0; n < n8; ++n) {
                boolean[] blArray7 = blArray[n];
                boolean[] blArray8 = blArray2[n];
                double[] dArray23 = dArray2[n];
                for (int i = 0; i < ChromHMM.this.numstates; ++i) {
                    double[][] dArray24 = this.gammaksum_nseq[i];
                    double d17 = dArray23[i];
                    for (int j = 0; j < ChromHMM.this.numdatasets; ++j) {
                        if (!blArray8[j]) continue;
                        if (blArray7[j]) {
                            double[] dArray25 = dArray24[j];
                            dArray25[1] = dArray25[1] + d17;
                            continue;
                        }
                        double[] dArray26 = dArray24[j];
                        dArray26[0] = dArray26[0] + d17;
                    }
                }
            }
            this.dloglikeA[this.nseq] = d3;
        }
    }

    class NewThread
    implements Runnable {
        int[] traindataObservedIndex_nseq;
        boolean[] traindataObservedSeqFlags_nseq;
        double[][][] gammaksum_nseq;
        double[][] sxi_nseq;
        int numtime_nseq;
        double[] gammainitstore_nseq;
        double[][][] gammaObservedSum_Pool;
        double[][][] alpha_Pool;
        double[][] emissionproducts;
        double[][] gamma_nt_Pool;
        double[][] coltransitionprobs;
        double[][] scale_Pool;
        double[][] beta_nt_Pool;
        double[][] beta_ntp1_Pool;
        double[][] tempproductbetaemiss_Pool;
        int nsparsecutoff;
        int nsparsecutofflooser;
        double[][][] sumforsxi_Pool;
        double[] dloglikeA;
        int nseq;
        double[] emissionproducts_scale;

        NewThread(int[] nArray, boolean[] blArray, double[][][] dArray, double[][] dArray2, int n, double[] dArray3, double[][][] dArray4, double[][][] dArray5, double[][] dArray6, double[][] dArray7, double[][] dArray8, double[][] dArray9, double[][] dArray10, double[][] dArray11, double[][] dArray12, double[][][] dArray13, int n2, int n3, double[] dArray14, int n4, double[] dArray15) {
            this.traindataObservedIndex_nseq = nArray;
            this.traindataObservedSeqFlags_nseq = blArray;
            this.gammaksum_nseq = dArray;
            this.sxi_nseq = dArray2;
            this.numtime_nseq = n;
            this.gammainitstore_nseq = dArray3;
            this.gammaObservedSum_Pool = dArray4;
            this.alpha_Pool = dArray5;
            this.emissionproducts = dArray6;
            this.gamma_nt_Pool = dArray7;
            this.coltransitionprobs = dArray8;
            this.scale_Pool = dArray9;
            this.beta_nt_Pool = dArray10;
            this.beta_ntp1_Pool = dArray11;
            this.tempproductbetaemiss_Pool = dArray12;
            this.nsparsecutoff = n2;
            this.nsparsecutofflooser = n3;
            this.sumforsxi_Pool = dArray13;
            this.dloglikeA = dArray14;
            this.nseq = n4;
            this.emissionproducts_scale = dArray15;
        }

        private int slotavailable() {
            for (int i = 0; i < ChromHMM.this.threadslots.length; ++i) {
                if (ChromHMM.this.threadslots[i]) continue;
                ChromHMM.this.threadslots[i] = true;
                return i;
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int n;
            Object object = ChromHMM.this.objlock;
            synchronized (object) {
                while ((n = this.slotavailable()) == -1) {
                    try {
                        ChromHMM.this.objlock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.estep(this.gammaObservedSum_Pool[n], this.alpha_Pool[n], this.gamma_nt_Pool[n], this.scale_Pool[n], this.beta_nt_Pool[n], this.beta_ntp1_Pool[n], this.tempproductbetaemiss_Pool[n], this.sumforsxi_Pool[n]);
            object = ChromHMM.this.objlock;
            synchronized (object) {
                --ChromHMM.this.nlaunched;
                ChromHMM.this.threadslots[n] = false;
                ChromHMM.this.objlock.notifyAll();
            }
        }

        public void estep(double[][] dArray, double[][] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, double[] dArray7, double[][] dArray8) {
            int n;
            int n2;
            double d;
            int n3;
            int n4;
            int n5;
            Object object;
            int n6;
            double d2 = 0.0;
            for (n6 = 0; n6 < this.gammaksum_nseq.length; ++n6) {
                object = this.gammaksum_nseq[n6];
                for (n5 = 0; n5 < ((double[][])object).length; ++n5) {
                    for (int i = 0; i < ChromHMM.this.numbuckets; ++i) {
                        object[n5][i] = 0.0;
                    }
                }
            }
            for (n6 = 0; n6 < this.sxi_nseq.length; ++n6) {
                object = this.sxi_nseq[n6];
                for (n5 = 0; n5 < ((double[][])object).length; ++n5) {
                    object[n5] = (double[])0.0;
                }
            }
            for (n6 = 0; n6 < dArray.length; ++n6) {
                object = dArray[n6];
                for (n5 = 0; n5 < ((double[][])object).length; ++n5) {
                    object[n5] = (double[])0.0;
                }
            }
            double[] dArray9 = dArray2[0];
            double d3 = 0.0;
            double[] dArray10 = this.emissionproducts[this.traindataObservedIndex_nseq[0]];
            for (n4 = 0; n4 < ChromHMM.this.numstates; ++n4) {
                dArray9[n4] = ChromHMM.this.probinit[n4] * dArray10[n4];
                d3 += dArray9[n4];
            }
            dArray4[0] = d3;
            if (ChromHMM.this.bscalebeta) {
                for (n4 = 0; n4 < ChromHMM.this.numstates; ++n4) {
                    int n7 = n4;
                    dArray9[n7] = dArray9[n7] / d3;
                    if (!(dArray9[n4] < EPSILONSTATE) || !(dArray10[n4] > 0.0)) continue;
                    dArray9[n4] = EPSILONSTATE;
                }
            } else {
                n4 = 0;
                while (n4 < ChromHMM.this.numstates) {
                    int n8 = n4++;
                    dArray9[n8] = dArray9[n8] / d3;
                }
            }
            d2 += Math.log(d3);
            if (ChromHMM.this.bscaleemissions) {
                d2 += this.emissionproducts_scale[this.traindataObservedIndex_nseq[0]];
            }
            for (n4 = 1; n4 < this.numtime_nseq; ++n4) {
                int n9;
                double[] dArray11 = dArray2[n4 - 1];
                dArray9 = dArray2[n4];
                d3 = 0.0;
                dArray10 = this.emissionproducts[this.traindataObservedIndex_nseq[n4]];
                for (n9 = 0; n9 < ChromHMM.this.numstates; ++n9) {
                    double d4;
                    int n10;
                    n3 = ChromHMM.this.transitionprobsnumCol[n9];
                    int[] nArray = ChromHMM.this.transitionprobsindexCol[n9];
                    double[] dArray12 = this.coltransitionprobs[n9];
                    d = 0.0;
                    if (n3 < this.nsparsecutoff) {
                        for (n10 = 0; n10 < n3; ++n10) {
                            int n11 = nArray[n10];
                            d += dArray12[n11] * dArray11[n11];
                        }
                    } else {
                        for (n10 = 0; n10 < ChromHMM.this.numstates; ++n10) {
                            d += dArray12[n10] * dArray11[n10];
                        }
                    }
                    dArray9[n9] = d4 = d * dArray10[n9];
                    d3 += d4;
                }
                dArray4[n4] = d3;
                if (ChromHMM.this.bscalebeta) {
                    for (n9 = 0; n9 < ChromHMM.this.numstates; ++n9) {
                        int n12 = n9;
                        dArray9[n12] = dArray9[n12] / d3;
                        if (!(dArray9[n9] < EPSILONSTATE) || !(dArray10[n9] > 0.0)) continue;
                        dArray9[n9] = EPSILONSTATE;
                    }
                } else {
                    n9 = 0;
                    while (n9 < ChromHMM.this.numstates) {
                        int n13 = n9++;
                        dArray9[n13] = dArray9[n13] / d3;
                    }
                }
                d2 += Math.log(d3);
                if (!ChromHMM.this.bscaleemissions) continue;
                d2 += this.emissionproducts_scale[this.traindataObservedIndex_nseq[n4]];
            }
            n4 = this.numtime_nseq - 1;
            double d5 = ChromHMM.this.bscalebeta ? 1.0 / (double)ChromHMM.this.numstates : 1.0 / dArray4[n4];
            for (n3 = 0; n3 < ChromHMM.this.numstates; ++n3) {
                dArray6[n3] = d5;
            }
            double d6 = 0.0;
            dArray9 = dArray2[n4];
            for (n2 = 0; n2 < dArray3.length; ++n2) {
                d = dArray9[n2] * dArray6[n2];
                d6 += d;
                dArray3[n2] = d;
            }
            n2 = 0;
            while (n2 < dArray3.length) {
                int n14 = n2++;
                dArray3[n14] = dArray3[n14] / d6;
            }
            double[] dArray13 = dArray[this.traindataObservedIndex_nseq[n4]];
            for (n = 0; n < ChromHMM.this.numstates; ++n) {
                int n15 = n;
                dArray13[n15] = dArray13[n15] + dArray3[n];
            }
            for (n = n4 - 1; n >= 0; --n) {
                int n16;
                Object[] objectArray;
                Object[] objectArray2;
                double d7;
                int n17;
                int n18 = n + 1;
                double[] dArray14 = this.emissionproducts[this.traindataObservedIndex_nseq[n18]];
                for (int i = 0; i < ChromHMM.this.numstates; ++i) {
                    dArray7[i] = dArray6[i] * dArray14[i];
                }
                double d8 = 0.0;
                double d9 = dArray4[n];
                for (n17 = 0; n17 < ChromHMM.this.numstates; ++n17) {
                    int n19;
                    d7 = 0.0;
                    objectArray2 = ChromHMM.this.transitionprobsindex[n17];
                    objectArray = ChromHMM.this.transitionprobs[n17];
                    int n20 = ChromHMM.this.transitionprobsnum[n17];
                    if (n20 < this.nsparsecutoff) {
                        for (n19 = 0; n19 < n20; ++n19) {
                            int n21 = objectArray2[n19];
                            d7 += objectArray[n21] * dArray7[n21];
                        }
                    } else {
                        for (n19 = 0; n19 < ChromHMM.this.numstates; ++n19) {
                            d7 += objectArray[n19] * dArray7[n19];
                        }
                    }
                    if (ChromHMM.this.bscalebeta) {
                        dArray5[n17] = d7;
                        d8 += d7;
                        continue;
                    }
                    double d10 = d7 / d9;
                    dArray5[n17] = d10 > Double.MAX_VALUE ? Double.MAX_VALUE : d10;
                }
                if (ChromHMM.this.bscalebeta) {
                    for (n17 = 0; n17 < ChromHMM.this.numstates; ++n17) {
                        int n22 = n17;
                        dArray5[n22] = dArray5[n22] / d8;
                        if (!(dArray5[n17] < EPSILONSTATE)) continue;
                        dArray5[n17] = EPSILONSTATE;
                    }
                }
                d6 = 0.0;
                dArray9 = dArray2[n];
                for (n17 = 0; n17 < dArray3.length; ++n17) {
                    d7 = dArray9[n17] * dArray5[n17];
                    d6 += d7;
                    dArray3[n17] = d7;
                }
                n17 = 0;
                while (n17 < dArray3.length) {
                    int n23 = n17++;
                    dArray3[n23] = dArray3[n23] / d6;
                }
                dArray13 = dArray[this.traindataObservedIndex_nseq[n]];
                for (n17 = 0; n17 < ChromHMM.this.numstates; ++n17) {
                    int n24 = n17;
                    dArray13[n24] = dArray13[n24] + dArray3[n17];
                }
                double d11 = 0.0;
                for (n16 = 0; n16 < ChromHMM.this.numstates; ++n16) {
                    int n25;
                    objectArray2 = dArray8[n16];
                    objectArray = ChromHMM.this.transitionprobsindex[n16];
                    double[] dArray15 = ChromHMM.this.transitionprobs[n16];
                    int n26 = ChromHMM.this.transitionprobsnum[n16];
                    double d12 = dArray9[n16];
                    if (n26 < this.nsparsecutofflooser) {
                        for (n25 = 0; n25 < n26; ++n25) {
                            double d13 = objectArray[n25];
                            double d14 = dArray15[d13] * d12 * dArray7[d13];
                            d11 += d14;
                            objectArray2[d13] = (int)d14;
                        }
                        continue;
                    }
                    for (n25 = 0; n25 < ChromHMM.this.numstates; ++n25) {
                        double d15 = dArray15[n25] * d12 * dArray7[n25];
                        d11 += d15;
                        objectArray2[n25] = (int)d15;
                    }
                }
                for (n16 = 0; n16 < ChromHMM.this.numstates; ++n16) {
                    int n27;
                    objectArray2 = ChromHMM.this.transitionprobsindex[n16];
                    objectArray = dArray8[n16];
                    double[] dArray16 = this.sxi_nseq[n16];
                    int n28 = ChromHMM.this.transitionprobsnum[n16];
                    if (n28 < this.nsparsecutoff) {
                        for (n27 = 0; n27 < n28; ++n27) {
                            int n29;
                            int n30 = n29 = objectArray2[n27];
                            dArray16[n30] = dArray16[n30] + objectArray[n29] / d11;
                        }
                        continue;
                    }
                    for (n27 = 0; n27 < ChromHMM.this.numstates; ++n27) {
                        int n31 = n27;
                        dArray16[n31] = dArray16[n31] + objectArray[n27] / d11;
                    }
                }
                dArray6 = dArray5;
            }
            for (n = 0; n < ChromHMM.this.numstates; ++n) {
                this.gammainitstore_nseq[n] = dArray3[n];
            }
            for (n = 0; n < dArray.length; ++n) {
                if (!this.traindataObservedSeqFlags_nseq[n]) continue;
                boolean[] blArray = ChromHMM.this.traindataObservedValues[n];
                boolean[] blArray2 = ChromHMM.this.traindataNotMissing[n];
                double[] dArray17 = dArray[n];
                for (int i = 0; i < ChromHMM.this.numstates; ++i) {
                    double[][] dArray18 = this.gammaksum_nseq[i];
                    double d16 = dArray17[i];
                    for (int j = 0; j < ChromHMM.this.numdatasets; ++j) {
                        if (!blArray2[j]) continue;
                        if (blArray[j]) {
                            double[] dArray19 = dArray18[j];
                            dArray19[1] = dArray19[1] + d16;
                            continue;
                        }
                        double[] dArray20 = dArray18[j];
                        dArray20[0] = dArray20[0] + d16;
                    }
                }
            }
            this.dloglikeA[this.nseq] = d2;
        }
    }

    public static class RecIntStringSplitCompare
    implements Comparator,
    Serializable {
        public int compare(Object object, Object object2) {
            RecIntStringSplit recIntStringSplit = (RecIntStringSplit)object;
            RecIntStringSplit recIntStringSplit2 = (RecIntStringSplit)object2;
            if (recIntStringSplit.szcell.equals(recIntStringSplit2.szcell)) {
                if (recIntStringSplit.szchrom.equals(recIntStringSplit2.szchrom)) {
                    if (recIntStringSplit.nsplitbinindex < recIntStringSplit2.nsplitbinindex) {
                        return -1;
                    }
                    if (recIntStringSplit.nsplitbinindex > recIntStringSplit2.nsplitbinindex) {
                        return 1;
                    }
                    return 0;
                }
                return (recIntStringSplit.szchrom + "_").compareTo(recIntStringSplit2.szchrom + "_");
            }
            return (recIntStringSplit.szcell + "_").compareTo(recIntStringSplit2.szcell + "_");
        }
    }

    static class RecIntStringSplit {
        int nindex;
        String szcell;
        String szchrom;
        int nsplitbinindex;

        RecIntStringSplit(int n, String string, String string2, int n2) {
            this.nindex = n;
            this.szcell = string;
            this.szchrom = string2;
            this.nsplitbinindex = n2;
        }
    }

    public static class RecIntStringCompare
    implements Comparator,
    Serializable {
        public int compare(Object object, Object object2) {
            RecIntString recIntString = (RecIntString)object;
            RecIntString recIntString2 = (RecIntString)object2;
            return recIntString.sz.compareTo(recIntString2.sz);
        }
    }

    static class RecIntString {
        int nindex;
        String sz;

        RecIntString(int n, String string) {
            this.nindex = n;
            this.sz = string;
        }
    }

    public static class RecIntDoubleCompare
    implements Comparator,
    Serializable {
        public int compare(Object object, Object object2) {
            RecIntDouble recIntDouble = (RecIntDouble)object;
            RecIntDouble recIntDouble2 = (RecIntDouble)object2;
            if (recIntDouble.dval < recIntDouble2.dval) {
                return -1;
            }
            if (recIntDouble.dval > recIntDouble2.dval) {
                return 1;
            }
            return 0;
        }
    }

    static class RecIntDouble {
        int nindex;
        double dval;

        RecIntDouble(int n, double d) {
            this.nindex = n;
            this.dval = d;
        }
    }

    static class ObservedRec {
        int nobserved;
        boolean[] flagA;

        ObservedRec(int n, boolean[] blArray) {
            this.nobserved = n;
            this.flagA = blArray;
        }
    }
}

