/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.labs.mosaic.sql;

import com.databricks.labs.mosaic.functions.MosaicContext;
import com.databricks.labs.mosaic.functions.MosaicContext$;
import com.databricks.labs.mosaic.sql.MosaicAnalyzer$;
import com.databricks.labs.mosaic.sql.MosaicFrame;
import com.databricks.labs.mosaic.sql.MosaicSQLExceptions$;
import com.databricks.labs.mosaic.sql.SampleStrategy;
import com.databricks.labs.mosaic.sql.SampleStrategy$;
import java.io.Serializable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001Q4A!\u0004\b\u00013!A\u0001\u0005\u0001B\u0001B\u0003%\u0011\u0005C\u0003&\u0001\u0011\u0005a\u0005C\u0004*\u0001\t\u0007I\u0011\u0001\u0016\t\r9\u0002\u0001\u0015!\u0003,\u0011\u0015y\u0003\u0001\"\u00011\u0011\u0015y\u0003\u0001\"\u00017\u0011\u0015a\u0004\u0001\"\u0001>\u0011\u001da\u0006!%A\u0005\u0002uCq\u0001\u001b\u0001\u0012\u0002\u0013\u0005\u0011\u000eC\u0004l\u0001E\u0005I\u0011A5\t\u000b1\u0004A\u0011B7\t\u000b=\u0002A\u0011A9\u0003\u001d5{7/Y5d\u0003:\fG.\u001f>fe*\u0011q\u0002E\u0001\u0004gFd'BA\t\u0013\u0003\u0019iwn]1jG*\u00111\u0003F\u0001\u0005Y\u0006\u00147O\u0003\u0002\u0016-\u0005QA-\u0019;bEJL7m[:\u000b\u0003]\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\u000e\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\r\u0005s\u0017PU3g\u0003M\tg.\u00197zu\u0016\u0014Xj\\:bS\u000e4%/Y7f!\t\u00113%D\u0001\u000f\u0013\t!cBA\u0006N_N\f\u0017n\u0019$sC6,\u0017A\u0002\u001fj]&$h\b\u0006\u0002(QA\u0011!\u0005\u0001\u0005\u0006A\t\u0001\r!I\u0001\u0016I\u00164\u0017-\u001e7u'\u0006l\u0007\u000f\\3Ge\u0006\u001cG/[8o+\u0005Y\u0003CA\u000e-\u0013\tiCD\u0001\u0004E_V\u0014G.Z\u0001\u0017I\u00164\u0017-\u001e7u'\u0006l\u0007\u000f\\3Ge\u0006\u001cG/[8oA\u0005!r-\u001a;PaRLW.\u00197SKN|G.\u001e;j_:$\"!\r\u001b\u0011\u0005m\u0011\u0014BA\u001a\u001d\u0005\rIe\u000e\u001e\u0005\u0006k\u0015\u0001\raK\u0001\u000fg\u0006l\u0007\u000f\\3Ge\u0006\u001cG/[8o)\t\tt\u0007C\u00039\r\u0001\u0007\u0011(\u0001\btC6\u0004H.Z*ue\u0006$XmZ=\u0011\u0005\tR\u0014BA\u001e\u000f\u00059\u0019\u0016-\u001c9mKN#(/\u0019;fOf\fAcZ3u%\u0016\u001cx\u000e\\;uS>tW*\u001a;sS\u000e\u001cH\u0003\u0002 X1j\u0003\"a\u0010+\u000f\u0005\u0001\u000bfBA!P\u001d\t\u0011EJ\u0004\u0002D\u0013:\u0011AiR\u0007\u0002\u000b*\u0011a\tG\u0001\u0007yI|w\u000e\u001e \n\u0003!\u000b1a\u001c:h\u0013\tQ5*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0011&\u0011QJT\u0001\u0006gB\f'o\u001b\u0006\u0003\u0015.K!a\u0004)\u000b\u00055s\u0015B\u0001*T\u0003\u001d\u0001\u0018mY6bO\u0016T!a\u0004)\n\u0005U3&!\u0003#bi\u00064%/Y7f\u0015\t\u00116\u000bC\u00049\u000fA\u0005\t\u0019A\u001d\t\u000fe;\u0001\u0013!a\u0001c\u0005QAn\\<fe2KW.\u001b;\t\u000fm;\u0001\u0013!a\u0001c\u0005QQ\u000f\u001d9fe2KW.\u001b;\u0002=\u001d,GOU3t_2,H/[8o\u001b\u0016$(/[2tI\u0011,g-Y;mi\u0012\nT#\u00010+\u0005ez6&\u00011\u0011\u0005\u00054W\"\u00012\u000b\u0005\r$\u0017!C;oG\",7m[3e\u0015\t)G$\u0001\u0006b]:|G/\u0019;j_:L!a\u001a2\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0010hKR\u0014Vm]8mkRLwN\\'fiJL7m\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\t!N\u000b\u00022?\u0006qr-\u001a;SKN|G.\u001e;j_:lU\r\u001e:jGN$C-\u001a4bk2$HeM\u0001\u0011O\u0016$X*Z1o\u0013:$W\r_!sK\u0006$2a\u000b8p\u0011\u0015A4\u00021\u0001:\u0011\u0015\u00018\u00021\u00012\u0003)\u0011Xm]8mkRLwN\u001c\u000b\u0003cIDQa\u001d\u0007A\u0002E\n!b]1na2,'k\\<t\u0001")
public class MosaicAnalyzer {
    private final MosaicFrame analyzerMosaicFrame;
    private final double defaultSampleFraction;

    public double defaultSampleFraction() {
        return this.defaultSampleFraction;
    }

    public int getOptimalResolution(double sampleFraction) {
        return this.getOptimalResolution(new SampleStrategy((Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)sampleFraction)), SampleStrategy$.MODULE$.apply$default$2()));
    }

    public int getOptimalResolution(SampleStrategy sampleStrategy) {
        SparkSession ss = SparkSession$.MODULE$.builder().getOrCreate();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MosaicAnalyzer.class.getClassLoader());
        public final class Com_databricks_labs_mosaic_sql_MosaicAnalyzer$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Com_databricks_labs_mosaic_sql_MosaicAnalyzer$$typecreator5$1(MosaicAnalyzer $outer) {
            }
        }
        Tuple2[] metrics = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getResolutionMetrics(sampleStrategy, 1, 100).select("resolution", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"percentile_50_geometry_area"})).as(ss.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Com_databricks_labs_mosaic_sql_MosaicAnalyzer$$typecreator5$1(null)))).collect())).sortBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)x$1._2$mcD$sp()), (Ordering)Ordering.Double$.MODULE$);
        int midInd = (metrics.length - 1) / 2;
        return metrics[midInd]._1$mcI$sp();
    }

    public Dataset<Row> getResolutionMetrics(SampleStrategy sampleStrategy, int lowerLimit, int upperLimit) {
        MosaicContext mosaicContext = MosaicContext$.MODULE$.context();
        SparkSession spark = SparkSession$.MODULE$.builder().getOrCreate();
        Row percentiles = (Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.analyzerMosaicFrame.transform((Function1 & Serializable & scala.Serializable)df -> sampleStrategy.transformer((Dataset<Row>)df)).withColumn("area", mosaicContext.functions().st_area(this.analyzerMosaicFrame.getGeometryColumn())).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.mean("area").alias("mean"), MosaicAnalyzer.areaPercentile$1(0.25).alias("p25"), MosaicAnalyzer.areaPercentile$1(0.5).alias("p50"), MosaicAnalyzer.areaPercentile$1(0.75).alias("p75")})).collect())).head();
        Set meanIndexAreas = (Set)mosaicContext.getIndexSystem().resolutions().map((Function1 & Serializable & scala.Serializable)i -> MosaicAnalyzer.$anonfun$getResolutionMetrics$2(this, sampleStrategy, BoxesRunTime.unboxToInt((Object)i)), Set$.MODULE$.canBuildFrom());
        if (percentiles.anyNull()) {
            throw MosaicSQLExceptions$.MODULE$.NotEnoughGeometriesException();
        }
        List indexAreaRows = ((TraversableOnce)meanIndexAreas.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int resolution = tuple2._1$mcI$sp();
            double indexArea = tuple2._2$mcD$sp();
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)resolution), BoxesRunTime.boxToDouble((double)indexArea), BoxesRunTime.boxToDouble((double)(percentiles.getDouble(0) / indexArea)), BoxesRunTime.boxToDouble((double)(percentiles.getDouble(1) / indexArea)), BoxesRunTime.boxToDouble((double)(percentiles.getDouble(2) / indexArea)), BoxesRunTime.boxToDouble((double)(percentiles.getDouble(3) / indexArea))}));
            return row;
        }, Set$.MODULE$.canBuildFrom())).toList();
        StructType indexAreaSchema = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("resolution", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("mean_index_area", (DataType)DoubleType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("mean_geometry_area", (DataType)DoubleType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("percentile_25_geometry_area", (DataType)DoubleType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("percentile_50_geometry_area", (DataType)DoubleType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("percentile_75_geometry_area", (DataType)DoubleType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))))));
        return spark.createDataFrame(spark.sparkContext().parallelize((Seq)indexAreaRows, spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(Row.class)), indexAreaSchema).where(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(354).append("\n                 |(").append(lowerLimit).append(" < mean_geometry_area and mean_geometry_area < ").append(upperLimit).append(") or\n                 |(").append(lowerLimit).append(" < percentile_25_geometry_area and percentile_25_geometry_area < ").append(upperLimit).append(") or\n                 |(").append(lowerLimit).append(" < percentile_50_geometry_area and percentile_50_geometry_area < ").append(upperLimit).append(") or\n                 |(").append(lowerLimit).append(" < percentile_75_geometry_area and percentile_75_geometry_area < ").append(upperLimit).append(")\n                 |").toString())).stripMargin());
    }

    public SampleStrategy getResolutionMetrics$default$1() {
        return new SampleStrategy(SampleStrategy$.MODULE$.apply$default$1(), SampleStrategy$.MODULE$.apply$default$2());
    }

    public int getResolutionMetrics$default$2() {
        return 5;
    }

    public int getResolutionMetrics$default$3() {
        return 500;
    }

    private double getMeanIndexArea(SampleStrategy sampleStrategy, int resolution) {
        double result;
        MosaicContext mosaicContext = MosaicContext$.MODULE$.context();
        SparkSession spark = SparkSession$.MODULE$.builder().getOrCreate();
        Dataset meanIndexAreaDf = this.analyzerMosaicFrame.transform((Function1 & Serializable & scala.Serializable)df -> sampleStrategy.transformer((Dataset<Row>)df)).withColumn("centroid", mosaicContext.functions().st_centroid2D(this.analyzerMosaicFrame.getGeometryColumn())).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.mean(mosaicContext.functions().st_area(mosaicContext.functions().index_geometry(mosaicContext.functions().point_index_lonlat(functions$.MODULE$.col("centroid").getItem((Object)"x"), functions$.MODULE$.col("centroid").getItem((Object)"y"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)resolution))))))}));
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])meanIndexAreaDf.as(spark.implicits().newDoubleEncoder()).collect())).head()));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                throw MosaicSQLExceptions$.MODULE$.NotEnoughGeometriesException();
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        double d = result = BoxesRunTime.unboxToDouble((Object)success.value());
        return d;
    }

    public int getOptimalResolution(int sampleRows) {
        Some x$1 = new Some((Object)BoxesRunTime.boxToInteger((int)sampleRows));
        Option<Object> x$2 = SampleStrategy$.MODULE$.apply$default$1();
        return this.getOptimalResolution(new SampleStrategy(x$2, (Option<Object>)x$1));
    }

    private static final Column areaPercentile$1(double p) {
        return functions$.MODULE$.percentile_approx(functions$.MODULE$.col("area"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)p)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)10000)));
    }

    public static final /* synthetic */ Tuple2 $anonfun$getResolutionMetrics$2(MosaicAnalyzer $this, SampleStrategy sampleStrategy$1, int i) {
        return new Tuple2.mcID.sp(i, $this.getMeanIndexArea(sampleStrategy$1, i));
    }

    public MosaicAnalyzer(MosaicFrame analyzerMosaicFrame) {
        this.analyzerMosaicFrame = analyzerMosaicFrame;
        this.defaultSampleFraction = 0.01;
    }
}

