/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.labs.mosaic.expressions.index;

import com.databricks.labs.mosaic.core.geometry.MosaicGeometry;
import com.databricks.labs.mosaic.core.geometry.api.GeometryAPI;
import com.databricks.labs.mosaic.core.geometry.api.GeometryAPI$;
import com.databricks.labs.mosaic.core.geometry.point.MosaicPoint;
import com.databricks.labs.mosaic.core.index.IndexSystem;
import com.databricks.labs.mosaic.core.index.IndexSystemID$;
import com.databricks.labs.mosaic.core.types.model.GeometryTypeEnum$;
import com.databricks.labs.mosaic.expressions.index.PointIndexGeom$;
import com.databricks.labs.mosaic.sql.MosaicSQLExceptions$;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionInfo;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t-a\u0001\u0002\u0013&\u0001JB\u0001b\u001a\u0001\u0003\u0016\u0004%\t\u0001\u001b\u0005\tY\u0002\u0011\t\u0012)A\u0005S\"AQ\u000e\u0001BK\u0002\u0013\u0005\u0001\u000e\u0003\u0005o\u0001\tE\t\u0015!\u0003j\u0011!y\u0007A!f\u0001\n\u0003\u0001\b\u0002C=\u0001\u0005#\u0005\u000b\u0011B9\t\u0011i\u0004!Q3A\u0005\u0002AD\u0001b\u001f\u0001\u0003\u0012\u0003\u0006I!\u001d\u0005\u0006y\u0002!\t! \u0005\b\u0003\u0013\u0001A\u0011IA\u0006\u0011\u0019\tI\u0002\u0001C!a\"9\u00111\u0004\u0001\u0005B\u0005u\u0001bBA\u0017\u0001\u0011\u0005\u0013q\u0006\u0005\b\u0003c\u0001A\u0011IA\u001a\u0011\u0019\t)\u0005\u0001C!Q\"1\u0011q\t\u0001\u0005B!Dq!!\u0013\u0001\t#\nY\u0005C\u0005\u0002V\u0001\t\t\u0011\"\u0001\u0002X!I\u0011\u0011\r\u0001\u0012\u0002\u0013\u0005\u00111\r\u0005\n\u0003s\u0002\u0011\u0013!C\u0001\u0003GB\u0011\"a\u001f\u0001#\u0003%\t!! \t\u0013\u0005\u0005\u0005!%A\u0005\u0002\u0005u\u0004\"CAB\u0001\u0005\u0005I\u0011IAC\u0011%\t)\nAA\u0001\n\u0003\t9\nC\u0005\u0002 \u0002\t\t\u0011\"\u0001\u0002\"\"I\u0011q\u0015\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u0016\u0005\n\u0003o\u0003\u0011\u0011!C\u0001\u0003sC\u0011\"a1\u0001\u0003\u0003%\t%!2\b\u000f\u0005%W\u0005#\u0001\u0002L\u001a1A%\nE\u0001\u0003\u001bDa\u0001 \u0010\u0005\u0002\u0005=\u0007bBAi=\u0011\u0005\u00111\u001b\u0005\n\u0003Kt\u0012\u0011!CA\u0003OD\u0011\"!=\u001f\u0003\u0003%\t)a=\t\u0013\t\u0005a$!A\u0005\n\t\r!A\u0004)pS:$\u0018J\u001c3fq\u001e+w.\u001c\u0006\u0003M\u001d\nQ!\u001b8eKbT!\u0001K\u0015\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003U-\na!\\8tC&\u001c'B\u0001\u0017.\u0003\u0011a\u0017MY:\u000b\u00059z\u0013A\u00033bi\u0006\u0014'/[2lg*\t\u0001'A\u0002d_6\u001c\u0001a\u0005\u0004\u0001g\tCf\f\u001a\t\u0003i\u0001k\u0011!\u000e\u0006\u0003QYR!a\u000e\u001d\u0002\u0011\r\fG/\u00197zgRT!!\u000f\u001e\u0002\u0007M\fHN\u0003\u0002<y\u0005)1\u000f]1sW*\u0011QHP\u0001\u0007CB\f7\r[3\u000b\u0003}\n1a\u001c:h\u0013\t\tUG\u0001\tCS:\f'/_#yaJ,7o]5p]B\u00111)\u0016\b\u0003\tNs!!\u0012*\u000f\u0005\u0019\u000bfBA$Q\u001d\tAuJ\u0004\u0002J\u001d:\u0011!*T\u0007\u0002\u0017*\u0011A*M\u0001\u0007yI|w\u000e\u001e \n\u0003}J!!\u0010 \n\u0005mb\u0014BA\u001d;\u0013\t9\u0004(\u0003\u0002)m%\u0011A+N\u0001\ba\u0006\u001c7.Y4f\u0013\t1vK\u0001\bOk2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u000b\u0005Q+\u0004CA-]\u001b\u0005Q&BA.6\u0003\u001d\u0019w\u000eZ3hK:L!!\u0018.\u0003\u001f\r{G-Z4f]\u001a\u000bG\u000e\u001c2bG.\u0004\"a\u00182\u000e\u0003\u0001T\u0011!Y\u0001\u0006g\u000e\fG.Y\u0005\u0003G\u0002\u0014q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002`K&\u0011a\r\u0019\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0005O\u0016|W.F\u0001j!\t!$.\u0003\u0002lk\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u000b\u001d,w.\u001c\u0011\u0002\u0015I,7o\u001c7vi&|g.A\u0006sKN|G.\u001e;j_:\u0004\u0013aD5oI\u0016D8+_:uK6t\u0015-\\3\u0016\u0003E\u0004\"A\u001d<\u000f\u0005M$\bC\u0001&a\u0013\t)\b-\u0001\u0004Qe\u0016$WMZ\u0005\u0003ob\u0014aa\u0015;sS:<'BA;a\u0003AIg\u000eZ3y'f\u001cH/Z7OC6,\u0007%A\bhK>lW\r\u001e:z\u0003BKe*Y7f\u0003A9Wm\\7fiJL\u0018\tU%OC6,\u0007%\u0001\u0004=S:LGO\u0010\u000b\n}\u0006\u0005\u00111AA\u0003\u0003\u000f\u0001\"a \u0001\u000e\u0003\u0015BQaZ\u0005A\u0002%DQ!\\\u0005A\u0002%DQa\\\u0005A\u0002EDQA_\u0005A\u0002E\f\u0001\u0002Z1uCRK\b/Z\u000b\u0003\u0003\u001b\u0001B!a\u0004\u0002\u00165\u0011\u0011\u0011\u0003\u0006\u0004\u0003'A\u0014!\u0002;za\u0016\u001c\u0018\u0002BA\f\u0003#\u0011\u0001\u0002R1uCRK\b/Z\u0001\u000baJ,G\u000f^=OC6,\u0017\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dGCBA\u0010\u0003K\tI\u0003E\u0002`\u0003CI1!a\ta\u0005\r\te.\u001f\u0005\b\u0003Oa\u0001\u0019AA\u0010\u0003\u0019Ig\u000e];uc!9\u00111\u0006\u0007A\u0002\u0005}\u0011AB5oaV$('\u0001\u0005u_N#(/\u001b8h)\u0005\t\u0018\u0001C7bW\u0016\u001cu\u000e]=\u0015\u0007%\f)\u0004C\u0004\u000289\u0001\r!!\u000f\u0002\u000f9,w/\u0011:hgB)q,a\u000f\u0002@%\u0019\u0011Q\b1\u0003\u000b\u0005\u0013(/Y=\u0011\u0007}\u000b\t%C\u0002\u0002D\u0001\u0014a!\u00118z%\u00164\u0017\u0001\u00027fMR\fQA]5hQR\fqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u000b%\fi%!\u0015\t\r\u0005=\u0013\u00031\u0001j\u0003!qWm\u001e$jeN$\bBBA*#\u0001\u0007\u0011.A\u0005oK^\u001cVmY8oI\u0006!1m\u001c9z)%q\u0018\u0011LA.\u0003;\ny\u0006C\u0004h%A\u0005\t\u0019A5\t\u000f5\u0014\u0002\u0013!a\u0001S\"9qN\u0005I\u0001\u0002\u0004\t\bb\u0002>\u0013!\u0003\u0005\r!]\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t)GK\u0002j\u0003OZ#!!\u001b\u0011\t\u0005-\u0014QO\u0007\u0003\u0003[RA!a\u001c\u0002r\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003g\u0002\u0017AC1o]>$\u0018\r^5p]&!\u0011qOA7\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!a +\u0007E\f9'\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t9\t\u0005\u0003\u0002\n\u0006MUBAAF\u0015\u0011\ti)a$\u0002\t1\fgn\u001a\u0006\u0003\u0003#\u000bAA[1wC&\u0019q/a#\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005e\u0005cA0\u0002\u001c&\u0019\u0011Q\u00141\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005}\u00111\u0015\u0005\n\u0003KK\u0012\u0011!a\u0001\u00033\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAV!\u0019\ti+a-\u0002 5\u0011\u0011q\u0016\u0006\u0004\u0003c\u0003\u0017AC2pY2,7\r^5p]&!\u0011QWAX\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005m\u0016\u0011\u0019\t\u0004?\u0006u\u0016bAA`A\n9!i\\8mK\u0006t\u0007\"CAS7\u0005\u0005\t\u0019AA\u0010\u0003\u0019)\u0017/^1mgR!\u00111XAd\u0011%\t)\u000bHA\u0001\u0002\u0004\ty\"\u0001\bQ_&tG/\u00138eKb<Um\\7\u0011\u0005}t2\u0003\u0002\u0010\u0002@\u0011$\"!a3\u0002-I,w-[:uef,\u0005\u0010\u001d:fgNLwN\\%oM>$B!!6\u0002\\B\u0019A'a6\n\u0007\u0005eWG\u0001\bFqB\u0014Xm]:j_:LeNZ8\t\u000f\u0005u\u0007\u00051\u0001\u0002`\u0006\u0011AM\u0019\t\u0005?\u0006\u0005\u0018/C\u0002\u0002d\u0002\u0014aa\u00149uS>t\u0017!B1qa2LH#\u0003@\u0002j\u0006-\u0018Q^Ax\u0011\u00159\u0017\u00051\u0001j\u0011\u0015i\u0017\u00051\u0001j\u0011\u0015y\u0017\u00051\u0001r\u0011\u0015Q\u0018\u00051\u0001r\u0003\u001d)h.\u00199qYf$B!!>\u0002~B)q,!9\u0002xB9q,!?jSF\f\u0018bAA~A\n1A+\u001e9mKRB\u0001\"a@#\u0003\u0003\u0005\rA`\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"A!\u0002\u0011\t\u0005%%qA\u0005\u0005\u0005\u0013\tYI\u0001\u0004PE*,7\r\u001e")
public class PointIndexGeom
extends BinaryExpression
implements package.NullIntolerant,
CodegenFallback,
scala.Serializable {
    private final Expression geom;
    private final Expression resolution;
    private final String indexSystemName;
    private final String geometryAPIName;

    public static Option<Tuple4<Expression, Expression, String, String>> unapply(PointIndexGeom pointIndexGeom) {
        return PointIndexGeom$.MODULE$.unapply(pointIndexGeom);
    }

    public static ExpressionInfo registryExpressionInfo(Option<String> option) {
        return PointIndexGeom$.MODULE$.registryExpressionInfo(option);
    }

    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$((CodegenFallback)this, (CodegenContext)ctx, (ExprCode)ev);
    }

    public Expression geom() {
        return this.geom;
    }

    public Expression resolution() {
        return this.resolution;
    }

    public String indexSystemName() {
        return this.indexSystemName;
    }

    public String geometryAPIName() {
        return this.geometryAPIName;
    }

    public DataType dataType() {
        return LongType$.MODULE$;
    }

    public String prettyName() {
        return "point_index_geom";
    }

    public Object nullSafeEval(Object input1, Object input2) {
        Enumeration.Value geomType;
        IndexSystem indexSystem = IndexSystemID$.MODULE$.getIndexSystem(IndexSystemID$.MODULE$.apply(this.indexSystemName()));
        int resolution = indexSystem.getResolution(input2);
        GeometryAPI geometryAPI = GeometryAPI$.MODULE$.apply(this.geometryAPIName());
        MosaicGeometry rowGeom = geometryAPI.geometry(input1, this.geom().dataType());
        Enumeration.Value value = geomType = GeometryTypeEnum$.MODULE$.fromString(rowGeom.getGeometryType());
        Enumeration.Value value2 = GeometryTypeEnum$.MODULE$.POINT();
        Enumeration.Value value3 = value;
        if (value2 != null ? !value2.equals(value3) : value3 != null) {
            throw MosaicSQLExceptions$.MODULE$.IncorrectGeometryTypeSupplied(this.toString(), geomType, GeometryTypeEnum$.MODULE$.POINT());
        }
        MosaicPoint point = (MosaicPoint)rowGeom;
        Long l = BoxesRunTime.boxToLong((long)indexSystem.pointToIndex(point.getX(), point.getY(), resolution));
        return l;
    }

    public String toString() {
        return new StringBuilder(20).append("point_index_geom(").append(this.geom()).append(", ").append(this.resolution()).append(")").toString();
    }

    /*
     * WARNING - void declaration
     */
    public Expression makeCopy(Object[] newArgs) {
        void var3_3;
        Expression[] asArray = (Expression[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(newArgs)).take(2))).map((Function1 & Serializable & scala.Serializable)x$1 -> (Expression)x$1, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Expression.class)));
        PointIndexGeom res = new PointIndexGeom(asArray[0], asArray[1], this.indexSystemName(), this.geometryAPIName());
        res.copyTagsFrom((TreeNode)this);
        return var3_3;
    }

    public Expression left() {
        return this.geom();
    }

    public Expression right() {
        return this.resolution();
    }

    public Expression withNewChildrenInternal(Expression newFirst, Expression newSecond) {
        return this.copy(newFirst, newSecond, this.copy$default$3(), this.copy$default$4());
    }

    public PointIndexGeom copy(Expression geom, Expression resolution, String indexSystemName, String geometryAPIName) {
        return new PointIndexGeom(geom, resolution, indexSystemName, geometryAPIName);
    }

    public Expression copy$default$1() {
        return this.geom();
    }

    public Expression copy$default$2() {
        return this.resolution();
    }

    public String copy$default$3() {
        return this.indexSystemName();
    }

    public String copy$default$4() {
        return this.geometryAPIName();
    }

    public String productPrefix() {
        return "PointIndexGeom";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.geom();
                break;
            }
            case 1: {
                object = this.resolution();
                break;
            }
            case 2: {
                object = this.indexSystemName();
                break;
            }
            case 3: {
                object = this.geometryAPIName();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof PointIndexGeom;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof PointIndexGeom)) return false;
        boolean bl = true;
        if (!bl) return false;
        PointIndexGeom pointIndexGeom = (PointIndexGeom)((Object)x$1);
        Expression expression = this.geom();
        Expression expression2 = pointIndexGeom.geom();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.resolution();
        Expression expression4 = pointIndexGeom.resolution();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        String string = this.indexSystemName();
        String string2 = pointIndexGeom.indexSystemName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.geometryAPIName();
        String string4 = pointIndexGeom.geometryAPIName();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        if (!pointIndexGeom.canEqual((Object)this)) return false;
        return true;
    }

    public PointIndexGeom(Expression geom, Expression resolution, String indexSystemName, String geometryAPIName) {
        this.geom = geom;
        this.resolution = resolution;
        this.indexSystemName = indexSystemName;
        this.geometryAPIName = geometryAPIName;
        CodegenFallback.$init$((CodegenFallback)this);
    }
}

