/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.labs.mosaic.core.geometry.multipoint;

import com.databricks.labs.mosaic.core.geometry.GeometryReader;
import com.databricks.labs.mosaic.core.geometry.MosaicGeometry;
import com.databricks.labs.mosaic.core.geometry.MosaicGeometryESRI$;
import com.databricks.labs.mosaic.core.geometry.multipoint.MosaicMultiPointESRI;
import com.databricks.labs.mosaic.core.geometry.point.MosaicPointESRI;
import com.databricks.labs.mosaic.core.types.model.GeometryTypeEnum$;
import com.databricks.labs.mosaic.core.types.model.InternalGeometry;
import com.databricks.labs.mosaic.core.types.model.InternalGeometry$;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.core.geometry.ogc.OGCMultiPoint;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class MosaicMultiPointESRI$
implements GeometryReader,
scala.Serializable {
    public static MosaicMultiPointESRI$ MODULE$;
    private final int defaultSpatialReferenceId;

    static {
        new MosaicMultiPointESRI$();
    }

    @Override
    public int defaultSpatialReferenceId() {
        return this.defaultSpatialReferenceId;
    }

    @Override
    public void com$databricks$labs$mosaic$core$geometry$GeometryReader$_setter_$defaultSpatialReferenceId_$eq(int x$1) {
        this.defaultSpatialReferenceId = x$1;
    }

    public MosaicMultiPointESRI apply(OGCGeometry multiPoint) {
        return new MosaicMultiPointESRI((OGCMultiPoint)multiPoint);
    }

    @Override
    public MosaicGeometry fromInternal(InternalRow row) {
        InternalGeometry internalGeom = InternalGeometry$.MODULE$.apply(row);
        Predef$.MODULE$.require(internalGeom.typeId() == GeometryTypeEnum$.MODULE$.MULTIPOINT().id());
        MultiPoint multiPoint = new MultiPoint();
        Seq[] coordsCollection = (Seq[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])internalGeom.boundaries())).head())).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.coords(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class)));
        int dim = ((SeqLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])coordsCollection)).head()).length();
        SpatialReference spatialReference = internalGeom.srid() != 0 ? SpatialReference.create((int)internalGeom.srid()) : MosaicGeometryESRI$.MODULE$.defaultSpatialReference();
        int n = dim;
        switch (n) {
            case 2: {
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])coordsCollection)).foreach((Function1 & Serializable & scala.Serializable)coords -> {
                    multiPoint.add(new Point(BoxesRunTime.unboxToDouble((Object)coords.apply(0)), BoxesRunTime.unboxToDouble((Object)coords.apply(1))));
                    return BoxedUnit.UNIT;
                });
                break;
            }
            case 3: {
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])coordsCollection)).foreach((Function1 & Serializable & scala.Serializable)coords -> {
                    multiPoint.add(new Point(BoxesRunTime.unboxToDouble((Object)coords.apply(0)), BoxesRunTime.unboxToDouble((Object)coords.apply(1)), BoxesRunTime.unboxToDouble((Object)coords.apply(2))));
                    return BoxedUnit.UNIT;
                });
                break;
            }
            default: {
                throw new UnsupportedOperationException("Only 2D and 3D points supported.");
            }
        }
        OGCMultiPoint ogcMultiPoint = new OGCMultiPoint(multiPoint, spatialReference);
        return new MosaicMultiPointESRI(ogcMultiPoint);
    }

    @Override
    public <T extends MosaicGeometry> MosaicMultiPointESRI fromSeq(Seq<T> geomSeq, Enumeration.Value geomType) {
        MultiPoint multiPoint;
        SpatialReference spatialReference = SpatialReference.create((int)((MosaicGeometry)geomSeq.head()).getSpatialReference());
        Enumeration.Value value = GeometryTypeEnum$.MODULE$.fromString(((MosaicGeometry)geomSeq.head()).getGeometryType());
        Enumeration.Value value2 = GeometryTypeEnum$.MODULE$.POINT();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            multiPoint = new MultiPoint();
            Seq extractedPoints = (Seq)geomSeq.map((Function1 & Serializable & scala.Serializable)x$5 -> (MosaicPointESRI)x$5, Seq$.MODULE$.canBuildFrom());
            int n = ((MosaicPointESRI)extractedPoints.head()).asSeq().length();
            switch (n) {
                case 2: {
                    extractedPoints.foreach((Function1 & Serializable & scala.Serializable)p -> {
                        multiPoint.add(new Point(BoxesRunTime.unboxToDouble((Object)p.asSeq().apply(0)), BoxesRunTime.unboxToDouble((Object)p.asSeq().apply(1))));
                        return BoxedUnit.UNIT;
                    });
                    break;
                }
                case 3: {
                    extractedPoints.foreach((Function1 & Serializable & scala.Serializable)p -> {
                        multiPoint.add(new Point(BoxesRunTime.unboxToDouble((Object)p.asSeq().apply(0)), BoxesRunTime.unboxToDouble((Object)p.asSeq().apply(1)), BoxesRunTime.unboxToDouble((Object)p.asSeq().apply(2))));
                        return BoxedUnit.UNIT;
                    });
                    break;
                }
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                }
            }
        } else {
            if (value != null) {
                Enumeration.Value value4 = value;
                throw new UnsupportedOperationException(new StringBuilder(57).append("MosaicGeometry.fromSeq() cannot create ").append(geomType.toString()).append(" from ").append(value4.toString()).append(" geometries.").toString());
            }
            throw new MatchError((Object)value);
        }
        OGCMultiPoint oGCMultiPoint = new OGCMultiPoint(multiPoint, spatialReference);
        OGCMultiPoint newGeom = oGCMultiPoint;
        return this.apply((OGCGeometry)newGeom);
    }

    public <T extends MosaicGeometry> Enumeration.Value fromSeq$default$2() {
        return GeometryTypeEnum$.MODULE$.MULTIPOINT();
    }

    @Override
    public MosaicGeometry fromWKB(byte[] wkb) {
        return MosaicGeometryESRI$.MODULE$.fromWKB(wkb);
    }

    @Override
    public MosaicGeometry fromWKT(String wkt) {
        return MosaicGeometryESRI$.MODULE$.fromWKT(wkt);
    }

    @Override
    public MosaicGeometry fromJSON(String geoJson) {
        return MosaicGeometryESRI$.MODULE$.fromJSON(geoJson);
    }

    @Override
    public MosaicGeometry fromHEX(String hex) {
        return MosaicGeometryESRI$.MODULE$.fromHEX(hex);
    }

    @Override
    public MosaicGeometry fromKryo(InternalRow row) {
        return MosaicGeometryESRI$.MODULE$.fromKryo(row);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private MosaicMultiPointESRI$() {
        MODULE$ = this;
        GeometryReader.$init$(this);
    }
}

