/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.labs.mosaic.codegen.geometry;

import com.databricks.labs.mosaic.codegen.format.ConvertToCodeGen$;
import com.databricks.labs.mosaic.core.geometry.MosaicGeometryESRI;
import com.databricks.labs.mosaic.core.geometry.api.GeometryAPI;
import com.esri.core.geometry.ogc.OGCGeometry;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.types.DataType;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.StringOps;

public final class GeometryTransformationsCodeGenESRI$ {
    public static GeometryTransformationsCodeGenESRI$ MODULE$;

    static {
        new GeometryTransformationsCodeGenESRI$();
    }

    public Tuple2<String, String> rotate(CodegenContext ctx, String geomEval, String angleEval, DataType dataType, GeometryAPI geometryAPI) {
        Tuple2<String, String> tuple2 = ConvertToCodeGen$.MODULE$.readGeometryCode(ctx, geomEval, dataType, geometryAPI);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String inCode = (String)tuple2._1();
        String geomInRef = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)inCode, (Object)geomInRef);
        Tuple2 tuple23 = tuple22;
        String inCode2 = (String)tuple23._1();
        String geomInRef2 = (String)tuple23._2();
        String tmpGeom = ctx.freshName("tmpGeom");
        Tuple2<String, String> tuple24 = ConvertToCodeGen$.MODULE$.writeGeometryCode(ctx, tmpGeom, dataType, geometryAPI);
        if (tuple24 == null) {
            throw new MatchError(tuple24);
        }
        String outCode = (String)tuple24._1();
        String geomOutRef = (String)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)outCode, (Object)geomOutRef);
        Tuple2 tuple26 = tuple25;
        String outCode2 = (String)tuple26._1();
        String geomOutRef2 = (String)tuple26._2();
        String ogcGeometryClass = OGCGeometry.class.getName();
        String mosaicGeometryOGCClass = MosaicGeometryESRI.class.getName();
        return new Tuple2((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(96).append("\n             |").append(inCode2).append("\n             |").append(ogcGeometryClass).append(" ").append(tmpGeom).append(" = ((").append(mosaicGeometryOGCClass).append(")").append(mosaicGeometryOGCClass).append(".apply(").append(geomInRef2).append(").rotate(").append(angleEval).append(")).getGeom();\n             |").append(outCode2).append("\n             |").toString())).stripMargin(), (Object)geomOutRef2);
    }

    public Tuple2<String, String> scale(CodegenContext ctx, String geomEval, String xDist, String yDist, DataType dataType, GeometryAPI geometryAPI) {
        Tuple2<String, String> tuple2 = ConvertToCodeGen$.MODULE$.readGeometryCode(ctx, geomEval, dataType, geometryAPI);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String inCode = (String)tuple2._1();
        String geomInRef = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)inCode, (Object)geomInRef);
        Tuple2 tuple23 = tuple22;
        String inCode2 = (String)tuple23._1();
        String geomInRef2 = (String)tuple23._2();
        String tmpGeom = ctx.freshName("tmpGeom");
        Tuple2<String, String> tuple24 = ConvertToCodeGen$.MODULE$.writeGeometryCode(ctx, tmpGeom, dataType, geometryAPI);
        if (tuple24 == null) {
            throw new MatchError(tuple24);
        }
        String outCode = (String)tuple24._1();
        String geomOutRef = (String)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)outCode, (Object)geomOutRef);
        Tuple2 tuple26 = tuple25;
        String outCode2 = (String)tuple26._1();
        String geomOutRef2 = (String)tuple26._2();
        String ogcGeometryClass = OGCGeometry.class.getName();
        String mosaicGeometryOGCClass = MosaicGeometryESRI.class.getName();
        return new Tuple2((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(97).append("\n             |").append(inCode2).append("\n             |").append(ogcGeometryClass).append(" ").append(tmpGeom).append(" = ((").append(mosaicGeometryOGCClass).append(")").append(mosaicGeometryOGCClass).append(".apply(").append(geomInRef2).append(").scale(").append(xDist).append(", ").append(yDist).append(")).getGeom();\n             |").append(outCode2).append("\n             |").toString())).stripMargin(), (Object)geomOutRef2);
    }

    public Tuple2<String, String> translate(CodegenContext ctx, String geomEval, String xDist, String yDist, DataType dataType, GeometryAPI geometryAPI) {
        Tuple2<String, String> tuple2 = ConvertToCodeGen$.MODULE$.readGeometryCode(ctx, geomEval, dataType, geometryAPI);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String inCode = (String)tuple2._1();
        String geomInRef = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)inCode, (Object)geomInRef);
        Tuple2 tuple23 = tuple22;
        String inCode2 = (String)tuple23._1();
        String geomInRef2 = (String)tuple23._2();
        String tmpGeom = ctx.freshName("tmpGeom");
        Tuple2<String, String> tuple24 = ConvertToCodeGen$.MODULE$.writeGeometryCode(ctx, tmpGeom, dataType, geometryAPI);
        if (tuple24 == null) {
            throw new MatchError(tuple24);
        }
        String outCode = (String)tuple24._1();
        String geomOutRef = (String)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)outCode, (Object)geomOutRef);
        Tuple2 tuple26 = tuple25;
        String outCode2 = (String)tuple26._1();
        String geomOutRef2 = (String)tuple26._2();
        String ogcGeometryClass = OGCGeometry.class.getName();
        String mosaicGeometryOGCClass = MosaicGeometryESRI.class.getName();
        return new Tuple2((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(101).append("\n             |").append(inCode2).append("\n             |").append(ogcGeometryClass).append(" ").append(tmpGeom).append(" = ((").append(mosaicGeometryOGCClass).append(")").append(mosaicGeometryOGCClass).append(".apply(").append(geomInRef2).append(").translate(").append(xDist).append(", ").append(yDist).append(")).getGeom();\n             |").append(outCode2).append("\n             |").toString())).stripMargin(), (Object)geomOutRef2);
    }

    private GeometryTransformationsCodeGenESRI$() {
        MODULE$ = this;
    }
}

